<?php
/**
 * Font awesome icons array array file.
 *
 * @package     UAGB
 * @author      Brainstorm Force
 * @link        https://wpspectra.com/
 */

/**
 * Returns font awesome icons array 
 */
return array("satellite"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M502.8 264.1l-80.37-80.37l47.87-47.88c13-13.12 13-34.37 0-47.5l-47.5-47.5c-13.12-13.12-34.38-13.12-47.5 0l-47.88 47.88L247.1 9.25C241 3.375 232.9 0 224.5 0c-8.5 0-16.62 3.375-22.5 9.25l-96.75 96.75c-12.38 12.5-12.38 32.62 0 45.12L185.5 231.5L175.8 241.4c-54-24.5-116.3-22.5-168.5 5.375c-8.498 4.625-9.623 16.38-2.873 23.25l107.6 107.5l-17.88 17.75c-2.625-.75-5-1.625-7.75-1.625c-17.75 0-32 14.38-32 32c0 17.75 14.25 32 32 32c17.62 0 32-14.25 32-32c0-2.75-.875-5.125-1.625-7.75l17.75-17.88l107.6 107.6c6.75 6.75 18.62 5.625 23.12-2.875c27.88-52.25 29.88-114.5 5.375-168.5l10-9.873l80.25 80.36c12.5 12.38 32.62 12.38 44.1 0l96.75-96.75C508.6 304.1 512 295.1 512 287.5C512 279.1 508.6 270.1 502.8 264.1zM219.5 197.4L150.6 128.5l73.87-73.75l68.86 68.88L219.5 197.4zM383.5 361.4L314.6 292.5l73.75-73.88l68.88 68.87L383.5 361.4z")),"label"=>__("Satellite","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"satellite-dish"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M216 104C202.8 104 192 114.8 192 128s10.75 24 24 24c79.41 0 144 64.59 144 144C360 309.3 370.8 320 384 320s24-10.75 24-24C408 190.1 321.9 104 216 104zM224 0C206.3 0 192 14.31 192 32s14.33 32 32 32c123.5 0 224 100.5 224 224c0 17.69 14.33 32 32 32s32-14.31 32-32C512 129.2 382.8 0 224 0zM188.9 346l27.37-27.37c2.625 .625 5.059 1.506 7.809 1.506c17.75 0 31.99-14.26 31.99-32c0-17.62-14.24-32.01-31.99-32.01c-17.62 0-31.99 14.38-31.99 32.01c0 2.875 .8099 5.25 1.56 7.875L166.2 323.4L49.37 206.5c-7.25-7.25-20.12-6-24.1 3c-41.75 77.88-29.88 176.7 35.75 242.4c65.62 65.62 164.6 77.5 242.4 35.75c9.125-5 10.38-17.75 3-25L188.9 346z")),"label"=>__("Satellite Dish","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology","travel")),"scale-balanced"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M554.9 154.5c-17.62-35.25-68.12-35.38-85.87 0c-87 174.3-84.1 165.9-84.1 181.5c0 44.13 57.25 80 128 80s127.1-35.88 127.1-80C639.1 319.9 641.4 327.3 554.9 154.5zM439.1 320l71.96-144l72.17 144H439.1zM256 336c0-16.12 1.375-8.75-85.12-181.5c-17.62-35.25-68.12-35.38-85.87 0c-87 174.3-84.1 165.9-84.1 181.5c0 44.13 57.25 80 127.1 80S256 380.1 256 336zM127.9 176L200.1 320H55.96L127.9 176zM495.1 448h-143.1V153.3C375.5 143 393.1 121.8 398.4 96h113.6c17.67 0 31.1-14.33 31.1-32s-14.33-32-31.1-32h-128.4c-14.62-19.38-37.5-32-63.62-32S270.1 12.62 256.4 32H128C110.3 32 96 46.33 96 64S110.3 96 127.1 96h113.6c5.25 25.75 22.87 47 46.37 57.25V448H144c-26.51 0-48.01 21.49-48.01 48c0 8.836 7.165 16 16 16h416c8.836 0 16-7.164 16-16C544 469.5 522.5 448 495.1 448z")),"label"=>__("Scale Balanced","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"scale-unbalanced"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M85 250.5c-87 174.2-84.1 165.9-84.1 181.5C.0035 476.1 57.25 512 128 512s128-35.88 128-79.1c0-16.12 1.375-8.752-85.12-181.5C153.3 215.3 102.8 215.1 85 250.5zM55.96 416l71.98-143.1l72.15 143.1H55.96zM554.9 122.5c-17.62-35.25-68.08-35.37-85.83 0c-87 174.2-85.04 165.9-85.04 181.5c0 44.12 57.25 79.1 128 79.1s127.1-35.87 127.1-79.1C639.1 287.9 641.4 295.3 554.9 122.5zM439.1 288l72.04-143.1l72.08 143.1H439.1zM495.1 448h-143.1V153.3c20.83-9.117 36.72-26.93 43.78-48.77l126.3-42.11c16.77-5.594 25.83-23.72 20.23-40.48c-5.578-16.73-23.62-25.86-40.48-20.23l-113.3 37.76c-13.94-23.49-39.29-39.41-68.58-39.41c-44.18 0-79.1 35.82-79.1 80c0 2.961 .5587 5.771 .8712 8.648L117.9 129.7C101.1 135.3 92.05 153.4 97.64 170.1c4.469 13.41 16.95 21.88 30.36 21.88c3.344 0 6.768-.5186 10.13-1.644L273.8 145.1C278.2 148.3 282.1 151.1 288 153.3V496C288 504.8 295.2 512 304 512h223.1c8.838 0 16-7.164 16-15.1C543.1 469.5 522.5 448 495.1 448z")),"label"=>__("Scale Unbalanced","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"scale-unbalanced-flip"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M554.9 250.5c-17.62-35.37-68.12-35.25-85.87 0c-86.38 172.7-85.04 165.4-85.04 181.5C383.1 476.1 441.3 512 512 512s127.1-35.88 127.1-79.1C639.1 416.4 642 424.7 554.9 250.5zM439.9 416l72.15-143.1l71.98 143.1H439.9zM512 192c13.41 0 25.89-8.471 30.36-21.88c5.594-16.76-3.469-34.89-20.23-40.48l-122.1-40.1c.3125-2.877 .8712-5.687 .8712-8.648c0-44.18-35.81-80-79.1-80c-29.29 0-54.65 15.92-68.58 39.41l-113.3-37.76C121.3-3.963 103.2 5.162 97.64 21.9C92.05 38.66 101.1 56.78 117.9 62.38l126.3 42.11c7.061 21.84 22.95 39.65 43.78 48.77v294.7H144c-26.51 0-47.1 21.49-47.1 47.1C96 504.8 103.2 512 112 512h223.1c8.836 0 15.1-7.164 15.1-15.1V153.3c5.043-2.207 9.756-4.965 14.19-8.115l135.7 45.23C505.2 191.5 508.7 192 512 192zM256 304c0-15.62 1.1-7.252-85.12-181.5c-17.62-35.37-68.08-35.25-85.83 0c-86.38 172.7-85.04 165.4-85.04 181.5c0 44.12 57.25 79.1 127.1 79.1S256 348.1 256 304zM128 144l72.04 143.1H55.92L128 144z")),"label"=>__("Scale Unbalanced Flip","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"schlix"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M350.5 157.7l-54.2-46.1 73.4-39 78.3 44.2-97.5 40.9zM192 122.1l45.7-28.2 34.7 34.6-55.4 29-25-35.4zm-65.1 6.6l31.9-22.1L176 135l-36.7 22.5-12.4-28.8zm-23.3 88.2l-8.8-34.8 29.6-18.3 13.1 35.3-33.9 17.8zm-21.2-83.7l23.9-18.1 8.9 24-26.7 18.3-6.1-24.2zM59 206.5l-3.6-28.4 22.3-15.5 6.1 28.7L59 206.5zm-30.6 16.6l20.8-12.8 3.3 33.4-22.9 12-1.2-32.6zM1.4 268l19.2-10.2 .4 38.2-21 8.8L1.4 268zm59.1 59.3l-28.3 8.3-1.6-46.8 25.1-10.7 4.8 49.2zM99 263.2l-31.1 13-5.2-40.8L90.1 221l8.9 42.2zM123.2 377l-41.6 5.9-8.1-63.5 35.2-10.8 14.5 68.4zm28.5-139.9l21.2 57.1-46.2 13.6-13.7-54.1 38.7-16.6zm85.7 230.5l-70.9-3.3-24.3-95.8 55.2-8.6 40 107.7zm-84.9-279.7l42.2-22.4 28 45.9-50.8 21.3-19.4-44.8zm41 94.9l61.3-18.7 52.8 86.6-79.8 11.3-34.3-79.2zm51.4-85.6l67.3-28.8 65.5 65.4-88.6 26.2-44.2-62.8z")),"label"=>__("SCHLIX","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"school"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M320 128C328.8 128 336 135.2 336 144V160H352C360.8 160 368 167.2 368 176C368 184.8 360.8 192 352 192H320C311.2 192 304 184.8 304 176V144C304 135.2 311.2 128 320 128zM476.8 98.06L602.4 125.1C624.4 130.9 640 150.3 640 172.8V464C640 490.5 618.5 512 592 512H48C21.49 512 0 490.5 0 464V172.8C0 150.3 15.63 130.9 37.59 125.1L163.2 98.06L302.2 5.374C312.1-1.791 327-1.791 337.8 5.374L476.8 98.06zM256 512H384V416C384 380.7 355.3 352 320 352C284.7 352 256 380.7 256 416V512zM96 192C87.16 192 80 199.2 80 208V272C80 280.8 87.16 288 96 288H128C136.8 288 144 280.8 144 272V208C144 199.2 136.8 192 128 192H96zM496 272C496 280.8 503.2 288 512 288H544C552.8 288 560 280.8 560 272V208C560 199.2 552.8 192 544 192H512C503.2 192 496 199.2 496 208V272zM96 320C87.16 320 80 327.2 80 336V400C80 408.8 87.16 416 96 416H128C136.8 416 144 408.8 144 400V336C144 327.2 136.8 320 128 320H96zM496 400C496 408.8 503.2 416 512 416H544C552.8 416 560 408.8 560 400V336C560 327.2 552.8 320 544 320H512C503.2 320 496 327.2 496 336V400zM320 88C271.4 88 232 127.4 232 176C232 224.6 271.4 264 320 264C368.6 264 408 224.6 408 176C408 127.4 368.6 88 320 88z")),"label"=>__("School","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","education")),"school-circle-check"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M476.8 98.06L602.4 125.1C624.4 130.9 640 150.3 640 172.8V266.8C608.1 221.6 555.5 191.1 496 191.1C457.5 191.1 421.8 204.4 392.9 225.4C402.4 211.3 408 194.3 408 175.1C408 127.4 368.6 87.1 320 87.1C271.4 87.1 232 127.4 232 175.1C232 224.6 271.4 263.1 320 263.1C335.6 263.1 350.2 259.1 362.9 252.9C339.4 279.9 324.1 314.3 320.7 352H320.3L320 352C284.7 352 256 380.7 256 416V512L320 512H48C21.49 512 0 490.5 0 464V172.8C0 150.3 15.63 130.9 37.59 125.1L163.2 98.06L302.2 5.374C312.1-1.791 327-1.791 337.8 5.374L476.8 98.06zM96 192C87.16 192 80 199.2 80 208V272C80 280.8 87.16 288 96 288H128C136.8 288 144 280.8 144 272V208C144 199.2 136.8 192 128 192H96zM96 320C87.16 320 80 327.2 80 336V400C80 408.8 87.16 416 96 416H128C136.8 416 144 408.8 144 400V336C144 327.2 136.8 320 128 320H96zM320 128C328.8 128 336 135.2 336 144V160H352C360.8 160 368 167.2 368 176C368 184.8 360.8 192 352 192H320C311.2 192 304 184.8 304 176V144C304 135.2 311.2 128 320 128zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM480 385.4L451.3 356.7C445.1 350.4 434.9 350.4 428.7 356.7C422.4 362.9 422.4 373.1 428.7 379.3L468.7 419.3C474.9 425.6 485.1 425.6 491.3 419.3L563.3 347.3C569.6 341.1 569.6 330.9 563.3 324.7C557.1 318.4 546.9 318.4 540.7 324.7L480 385.4z")),"label"=>__("School Circle Check","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","education")),"school-circle-exclamation"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M476.8 98.06L602.4 125.1C624.4 130.9 640 150.3 640 172.8V266.8C608.1 221.6 555.5 191.1 496 191.1C457.5 191.1 421.8 204.4 392.9 225.4C402.4 211.3 408 194.3 408 175.1C408 127.4 368.6 87.1 320 87.1C271.4 87.1 232 127.4 232 175.1C232 224.6 271.4 263.1 320 263.1C335.6 263.1 350.2 259.1 362.9 252.9C339.4 279.9 324.1 314.3 320.7 352H320.3L320 352C284.7 352 256 380.7 256 416V512L320 512H48C21.49 512 0 490.5 0 464V172.8C0 150.3 15.63 130.9 37.59 125.1L163.2 98.06L302.2 5.374C312.1-1.791 327-1.791 337.8 5.374L476.8 98.06zM96 192C87.16 192 80 199.2 80 208V272C80 280.8 87.16 288 96 288H128C136.8 288 144 280.8 144 272V208C144 199.2 136.8 192 128 192H96zM96 320C87.16 320 80 327.2 80 336V400C80 408.8 87.16 416 96 416H128C136.8 416 144 408.8 144 400V336C144 327.2 136.8 320 128 320H96zM320 128C328.8 128 336 135.2 336 144V160H352C360.8 160 368 167.2 368 176C368 184.8 360.8 192 352 192H320C311.2 192 304 184.8 304 176V144C304 135.2 311.2 128 320 128zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 464C509.3 464 520 453.3 520 440C520 426.7 509.3 416 496 416C482.7 416 472 426.7 472 440C472 453.3 482.7 464 496 464zM479.1 288V368C479.1 376.8 487.2 384 495.1 384C504.8 384 511.1 376.8 511.1 368V288C511.1 279.2 504.8 272 495.1 272C487.2 272 479.1 279.2 479.1 288z")),"label"=>__("School Circle Exclamation","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","education")),"school-circle-xmark"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M476.8 98.06L602.4 125.1C624.4 130.9 640 150.3 640 172.8V266.8C608.1 221.6 555.5 191.1 496 191.1C457.5 191.1 421.8 204.4 392.9 225.4C402.4 211.3 408 194.3 408 175.1C408 127.4 368.6 87.1 320 87.1C271.4 87.1 232 127.4 232 175.1C232 224.6 271.4 263.1 320 263.1C335.6 263.1 350.2 259.1 362.9 252.9C339.4 279.9 324.1 314.3 320.7 352H320.3L320 352C284.7 352 256 380.7 256 416V512L320 512H48C21.49 512 0 490.5 0 464V172.8C0 150.3 15.63 130.9 37.59 125.1L163.2 98.06L302.2 5.374C312.1-1.791 327-1.791 337.8 5.374L476.8 98.06zM96 192C87.16 192 80 199.2 80 208V272C80 280.8 87.16 288 96 288H128C136.8 288 144 280.8 144 272V208C144 199.2 136.8 192 128 192H96zM96 320C87.16 320 80 327.2 80 336V400C80 408.8 87.16 416 96 416H128C136.8 416 144 408.8 144 400V336C144 327.2 136.8 320 128 320H96zM320 128C328.8 128 336 135.2 336 144V160H352C360.8 160 368 167.2 368 176C368 184.8 360.8 192 352 192H320C311.2 192 304 184.8 304 176V144C304 135.2 311.2 128 320 128zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM518.6 368L555.3 331.3C561.6 325.1 561.6 314.9 555.3 308.7C549.1 302.4 538.9 302.4 532.7 308.7L496 345.4L459.3 308.7C453.1 302.4 442.9 302.4 436.7 308.7C430.4 314.9 430.4 325.1 436.7 331.3L473.4 368L436.7 404.7C430.4 410.9 430.4 421.1 436.7 427.3C442.9 433.6 453.1 433.6 459.3 427.3L496 390.6L532.7 427.3C538.9 433.6 549.1 433.6 555.3 427.3C561.6 421.1 561.6 410.9 555.3 404.7L518.6 368z")),"label"=>__("School Circle Xmark","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","education")),"school-flag"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M288 0H400C408.8 0 416 7.164 416 16V64C416 72.84 408.8 80 400 80H320V95.53L410.3 160H512C547.3 160 576 188.7 576 224V448C576 483.3 547.3 512 512 512H336V400C336 373.5 314.5 352 288 352C261.5 352 240 373.5 240 400V512H64C28.65 512 0 483.3 0 448V224C0 188.7 28.65 160 64 160H165.7L256 95.53V32C256 14.33 270.3 0 288 0V0zM288 192C261.5 192 240 213.5 240 240C240 266.5 261.5 288 288 288C314.5 288 336 266.5 336 240C336 213.5 314.5 192 288 192zM80 224C71.16 224 64 231.2 64 240V304C64 312.8 71.16 320 80 320H112C120.8 320 128 312.8 128 304V240C128 231.2 120.8 224 112 224H80zM448 304C448 312.8 455.2 320 464 320H496C504.8 320 512 312.8 512 304V240C512 231.2 504.8 224 496 224H464C455.2 224 448 231.2 448 240V304zM80 352C71.16 352 64 359.2 64 368V432C64 440.8 71.16 448 80 448H112C120.8 448 128 440.8 128 432V368C128 359.2 120.8 352 112 352H80zM464 352C455.2 352 448 359.2 448 368V432C448 440.8 455.2 448 464 448H496C504.8 448 512 440.8 512 432V368C512 359.2 504.8 352 496 352H464z")),"label"=>__("School Flag","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","education")),"school-lock"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M336 160H352C360.8 160 368 167.2 368 176C368 184.8 360.8 192 352 192H320C311.2 192 304 184.8 304 176V144C304 135.2 311.2 128 320 128C328.8 128 336 135.2 336 144V160zM302.2 5.374C312.1-1.791 327-1.791 337.8 5.374L476.8 98.06L602.4 125.1C624.4 130.9 640 150.3 640 172.8V271.1C640 210.1 589.9 159.1 528 159.1C466.1 159.1 416 210.1 416 271.1V296.6C396.9 307.6 384 328.3 384 352H320.3L320 352C284.7 352 256 380.7 256 416V512H320L48 512C21.49 512 0 490.5 0 464V172.8C0 150.3 15.63 130.9 37.59 125.1L163.2 98.06L302.2 5.374zM80 272C80 280.8 87.16 288 96 288H128C136.8 288 144 280.8 144 272V208C144 199.2 136.8 192 128 192H96C87.16 192 80 199.2 80 208V272zM80 400C80 408.8 87.16 416 96 416H128C136.8 416 144 408.8 144 400V336C144 327.2 136.8 320 128 320H96C87.16 320 80 327.2 80 336V400zM320 264C368.6 264 408 224.6 408 176C408 127.4 368.6 88 320 88C271.4 88 232 127.4 232 176C232 224.6 271.4 264 320 264zM528 192C572.2 192 608 227.8 608 272V320C625.7 320 640 334.3 640 352V480C640 497.7 625.7 512 608 512H448C430.3 512 416 497.7 416 480V352C416 334.3 430.3 320 448 320V272C448 227.8 483.8 192 528 192zM528 240C510.3 240 496 254.3 496 272V320H560V272C560 254.3 545.7 240 528 240z")),"label"=>__("School Lock","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","education")),"scissors"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M396.8 51.2C425.1 22.92 470.9 22.92 499.2 51.2C506.3 58.27 506.3 69.73 499.2 76.8L216.5 359.5C221.3 372.1 224 385.7 224 400C224 461.9 173.9 512 112 512C50.14 512 0 461.9 0 400C0 338.1 50.14 287.1 112 287.1C126.3 287.1 139.9 290.7 152.5 295.5L191.1 255.1L152.5 216.5C139.9 221.3 126.3 224 112 224C50.14 224 0 173.9 0 112C0 50.14 50.14 0 112 0C173.9 0 224 50.14 224 112C224 126.3 221.3 139.9 216.5 152.5L255.1 191.1L396.8 51.2zM160 111.1C160 85.49 138.5 63.1 112 63.1C85.49 63.1 64 85.49 64 111.1C64 138.5 85.49 159.1 112 159.1C138.5 159.1 160 138.5 160 111.1zM112 448C138.5 448 160 426.5 160 400C160 373.5 138.5 352 112 352C85.49 352 64 373.5 64 400C64 426.5 85.49 448 112 448zM278.6 342.6L342.6 278.6L499.2 435.2C506.3 442.3 506.3 453.7 499.2 460.8C470.9 489.1 425.1 489.1 396.8 460.8L278.6 342.6z")),"label"=>__("Scissors","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","design")),"screenpal"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M233.5 22.49C233.5 10.07 243.6 0 256 0C268.4 0 278.5 10.07 278.5 22.49C278.5 34.91 268.4 44.98 256 44.98C243.6 44.98 233.5 34.91 233.5 22.49zM313.4 259C313.4 290.7 287.7 316.4 256 316.4C224.3 316.4 198.6 290.7 198.6 259C198.6 227.3 224.3 201.6 256 201.6C287.7 201.6 313.4 227.3 313.4 259zM337.2 350C359.5 330.1 373.7 302.7 377.1 273H496.6C493.1 334.4 466.2 392.2 421.4 434.4C376.7 476.6 317.5 500.2 256 500.2C194.5 500.2 135.3 476.6 90.56 434.4C45.83 392.2 18.94 334.4 15.39 273H135.1C138.5 302.7 152.7 330.1 175 350C197.3 369.9 226.2 380.9 256.1 380.9C285.1 380.9 314.8 369.9 337.2 350zM73.14 140.3C73.54 152.7 63.81 163.1 51.39 163.5C38.97 163.9 28.59 154.2 28.18 141.8C27.78 129.3 37.52 118.9 49.94 118.5C62.35 118.1 72.74 127.9 73.14 140.3zM438.9 141C438.9 128.6 448.9 118.5 461.4 118.5C473.8 118.5 483.8 128.6 483.8 141C483.8 153.5 473.8 163.5 461.4 163.5C448.9 163.5 438.9 153.5 438.9 141zM317.9 95.27C300.6 109.1 278.7 118.1 256 118.1C233.3 118.1 211.4 109.1 194.1 95.27C176.8 80.55 165.3 60.18 161.7 37.78C176.8 31.37 192.5 26.52 208.6 23.31C208.6 35.88 213.6 47.93 222.5 56.82C231.4 65.7 243.4 70.7 256 70.7C268.6 70.7 280.6 65.7 289.5 56.82C298.4 47.93 303.4 35.88 303.4 23.31C319.5 26.52 335.2 31.37 350.3 37.78C346.7 60.18 335.2 80.55 317.9 95.27H317.9zM82.78 231C61.42 238.6 38.06 238.4 16.86 230.4C18.82 214.1 22.46 198.1 27.71 182.5C33.1 185.6 39.05 187.6 45.22 188.5C51.39 189.3 57.67 188.9 63.68 187.3C69.69 185.6 75.33 182.9 80.27 179.1C85.21 175.3 89.36 170.6 92.47 165.2C95.58 159.8 97.61 153.8 98.42 147.7C99.23 141.5 98.83 135.2 97.22 129.2C95.61 123.2 92.83 117.6 89.04 112.6C85.25 107.7 80.53 103.5 75.14 100.4C85.96 88.11 98.01 76.94 111.1 67.07C128.7 81.42 140.6 101.6 144.7 123.9C148.8 146.2 144.8 169.3 133.5 188.9C122.1 208.5 104.1 223.4 82.78 231V231zM429.2 231.1C407.9 223.5 389.9 208.5 378.5 188.9C367.2 169.3 363.3 146.2 367.4 123.9C371.5 101.7 383.4 81.54 400.9 67.19C414 77.04 426.1 88.21 436.9 100.5C426.2 106.9 418.5 117.2 415.4 129.3C412.2 141.3 413.1 154.1 420.2 164.9C426.4 175.7 436.6 183.6 448.6 186.9C460.6 190.2 473.5 188.6 484.3 182.6C489.6 198.1 493.2 214.2 495.2 230.4C473.1 238.5 450.6 238.7 429.2 231.1L429.2 231.1z")),"label"=>__("Screenpal","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"screwdriver"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M128 278.6l-117.1 116.9c-14.5 14.62-14.5 38.29 0 52.79l52.75 52.75c14.5 14.5 38.17 14.5 52.79 0L233.4 384c29.12-29.12 29.12-76.25 0-105.4S157.1 249.5 128 278.6zM447.1 0l-128 96L320 158L237 241.1C243.8 245.4 250.3 250.1 256 256c5.875 5.75 10.62 12.25 14.88 19L353.1 192h61.99l95.1-128L447.1 0z")),"label"=>__("Screwdriver","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"screwdriver-wrench"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M331.8 224.1c28.29 0 54.88 10.99 74.86 30.97l19.59 19.59c40.01-17.74 71.25-53.3 81.62-96.65c5.725-23.92 5.34-47.08 .2148-68.4c-2.613-10.88-16.43-14.51-24.34-6.604l-68.9 68.9h-75.6V97.2l68.9-68.9c7.912-7.912 4.275-21.73-6.604-24.34c-21.32-5.125-44.48-5.51-68.4 .2148c-55.3 13.23-98.39 60.22-107.2 116.4C224.5 128.9 224.2 137 224.3 145l82.78 82.86C315.2 225.1 323.5 224.1 331.8 224.1zM384 278.6c-23.16-23.16-57.57-27.57-85.39-13.9L191.1 158L191.1 95.99l-127.1-95.99L0 63.1l96 127.1l62.04 .0077l106.7 106.6c-13.67 27.82-9.251 62.23 13.91 85.39l117 117.1c14.62 14.5 38.21 14.5 52.71-.0016l52.75-52.75c14.5-14.5 14.5-38.08-.0016-52.71L384 278.6zM227.9 307L168.7 247.9l-148.9 148.9c-26.37 26.37-26.37 69.08 0 95.45C32.96 505.4 50.21 512 67.5 512s34.54-6.592 47.72-19.78l119.1-119.1C225.5 352.3 222.6 329.4 227.9 307zM64 472c-13.25 0-24-10.75-24-24c0-13.26 10.75-24 24-24S88 434.7 88 448C88 461.3 77.25 472 64 472z")),"label"=>__("Screwdriver Wrench","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"scribd"=>array("svg"=>array("brands"=>array("width"=>384,"height"=>512,"path"=>"M42.3 252.7c-16.1-19-24.7-45.9-24.8-79.9 0-100.4 75.2-153.1 167.2-153.1 98.6-1.6 156.8 49 184.3 70.6l-50.5 72.1-37.3-24.6 26.9-38.6c-36.5-24-79.4-36.5-123-35.8-50.7-.8-111.7 27.2-111.7 76.2 0 18.7 11.2 20.7 28.6 15.6 23.3-5.3 41.9 .6 55.8 14 26.4 24.3 23.2 67.6-.7 91.9-29.2 29.5-85.2 27.3-114.8-8.4zm317.7 5.9c-15.5-18.8-38.9-29.4-63.2-28.6-38.1-2-71.1 28-70.5 67.2-.7 16.8 6 33 18.4 44.3 14.1 13.9 33 19.7 56.3 14.4 17.4-5.1 28.6-3.1 28.6 15.6 0 4.3-.5 8.5-1.4 12.7-16.7 40.9-59.5 64.4-121.4 64.4-51.9 .2-102.4-16.4-144.1-47.3l33.7-39.4-35.6-27.4L0 406.3l15.4 13.8c52.5 46.8 120.4 72.5 190.7 72.2 51.4 0 94.4-10.5 133.6-44.1 57.1-51.4 54.2-149.2 20.3-189.6z")),"label"=>__("Scribd","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"scroll"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M48 32C21.5 32 0 53.5 0 80v64C0 152.9 7.125 160 16 160H96V80C96 53.5 74.5 32 48 32zM256 380.6V320h224V128c0-53-43-96-96-96H111.6C121.8 45.38 128 61.88 128 80V384c0 38.88 34.62 69.63 74.75 63.13C234.3 442 256 412.5 256 380.6zM288 352v32c0 52.88-43 96-96 96h272c61.88 0 112-50.13 112-112c0-8.875-7.125-16-16-16H288z")),"label"=>__("Scroll","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"scroll-torah"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M320 366.5l17.75-29.62l-35.5 .0011L320 366.5zM382.5 311.5l36.75-.0011l-18.38-30.75L382.5 311.5zM48 0C21.5 0 0 14.38 0 32v448c0 17.62 21.5 32 48 32S96 497.6 96 480V32C96 14.38 74.5 0 48 0zM419.2 200.5L382.4 200.5l18.5 30.79L419.2 200.5zM220.8 311.5l36.87-.0012l-18.5-30.87L220.8 311.5zM287.1 311.5L352.9 311.5l33.25-55.5l-33.25-55.5L287.1 200.5L253.9 256L287.1 311.5zM592 0C565.5 0 544 14.38 544 32v448c0 17.62 21.5 32 48 32s48-14.38 48-32V32C640 14.38 618.5 0 592 0zM128 480h384V32H128V480zM194.8 185.9c3.75-6.625 10.87-10.75 18.5-10.75L272.7 175.1l29.12-48.67C305.6 119.1 312.6 116.1 319.1 116.1c7.375-.125 14.25 3.916 17.1 10.17l29.25 48.87l59.5-.0019c7.625 0 14.62 4.124 18.38 10.75s3.626 14.75-.2493 21.25l-29.25 48.87l29.38 48.1c4 6.5 4.001 14.62 .2506 21.12c-3.75 6.625-10.87 10.75-18.5 10.75l-59.5 .0019l-29.12 48.67c-3.75 6.5-10.62 10.33-18.12 10.46c-7.375 0-14.25-3.874-18-10.25l-29.25-48.87l-59.5 .0019c-7.625 0-14.62-4.124-18.37-10.75S191.3 311.4 195.1 304.9l29.25-48.87L195 207C191.1 200.5 191 192.4 194.8 185.9zM319.1 145.5L302.2 175.1l35.37-.0011L319.1 145.5zM257.5 200.5L220.8 200.5l18.38 30.83L257.5 200.5z")),"label"=>__("Scroll Torah","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"sd-card"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M320 0H128L0 128v320c0 35.25 28.75 64 64 64h256c35.25 0 64-28.75 64-64V64C384 28.75 355.3 0 320 0zM160 160H112V64H160V160zM240 160H192V64h48V160zM320 160h-48V64H320V160z")),"label"=>__("Sd Card","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"searchengin"=>array("svg"=>array("brands"=>array("width"=>460,"height"=>512,"path"=>"M220.6 130.3l-67.2 28.2V43.2L98.7 233.5l54.7-24.2v130.3l67.2-209.3zm-83.2-96.7l-1.3 4.7-15.2 52.9C80.6 106.7 52 145.8 52 191.5c0 52.3 34.3 95.9 83.4 105.5v53.6C57.5 340.1 0 272.4 0 191.6c0-80.5 59.8-147.2 137.4-158zm311.4 447.2c-11.2 11.2-23.1 12.3-28.6 10.5-5.4-1.8-27.1-19.9-60.4-44.4-33.3-24.6-33.6-35.7-43-56.7-9.4-20.9-30.4-42.6-57.5-52.4l-9.7-14.7c-24.7 16.9-53 26.9-81.3 28.7l2.1-6.6 15.9-49.5c46.5-11.9 80.9-54 80.9-104.2 0-54.5-38.4-102.1-96-107.1V32.3C254.4 37.4 320 106.8 320 191.6c0 33.6-11.2 64.7-29 90.4l14.6 9.6c9.8 27.1 31.5 48 52.4 57.4s32.2 9.7 56.8 43c24.6 33.2 42.7 54.9 44.5 60.3s.7 17.3-10.5 28.5zm-9.9-17.9c0-4.4-3.6-8-8-8s-8 3.6-8 8 3.6 8 8 8 8-3.6 8-8z")),"label"=>__("Searchengin","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"section"=>array("svg"=>array("solid"=>array("width"=>256,"height"=>512,"path"=>"M224.5 337.4c15.66-14.28 26.09-33.12 29.8-55.82c14.46-88.44-64.67-112.4-117-128.2L124.7 149.5C65.67 131.2 61.11 119.4 64.83 96.79c1.531-9.344 5.715-16.19 13.21-21.56c14.74-10.56 39.94-13.87 69.23-9.029c10.74 1.75 24.36 5.686 41.66 12.03c16.58 6 34.98-2.438 41.04-19.06c6.059-16.59-2.467-34.97-19.05-41.06c-21.39-7.842-38.35-12.62-53.28-15.06c-46.47-7.781-88.1-.5313-116.9 20.19C19.46 38.52 5.965 60.39 1.686 86.48C-5.182 128.6 9.839 156 31.47 174.7C15.87 188.1 5.406 207.8 1.686 230.5C-12.59 317.9 67.36 342.7 105.7 354.6l12.99 3.967c64.71 19.56 76.92 29.09 72.42 56.59c-1.279 7.688-4.84 18.75-21.23 26.16c-15.27 6.906-37.01 8.406-61.4 4.469c-16.74-2.656-37.32-10.5-55.49-17.41l-9.773-3.719c-16.52-6.156-34.95 2.25-41.16 18.75c-6.184 16.56 2.186 34.1 18.74 41.19l9.463 3.594c21.05 8 44.94 17.12 68.02 20.75c12.21 2.031 24.14 3.032 35.54 3.032c23.17 0 44.28-4.157 62.4-12.34c31.95-14.44 52.53-40.75 58.02-74.12C261.1 383.6 246.8 356.3 224.5 337.4zM64.83 240.8c3.303-20.28 21.22-28.1 38.09-31.04c.9258 .2891 15.81 4.852 15.81 4.852c64.71 19.56 76.92 29.09 72.39 56.62c-3.291 20.2-21.12 28.07-37.93 31.04c-5.488-1.746-28.49-8.754-28.49-8.754C65.67 275.2 61.11 263.4 64.83 240.8z")),"label"=>__("Section","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"seedling"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M64 95.1H0c0 123.8 100.3 224 224 224v128C224 465.6 238.4 480 255.1 480S288 465.6 288 448V320C288 196.3 187.7 95.1 64 95.1zM448 32c-84.25 0-157.4 46.5-195.8 115.3c27.75 30.12 48.25 66.88 59 107.5C424 243.1 512 147.9 512 32H448z")),"label"=>__("Seedling","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","environment","lifestyle-and-hobbies","science-and-technology")),"sellcast"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M353.4 32H94.7C42.6 32 0 74.6 0 126.6v258.7C0 437.4 42.6 480 94.7 480h258.7c52.1 0 94.7-42.6 94.7-94.6V126.6c0-52-42.6-94.6-94.7-94.6zm-50 316.4c-27.9 48.2-89.9 64.9-138.2 37.2-22.9 39.8-54.9 8.6-42.3-13.2l15.7-27.2c5.9-10.3 19.2-13.9 29.5-7.9 18.6 10.8-.1-.1 18.5 10.7 27.6 15.9 63.4 6.3 79.4-21.3 15.9-27.6 6.3-63.4-21.3-79.4-17.8-10.2-.6-.4-18.6-10.6-24.6-14.2-3.4-51.9 21.6-37.5 18.6 10.8-.1-.1 18.5 10.7 48.4 28 65.1 90.3 37.2 138.5zm21.8-208.8c-17 29.5-16.3 28.8-19 31.5-6.5 6.5-16.3 8.7-26.5 3.6-18.6-10.8 .1 .1-18.5-10.7-27.6-15.9-63.4-6.3-79.4 21.3s-6.3 63.4 21.3 79.4c0 0 18.5 10.6 18.6 10.6 24.6 14.2 3.4 51.9-21.6 37.5-18.6-10.8 .1 .1-18.5-10.7-48.2-27.8-64.9-90.1-37.1-138.4 27.9-48.2 89.9-64.9 138.2-37.2l4.8-8.4c14.3-24.9 52-3.3 37.7 21.5z")),"label"=>__("Sellcast","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"sellsy"=>array("svg"=>array("brands"=>array("width"=>640,"height"=>512,"path"=>"M539.7 237.3c3.064-12.26 4.29-24.82 4.29-37.38C544 107.4 468.6 32 376.1 32c-77.22 0-144.6 53.01-163 127.8-15.32-13.18-34.93-20.53-55.16-20.53-46.27 0-83.96 37.69-83.96 83.96 0 7.354 .92 15.02 3.065 22.37-42.9 20.23-70.79 63.74-70.79 111.2C6.216 424.8 61.68 480 129.4 480h381.2c67.72 0 123.2-55.16 123.2-123.2 .001-56.38-38.92-106-94.07-119.5zM199.9 401.6c0 8.274-7.048 15.32-15.32 15.32H153.6c-8.274 0-15.32-7.048-15.32-15.32V290.6c0-8.273 7.048-15.32 15.32-15.32h30.95c8.274 0 15.32 7.048 15.32 15.32v110.9zm89.48 0c0 8.274-7.048 15.32-15.32 15.32h-30.95c-8.274 0-15.32-7.048-15.32-15.32V270.1c0-8.274 7.048-15.32 15.32-15.32h30.95c8.274 0 15.32 7.048 15.32 15.32v131.5zm89.48 0c0 8.274-7.047 15.32-15.32 15.32h-30.95c-8.274 0-15.32-7.048-15.32-15.32V238.8c0-8.274 7.048-15.32 15.32-15.32h30.95c8.274 0 15.32 7.048 15.32 15.32v162.7zm87.03 0c0 8.274-7.048 15.32-15.32 15.32h-28.5c-8.274 0-15.32-7.048-15.32-15.32V176.9c0-8.579 7.047-15.63 15.32-15.63h28.5c8.274 0 15.32 7.048 15.32 15.63v224.6z")),"label"=>__("Sellsy","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"server"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M480 288H32c-17.62 0-32 14.38-32 32v128c0 17.62 14.38 32 32 32h448c17.62 0 32-14.38 32-32v-128C512 302.4 497.6 288 480 288zM352 408c-13.25 0-24-10.75-24-24s10.75-24 24-24s24 10.75 24 24S365.3 408 352 408zM416 408c-13.25 0-24-10.75-24-24s10.75-24 24-24s24 10.75 24 24S429.3 408 416 408zM480 32H32C14.38 32 0 46.38 0 64v128c0 17.62 14.38 32 32 32h448c17.62 0 32-14.38 32-32V64C512 46.38 497.6 32 480 32zM352 152c-13.25 0-24-10.75-24-24S338.8 104 352 104S376 114.8 376 128S365.3 152 352 152zM416 152c-13.25 0-24-10.75-24-24S402.8 104 416 104S440 114.8 440 128S429.3 152 416 152z")),"label"=>__("Server","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"servicestack"=>array("svg"=>array("brands"=>array("width"=>496,"height"=>512,"path"=>"M88 216c81.7 10.2 273.7 102.3 304 232H0c99.5-8.1 184.5-137 88-232zm32-152c32.3 35.6 47.7 83.9 46.4 133.6C249.3 231.3 373.7 321.3 400 448h96C455.3 231.9 222.8 79.5 120 64z")),"label"=>__("Servicestack","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"shapes"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M411.4 175.5C417.4 185.4 417.5 197.7 411.8 207.8C406.2 217.8 395.5 223.1 384 223.1H192C180.5 223.1 169.8 217.8 164.2 207.8C158.5 197.7 158.6 185.4 164.6 175.5L260.6 15.54C266.3 5.897 276.8 0 288 0C299.2 0 309.7 5.898 315.4 15.54L411.4 175.5zM288 312C288 289.9 305.9 272 328 272H472C494.1 272 512 289.9 512 312V456C512 478.1 494.1 496 472 496H328C305.9 496 288 478.1 288 456V312zM0 384C0 313.3 57.31 256 128 256C198.7 256 256 313.3 256 384C256 454.7 198.7 512 128 512C57.31 512 0 454.7 0 384z")),"label"=>__("Shapes","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design","education")),"share"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M503.7 226.2l-176 151.1c-15.38 13.3-39.69 2.545-39.69-18.16V272.1C132.9 274.3 66.06 312.8 111.4 457.8c5.031 16.09-14.41 28.56-28.06 18.62C39.59 444.6 0 383.8 0 322.3c0-152.2 127.4-184.4 288-186.3V56.02c0-20.67 24.28-31.46 39.69-18.16l176 151.1C514.8 199.4 514.8 216.6 503.7 226.2z")),"label"=>__("Share","ultimate-addons-for-gutenberg"),"custom_categories"=>array("social")),"share-from-square"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M568.9 143.5l-150.9-138.2C404.8-6.773 384 3.039 384 21.84V96C241.2 97.63 128 126.1 128 260.6c0 54.3 35.2 108.1 74.08 136.2c12.14 8.781 29.42-2.238 24.94-16.46C186.7 252.2 256 224 384 223.1v74.2c0 18.82 20.84 28.59 34.02 16.51l150.9-138.2C578.4 167.8 578.4 152.2 568.9 143.5zM416 384c-17.67 0-32 14.33-32 32v31.1l-320-.0013V128h32c17.67 0 32-14.32 32-32S113.7 64 96 64H64C28.65 64 0 92.65 0 128v319.1c0 35.34 28.65 64 64 64l320-.0013c35.35 0 64-28.66 64-64V416C448 398.3 433.7 384 416 384z"),"regular"=>array("width"=>576,"height"=>512,"path"=>"M568.5 142.6l-144-135.1c-9.625-9.156-24.81-8.656-33.91 .9687c-9.125 9.625-8.688 24.81 .9687 33.91l100.1 94.56h-163.4C287.5 134.2 249.7 151 221 179.4C192 208.2 176 246.7 176 288v87.1c0 13.25 10.75 23.1 24 23.1S224 389.3 224 376V288c0-28.37 10.94-54.84 30.78-74.5C274.3 194.2 298.9 183 328 184h163.6l-100.1 94.56c-9.656 9.094-10.09 24.28-.9687 33.91c4.719 4.1 11.06 7.531 17.44 7.531c5.906 0 11.84-2.156 16.47-6.562l144-135.1C573.3 172.9 576 166.6 576 160S573.3 147.1 568.5 142.6zM360 384c-13.25 0-24 10.75-24 23.1v47.1c0 4.406-3.594 7.1-8 7.1h-272c-4.406 0-8-3.594-8-7.1V184c0-4.406 3.594-7.1 8-7.1H112c13.25 0 24-10.75 24-23.1s-10.75-23.1-24-23.1H56c-30.88 0-56 25.12-56 55.1v271.1C0 486.9 25.13 512 56 512h272c30.88 0 56-25.12 56-55.1v-47.1C384 394.8 373.3 384 360 384z")),"label"=>__("Share From Square","ultimate-addons-for-gutenberg"),"custom_categories"=>array("social")),"share-nodes"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M448 127.1C448 181 405 223.1 352 223.1C326.1 223.1 302.6 213.8 285.4 197.1L191.3 244.1C191.8 248 191.1 251.1 191.1 256C191.1 260 191.8 263.1 191.3 267.9L285.4 314.9C302.6 298.2 326.1 288 352 288C405 288 448 330.1 448 384C448 437 405 480 352 480C298.1 480 256 437 256 384C256 379.1 256.2 376 256.7 372.1L162.6 325.1C145.4 341.8 121.9 352 96 352C42.98 352 0 309 0 256C0 202.1 42.98 160 96 160C121.9 160 145.4 170.2 162.6 186.9L256.7 139.9C256.2 135.1 256 132 256 128C256 74.98 298.1 32 352 32C405 32 448 74.98 448 128L448 127.1zM95.1 287.1C113.7 287.1 127.1 273.7 127.1 255.1C127.1 238.3 113.7 223.1 95.1 223.1C78.33 223.1 63.1 238.3 63.1 255.1C63.1 273.7 78.33 287.1 95.1 287.1zM352 95.1C334.3 95.1 320 110.3 320 127.1C320 145.7 334.3 159.1 352 159.1C369.7 159.1 384 145.7 384 127.1C384 110.3 369.7 95.1 352 95.1zM352 416C369.7 416 384 401.7 384 384C384 366.3 369.7 352 352 352C334.3 352 320 366.3 320 384C320 401.7 334.3 416 352 416z")),"label"=>__("Share Nodes","ultimate-addons-for-gutenberg"),"custom_categories"=>array("social","brands","brands","social")),"sheet-plastic"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M0 64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V352H256C238.3 352 224 366.3 224 384V512H64C28.65 512 0 483.3 0 448V64zM171.3 52.69C165.1 46.44 154.9 46.44 148.7 52.69L52.69 148.7C46.44 154.9 46.44 165.1 52.69 171.3C58.93 177.6 69.06 177.6 75.31 171.3L171.3 75.31C177.6 69.07 177.6 58.94 171.3 52.69V52.69zM267.3 107.3C273.6 101.1 273.6 90.93 267.3 84.69C261.1 78.44 250.9 78.44 244.7 84.69L84.69 244.7C78.44 250.9 78.44 261.1 84.69 267.3C90.93 273.6 101.1 273.6 107.3 267.3L267.3 107.3zM384 384L256 512V384H384z")),"label"=>__("Sheet Plastic","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies")),"shekel-sign"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M192 32C262.7 32 320 89.31 320 160V320C320 337.7 305.7 352 288 352C270.3 352 256 337.7 256 320V160C256 124.7 227.3 96 192 96H64V448C64 465.7 49.67 480 32 480C14.33 480 0 465.7 0 448V64C0 46.33 14.33 32 32 32H192zM160 480C142.3 480 128 465.7 128 448V192C128 174.3 142.3 160 160 160C177.7 160 192 174.3 192 192V416H320C355.3 416 384 387.3 384 352V64C384 46.33 398.3 32 416 32C433.7 32 448 46.33 448 64V352C448 422.7 390.7 480 320 480H160z")),"label"=>__("Shekel Sign","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"shield"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M256-.0078C260.7-.0081 265.2 1.008 269.4 2.913L457.7 82.79C479.7 92.12 496.2 113.8 496 139.1C495.5 239.2 454.7 420.7 282.4 503.2C265.7 511.1 246.3 511.1 229.6 503.2C57.25 420.7 16.49 239.2 15.1 139.1C15.87 113.8 32.32 92.12 54.3 82.79L242.7 2.913C246.8 1.008 251.4-.0081 256-.0078V-.0078z")),"label"=>__("Shield","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design","science-and-technology")),"shield-cat"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M199.1 272C199.1 263.2 207.2 256 215.1 256C224.8 256 231.1 263.2 231.1 272C231.1 280.8 224.8 288 215.1 288C207.2 288 199.1 280.8 199.1 272zM312 272C312 280.8 304.8 288 296 288C287.2 288 280 280.8 280 272C280 263.2 287.2 256 296 256C304.8 256 312 263.2 312 272zM256.3-.0068C261.9-.0507 267.3 1.386 272.1 4.066L476.5 90.53C487.7 95.27 495.2 105.1 495.9 118.1C501.6 213.6 466.7 421.9 272.5 507.7C267.6 510.5 261.1 512.1 256.3 512C250.5 512.1 244.9 510.5 239.1 507.7C45.8 421.9 10.95 213.6 16.57 118.1C17.28 105.1 24.83 95.27 36.04 90.53L240.4 4.066C245.2 1.386 250.7-.0507 256.3-.0068H256.3zM223.1 208L159.1 144V272C159.1 325 202.1 368 255.1 368C309 368 352 325 352 272V144L288 208H223.1z")),"label"=>__("Shield Cat","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment","science-and-technology")),"shield-dog"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M288 208C288 216.8 280.8 224 272 224C263.2 224 255.1 216.8 255.1 208C255.1 199.2 263.2 192 272 192C280.8 192 288 199.2 288 208zM256.3-.0068C261.9-.0507 267.3 1.386 272.1 4.066L476.5 90.53C487.7 95.27 495.2 105.1 495.9 118.1C501.6 213.6 466.7 421.9 272.5 507.7C267.6 510.5 261.1 512.1 256.3 512C250.5 512.1 244.9 510.5 239.1 507.7C45.8 421.9 10.95 213.6 16.57 118.1C17.28 105.1 24.83 95.27 36.04 90.53L240.4 4.066C245.2 1.386 250.7-.0507 256.3-.0068H256.3zM160.9 286.2L143.1 320L272 384V320H320C364.2 320 400 284.2 400 240V208C400 199.2 392.8 192 384 192H320L312.8 177.7C307.4 166.8 296.3 160 284.2 160H239.1V224C239.1 259.3 211.3 288 175.1 288C170.8 288 165.7 287.4 160.9 286.2H160.9zM143.1 176V224C143.1 241.7 158.3 256 175.1 256C193.7 256 207.1 241.7 207.1 224V160H159.1C151.2 160 143.1 167.2 143.1 176z")),"label"=>__("Shield Dog","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment","science-and-technology")),"shield-halved"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M256-.0078C260.7-.0081 265.2 1.008 269.4 2.913L457.7 82.79C479.7 92.12 496.2 113.8 496 139.1C495.5 239.2 454.7 420.7 282.4 503.2C265.7 511.1 246.3 511.1 229.6 503.2C57.25 420.7 16.49 239.2 15.1 139.1C15.87 113.8 32.32 92.12 54.3 82.79L242.7 2.913C246.8 1.008 251.4-.0081 256-.0078V-.0078zM256 444.8C393.1 378 431.1 230.1 432 141.4L256 66.77L256 444.8z")),"label"=>__("Shield Halved","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","science-and-technology")),"shield-heart"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M256.3-.0068C261.9-.0507 267.3 1.386 272.1 4.066L476.5 90.53C487.7 95.27 495.2 105.1 495.9 118.1C501.6 213.6 466.7 421.9 272.5 507.7C267.6 510.5 261.1 512.1 256.3 512C250.5 512.1 244.9 510.5 239.1 507.7C45.8 421.9 10.95 213.6 16.57 118.1C17.28 105.1 24.83 95.27 36.04 90.53L240.4 4.066C245.2 1.386 250.7-.0507 256.3-.0068H256.3zM266.1 363.4L364.2 263.6C392.2 234.7 390.5 186.6 358.1 159.5C331.8 135.8 291.5 140.2 266.1 166.5L256.4 176.1L245.9 166.5C221.4 140.2 180.2 135.8 153 159.5C121.5 186.6 119.8 234.7 147.8 263.6L244.2 363.4C251.2 369.5 260.8 369.5 266.1 363.4V363.4z")),"label"=>__("Shield Heart","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"shield-virus"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M288 255.1c-8.836 0-16 7.162-16 16c0 8.836 7.164 15.1 16 15.1s16-7.163 16-15.1C304 263.2 296.8 255.1 288 255.1zM224 191.1c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 15.1 16s16-7.164 16-16C240 199.2 232.8 191.1 224 191.1zM466.5 83.68l-192-80.01C269.6 1.641 261.3 0 256.1 0C250.7 0 242.5 1.641 237.6 3.672l-192 80.01C27.69 91.07 16 108.6 16 127.1C16 385.2 205.2 512 255.9 512c52.02 0 240.1-128.2 240.1-384C496 108.6 484.3 91.07 466.5 83.68zM384 255.1h-12.12c-19.29 0-32.06 15.78-32.06 32.23c0 7.862 2.918 15.88 9.436 22.4l8.576 8.576c3.125 3.125 4.688 7.218 4.688 11.31c0 8.527-6.865 15.1-16 15.1c-4.094 0-8.188-1.562-11.31-4.688l-8.576-8.576c-6.519-6.519-14.53-9.436-22.4-9.436c-16.45 0-32.23 12.77-32.23 32.06v12.12c0 8.844-7.156 16-16 16s-16-7.156-16-16v-12.12c0-19.29-15.78-32.06-32.23-32.06c-7.862 0-15.87 2.917-22.39 9.436l-8.576 8.576c-3.125 3.125-7.219 4.688-11.31 4.688c-9.139 0-16-7.473-16-15.1c0-4.094 1.562-8.187 4.688-11.31l8.576-8.576c6.519-6.519 9.436-14.53 9.436-22.4c0-16.45-12.77-32.23-32.06-32.23H128c-8.844 0-16-7.156-16-16s7.156-16 16-16h12.12c19.29 0 32.06-15.78 32.06-32.23c0-7.862-2.918-15.88-9.436-22.4L154.2 160.8C151 157.7 149.5 153.6 149.5 149.5c0-8.527 6.865-15.1 16-15.1c4.094 0 8.188 1.562 11.31 4.688L185.4 146.7C191.9 153.3 199.9 156.2 207.8 156.2c16.45 0 32.23-12.77 32.23-32.07V111.1c0-8.844 7.156-16 16-16s16 7.156 16 16v12.12c0 19.29 15.78 32.07 32.23 32.07c7.862 0 15.88-2.917 22.4-9.436l8.576-8.577c3.125-3.125 7.219-4.688 11.31-4.688c9.139 0 16 7.473 16 15.1c0 4.094-1.562 8.187-4.688 11.31l-8.576 8.577c-6.519 6.519-9.436 14.53-9.436 22.4c0 16.45 12.77 32.23 32.06 32.23h12.12c8.844 0 16 7.156 16 16S392.8 255.1 384 255.1z")),"label"=>__("Shield Virus","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"ship"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M192 32C192 14.33 206.3 0 224 0H352C369.7 0 384 14.33 384 32V64H432C458.5 64 480 85.49 480 112V240L524.4 254.8C547.6 262.5 553.9 292.3 535.9 308.7L434.9 401.4C418.7 410.7 400.2 416.5 384 416.5C364.4 416.5 343.2 408.8 324.8 396.1C302.8 380.6 273.3 380.6 251.2 396.1C234 407.9 213.2 416.5 192 416.5C175.8 416.5 157.3 410.7 141.1 401.3L40.09 308.7C22.1 292.3 28.45 262.5 51.59 254.8L96 239.1V111.1C96 85.49 117.5 63.1 144 63.1H192V32zM160 218.7L267.8 182.7C280.9 178.4 295.1 178.4 308.2 182.7L416 218.7V128H160V218.7zM384 448C410.9 448 439.4 437.2 461.4 421.9L461.5 421.9C473.4 413.4 489.5 414.1 500.7 423.6C515 435.5 533.2 444.6 551.3 448.8C568.5 452.8 579.2 470.1 575.2 487.3C571.2 504.5 553.1 515.2 536.7 511.2C512.2 505.4 491.9 494.6 478.5 486.2C449.5 501.7 417 512 384 512C352.1 512 323.4 502.1 303.6 493.1C297.7 490.5 292.5 487.8 288 485.4C283.5 487.8 278.3 490.5 272.4 493.1C252.6 502.1 223.9 512 192 512C158.1 512 126.5 501.7 97.5 486.2C84.12 494.6 63.79 505.4 39.27 511.2C22.06 515.2 4.853 504.5 .8422 487.3C-3.169 470.1 7.532 452.8 24.74 448.8C42.84 444.6 60.96 435.5 75.31 423.6C86.46 414.1 102.6 413.4 114.5 421.9L114.6 421.9C136.7 437.2 165.1 448 192 448C219.5 448 247 437.4 269.5 421.9C280.6 414 295.4 414 306.5 421.9C328.1 437.4 356.5 448 384 448H384z")),"label"=>__("Ship","ultimate-addons-for-gutenberg"),"custom_categories"=>array("travel")),"shirt"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M640 162.8c0 6.917-2.293 13.88-7.012 19.7l-49.96 61.63c-6.32 7.796-15.62 11.85-25.01 11.85c-7.01 0-14.07-2.262-19.97-6.919L480 203.3V464c0 26.51-21.49 48-48 48H208C181.5 512 160 490.5 160 464V203.3L101.1 249.1C96.05 253.7 88.99 255.1 81.98 255.1c-9.388 0-18.69-4.057-25.01-11.85L7.012 182.5C2.292 176.7-.0003 169.7-.0003 162.8c0-9.262 4.111-18.44 12.01-24.68l135-106.6C159.8 21.49 175.7 16 191.1 16H225.6C233.3 61.36 272.5 96 320 96s86.73-34.64 94.39-80h33.6c16.35 0 32.22 5.49 44.99 15.57l135 106.6C635.9 144.4 640 153.6 640 162.8z")),"label"=>__("Shirt","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"shirtsinbulk"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M100 410.3l30.6 13.4 4.4-9.9-30.6-13.4zm39.4 17.5l30.6 13.4 4.4-9.9-30.6-13.4zm172.1-14l4.4 9.9 30.6-13.4-4.4-9.9zM179.1 445l30.3 13.7 4.4-9.9-30.3-13.4zM60.4 392.8L91 406.2l4.4-9.6-30.6-13.7zm211.4 38.5l4.4 9.9 30.6-13.4-4.4-9.9zm-39.3 17.5l4.4 9.9 30.6-13.7-4.4-9.6zm118.4-52.2l4.4 9.6 30.6-13.4-4.4-9.9zM170 46.6h-33.5v10.5H170zm-47.2 0H89.2v10.5h33.5zm-47.3 0H42.3v10.5h33.3zm141.5 0h-33.2v10.5H217zm94.5 0H278v10.5h33.5zm47.3 0h-33.5v10.5h33.5zm-94.6 0H231v10.5h33.2zm141.5 0h-33.3v10.5h33.3zM52.8 351.1H42v33.5h10.8zm70-215.9H89.2v10.5h33.5zm-70 10.6h22.8v-10.5H42v33.5h10.8zm168.9 228.6c50.5 0 91.3-40.8 91.3-91.3 0-50.2-40.8-91.3-91.3-91.3-50.2 0-91.3 41.1-91.3 91.3 0 50.5 41.1 91.3 91.3 91.3zm-48.2-111.1c0-25.4 29.5-31.8 49.6-31.8 16.9 0 29.2 5.8 44.3 12l-8.8 16.9h-.9c-6.4-9.9-24.8-13.1-35.6-13.1-9 0-29.8 1.8-29.8 14.9 0 21.6 78.5-10.2 78.5 37.9 0 25.4-31.5 31.2-51 31.2-18.1 0-32.4-2.9-47.2-12.2l9-18.4h.9c6.1 12.2 23.6 14.9 35.9 14.9 8.7 0 32.7-1.2 32.7-14.3 0-26.1-77.6 6.3-77.6-38zM52.8 178.4H42V212h10.8zm342.4 206.2H406v-33.5h-10.8zM52.8 307.9H42v33.5h10.8zM0 3.7v406l221.7 98.6L448 409.7V3.7zm418.8 387.1L222 476.5 29.2 390.8V120.7h389.7v270.1zm0-299.3H29.2V32.9h389.7v58.6zm-366 130.1H42v33.5h10.8zm0 43.2H42v33.5h10.8zM170 135.2h-33.5v10.5H170zm225.2 163.1H406v-33.5h-10.8zm0-43.2H406v-33.5h-10.8zM217 135.2h-33.2v10.5H217zM395.2 212H406v-33.5h-10.8zm0 129.5H406V308h-10.8zm-131-206.3H231v10.5h33.2zm47.3 0H278v10.5h33.5zm83.7 33.6H406v-33.5h-33.5v10.5h22.8zm-36.4-33.6h-33.5v10.5h33.5z")),"label"=>__("Shirts in Bulk","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"shoe-prints"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M192 159.1L224 159.1V32L192 32c-35.38 0-64 28.62-64 63.1S156.6 159.1 192 159.1zM0 415.1c0 35.37 28.62 64.01 64 64.01l32-.0103v-127.1l-32-.0005C28.62 351.1 0 380.6 0 415.1zM337.5 287.1c-35 0-76.25 13.12-104.8 31.1C208 336.4 188.3 351.1 128 351.1v128l57.5 15.98c26.25 7.25 53 13.13 80.38 15.01c32.63 2.375 65.63 .743 97.5-6.132C472.9 481.2 512 429.2 512 383.1C512 319.1 427.9 287.1 337.5 287.1zM491.4 7.252c-31.88-6.875-64.88-8.625-97.5-6.25C366.5 2.877 339.8 8.752 313.5 16L256 32V159.1c60.25 0 80 15.62 104.8 31.1c28.5 18.87 69.75 31.1 104.8 31.1C555.9 223.1 640 191.1 640 127.1C640 82.75 600.9 30.75 491.4 7.252z")),"label"=>__("Shoe Prints","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","travel")),"shop"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M0 155.2C0 147.9 2.153 140.8 6.188 134.7L81.75 21.37C90.65 8.021 105.6 0 121.7 0H518.3C534.4 0 549.3 8.021 558.2 21.37L633.8 134.7C637.8 140.8 640 147.9 640 155.2C640 175.5 623.5 192 603.2 192H36.84C16.5 192 .0003 175.5 .0003 155.2H0zM64 224H128V384H320V224H384V464C384 490.5 362.5 512 336 512H112C85.49 512 64 490.5 64 464V224zM512 224H576V480C576 497.7 561.7 512 544 512C526.3 512 512 497.7 512 480V224z")),"label"=>__("Shop","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies")),"shop-lock"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M0 155.2C0 147.9 2.153 140.8 6.188 134.7L81.75 21.37C90.65 8.021 105.6 0 121.7 0H518.3C534.4 0 549.3 8.021 558.2 21.37L633.8 134.7C637.8 140.8 640 147.9 640 155.2C640 174.5 625.2 190.3 606.3 191.9C586.1 172.2 558.5 160 528 160C497.5 160 469.8 172.2 449.6 192H36.84C16.5 192 .0003 175.5 .0003 155.2H0zM384 224V464C384 490.5 362.5 512 336 512H112C85.49 512 64 490.5 64 464V224H128V384H320V224H384zM528 192C572.2 192 608 227.8 608 272V320C625.7 320 640 334.3 640 352V480C640 497.7 625.7 512 608 512H448C430.3 512 416 497.7 416 480V352C416 334.3 430.3 320 448 320V272C448 227.8 483.8 192 528 192zM528 240C510.3 240 496 254.3 496 272V320H560V272C560 254.3 545.7 240 528 240z")),"label"=>__("Shop Lock","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies")),"shop-slash"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M74.13 32.8L81.75 21.38C90.65 8.022 105.6 .001 121.7 .001H518.3C534.4 .001 549.3 8.022 558.2 21.38L633.8 134.7C637.8 140.8 640 147.9 640 155.2C640 175.5 623.5 192 603.2 192H277.3L320 225.5V224H384V275.7L512 375.1V224H576V426.2L630.8 469.1C641.2 477.3 643.1 492.4 634.9 502.8C626.7 513.2 611.6 515.1 601.2 506.9L9.196 42.89C-1.236 34.71-3.065 19.63 5.112 9.196C13.29-1.236 28.37-3.065 38.81 5.112L74.13 32.8zM0 155.2C0 147.9 2.153 140.8 6.188 134.7L20.98 112.5L121.8 192H36.84C16.5 192 .0003 175.5 .0003 155.2H0zM320 384V348.1L384 398.5V464C384 490.5 362.5 512 336 512H112C85.49 512 64 490.5 64 464V224H128V384H320z")),"label"=>__("Shop Slash","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"shopify"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M388.3 104.1a4.66 4.66 0 0 0 -4.4-4c-2 0-37.23-.8-37.23-.8s-21.61-20.82-29.62-28.83V503.2L442.8 472S388.7 106.5 388.3 104.1zM288.6 70.47a116.7 116.7 0 0 0 -7.21-17.61C271 32.85 255.4 22 237 22a15 15 0 0 0 -4 .4c-.4-.8-1.2-1.2-1.6-2C223.4 11.63 213 7.63 200.6 8c-24 .8-48 18-67.25 48.83-13.61 21.62-24 48.84-26.82 70.06-27.62 8.4-46.83 14.41-47.23 14.81-14 4.4-14.41 4.8-16 18-1.2 10-38 291.8-38 291.8L307.9 504V65.67a41.66 41.66 0 0 0 -4.4 .4S297.9 67.67 288.6 70.47zM233.4 87.69c-16 4.8-33.63 10.4-50.84 15.61 4.8-18.82 14.41-37.63 25.62-50 4.4-4.4 10.41-9.61 17.21-12.81C232.2 54.86 233.8 74.48 233.4 87.69zM200.6 24.44A27.49 27.49 0 0 1 215 28c-6.4 3.2-12.81 8.41-18.81 14.41-15.21 16.42-26.82 42-31.62 66.45-14.42 4.41-28.83 8.81-42 12.81C131.3 83.28 163.8 25.24 200.6 24.44zM154.1 244.6c1.6 25.61 69.25 31.22 73.25 91.66 2.8 47.64-25.22 80.06-65.65 82.47-48.83 3.2-75.65-25.62-75.65-25.62l10.4-44s26.82 20.42 48.44 18.82c14-.8 19.22-12.41 18.81-20.42-2-33.62-57.24-31.62-60.84-86.86-3.2-46.44 27.22-93.27 94.47-97.68 26-1.6 39.23 4.81 39.23 4.81L221.4 225.4s-17.21-8-37.63-6.4C154.1 221 153.8 239.8 154.1 244.6zM249.4 82.88c0-12-1.6-29.22-7.21-43.63 18.42 3.6 27.22 24 31.23 36.43Q262.6 78.68 249.4 82.88z")),"label"=>__("Shopify","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"shopware"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M403.5 455.4A246.2 246.2 0 0 1 256 504C118.8 504 8 393 8 256 8 118.8 119 8 256 8a247.4 247.4 0 0 1 165.7 63.5 3.57 3.57 0 0 1 -2.86 6.18A418.6 418.6 0 0 0 362.1 74c-129.4 0-222.4 53.47-222.4 155.4 0 109 92.13 145.9 176.8 178.7 33.64 13 65.4 25.36 87 41.59a3.58 3.58 0 0 1 0 5.72zM503 233.1a3.64 3.64 0 0 0 -1.27-2.44c-51.76-43-93.62-60.48-144.5-60.48-84.13 0-80.25 52.17-80.25 53.63 0 42.6 52.06 62 112.3 84.49 31.07 11.59 63.19 23.57 92.68 39.93a3.57 3.57 0 0 0 5-1.82A249 249 0 0 0 503 233.1z")),"label"=>__("Shopware","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"shower"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M288 384c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C320 398.3 305.7 384 288 384zM416 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C448 270.3 433.7 256 416 256zM480 192c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C512 206.3 497.7 192 480 192zM288 320c0-17.67-14.33-32-32-32s-32 14.33-32 32c0 17.67 14.33 32 32 32S288 337.7 288 320zM320 224c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C352 238.3 337.7 224 320 224zM384 224c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32s-32 14.33-32 32C352 209.7 366.3 224 384 224zM352 320c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C384 334.3 369.7 320 352 320zM347.3 91.31l-11.31-11.31c-6.248-6.248-16.38-6.248-22.63 0l-6.631 6.631c-35.15-26.29-81.81-29.16-119.6-8.779L170.5 61.25C132.2 22.95 63.65 18.33 21.98 71.16C7.027 90.11 0 114.3 0 138.4V464C0 472.8 7.164 480 16 480h32C56.84 480 64 472.8 64 464V131.9c0-19.78 16.09-35.87 35.88-35.87c9.438 0 18.69 3.828 25.38 10.5l16.61 16.61C121.5 160.9 124.3 207.6 150.6 242.7L144 249.4c-6.248 6.248-6.248 16.38 0 22.63l11.31 11.31c6.248 6.25 16.38 6.25 22.63 0l169.4-169.4C353.6 107.7 353.6 97.56 347.3 91.31z")),"label"=>__("Shower","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","travel")),"shrimp"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M288 320V128H64C46.34 128 32 113.6 32 96s14.34-32 32-32h368c8.844 0 16-7.156 16-16s-7.156-16-16-16H64C28.72 32 0 60.7 0 96s28.72 64 64 64h2.879c15.26 90.77 94.01 160 189.1 160H288zM192 216c-13.25 0-24-10.75-24-24c0-13.26 10.75-24 24-24s24 10.74 24 24C216 205.3 205.3 216 192 216zM225.6 399.4c-4.75 12.36 1.406 26.25 13.78 31.02l5.688 2.188C233.3 434.1 224 443.8 224 456c0 13.25 10.75 24 24 24h72v-70.03l-63.38-24.38C244.3 380.9 230.4 386.1 225.6 399.4zM511.2 286.7c-.5488-5.754-2.201-11.1-3.314-16.65l-124.6 90.62c.3711 2.404 .7383 4.814 .7383 7.322c0 1.836-.3379 3.576-.5391 5.357l90.15 40.06C500.8 379.2 515.8 334.8 511.2 286.7zM352 413.1v66.08c37.23-3.363 71.04-18.3 97.94-41.21l-80.34-35.71C364.7 407.1 358.6 410.7 352 413.1zM497.9 237.7C470.1 172.4 402.8 128 328.4 128h-8.436v192h16c12.28 0 23.36 4.748 31.85 12.33L497.9 237.7z")),"label"=>__("Shrimp","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment","lifestyle-and-hobbies","travel")),"shuffle"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M424.1 287c-15.13-15.12-40.1-4.426-40.1 16.97V352H336L153.6 108.8C147.6 100.8 138.1 96 128 96H32C14.31 96 0 110.3 0 128s14.31 32 32 32h80l182.4 243.2C300.4 411.3 309.9 416 320 416h63.97v47.94c0 21.39 25.86 32.12 40.99 17l79.1-79.98c9.387-9.387 9.387-24.59 0-33.97L424.1 287zM336 160h47.97v48.03c0 21.39 25.87 32.09 40.1 16.97l79.1-79.98c9.387-9.391 9.385-24.59-.0013-33.97l-79.1-79.98c-15.13-15.12-40.99-4.391-40.99 17V96H320c-10.06 0-19.56 4.75-25.59 12.81L254 162.7L293.1 216L336 160zM112 352H32c-17.69 0-32 14.31-32 32s14.31 32 32 32h96c10.06 0 19.56-4.75 25.59-12.81l40.4-53.87L154 296L112 352z")),"label"=>__("Shuffle","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","science-and-technology")),"shuttle-space"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M129.1 480H128V384H352L245.2 448.1C210.4 468.1 170.6 480 129.1 480zM352 128H128V32H129.1C170.6 32 210.4 43.03 245.2 63.92L352 128zM104 128C130.2 128 153.4 140.6 168 160H456C525.3 160 591 182.7 635.2 241.6C641.6 250.1 641.6 261.9 635.2 270.4C591 329.3 525.3 352 456 352H168C153.4 371.4 130.2 384 104 384H96V480H80C53.49 480 32 458.5 32 432V384H40C17.91 384 0 366.1 0 344V168C0 145.9 17.89 128 39.96 128H32V80C32 53.49 53.49 32 80 32H96V128H104zM476.4 208C473.1 208 472 209.1 472 212.4V299.6C472 302 473.1 304 476.4 304C496.1 304 512 288.1 512 268.4V243.6C512 223.9 496.1 208 476.4 208z")),"label"=>__("Shuttle Space","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology","travel")),"sign-hanging"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M96 0C113.7 0 128 14.33 128 32V64H480C497.7 64 512 78.33 512 96C512 113.7 497.7 128 480 128H128V480C128 497.7 113.7 512 96 512C78.33 512 64 497.7 64 480V128H32C14.33 128 0 113.7 0 96C0 78.33 14.33 64 32 64H64V32C64 14.33 78.33 0 96 0zM448 160C465.7 160 480 174.3 480 192V352C480 369.7 465.7 384 448 384H192C174.3 384 160 369.7 160 352V192C160 174.3 174.3 160 192 160H448z")),"label"=>__("Sign Hanging","ultimate-addons-for-gutenberg"),"custom_categories"=>array("travel")),"signal"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M544 0c-17.67 0-32 14.33-32 31.1V480C512 497.7 526.3 512 544 512s32-14.33 32-31.1V31.1C576 14.33 561.7 0 544 0zM160 288C142.3 288 128 302.3 128 319.1v160C128 497.7 142.3 512 160 512s32-14.33 32-31.1V319.1C192 302.3 177.7 288 160 288zM32 384C14.33 384 0 398.3 0 415.1v64C0 497.7 14.33 512 31.1 512S64 497.7 64 480V415.1C64 398.3 49.67 384 32 384zM416 96c-17.67 0-32 14.33-32 31.1V480C384 497.7 398.3 512 416 512s32-14.33 32-31.1V127.1C448 110.3 433.7 96 416 96zM288 192C270.3 192 256 206.3 256 223.1v256C256 497.7 270.3 512 288 512s32-14.33 32-31.1V223.1C320 206.3 305.7 192 288 192z")),"label"=>__("Signal","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology","travel")),"signature"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M192 160C192 177.7 177.7 192 160 192C142.3 192 128 177.7 128 160V128C128 74.98 170.1 32 224 32C277 32 320 74.98 320 128V135.8C320 156.6 318.8 177.4 316.4 198.1L438.8 161.3C450.2 157.9 462.6 161.1 470.1 169.7C479.3 178.3 482.1 190.8 478.4 202.1L460.4 255.1H544C561.7 255.1 576 270.3 576 287.1C576 305.7 561.7 319.1 544 319.1H416C405.7 319.1 396.1 315.1 390 306.7C384 298.4 382.4 287.6 385.6 277.9L398.1 240.4L303.7 268.7C291.9 321.5 272.2 372.2 245.3 419.2L231.4 443.5C218.5 466.1 194.5 480 168.5 480C128.5 480 95.1 447.5 95.1 407.5V335.6C95.1 293.2 123.8 255.8 164.4 243.7L248.8 218.3C253.6 191.1 255.1 163.5 255.1 135.8V128C255.1 110.3 241.7 96 223.1 96C206.3 96 191.1 110.3 191.1 128L192 160zM160 335.6V407.5C160 412.2 163.8 416 168.5 416C171.5 416 174.4 414.4 175.9 411.7L189.8 387.4C207.3 356.6 221.4 324.1 231.8 290.3L182.8 304.1C169.3 309 160 321.5 160 335.6V335.6zM24 368H64V407.5C64 410.4 64.11 413.2 64.34 416H24C10.75 416 0 405.3 0 392C0 378.7 10.75 368 24 368zM616 416H283.5C291.7 400.3 299.2 384.3 305.9 368H616C629.3 368 640 378.7 640 392C640 405.3 629.3 416 616 416z")),"label"=>__("Signature","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","communication","design")),"signs-post"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M223.1 32C223.1 14.33 238.3 0 255.1 0C273.7 0 288 14.33 288 32H441.4C445.6 32 449.7 33.69 452.7 36.69L500.7 84.69C506.9 90.93 506.9 101.1 500.7 107.3L452.7 155.3C449.7 158.3 445.6 160 441.4 160H63.1C46.33 160 31.1 145.7 31.1 128V64C31.1 46.33 46.33 32 63.1 32L223.1 32zM480 320C480 337.7 465.7 352 448 352H70.63C66.38 352 62.31 350.3 59.31 347.3L11.31 299.3C5.065 293.1 5.065 282.9 11.31 276.7L59.31 228.7C62.31 225.7 66.38 223.1 70.63 223.1H223.1V191.1H288V223.1H448C465.7 223.1 480 238.3 480 255.1V320zM255.1 512C238.3 512 223.1 497.7 223.1 480V384H288V480C288 497.7 273.7 512 255.1 512z")),"label"=>__("Signs Post","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment","lifestyle-and-hobbies","travel")),"sim-card"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M0 64v384c0 35.25 28.75 64 64 64h256c35.25 0 64-28.75 64-64V128l-128-128H64C28.75 0 0 28.75 0 64zM224 256H160V192h64V256zM320 256h-64V192h32c17.75 0 32 14.25 32 32V256zM256 384h64v32c0 17.75-14.25 32-32 32h-32V384zM160 384h64v64H160V384zM64 384h64v64H96c-17.75 0-32-14.25-32-32V384zM64 288h256v64H64V288zM64 224c0-17.75 14.25-32 32-32h32v64H64V224z")),"label"=>__("Sim Card","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"simplybuilt"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M481.2 64h-106c-14.5 0-26.6 11.8-26.6 26.3v39.6H163.3V90.3c0-14.5-12-26.3-26.6-26.3h-106C16.1 64 4.3 75.8 4.3 90.3v331.4c0 14.5 11.8 26.3 26.6 26.3h450.4c14.8 0 26.6-11.8 26.6-26.3V90.3c-.2-14.5-12-26.3-26.7-26.3zM149.8 355.8c-36.6 0-66.4-29.7-66.4-66.4 0-36.9 29.7-66.6 66.4-66.6 36.9 0 66.6 29.7 66.6 66.6 0 36.7-29.7 66.4-66.6 66.4zm212.4 0c-36.9 0-66.6-29.7-66.6-66.6 0-36.6 29.7-66.4 66.6-66.4 36.6 0 66.4 29.7 66.4 66.4 0 36.9-29.8 66.6-66.4 66.6z")),"label"=>__("SimplyBuilt","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"sink"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M496 288h-96V256l64 .0002c8.838 0 16-7.164 16-15.1v-15.1c0-8.838-7.162-16-16-16L384 208c-17.67 0-32 14.33-32 32v47.1l-64 .0005v-192c0-17.64 14.36-32 32-32s32 14.36 32 32v16c0 8.836 7.164 16 16 16h32c8.838 0 16-7.164 16-16v-16c0-59.2-53.85-106-115.1-94.14C255.3 10.71 224 53.36 224 99.79v188.2L160 288V240c0-17.67-14.33-32-32-32L48 208c-8.836 0-16 7.162-16 16v15.1C32 248.8 39.16 256 48 256l64-.0002V288h-96c-8.836 0-16 7.164-16 16v32c0 8.836 7.164 16 16 16h480c8.836 0 16-7.164 16-16V304C512 295.2 504.8 288 496 288zM32 416c0 53.02 42.98 96 96 96h256c53.02 0 96-42.98 96-96v-32H32V416z")),"label"=>__("Sink","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"sistrix"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M448 449L301.2 300.2c20-27.9 31.9-62.2 31.9-99.2 0-93.1-74.7-168.9-166.5-168.9C74.7 32 0 107.8 0 200.9s74.7 168.9 166.5 168.9c39.8 0 76.3-14.2 105-37.9l146 148.1 30.5-31zM166.5 330.8c-70.6 0-128.1-58.3-128.1-129.9S95.9 71 166.5 71s128.1 58.3 128.1 129.9-57.4 129.9-128.1 129.9z")),"label"=>__("SISTRIX","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"sitemap"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M208 80C208 53.49 229.5 32 256 32H320C346.5 32 368 53.49 368 80V144C368 170.5 346.5 192 320 192H312V232H464C494.9 232 520 257.1 520 288V320H528C554.5 320 576 341.5 576 368V432C576 458.5 554.5 480 528 480H464C437.5 480 416 458.5 416 432V368C416 341.5 437.5 320 464 320H472V288C472 283.6 468.4 280 464 280H312V320H320C346.5 320 368 341.5 368 368V432C368 458.5 346.5 480 320 480H256C229.5 480 208 458.5 208 432V368C208 341.5 229.5 320 256 320H264V280H112C107.6 280 104 283.6 104 288V320H112C138.5 320 160 341.5 160 368V432C160 458.5 138.5 480 112 480H48C21.49 480 0 458.5 0 432V368C0 341.5 21.49 320 48 320H56V288C56 257.1 81.07 232 112 232H264V192H256C229.5 192 208 170.5 208 144V80z")),"label"=>__("Sitemap","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","science-and-technology")),"sith"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M0 32l69.71 118.8-58.86-11.52 69.84 91.03a146.7 146.7 0 0 0 0 51.45l-69.84 91.03 58.86-11.52L0 480l118.8-69.71-11.52 58.86 91.03-69.84c17.02 3.04 34.47 3.04 51.48 0l91.03 69.84-11.52-58.86L448 480l-69.71-118.8 58.86 11.52-69.84-91.03c3.03-17.01 3.04-34.44 0-51.45l69.84-91.03-58.86 11.52L448 32l-118.8 69.71 11.52-58.9-91.06 69.87c-8.5-1.52-17.1-2.29-25.71-2.29s-17.21 .78-25.71 2.29l-91.06-69.87 11.52 58.9L0 32zm224 99.78c31.8 0 63.6 12.12 87.85 36.37 48.5 48.5 48.49 127.2 0 175.7s-127.2 48.46-175.7-.03c-48.5-48.5-48.49-127.2 0-175.7 24.24-24.25 56.05-36.34 87.85-36.34zm0 36.66c-22.42 0-44.83 8.52-61.92 25.61-34.18 34.18-34.19 89.68 0 123.9s89.65 34.18 123.8 0c34.18-34.18 34.19-89.68 0-123.9-17.09-17.09-39.5-25.61-61.92-25.61z")),"label"=>__("Sith","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"sitrox"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M212.4 .0085V0H448V128H64C64 57.6 141.8 .4753 212.4 .0085zM237.3 192V192C307.1 192.5 384 249.6 384 320H210.8V319.1C140.9 319.6 64 262.4 64 192H237.3zM235.6 511.1C306.3 511.5 384 454.4 384 384H0V512H235.6V511.1z")),"label"=>__("Sitrox","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"sketch"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M27.5 162.2L9 187.1h90.5l6.9-130.7-78.9 105.8zM396.3 45.7L267.7 32l135.7 147.2-7.1-133.5zM112.2 218.3l-11.2-22H9.9L234.8 458zm2-31.2h284l-81.5-88.5L256.3 33zm297.3 9.1L277.6 458l224.8-261.7h-90.9zM415.4 69L406 56.4l.9 17.3 6.1 113.4h90.3zM113.5 93.5l-4.6 85.6L244.7 32 116.1 45.7zm287.7 102.7h-290l42.4 82.9L256.3 480l144.9-283.8z")),"label"=>__("Sketch","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"skull"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M416 400V464C416 490.5 394.5 512 368 512H320V464C320 455.2 312.8 448 304 448C295.2 448 288 455.2 288 464V512H224V464C224 455.2 216.8 448 208 448C199.2 448 192 455.2 192 464V512H144C117.5 512 96 490.5 96 464V400C96 399.6 96 399.3 96.01 398.9C37.48 357.8 0 294.7 0 224C0 100.3 114.6 0 256 0C397.4 0 512 100.3 512 224C512 294.7 474.5 357.8 415.1 398.9C415.1 399.3 416 399.6 416 400V400zM160 192C124.7 192 96 220.7 96 256C96 291.3 124.7 320 160 320C195.3 320 224 291.3 224 256C224 220.7 195.3 192 160 192zM352 320C387.3 320 416 291.3 416 256C416 220.7 387.3 192 352 192C316.7 192 288 220.7 288 256C288 291.3 316.7 320 352 320z")),"label"=>__("Skull","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"skull-crossbones"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M368 128C368 172.4 342.6 211.5 304 234.4V256C304 273.7 289.7 288 272 288H175.1C158.3 288 143.1 273.7 143.1 256V234.4C105.4 211.5 79.1 172.4 79.1 128C79.1 57.31 144.5 0 223.1 0C303.5 0 368 57.31 368 128V128zM167.1 176C185.7 176 199.1 161.7 199.1 144C199.1 126.3 185.7 112 167.1 112C150.3 112 135.1 126.3 135.1 144C135.1 161.7 150.3 176 167.1 176zM280 112C262.3 112 248 126.3 248 144C248 161.7 262.3 176 280 176C297.7 176 312 161.7 312 144C312 126.3 297.7 112 280 112zM3.378 273.7C11.28 257.9 30.5 251.5 46.31 259.4L223.1 348.2L401.7 259.4C417.5 251.5 436.7 257.9 444.6 273.7C452.5 289.5 446.1 308.7 430.3 316.6L295.6 384L430.3 451.4C446.1 459.3 452.5 478.5 444.6 494.3C436.7 510.1 417.5 516.5 401.7 508.6L223.1 419.8L46.31 508.6C30.5 516.5 11.28 510.1 3.378 494.3C-4.526 478.5 1.881 459.3 17.69 451.4L152.4 384L17.69 316.6C1.881 308.7-4.526 289.5 3.378 273.7V273.7z")),"label"=>__("Skull Crossbones","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","science-and-technology")),"skyatlas"=>array("svg"=>array("brands"=>array("width"=>640,"height"=>512,"path"=>"M640 329.3c0 65.9-52.5 114.4-117.5 114.4-165.9 0-196.6-249.7-359.7-249.7-146.9 0-147.1 212.2 5.6 212.2 42.5 0 90.9-17.8 125.3-42.5 5.6-4.1 16.9-16.3 22.8-16.3s10.9 5 10.9 10.9c0 7.8-13.1 19.1-18.7 24.1-40.9 35.6-100.3 61.2-154.7 61.2-83.4 .1-154-59-154-144.9s67.5-149.1 152.8-149.1c185.3 0 222.5 245.9 361.9 245.9 99.9 0 94.8-139.7 3.4-139.7-17.5 0-35 11.6-46.9 11.6-8.4 0-15.9-7.2-15.9-15.6 0-11.6 5.3-23.7 5.3-36.3 0-66.6-50.9-114.7-116.9-114.7-53.1 0-80 36.9-88.8 36.9-6.2 0-11.2-5-11.2-11.2 0-5.6 4.1-10.3 7.8-14.4 25.3-28.8 64.7-43.7 102.8-43.7 79.4 0 139.1 58.4 139.1 137.8 0 6.9-.3 13.7-1.2 20.6 11.9-3.1 24.1-4.7 35.9-4.7 60.7 0 111.9 45.3 111.9 107.2z")),"label"=>__("skyatlas","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"skype"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M424.7 299.8c2.9-14 4.7-28.9 4.7-43.8 0-113.5-91.9-205.3-205.3-205.3-14.9 0-29.7 1.7-43.8 4.7C161.3 40.7 137.7 32 112 32 50.2 32 0 82.2 0 144c0 25.7 8.7 49.3 23.3 68.2-2.9 14-4.7 28.9-4.7 43.8 0 113.5 91.9 205.3 205.3 205.3 14.9 0 29.7-1.7 43.8-4.7 19 14.6 42.6 23.3 68.2 23.3 61.8 0 112-50.2 112-112 .1-25.6-8.6-49.2-23.2-68.1zm-194.6 91.5c-65.6 0-120.5-29.2-120.5-65 0-16 9-30.6 29.5-30.6 31.2 0 34.1 44.9 88.1 44.9 25.7 0 42.3-11.4 42.3-26.3 0-18.7-16-21.6-42-28-62.5-15.4-117.8-22-117.8-87.2 0-59.2 58.6-81.1 109.1-81.1 55.1 0 110.8 21.9 110.8 55.4 0 16.9-11.4 31.8-30.3 31.8-28.3 0-29.2-33.5-75-33.5-25.7 0-42 7-42 22.5 0 19.8 20.8 21.8 69.1 33 41.4 9.3 90.7 26.8 90.7 77.6 0 59.1-57.1 86.5-112 86.5z")),"label"=>__("Skype","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"slack"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M94.12 315.1c0 25.9-21.16 47.06-47.06 47.06S0 341 0 315.1c0-25.9 21.16-47.06 47.06-47.06h47.06v47.06zm23.72 0c0-25.9 21.16-47.06 47.06-47.06s47.06 21.16 47.06 47.06v117.8c0 25.9-21.16 47.06-47.06 47.06s-47.06-21.16-47.06-47.06V315.1zm47.06-188.1c-25.9 0-47.06-21.16-47.06-47.06S139 32 164.9 32s47.06 21.16 47.06 47.06v47.06H164.9zm0 23.72c25.9 0 47.06 21.16 47.06 47.06s-21.16 47.06-47.06 47.06H47.06C21.16 243.1 0 222.8 0 196.9s21.16-47.06 47.06-47.06H164.9zm188.1 47.06c0-25.9 21.16-47.06 47.06-47.06 25.9 0 47.06 21.16 47.06 47.06s-21.16 47.06-47.06 47.06h-47.06V196.9zm-23.72 0c0 25.9-21.16 47.06-47.06 47.06-25.9 0-47.06-21.16-47.06-47.06V79.06c0-25.9 21.16-47.06 47.06-47.06 25.9 0 47.06 21.16 47.06 47.06V196.9zM283.1 385.9c25.9 0 47.06 21.16 47.06 47.06 0 25.9-21.16 47.06-47.06 47.06-25.9 0-47.06-21.16-47.06-47.06v-47.06h47.06zm0-23.72c-25.9 0-47.06-21.16-47.06-47.06 0-25.9 21.16-47.06 47.06-47.06h117.8c25.9 0 47.06 21.16 47.06 47.06 0 25.9-21.16 47.06-47.06 47.06H283.1z")),"label"=>__("Slack Logo","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"slash"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M5.112 9.196C13.29-1.236 28.37-3.065 38.81 5.112L630.8 469.1C641.2 477.3 643.1 492.4 634.9 502.8C626.7 513.2 611.6 515.1 601.2 506.9L9.196 42.89C-1.236 34.71-3.065 19.63 5.112 9.196V9.196z")),"label"=>__("Slash","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"sleigh"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M63.1 32C66.31 32 68.56 32.24 70.74 32.71C124.1 37.61 174.2 67.59 203.4 114.3L207.7 121.1C247.7 185.1 317.8 224 393.3 224C423.5 224 448 199.5 448 169.3V128C448 110.3 462.3 96 480 96H544C561.7 96 576 110.3 576 128C576 145.7 561.7 160 544 160V256C544 309 501 352 448 352V384H384V352H192V384H128V352C74.98 352 32 309 32 256V96C14.33 96 0 81.67 0 64C0 46.33 14.33 32 32 32H63.1zM640 392C640 440.6 600.6 480 552 480H63.1C46.33 480 31.1 465.7 31.1 448C31.1 430.3 46.33 416 63.1 416H552C565.3 416 576 405.3 576 392V384C576 366.3 590.3 352 608 352C625.7 352 640 366.3 640 384V392z")),"label"=>__("Sleigh","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","travel")),"sliders"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M0 416C0 398.3 14.33 384 32 384H86.66C99 355.7 127.2 336 160 336C192.8 336 220.1 355.7 233.3 384H480C497.7 384 512 398.3 512 416C512 433.7 497.7 448 480 448H233.3C220.1 476.3 192.8 496 160 496C127.2 496 99 476.3 86.66 448H32C14.33 448 0 433.7 0 416V416zM192 416C192 398.3 177.7 384 160 384C142.3 384 128 398.3 128 416C128 433.7 142.3 448 160 448C177.7 448 192 433.7 192 416zM352 176C384.8 176 412.1 195.7 425.3 224H480C497.7 224 512 238.3 512 256C512 273.7 497.7 288 480 288H425.3C412.1 316.3 384.8 336 352 336C319.2 336 291 316.3 278.7 288H32C14.33 288 0 273.7 0 256C0 238.3 14.33 224 32 224H278.7C291 195.7 319.2 176 352 176zM384 256C384 238.3 369.7 224 352 224C334.3 224 320 238.3 320 256C320 273.7 334.3 288 352 288C369.7 288 384 273.7 384 256zM480 64C497.7 64 512 78.33 512 96C512 113.7 497.7 128 480 128H265.3C252.1 156.3 224.8 176 192 176C159.2 176 131 156.3 118.7 128H32C14.33 128 0 113.7 0 96C0 78.33 14.33 64 32 64H118.7C131 35.75 159.2 16 192 16C224.8 16 252.1 35.75 265.3 64H480zM160 96C160 113.7 174.3 128 192 128C209.7 128 224 113.7 224 96C224 78.33 209.7 64 192 64C174.3 64 160 78.33 160 96z")),"label"=>__("Sliders","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","design","lifestyle-and-hobbies","science-and-technology")),"slideshare"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M187.7 153.7c-34 0-61.7 25.7-61.7 57.7 0 31.7 27.7 57.7 61.7 57.7s61.7-26 61.7-57.7c0-32-27.7-57.7-61.7-57.7zm143.4 0c-34 0-61.7 25.7-61.7 57.7 0 31.7 27.7 57.7 61.7 57.7 34.3 0 61.7-26 61.7-57.7 .1-32-27.4-57.7-61.7-57.7zm156.6 90l-6 4.3V49.7c0-27.4-20.6-49.7-46-49.7H76.6c-25.4 0-46 22.3-46 49.7V248c-2-1.4-4.3-2.9-6.3-4.3-15.1-10.6-25.1 4-16 17.7 18.3 22.6 53.1 50.3 106.3 72C58.3 525.1 252 555.7 248.9 457.5c0-.7 .3-56.6 .3-96.6 5.1 1.1 9.4 2.3 13.7 3.1 0 39.7 .3 92.8 .3 93.5-3.1 98.3 190.6 67.7 134.3-124 53.1-21.7 88-49.4 106.3-72 9.1-13.8-.9-28.3-16.1-17.8zm-30.5 19.2c-68.9 37.4-128.3 31.1-160.6 29.7-23.7-.9-32.6 9.1-33.7 24.9-10.3-7.7-18.6-15.5-20.3-17.1-5.1-5.4-13.7-8-27.1-7.7-31.7 1.1-89.7 7.4-157.4-28V72.3c0-34.9 8.9-45.7 40.6-45.7h317.7c30.3 0 40.9 12.9 40.9 45.7v190.6z")),"label"=>__("Slideshare","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"smog"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M144 288h156.1C322.6 307.8 351.8 320 384 320s61.25-12.25 83.88-32H528C589.9 288 640 237.9 640 176s-50.13-112-112-112c-18 0-34.75 4.625-49.75 12.12C453.1 30.1 406.8 0 352 0c-41 0-77.75 17.25-104 44.75C221.8 17.25 185 0 144 0c-79.5 0-144 64.5-144 144S64.5 288 144 288zM136 464H23.1C10.8 464 0 474.8 0 487.1S10.8 512 23.1 512H136C149.2 512 160 501.2 160 488S149.2 464 136 464zM616 368h-528C74.8 368 64 378.8 64 391.1S74.8 416 87.1 416h528c13.2 0 24-10.8 24-23.1S629.2 368 616 368zM552 464H231.1C218.8 464 208 474.8 208 487.1S218.8 512 231.1 512H552c13.2 0 24-10.8 24-23.1S565.2 464 552 464z")),"label"=>__("Smog","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment")),"smoking"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M432 352h-384C21.5 352 0 373.5 0 400v64C0 490.5 21.5 512 48 512h384c8.75 0 16-7.25 16-16v-128C448 359.3 440.8 352 432 352zM400 464H224v-64h176V464zM536 352h-48C483.6 352 480 355.6 480 360v144c0 4.375 3.625 8 8 8h48c4.375 0 8-3.625 8-8v-144C544 355.6 540.4 352 536 352zM632 352h-48C579.6 352 576 355.6 576 360v144c0 4.375 3.625 8 8 8h48c4.375 0 8-3.625 8-8v-144C640 355.6 636.4 352 632 352zM553.3 87.13C547.6 83.25 544 77.12 544 70.25V8C544 3.625 540.4 0 536 0h-48C483.6 0 480 3.625 480 8v62.25c0 22 10.25 43.5 28.62 55.5C550.8 153 576 199.5 576 249.8V280C576 284.4 579.6 288 584 288h48C636.4 288 640 284.4 640 280V249.8C640 184.3 607.6 123.5 553.3 87.13zM487.8 141.6C463.8 125 448 99.25 448 70.25V8C448 3.625 444.4 0 440 0h-48C387.6 0 384 3.625 384 8v66.38C384 118.1 408.6 156 444.3 181.1C466.8 196.8 480 222.3 480 249.8V280C480 284.4 483.6 288 488 288h48C540.4 288 544 284.4 544 280V249.8C544 206.4 523 166.3 487.8 141.6z")),"label"=>__("Smoking","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology","travel")),"snapchat"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M496.9 366.6c-3.373-9.176-9.8-14.09-17.11-18.15-1.376-.806-2.641-1.451-3.72-1.947-2.182-1.128-4.414-2.22-6.634-3.373-22.8-12.09-40.61-27.34-52.96-45.42a102.9 102.9 0 0 1 -9.089-16.12c-1.054-3.013-1-4.724-.248-6.287a10.22 10.22 0 0 1 2.914-3.038c3.918-2.591 7.96-5.22 10.7-6.993 4.885-3.162 8.754-5.667 11.25-7.44 9.362-6.547 15.91-13.5 20-21.28a42.37 42.37 0 0 0 2.1-35.19c-6.2-16.32-21.61-26.45-40.29-26.45a55.54 55.54 0 0 0 -11.72 1.24c-1.029 .224-2.059 .459-3.063 .72 .174-11.16-.074-22.94-1.066-34.53-3.522-40.76-17.79-62.12-32.67-79.16A130.2 130.2 0 0 0 332.1 36.44C309.5 23.55 283.9 17 256 17S202.6 23.55 180 36.44a129.7 129.7 0 0 0 -33.28 26.78c-14.88 17.04-29.15 38.44-32.67 79.16-.992 11.59-1.24 23.43-1.079 34.53-1-.26-2.021-.5-3.051-.719a55.46 55.46 0 0 0 -11.72-1.24c-18.69 0-34.13 10.13-40.3 26.45a42.42 42.42 0 0 0 2.046 35.23c4.105 7.774 10.65 14.73 20.01 21.28 2.48 1.736 6.361 4.24 11.25 7.44 2.641 1.711 6.5 4.216 10.28 6.72a11.05 11.05 0 0 1 3.3 3.311c.794 1.624 .818 3.373-.36 6.6a102 102 0 0 1 -8.94 15.78c-12.08 17.67-29.36 32.65-51.43 44.64C32.35 348.6 20.2 352.8 15.07 366.7c-3.868 10.53-1.339 22.51 8.494 32.6a49.14 49.14 0 0 0 12.4 9.387 134.3 134.3 0 0 0 30.34 12.14 20.02 20.02 0 0 1 6.126 2.741c3.583 3.137 3.075 7.861 7.849 14.78a34.47 34.47 0 0 0 8.977 9.127c10.02 6.919 21.28 7.353 33.21 7.811 10.78 .41 22.99 .881 36.94 5.481 5.778 1.91 11.78 5.605 18.74 9.92C194.8 480.1 217.7 495 255.1 495s61.29-14.12 78.12-24.43c6.907-4.24 12.87-7.9 18.49-9.758 13.95-4.613 26.16-5.072 36.94-5.481 11.93-.459 23.19-.893 33.21-7.812a34.58 34.58 0 0 0 10.22-11.16c3.434-5.84 3.348-9.919 6.572-12.77a18.97 18.97 0 0 1 5.753-2.629A134.9 134.9 0 0 0 476 408.7a48.34 48.34 0 0 0 13.02-10.19l.124-.149C498.4 388.5 500.7 376.9 496.9 366.6zm-34.01 18.28c-20.75 11.46-34.53 10.23-45.26 17.14-9.114 5.865-3.72 18.51-10.34 23.08-8.134 5.617-32.18-.4-63.24 9.858-25.62 8.469-41.96 32.82-88.04 32.82s-62.04-24.3-88.08-32.88c-31-10.26-55.09-4.241-63.24-9.858-6.609-4.563-1.24-17.21-10.34-23.08-10.74-6.907-24.53-5.679-45.26-17.08-13.21-7.291-5.716-11.8-1.314-13.94 75.14-36.38 87.13-92.55 87.67-96.72 .645-5.046 1.364-9.014-4.191-14.15-5.369-4.96-29.19-19.7-35.8-24.32-10.94-7.638-15.75-15.26-12.2-24.64 2.48-6.485 8.531-8.928 14.88-8.928a27.64 27.64 0 0 1 5.965 .67c12 2.6 23.66 8.617 30.39 10.24a10.75 10.75 0 0 0 2.48 .335c3.6 0 4.86-1.811 4.612-5.927-.768-13.13-2.628-38.72-.558-62.64 2.84-32.91 13.44-49.22 26.04-63.64 6.051-6.932 34.48-36.98 88.86-36.98s82.88 29.92 88.93 36.83c12.61 14.42 23.23 30.73 26.04 63.64 2.071 23.92 .285 49.53-.558 62.64-.285 4.327 1.017 5.927 4.613 5.927a10.65 10.65 0 0 0 2.48-.335c6.745-1.624 18.4-7.638 30.4-10.24a27.64 27.64 0 0 1 5.964-.67c6.386 0 12.4 2.48 14.88 8.928 3.546 9.374-1.24 17-12.19 24.64-6.609 4.612-30.43 19.34-35.8 24.32-5.568 5.134-4.836 9.1-4.191 14.15 .533 4.228 12.51 60.4 87.67 96.72C468.6 373 476.1 377.5 462.9 384.9z")),"label"=>__("Snapchat","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"snapchat-square"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M384 32H64A64 64 0 0 0 0 96V416a64 64 0 0 0 64 64H384a64 64 0 0 0 64-64V96A64 64 0 0 0 384 32zm-3.907 319.3-.083 .1a32.36 32.36 0 0 1 -8.717 6.823 90.26 90.26 0 0 1 -20.59 8.2 12.69 12.69 0 0 0 -3.852 1.76c-2.158 1.909-2.1 4.64-4.4 8.55a23.14 23.14 0 0 1 -6.84 7.471c-6.707 4.632-14.24 4.923-22.23 5.23-7.214 .274-15.39 .581-24.73 3.669-3.761 1.245-7.753 3.694-12.38 6.533-11.27 6.9-26.68 16.35-52.3 16.35s-40.92-9.4-52.11-16.28c-4.657-2.888-8.675-5.362-12.54-6.64-9.339-3.08-17.52-3.4-24.73-3.67-7.986-.307-15.52-.6-22.23-5.229a23.08 23.08 0 0 1 -6.01-6.11c-3.2-4.632-2.855-7.8-5.254-9.895a13.43 13.43 0 0 0 -4.1-1.834 89.99 89.99 0 0 1 -20.31-8.127 32.9 32.9 0 0 1 -8.3-6.284c-6.583-6.757-8.276-14.78-5.686-21.82 3.436-9.338 11.57-12.11 19.4-16.26 14.78-8.027 26.35-18.06 34.43-29.88a68.24 68.24 0 0 0 5.985-10.57c.789-2.158 .772-3.329 .241-4.416a7.386 7.386 0 0 0 -2.208-2.217c-2.532-1.676-5.113-3.353-6.882-4.5-3.27-2.141-5.868-3.818-7.529-4.98-6.267-4.383-10.65-9.04-13.4-14.24a28.4 28.4 0 0 1 -1.369-23.58c4.134-10.92 14.47-17.71 26.98-17.71a37.14 37.14 0 0 1 7.845 .83c.689 .15 1.37 .307 2.042 .482-.108-7.43 .058-15.36 .722-23.12 2.358-27.26 11.91-41.59 21.87-52.99a86.84 86.84 0 0 1 22.28-17.93C188.3 100.4 205.3 96 224 96s35.83 4.383 50.94 13.02a87.17 87.17 0 0 1 22.24 17.9c9.961 11.41 19.52 25.71 21.87 52.99a231.2 231.2 0 0 1 .713 23.12c.673-.174 1.362-.332 2.051-.481a37.13 37.13 0 0 1 7.844-.83c12.5 0 22.82 6.782 26.97 17.71a28.37 28.37 0 0 1 -1.4 23.56c-2.74 5.2-7.123 9.861-13.39 14.24-1.668 1.187-4.258 2.864-7.529 4.981-1.835 1.187-4.541 2.947-7.164 4.682a6.856 6.856 0 0 0 -1.951 2.034c-.506 1.046-.539 2.191 .166 4.208a69.01 69.01 0 0 0 6.085 10.79c8.268 12.1 20.19 22.31 35.45 30.41 1.486 .772 2.98 1.5 4.441 2.258 .722 .332 1.569 .763 2.491 1.3 4.9 2.723 9.2 6.01 11.45 12.15C387.8 336.9 386.3 344.7 380.1 351.3zm-16.72-18.46c-50.31-24.31-58.33-61.92-58.69-64.75-.431-3.379-.921-6.035 2.806-9.472 3.594-3.328 19.54-13.19 23.97-16.28 7.33-5.114 10.53-10.22 8.16-16.5-1.66-4.316-5.686-5.976-9.961-5.976a18.5 18.5 0 0 0 -3.993 .448c-8.035 1.743-15.84 5.769-20.35 6.857a7.1 7.1 0 0 1 -1.66 .224c-2.408 0-3.279-1.071-3.088-3.968 .564-8.783 1.759-25.92 .373-41.94-1.884-22.03-8.99-32.95-17.43-42.6-4.051-4.624-23.14-24.65-59.54-24.65S168.5 134.4 164.5 139c-8.434 9.654-15.53 20.57-17.43 42.6-1.386 16.01-.141 33.15 .373 41.94 .166 2.756-.68 3.968-3.088 3.968a7.1 7.1 0 0 1 -1.66-.224c-4.507-1.087-12.31-5.113-20.35-6.856a18.49 18.49 0 0 0 -3.993-.449c-4.25 0-8.3 1.636-9.961 5.977-2.374 6.276 .847 11.38 8.168 16.49 4.425 3.088 20.37 12.96 23.97 16.28 3.719 3.437 3.237 6.093 2.805 9.471-.356 2.79-8.384 40.39-58.69 64.75-2.946 1.428-7.96 4.45 .88 9.331 13.88 7.628 23.11 6.807 30.3 11.43 6.093 3.927 2.5 12.39 6.923 15.45 5.454 3.76 21.58-.266 42.33 6.6 17.43 5.744 28.12 22.01 58.96 22.01s41.79-16.3 58.94-21.97c20.8-6.865 36.89-2.839 42.34-6.6 4.433-3.055 .822-11.52 6.923-15.45 7.181-4.624 16.41-3.8 30.3-11.47C371.4 337.4 366.3 334.3 363.4 332.8z")),"label"=>__("Snapchat Square","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"snowflake"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M475.6 384.1C469.7 394.3 458.9 400 447.9 400c-5.488 0-11.04-1.406-16.13-4.375l-25.09-14.64l5.379 20.29c3.393 12.81-4.256 25.97-17.08 29.34c-2.064 .5625-4.129 .8125-6.164 .8125c-10.63 0-20.36-7.094-23.21-17.84l-17.74-66.92L288 311.7l.0002 70.5l48.38 48.88c9.338 9.438 9.244 24.62-.1875 33.94C331.5 469.7 325.4 472 319.3 472c-6.193 0-12.39-2.375-17.08-7.125l-14.22-14.37L288 480c0 17.69-14.34 32-32.03 32s-32.03-14.31-32.03-32l-.0002-29.5l-14.22 14.37c-9.322 9.438-24.53 9.5-33.97 .1875c-9.432-9.312-9.525-24.5-.1875-33.94l48.38-48.88L223.1 311.7l-59.87 34.93l-17.74 66.92c-2.848 10.75-12.58 17.84-23.21 17.84c-2.035 0-4.1-.25-6.164-.8125c-12.82-3.375-20.47-16.53-17.08-29.34l5.379-20.29l-25.09 14.64C75.11 398.6 69.56 400 64.07 400c-11.01 0-21.74-5.688-27.69-15.88c-8.932-15.25-3.785-34.84 11.5-43.75l25.96-15.15l-20.33-5.508C40.7 316.3 33.15 303.1 36.62 290.3S53.23 270 66.09 273.4L132 291.3L192.5 256L132 220.7L66.09 238.6c-2.111 .5625-4.225 .8438-6.305 .8438c-10.57 0-20.27-7.031-23.16-17.72C33.15 208.9 40.7 195.8 53.51 192.3l20.33-5.508L47.88 171.6c-15.28-8.906-20.43-28.5-11.5-43.75c8.885-15.28 28.5-20.44 43.81-11.5l25.09 14.64L99.9 110.7C96.51 97.91 104.2 84.75 116.1 81.38C129.9 77.91 142.1 85.63 146.4 98.41l17.74 66.92L223.1 200.3l-.0002-70.5L175.6 80.88C166.3 71.44 166.3 56.25 175.8 46.94C185.2 37.59 200.4 37.72 209.8 47.13l14.22 14.37L223.1 32c0-17.69 14.34-32 32.03-32s32.03 14.31 32.03 32l.0002 29.5l14.22-14.37c9.307-9.406 24.51-9.531 33.97-.1875c9.432 9.312 9.525 24.5 .1875 33.94l-48.38 48.88L288 200.3l59.87-34.93l17.74-66.92c3.395-12.78 16.56-20.5 29.38-17.03c12.82 3.375 20.47 16.53 17.08 29.34l-5.379 20.29l25.09-14.64c15.28-8.906 34.91-3.75 43.81 11.5c8.932 15.25 3.785 34.84-11.5 43.75l-25.96 15.15l20.33 5.508c12.81 3.469 20.37 16.66 16.89 29.44c-2.895 10.69-12.59 17.72-23.16 17.72c-2.08 0-4.193-.2813-6.305-.8438L379.1 220.7L319.5 256l60.46 35.28l65.95-17.87C458.8 270 471.9 277.5 475.4 290.3c3.473 12.78-4.082 25.97-16.89 29.44l-20.33 5.508l25.96 15.15C479.4 349.3 484.5 368.9 475.6 384.1z"),"regular"=>array("width"=>512,"height"=>512,"path"=>"M484.4 294.4c1.715 6.402 .6758 12.89-2.395 18.21s-8.172 9.463-14.57 11.18l-31.46 8.43l32.96 19.03C480.4 357.8 484.4 372.5 477.8 384s-21.38 15.41-32.86 8.783l-32.96-19.03l8.43 31.46c3.432 12.81-4.162 25.96-16.97 29.39s-25.96-4.162-29.39-16.97l-20.85-77.82L280 297.6v84.49l56.97 56.97c9.375 9.375 9.375 24.56 0 33.94C332.3 477.7 326.1 480 320 480s-12.28-2.344-16.97-7.031L280 449.9V488c0 13.25-10.75 24-24 24s-24-10.75-24-24v-38.06l-23.03 23.03c-9.375 9.375-24.56 9.375-33.94 0s-9.375-24.56 0-33.94L232 382.1V297.6l-73.17 42.25l-20.85 77.82c-3.432 12.81-16.58 20.4-29.39 16.97s-20.4-16.58-16.97-29.39l8.43-31.46l-32.96 19.03C55.61 399.4 40.85 395.5 34.22 384s-2.615-26.16 8.859-32.79l32.96-19.03l-31.46-8.43c-12.81-3.432-20.4-16.58-16.97-29.39s16.58-20.4 29.39-16.97l77.82 20.85L208 255.1L134.8 213.8L57.01 234.6C44.2 238 31.05 230.4 27.62 217.6s4.162-25.96 16.97-29.39l31.46-8.432L43.08 160.8C31.61 154.2 27.6 139.5 34.22 128s21.38-15.41 32.86-8.785l32.96 19.03L91.62 106.8C88.18 93.98 95.78 80.83 108.6 77.39s25.96 4.162 29.39 16.97l20.85 77.82L232 214.4V129.9L175 72.97c-9.375-9.375-9.375-24.56 0-33.94s24.56-9.375 33.94 0L232 62.06V24C232 10.75 242.8 0 256 0s24 10.75 24 24v38.06l23.03-23.03c9.375-9.375 24.56-9.375 33.94 0s9.375 24.56 0 33.94L280 129.9v84.49l73.17-42.25l20.85-77.82c3.432-12.81 16.58-20.4 29.39-16.97c6.402 1.715 11.5 5.861 14.57 11.18s4.109 11.81 2.395 18.21l-8.43 31.46l32.96-19.03C456.4 112.6 471.2 116.5 477.8 128s2.615 26.16-8.859 32.78l-32.96 19.03l31.46 8.432c12.81 3.432 20.4 16.58 16.97 29.39s-16.58 20.4-29.39 16.97l-77.82-20.85L304 255.1l73.17 42.25l77.82-20.85C467.8 273.1 480.1 281.6 484.4 294.4z")),"label"=>__("Snowflake","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment","lifestyle-and-hobbies","travel")),"snowman"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M510.9 152.3l-5.875-14.5c-3.25-8-12.62-11.88-20.75-8.625l-28.25 11.5v-29C455.1 103 448.7 96 439.1 96h-16c-8.75 0-16 7-16 15.62V158.5c0 .5 .25 1 .25 1.5l-48.98 20.6c-5.291-12.57-12.98-23.81-22.24-33.55c9.35-14.81 14.98-32.23 14.98-51.04C351.1 42.98 309 0 255.1 0S160 42.98 160 95.1c0 18.81 5.626 36.23 14.98 51.04C165.7 156.8 158.1 168.1 152.8 180.7L103.8 160c0-.5 .25-1 .25-1.5V111.6C104 103 96.76 96 88.01 96h-16c-8.75 0-16 7-16 15.62v29l-28.25-11.5c-8.125-3.25-17.5 .625-20.75 8.625l-5.875 14.5C-2.119 160.4 1.881 169.5 10.01 172.6L144.4 228.4C144.9 240.8 147.3 252.7 151.5 263.7c-33.78 29.34-55.53 72.04-55.53 120.3c0 52.59 25.71 98.84 64.88 128h190.2c39.17-29.17 64.88-75.42 64.88-128c0-48.25-21.76-90.95-55.53-120.3c4.195-11.03 6.599-22.89 7.091-35.27l134.4-55.8C510.1 169.5 514.1 160.4 510.9 152.3zM224 95.1c-8.75 0-15.1-7.25-15.1-15.1s7.25-15.1 15.1-15.1s15.1 7.25 15.1 15.1S232.8 95.1 224 95.1zM256 367.1c-8.75 0-15.1-7.25-15.1-15.1S247.3 335.1 256 335.1s15.1 7.25 15.1 15.1S264.8 367.1 256 367.1zM256 303.1c-8.75 0-15.1-7.25-15.1-15.1S247.3 271.1 256 271.1s15.1 7.25 15.1 15.1S264.8 303.1 256 303.1zM256 239.1c-8.75 0-15.1-7.25-15.1-15.1S247.3 207.1 256 207.1s15.1 7.25 15.1 15.1S264.8 239.1 256 239.1zM256 152c0 0-15.1-23.25-15.1-32S247.3 104 256 104s15.1 7.25 15.1 16S256 152 256 152zM287.1 95.1c-8.75 0-15.1-7.25-15.1-15.1s7.25-15.1 15.1-15.1s15.1 7.25 15.1 15.1S296.7 95.1 287.1 95.1z")),"label"=>__("Snowman","ultimate-addons-for-gutenberg"),"custom_categories"=>array("education","lifestyle-and-hobbies")),"snowplow"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M144 400C144 413.3 133.3 424 120 424C106.7 424 96 413.3 96 400C96 386.7 106.7 376 120 376C133.3 376 144 386.7 144 400zM336 400C336 386.7 346.7 376 360 376C373.3 376 384 386.7 384 400C384 413.3 373.3 424 360 424C346.7 424 336 413.3 336 400zM304 400C304 413.3 293.3 424 280 424C266.7 424 256 413.3 256 400C256 386.7 266.7 376 280 376C293.3 376 304 386.7 304 400zM176 400C176 386.7 186.7 376 200 376C213.3 376 224 386.7 224 400C224 413.3 213.3 424 200 424C186.7 424 176 413.3 176 400zM447.4 249.6C447.8 251.9 448.1 254.3 448 256.7V288H512V235.2C512 220.7 516.9 206.6 526 195.2L583 124C594.1 110.2 614.2 107.1 627.1 119C641.8 130.1 644 150.2 632.1 163.1L576 235.2V402.7L630.6 457.4C643.1 469.9 643.1 490.1 630.6 502.6C618.1 515.1 597.9 515.1 585.4 502.6L530.7 448C518.7 435.1 512 419.7 512 402.7V352H469.2C476.1 366.5 480 382.8 480 400C480 461.9 429.9 512 368 512H112C50.14 512 0 461.9 0 400C0 355.3 26.16 316.8 64 298.8V192C64 174.3 78.33 160 96 160H128V48C128 21.49 149.5 0 176 0H298.9C324.5 0 347.6 15.26 357.7 38.79L445.1 242.7C446.1 244.9 446.9 247.2 447.4 249.6H447.4zM298.9 64H192V160L256 224H367.5L298.9 64zM368 352H112C85.49 352 64 373.5 64 400C64 426.5 85.49 448 112 448H368C394.5 448 416 426.5 416 400C416 373.5 394.5 352 368 352z")),"label"=>__("Snowplow","ultimate-addons-for-gutenberg"),"custom_categories"=>array("travel")),"soap"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M320 256c35.35 0 64-28.65 64-64c0-35.35-28.65-64-64-64s-64 28.65-64 64C256 227.3 284.7 256 320 256zM160 288c-35.35 0-64 28.65-64 64c0 35.35 28.65 64 64 64h192c35.35 0 64-28.65 64-64c0-35.35-28.65-64-64-64H160zM384 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32s-32 14.33-32 32C352 49.67 366.3 64 384 64zM208 96C234.5 96 256 74.51 256 48S234.5 0 208 0S160 21.49 160 48S181.5 96 208 96zM416 192c0 27.82-12.02 52.68-30.94 70.21C421.7 275.7 448 310.7 448 352c0 53.02-42.98 96-96 96H160c-53.02 0-96-42.98-96-96s42.98-96 96-96h88.91C233.6 238.1 224 216.7 224 192H96C42.98 192 0 234.1 0 288v128c0 53.02 42.98 96 96 96h320c53.02 0 96-42.98 96-96V288C512 234.1 469 192 416 192z")),"label"=>__("Soap","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"socks"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M319.1 32c0-11 3.125-21.25 8-30.38C325.4 .8721 322.9 0 319.1 0H192C174.4 0 159.1 14.38 159.1 32l.0042 32h160L319.1 32zM246.6 310.1l73.36-55l.0026-159.1h-160l-.0042 175.1l-86.64 64.61c-39.38 29.5-53.86 84.4-29.24 127c18.25 31.62 51.1 48.36 83.97 48.36c20 0 40.26-6.225 57.51-19.22l21.87-16.38C177.6 421 193.9 350.6 246.6 310.1zM351.1 271.1l-86.13 64.61c-39.37 29.5-53.86 84.4-29.23 127C254.9 495.3 287.2 512 320.1 512c20 0 40.25-6.25 57.5-19.25l115.2-86.38C525 382.3 544 344.2 544 303.1v-207.1h-192L351.1 271.1zM512 0h-128c-17.62 0-32 14.38-32 32l-.0003 32H544V32C544 14.38 529.6 0 512 0z")),"label"=>__("Socks","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies")),"solar-panel"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M575.4 25.72C572.4 10.78 559.2 0 543.1 0H96c-15.25 0-28.39 10.78-31.38 25.72l-63.1 320c-1.891 9.406 .5469 19.16 6.625 26.56S22.41 384 32 384h255.1v64.25H239.8c-26.26 0-47.75 21.49-47.75 47.75c0 8.844 7.168 16.01 16.01 16l223.1-.1667c8.828-.0098 15.99-7.17 15.99-16C447.1 469.5 426.6 448 400.2 448h-48.28v-64h256c9.594 0 18.67-4.312 24.75-11.72s8.516-17.16 6.625-26.56L575.4 25.72zM517.8 64l19.2 96h-97.98L429.2 64H517.8zM380.1 64l9.617 96H250l9.873-96H380.1zM210.8 64L201 160H103.1l19.18-96H210.8zM71.16 320l22.28-112h102.7L184.6 320H71.16zM233.8 320l11.37-112h149.7L406.2 320H233.8zM455.4 320l-11.5-112h102.7l22.28 112H455.4z")),"label"=>__("Solar Panel","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"sort"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M27.66 224h264.7c24.6 0 36.89-29.78 19.54-47.12l-132.3-136.8c-5.406-5.406-12.47-8.107-19.53-8.107c-7.055 0-14.09 2.701-19.45 8.107L8.119 176.9C-9.229 194.2 3.055 224 27.66 224zM292.3 288H27.66c-24.6 0-36.89 29.77-19.54 47.12l132.5 136.8C145.9 477.3 152.1 480 160 480c7.053 0 14.12-2.703 19.53-8.109l132.3-136.8C329.2 317.8 316.9 288 292.3 288z")),"label"=>__("Sort","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"sort-down"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M311.9 335.1l-132.4 136.8C174.1 477.3 167.1 480 160 480c-7.055 0-14.12-2.702-19.47-8.109l-132.4-136.8C-9.229 317.8 3.055 288 27.66 288h264.7C316.9 288 329.2 317.8 311.9 335.1z")),"label"=>__("Sort Down","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"sort-up"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M27.66 224h264.7c24.6 0 36.89-29.78 19.54-47.12l-132.3-136.8c-5.406-5.406-12.47-8.107-19.53-8.107c-7.055 0-14.09 2.701-19.45 8.107L8.119 176.9C-9.229 194.2 3.055 224 27.66 224z")),"label"=>__("Sort Up","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"soundcloud"=>array("svg"=>array("brands"=>array("width"=>640,"height"=>512,"path"=>"M111.4 256.3l5.8 65-5.8 68.3c-.3 2.5-2.2 4.4-4.4 4.4s-4.2-1.9-4.2-4.4l-5.6-68.3 5.6-65c0-2.2 1.9-4.2 4.2-4.2 2.2 0 4.1 2 4.4 4.2zm21.4-45.6c-2.8 0-4.7 2.2-5 5l-5 105.6 5 68.3c.3 2.8 2.2 5 5 5 2.5 0 4.7-2.2 4.7-5l5.8-68.3-5.8-105.6c0-2.8-2.2-5-4.7-5zm25.5-24.1c-3.1 0-5.3 2.2-5.6 5.3l-4.4 130 4.4 67.8c.3 3.1 2.5 5.3 5.6 5.3 2.8 0 5.3-2.2 5.3-5.3l5.3-67.8-5.3-130c0-3.1-2.5-5.3-5.3-5.3zM7.2 283.2c-1.4 0-2.2 1.1-2.5 2.5L0 321.3l4.7 35c.3 1.4 1.1 2.5 2.5 2.5s2.2-1.1 2.5-2.5l5.6-35-5.6-35.6c-.3-1.4-1.1-2.5-2.5-2.5zm23.6-21.9c-1.4 0-2.5 1.1-2.5 2.5l-6.4 57.5 6.4 56.1c0 1.7 1.1 2.8 2.5 2.8s2.5-1.1 2.8-2.5l7.2-56.4-7.2-57.5c-.3-1.4-1.4-2.5-2.8-2.5zm25.3-11.4c-1.7 0-3.1 1.4-3.3 3.3L47 321.3l5.8 65.8c.3 1.7 1.7 3.1 3.3 3.1 1.7 0 3.1-1.4 3.1-3.1l6.9-65.8-6.9-68.1c0-1.9-1.4-3.3-3.1-3.3zm25.3-2.2c-1.9 0-3.6 1.4-3.6 3.6l-5.8 70 5.8 67.8c0 2.2 1.7 3.6 3.6 3.6s3.6-1.4 3.9-3.6l6.4-67.8-6.4-70c-.3-2.2-2-3.6-3.9-3.6zm241.4-110.9c-1.1-.8-2.8-1.4-4.2-1.4-2.2 0-4.2 .8-5.6 1.9-1.9 1.7-3.1 4.2-3.3 6.7v.8l-3.3 176.7 1.7 32.5 1.7 31.7c.3 4.7 4.2 8.6 8.9 8.6s8.6-3.9 8.6-8.6l3.9-64.2-3.9-177.5c-.4-3-2-5.8-4.5-7.2zm-26.7 15.3c-1.4-.8-2.8-1.4-4.4-1.4s-3.1 .6-4.4 1.4c-2.2 1.4-3.6 3.9-3.6 6.7l-.3 1.7-2.8 160.8s0 .3 3.1 65.6v.3c0 1.7 .6 3.3 1.7 4.7 1.7 1.9 3.9 3.1 6.4 3.1 2.2 0 4.2-1.1 5.6-2.5 1.7-1.4 2.5-3.3 2.5-5.6l.3-6.7 3.1-58.6-3.3-162.8c-.3-2.8-1.7-5.3-3.9-6.7zm-111.4 22.5c-3.1 0-5.8 2.8-5.8 6.1l-4.4 140.6 4.4 67.2c.3 3.3 2.8 5.8 5.8 5.8 3.3 0 5.8-2.5 6.1-5.8l5-67.2-5-140.6c-.2-3.3-2.7-6.1-6.1-6.1zm376.7 62.8c-10.8 0-21.1 2.2-30.6 6.1-6.4-70.8-65.8-126.4-138.3-126.4-17.8 0-35 3.3-50.3 9.4-6.1 2.2-7.8 4.4-7.8 9.2v249.7c0 5 3.9 8.6 8.6 9.2h218.3c43.3 0 78.6-35 78.6-78.3 .1-43.6-35.2-78.9-78.5-78.9zm-296.7-60.3c-4.2 0-7.5 3.3-7.8 7.8l-3.3 136.7 3.3 65.6c.3 4.2 3.6 7.5 7.8 7.5 4.2 0 7.5-3.3 7.5-7.5l3.9-65.6-3.9-136.7c-.3-4.5-3.3-7.8-7.5-7.8zm-53.6-7.8c-3.3 0-6.4 3.1-6.4 6.7l-3.9 145.3 3.9 66.9c.3 3.6 3.1 6.4 6.4 6.4 3.6 0 6.4-2.8 6.7-6.4l4.4-66.9-4.4-145.3c-.3-3.6-3.1-6.7-6.7-6.7zm26.7 3.4c-3.9 0-6.9 3.1-6.9 6.9L227 321.3l3.9 66.4c.3 3.9 3.1 6.9 6.9 6.9s6.9-3.1 6.9-6.9l4.2-66.4-4.2-141.7c0-3.9-3-6.9-6.9-6.9z")),"label"=>__("SoundCloud","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","brands","brands","social")),"sourcetree"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M427.2 203c0-112.1-90.9-203-203-203C112.1-.2 21.2 90.6 21 202.6A202.9 202.9 0 0 0 161.5 396v101.7a14.3 14.3 0 0 0 14.3 14.3h96.4a14.3 14.3 0 0 0 14.3-14.3V396.1A203.2 203.2 0 0 0 427.2 203zm-271.6 0c0-90.8 137.3-90.8 137.3 0-.1 89.9-137.3 91-137.3 0z")),"label"=>__("Sourcetree","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"spa"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M568.3 192c-29 .125-135 6.124-213.9 82.1C321.2 304.7 301 338.3 288 369.9c-13-31.63-33.25-65.25-66.38-94.87C142.8 198.2 36.75 192.2 7.75 192C3.375 192 0 195.4 0 199.9c.25 27.88 7.125 126.2 88.75 199.3C172.8 481 256 479.1 288 479.1s115.2 1.025 199.3-80.85C568.9 326 575.8 227.7 576 199.9C576 195.4 572.6 192 568.3 192zM288 302.6c12.75-18.87 27.62-35.75 44.13-50.5c19-18.62 39.5-33.37 60.25-45.25c-16.5-70.5-51.75-133-96.75-172.3c-4.125-3.5-11-3.5-15.12 0c-45 39.25-80.25 101.6-96.75 172.1c20.37 11.75 40.5 26.12 59.25 44.37C260 266.4 275.1 283.7 288 302.6z")),"label"=>__("Spa","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","travel")),"spaghetti-monster-flying"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M624.5 347.7c-32.63-12.5-57.38 4.241-75.38 16.49c-17 11.5-23.25 14.37-31.38 11.37c-8.125-3.125-10.88-9.358-15.88-29.36c-3.375-13.12-7.5-29.47-18-42.72c2.25-3 4.5-5.875 6.375-8.625C500.5 304.5 513.8 312 532 312c33.1 0 50.87-25.75 61.1-42.88C604.6 253 609 248 616 248C629.3 248 640 237.3 640 224s-10.75-24-24-24c-34 0-50.88 25.75-62 42.88C543.4 259 539 264 532 264c-17.25 0-37.5-61.38-97.25-101.9L452 127.6C485.4 125.5 512 97.97 512 63.97C512 28.6 483.4 0 448 0s-64 28.6-64 63.97c0 13 4 25.15 10.62 35.28L376.5 135.5C359.5 130.9 340.9 128 320 128S280.5 130.9 263.5 135.5L245.4 99.25C252 89.13 256 76.97 256 63.97C256 28.6 227.4 0 192 0S128 28.6 128 63.97C128 97.97 154.5 125.5 188 127.6l17.25 34.5C145.6 202.5 125.1 264 108 264c-7 0-11.31-5-21.94-21.12C74.94 225.8 57.1 200 24 200C10.75 200 0 210.8 0 224s10.75 24 24 24c7 0 11.37 5 21.1 21.12C57.12 286.3 73.1 312 108 312c18.25 0 31.5-7.5 41.75-17.12C151.6 297.6 153.9 300.5 156.1 303.5c-10.5 13.25-14.62 29.59-18 42.72c-5 20-7.75 26.23-15.88 29.36c-8.125 3-14.37 .1314-31.37-11.37c-18.12-12.25-42.75-28.87-75.38-16.49c-12.38 4.75-18.62 18.61-13.88 30.98c4.625 12.38 18.62 18.62 30.88 13.87C40.75 389.6 46.88 392.4 64 403.9c13.5 9.125 30.75 20.86 52.38 20.86c7.125 0 14.88-1.248 23-4.373c32.63-12.5 40-41.34 45.25-62.46c2.25-8.75 4-14.49 6-18.86c16.62 13.62 37 25.86 61.63 34.23C242.3 410.3 220.1 464 192 464c-13.25 0-24 10.74-24 23.99S178.8 512 192 512c66.75 0 97-88.55 107.4-129.1C306.1 383.6 312.9 384 320 384s13.88-.4706 20.62-1.096C351 423.4 381.3 512 448 512c13.25 0 24-10.74 24-23.99S461.3 464 448 464c-28 0-50.25-53.74-60.25-90.74c24.75-8.375 45-20.56 61.63-34.19c2 4.375 3.75 10.11 6 18.86c5.375 21.12 12.62 49.96 45.25 62.46c8.25 3.125 15.88 4.373 23 4.373c21.62 0 38.83-11.74 52.46-20.86c17-11.5 23.29-14.37 31.42-11.37c12.38 4.75 26.25-1.492 30.88-13.87C643.1 366.3 637 352.5 624.5 347.7zM192 79.97c-8.875 0-16-7.125-16-16S183.1 47.98 192 47.98s16 7.118 16 15.99S200.9 79.97 192 79.97zM448 47.98c8.875 0 16 7.118 16 15.99s-7.125 16-16 16s-16-7.125-16-16S439.1 47.98 448 47.98z")),"label"=>__("Spaghetti Monster Flying","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"speakap"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M64 391.8C-15.41 303.6-8 167.4 80.64 87.64s224.8-73 304.2 15.24 72 224.4-16.64 304.1c-18.74 16.87 64 43.09 42 52.26-82.06 34.21-253.9 35-346.2-67.5zm213.3-211.6l38.5-40.86c-9.61-8.89-32-26.83-76.17-27.6-52.33-.91-95.86 28.3-96.77 80-.2 11.33 .29 36.72 29.42 54.83 34.46 21.42 86.52 21.51 86 52.26-.37 21.28-26.42 25.81-38.59 25.6-3-.05-30.23-.46-47.61-24.62l-40 42.61c28.16 27 59 32.62 83.49 33.05 10.23 .18 96.42 .33 97.84-81 .28-15.81-2.07-39.72-28.86-56.59-34.36-21.64-85-19.45-84.43-49.75 .41-23.25 31-25.37 37.53-25.26 .43 0 26.62 .26 39.62 17.37z")),"label"=>__("Speakap","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"speaker-deck"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M213.9 296H100a100 100 0 0 1 0-200h132.8a40 40 0 0 1 0 80H98c-26.47 0-26.45 40 0 40h113.8a100 100 0 0 1 0 200H40a40 40 0 0 1 0-80h173.9c26.48 0 26.46-40 0-40zM298 416a120.2 120.2 0 0 0 51.11-80h64.55a19.83 19.83 0 0 0 19.66-20V196a19.83 19.83 0 0 0 -19.66-20H296.4a60.77 60.77 0 0 0 0-80h136.9c43.44 0 78.65 35.82 78.65 80v160c0 44.18-35.21 80-78.65 80z")),"label"=>__("Speaker Deck","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"spell-check"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M566.6 265.4c-12.5-12.5-32.75-12.5-45.25 0L352 434.8l-73.38-73.38c-12.5-12.5-32.75-12.5-45.25 0s-12.5 32.75 0 45.25l96 96c6.25 6.25 14.44 9.368 22.62 9.368s16.38-3.118 22.63-9.368l192-192C579.1 298.1 579.1 277.9 566.6 265.4zM221.5 211.7l-80-192C136.6 7.796 124.9 .0147 112 .0147S87.44 7.796 82.47 19.7l-80 192C-4.328 228 3.375 246.8 19.69 253.5c16.36 6.812 35.06-.9375 41.84-17.22l5.131-12.31h90.68l5.131 12.31c5.109 12.28 17.02 19.69 29.55 19.69c4.094 0 8.266-.7812 12.3-2.469C220.6 246.8 228.3 228 221.5 211.7zM93.33 160L112 115.2l18.67 44.81H93.33zM288 256h80c44.11 0 80-35.87 80-79.1c0-23.15-10.03-43.85-25.79-58.47C428.3 106.3 432 93.65 432 80.01c0-44.13-35.89-80-79.1-80L288 .0147c-17.67 0-32 14.31-32 31.1v192C256 241.7 270.3 256 288 256zM320 64.01h32c8.828 0 16 7.188 16 16s-7.172 16-16 16h-32V64.01zM320 160h48c8.828 0 16 7.188 16 16s-7.172 16-16 16H320V160z")),"label"=>__("Spell Check","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"spider"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M563.3 401.6c2.608 8.443-2.149 17.4-10.62 19.1l-15.35 4.709c-8.48 2.6-17.47-2.139-20.08-10.59L493.2 338l-79.79-31.8l53.47 62.15c5.08 5.904 6.972 13.89 5.08 21.44l-28.23 110.1c-2.151 8.57-10.87 13.78-19.47 11.64l-15.58-3.873c-8.609-2.141-13.84-10.83-11.69-19.4l25.2-98.02l-38.51-44.77c.1529 2.205 .6627 4.307 .6627 6.549c0 53.02-43.15 96-96.37 96S191.6 405 191.6 352c0-2.242 .5117-4.34 .6627-6.543l-38.51 44.76l25.2 98.02c2.151 8.574-3.084 17.26-11.69 19.4l-15.58 3.873c-8.603 2.141-17.32-3.072-19.47-11.64l-28.23-110.1c-1.894-7.543 0-15.53 5.08-21.44l53.47-62.15l-79.79 31.8l-24.01 77.74c-2.608 8.447-11.6 13.19-20.08 10.59l-15.35-4.709c-8.478-2.6-13.23-11.55-10.63-19.1l27.4-88.69c2.143-6.939 7.323-12.54 14.09-15.24L158.9 256l-104.7-41.73C47.43 211.6 42.26 205.1 40.11 199.1L12.72 110.4c-2.608-8.443 2.149-17.4 10.62-19.1l15.35-4.709c8.48-2.6 17.47 2.139 20.08 10.59l24.01 77.74l79.79 31.8L109.1 143.6C104 137.7 102.1 129.7 104 122.2l28.23-110.1c2.151-8.57 10.87-13.78 19.47-11.64l15.58 3.873C175.9 6.494 181.1 15.18 178.1 23.76L153.8 121.8L207.7 184.4l.1542-24.44C206.1 123.4 228.9 91.77 261.4 80.43c5.141-1.793 10.5 2.215 10.5 7.641V112h32.12V88.09c0-5.443 5.394-9.443 10.55-7.641C345.9 91.39 368.3 121 368.3 155.9c0 1.393-.1786 2.689-.2492 4.064L368.3 184.4l53.91-62.66l-25.2-98.02c-2.151-8.574 3.084-17.26 11.69-19.4l15.58-3.873c8.603-2.141 17.32 3.072 19.47 11.64l28.23 110.1c1.894 7.543 0 15.53-5.08 21.44l-53.47 62.15l79.79-31.8l24.01-77.74c2.608-8.447 11.6-13.19 20.08-10.59l15.35 4.709c8.478 2.6 13.23 11.55 10.63 19.1l-27.4 88.69c-2.143 6.939-7.323 12.54-14.09 15.24L417.1 256l104.7 41.73c6.754 2.691 11.92 8.283 14.07 15.21L563.3 401.6z")),"label"=>__("Spider","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment")),"spinner"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M304 48C304 74.51 282.5 96 256 96C229.5 96 208 74.51 208 48C208 21.49 229.5 0 256 0C282.5 0 304 21.49 304 48zM304 464C304 490.5 282.5 512 256 512C229.5 512 208 490.5 208 464C208 437.5 229.5 416 256 416C282.5 416 304 437.5 304 464zM0 256C0 229.5 21.49 208 48 208C74.51 208 96 229.5 96 256C96 282.5 74.51 304 48 304C21.49 304 0 282.5 0 256zM512 256C512 282.5 490.5 304 464 304C437.5 304 416 282.5 416 256C416 229.5 437.5 208 464 208C490.5 208 512 229.5 512 256zM74.98 437C56.23 418.3 56.23 387.9 74.98 369.1C93.73 350.4 124.1 350.4 142.9 369.1C161.6 387.9 161.6 418.3 142.9 437C124.1 455.8 93.73 455.8 74.98 437V437zM142.9 142.9C124.1 161.6 93.73 161.6 74.98 142.9C56.24 124.1 56.24 93.73 74.98 74.98C93.73 56.23 124.1 56.23 142.9 74.98C161.6 93.73 161.6 124.1 142.9 142.9zM369.1 369.1C387.9 350.4 418.3 350.4 437 369.1C455.8 387.9 455.8 418.3 437 437C418.3 455.8 387.9 455.8 369.1 437C350.4 418.3 350.4 387.9 369.1 369.1V369.1z")),"label"=>__("Spinner","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"splotch"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M349.3 47.38L367.9 116.1C374.6 142.1 393.2 162.3 417.6 171.2L475.8 192.4C497.5 200.3 512 221 512 244.2C512 261.8 503.6 278.4 489.4 288.8L406.9 348.1C393.3 358.9 385.7 374.1 386.7 391.8L389.8 442.4C392.1 480.1 362.2 511.9 324.4 511.9C308.8 511.9 293.8 506.4 281.1 496.4L236.1 458.2C221.1 444.7 200.9 437.3 180 437.3H171.6C165.1 437.3 160.4 437.8 154.8 438.9L87.81 451.9C63.82 456.6 39.53 445.5 27.41 424.3C17.39 406.7 17.39 385.2 27.41 367.7L55.11 319.2C60.99 308.9 64.09 297.3 64.09 285.4C64.09 272.3 60.33 259.6 53.27 248.6L8.796 179.4C-6.738 155.2-1.267 123.2 21.41 105.6C32.12 97.25 45.52 93.13 59.07 94.01L130.8 98.66C159.8 100.5 187.1 87.91 205.9 64.93L237.3 24.66C249.4 9.133 267.9 .0566 287.6 .0566C316.5 .0566 341.8 19.47 349.3 47.38V47.38z")),"label"=>__("Splotch","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design")),"spoon"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M449.5 242.2C436.4 257.8 419.8 270 400.1 277.8C382.2 285.6 361.7 288.8 341.4 287C326.2 284.5 311.8 278.4 299.5 269.1L68.29 500.3C60.79 507.8 50.61 512 40 512C29.39 512 19.22 507.8 11.71 500.3C4.211 492.8-.0039 482.6-.0039 472C-.0039 461.4 4.211 451.2 11.71 443.7L243 212.5C233.7 200.2 227.6 185.8 225.1 170.6C223.3 150.3 226.5 129.9 234.3 111C242.1 92.22 254.3 75.56 269.9 62.47C337.8-5.437 433.1-20.28 482.7 29.35C532.3 78.95 517.4 174.2 449.5 242.2z")),"label"=>__("Spoon","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","travel")),"spotify"=>array("svg"=>array("brands"=>array("width"=>496,"height"=>512,"path"=>"M248 8C111.1 8 0 119.1 0 256s111.1 248 248 248 248-111.1 248-248S384.9 8 248 8zm100.7 364.9c-4.2 0-6.8-1.3-10.7-3.6-62.4-37.6-135-39.2-206.7-24.5-3.9 1-9 2.6-11.9 2.6-9.7 0-15.8-7.7-15.8-15.8 0-10.3 6.1-15.2 13.6-16.8 81.9-18.1 165.6-16.5 237 26.2 6.1 3.9 9.7 7.4 9.7 16.5s-7.1 15.4-15.2 15.4zm26.9-65.6c-5.2 0-8.7-2.3-12.3-4.2-62.5-37-155.7-51.9-238.6-29.4-4.8 1.3-7.4 2.6-11.9 2.6-10.7 0-19.4-8.7-19.4-19.4s5.2-17.8 15.5-20.7c27.8-7.8 56.2-13.6 97.8-13.6 64.9 0 127.6 16.1 177 45.5 8.1 4.8 11.3 11 11.3 19.7-.1 10.8-8.5 19.5-19.4 19.5zm31-76.2c-5.2 0-8.4-1.3-12.9-3.9-71.2-42.5-198.5-52.7-280.9-29.7-3.6 1-8.1 2.6-12.9 2.6-13.2 0-23.3-10.3-23.3-23.6 0-13.6 8.4-21.3 17.4-23.9 35.2-10.3 74.6-15.2 117.5-15.2 73 0 149.5 15.2 205.4 47.8 7.8 4.5 12.9 10.7 12.9 22.6 0 13.6-11 23.3-23.2 23.3z")),"label"=>__("Spotify","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","brands","brands","social")),"spray-can"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M192 0C209.7 0 224 14.33 224 32V128H96V32C96 14.33 110.3 0 128 0H192zM0 256C0 202.1 42.98 160 96 160H224C277 160 320 202.1 320 256V464C320 490.5 298.5 512 272 512H48C21.49 512 0 490.5 0 464V256zM160 256C115.8 256 80 291.8 80 336C80 380.2 115.8 416 160 416C204.2 416 240 380.2 240 336C240 291.8 204.2 256 160 256zM320 64C320 81.67 305.7 96 288 96C270.3 96 256 81.67 256 64C256 46.33 270.3 32 288 32C305.7 32 320 46.33 320 64zM352 64C352 46.33 366.3 32 384 32C401.7 32 416 46.33 416 64C416 81.67 401.7 96 384 96C366.3 96 352 81.67 352 64zM512 64C512 81.67 497.7 96 480 96C462.3 96 448 81.67 448 64C448 46.33 462.3 32 480 32C497.7 32 512 46.33 512 64zM448 160C448 142.3 462.3 128 480 128C497.7 128 512 142.3 512 160C512 177.7 497.7 192 480 192C462.3 192 448 177.7 448 160zM512 256C512 273.7 497.7 288 480 288C462.3 288 448 273.7 448 256C448 238.3 462.3 224 480 224C497.7 224 512 238.3 512 256zM352 160C352 142.3 366.3 128 384 128C401.7 128 416 142.3 416 160C416 177.7 401.7 192 384 192C366.3 192 352 177.7 352 160z")),"label"=>__("Spray Can","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design")),"spray-can-sparkles"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M96 32C96 14.33 110.3 0 128 0H192C209.7 0 224 14.33 224 32V128H96V32zM224 160C277 160 320 202.1 320 256V464C320 490.5 298.5 512 272 512H48C21.49 512 0 490.5 0 464V256C0 202.1 42.98 160 96 160H224zM160 416C204.2 416 240 380.2 240 336C240 291.8 204.2 256 160 256C115.8 256 80 291.8 80 336C80 380.2 115.8 416 160 416zM384 48C384 49.36 383 50.97 381.8 51.58L352 64L339.6 93.78C338.1 95 337.4 96 336 96C334.6 96 333 95 332.4 93.78L320 64L290.2 51.58C288.1 50.97 288 49.36 288 48C288 46.62 288.1 45.03 290.2 44.42L320 32L332.4 2.219C333 1 334.6 0 336 0C337.4 0 338.1 1 339.6 2.219L352 32L381.8 44.42C383 45.03 384 46.62 384 48zM460.4 93.78L448 64L418.2 51.58C416.1 50.97 416 49.36 416 48C416 46.62 416.1 45.03 418.2 44.42L448 32L460.4 2.219C461 1 462.6 0 464 0C465.4 0 466.1 1 467.6 2.219L480 32L509.8 44.42C511 45.03 512 46.62 512 48C512 49.36 511 50.97 509.8 51.58L480 64L467.6 93.78C466.1 95 465.4 96 464 96C462.6 96 461 95 460.4 93.78zM467.6 194.2L480 224L509.8 236.4C511 237 512 238.6 512 240C512 241.4 511 242.1 509.8 243.6L480 256L467.6 285.8C466.1 287 465.4 288 464 288C462.6 288 461 287 460.4 285.8L448 256L418.2 243.6C416.1 242.1 416 241.4 416 240C416 238.6 416.1 237 418.2 236.4L448 224L460.4 194.2C461 193 462.6 192 464 192C465.4 192 466.1 193 467.6 194.2zM448 144C448 145.4 447 146.1 445.8 147.6L416 160L403.6 189.8C402.1 191 401.4 192 400 192C398.6 192 397 191 396.4 189.8L384 160L354.2 147.6C352.1 146.1 352 145.4 352 144C352 142.6 352.1 141 354.2 140.4L384 128L396.4 98.22C397 97 398.6 96 400 96C401.4 96 402.1 97 403.6 98.22L416 128L445.8 140.4C447 141 448 142.6 448 144z")),"label"=>__("Spray Can Sparkles","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"square"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M0 96C0 60.65 28.65 32 64 32H384C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96z"),"regular"=>array("width"=>448,"height"=>512,"path"=>"M384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM384 80H64C55.16 80 48 87.16 48 96V416C48 424.8 55.16 432 64 432H384C392.8 432 400 424.8 400 416V96C400 87.16 392.8 80 384 80z")),"label"=>__("Square","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design")),"square-arrow-up-right"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h320c35.35 0 64-28.66 64-64V96C448 60.66 419.3 32 384 32zM344 312c0 17.69-14.31 32-32 32s-32-14.31-32-32V245.3l-121.4 121.4C152.4 372.9 144.2 376 136 376s-16.38-3.125-22.62-9.375c-12.5-12.5-12.5-32.75 0-45.25L234.8 200H168c-17.69 0-32-14.31-32-32s14.31-32 32-32h144c17.69 0 32 14.31 32 32V312z")),"label"=>__("Square Arrow Up Right","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"square-caret-down"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32H64C28.65 32 0 60.65 0 96v320c0 35.34 28.65 64 64 64h320c35.35 0 64-28.66 64-64V96C448 60.65 419.3 32 384 32zM345.6 232.3l-104 112C237 349.2 230.7 352 224 352s-13.03-2.781-17.59-7.656l-104-112c-6.5-7-8.219-17.19-4.407-25.94C101.8 197.7 110.5 192 120 192h208c9.531 0 18.19 5.656 21.1 14.41C353.8 215.2 352.1 225.3 345.6 232.3z"),"regular"=>array("width"=>448,"height"=>512,"path"=>"M320 192H128C118.5 192 109.8 197.7 105.1 206.4C102.2 215.1 103.9 225.3 110.4 232.3l96 104C210.9 341.2 217.3 344 224 344s13.09-2.812 17.62-7.719l96-104c6.469-7 8.188-17.19 4.375-25.91C338.2 197.7 329.5 192 320 192zM384 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h320c35.35 0 64-28.66 64-64V96C448 60.66 419.3 32 384 32zM400 416c0 8.82-7.178 16-16 16H64c-8.822 0-16-7.18-16-16V96c0-8.82 7.178-16 16-16h320c8.822 0 16 7.18 16 16V416z")),"label"=>__("Square Caret Down","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"square-caret-left"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32H64C28.65 32 0 60.65 0 96v320c0 35.34 28.65 64 64 64h320c35.35 0 64-28.66 64-64V96C448 60.65 419.3 32 384 32zM288 360c0 9.531-5.656 18.19-14.41 22C270.5 383.3 267.3 384 264 384c-5.938 0-11.81-2.219-16.34-6.406l-112-104C130.8 269 128 262.7 128 256s2.781-13.03 7.656-17.59l112-104c7.031-6.469 17.22-8.156 25.94-4.406C282.3 133.8 288 142.5 288 152V360z"),"regular"=>array("width"=>448,"height"=>512,"path"=>"M384 32H64C28.66 32 0 60.66 0 96v320c0 35.34 28.66 64 64 64h320c35.34 0 64-28.66 64-64V96C448 60.66 419.3 32 384 32zM400 416c0 8.82-7.18 16-16 16H64c-8.82 0-16-7.18-16-16V96c0-8.82 7.18-16 16-16h320c8.82 0 16 7.18 16 16V416zM273.6 138c-8.719-3.812-18.91-2.094-25.91 4.375l-104 96C138.8 242.9 136 249.3 136 256s2.812 13.09 7.719 17.62l104 96c7 6.469 17.19 8.188 25.91 4.375C282.3 370.2 288 361.5 288 352V160C288 150.5 282.3 141.8 273.6 138z")),"label"=>__("Square Caret Left","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"square-caret-right"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32H64C28.65 32 0 60.65 0 96v320c0 35.34 28.65 64 64 64h320c35.35 0 64-28.66 64-64V96C448 60.65 419.3 32 384 32zM312.3 273.6l-112 104C195.8 381.8 189.9 384 184 384c-3.25 0-6.5-.6562-9.594-2C165.7 378.2 160 369.5 160 360v-208c0-9.531 5.656-18.19 14.41-22c8.75-3.75 18.94-2.062 25.94 4.406l112 104C317.2 242.1 320 249.3 320 256S317.2 269 312.3 273.6z"),"regular"=>array("width"=>448,"height"=>512,"path"=>"M200.3 142.4C193.3 135.9 183.1 134.2 174.4 138C165.7 141.8 160 150.5 160 159.1v192C160 361.5 165.7 370.2 174.4 374c8.719 3.812 18.91 2.094 25.91-4.375l104-96C309.2 269.1 312 262.7 312 256s-2.812-13.09-7.719-17.62L200.3 142.4zM384 32H64C28.66 32 0 60.66 0 96v320c0 35.34 28.66 64 64 64h320c35.34 0 64-28.66 64-64V96C448 60.66 419.3 32 384 32zM400 416c0 8.82-7.18 16-16 16H64c-8.82 0-16-7.18-16-16V96c0-8.82 7.18-16 16-16h320c8.82 0 16 7.18 16 16V416z")),"label"=>__("Square Caret Right","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"square-caret-up"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32H64C28.65 32 0 60.65 0 96v320c0 35.34 28.65 64 64 64h320c35.35 0 64-28.66 64-64V96C448 60.65 419.3 32 384 32zM349.1 305.6C346.2 314.3 337.5 320 328 320h-208c-9.531 0-18.19-5.656-22-14.41C94.19 296.8 95.91 286.7 102.4 279.7l104-112c9.125-9.75 26.06-9.75 35.19 0l104 112C352.1 286.7 353.8 296.8 349.1 305.6z"),"regular"=>array("width"=>448,"height"=>512,"path"=>"M241.6 175.7C237.1 170.8 230.7 168 224 168S210.9 170.8 206.4 175.7l-96 104c-6.469 7-8.188 17.19-4.375 25.91C109.8 314.3 118.5 320 127.1 320h192c9.531 0 18.16-5.656 22-14.38c3.813-8.719 2.094-18.91-4.375-25.91L241.6 175.7zM384 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h320c35.35 0 64-28.66 64-64V96C448 60.66 419.3 32 384 32zM400 416c0 8.82-7.178 16-16 16H64c-8.822 0-16-7.18-16-16V96c0-8.82 7.178-16 16-16h320c8.822 0 16 7.18 16 16V416z")),"label"=>__("Square Caret Up","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"square-check"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM339.8 211.8C350.7 200.9 350.7 183.1 339.8 172.2C328.9 161.3 311.1 161.3 300.2 172.2L192 280.4L147.8 236.2C136.9 225.3 119.1 225.3 108.2 236.2C97.27 247.1 97.27 264.9 108.2 275.8L172.2 339.8C183.1 350.7 200.9 350.7 211.8 339.8L339.8 211.8z"),"regular"=>array("width"=>448,"height"=>512,"path"=>"M211.8 339.8C200.9 350.7 183.1 350.7 172.2 339.8L108.2 275.8C97.27 264.9 97.27 247.1 108.2 236.2C119.1 225.3 136.9 225.3 147.8 236.2L192 280.4L300.2 172.2C311.1 161.3 328.9 161.3 339.8 172.2C350.7 183.1 350.7 200.9 339.8 211.8L211.8 339.8zM0 96C0 60.65 28.65 32 64 32H384C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96zM48 96V416C48 424.8 55.16 432 64 432H384C392.8 432 400 424.8 400 416V96C400 87.16 392.8 80 384 80H64C55.16 80 48 87.16 48 96z")),"label"=>__("Square Check","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design")),"square-envelope"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32H64C28.63 32 0 60.63 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.63 419.4 32 384 32zM384 336c0 17.67-14.33 32-32 32H96c-17.67 0-32-14.33-32-32V225.9l138.5 69.27C209.3 298.5 216.6 300.2 224 300.2s14.75-1.688 21.47-5.047L384 225.9V336zM384 190.1l-152.8 76.42c-4.5 2.25-9.812 2.25-14.31 0L64 190.1V176c0-17.67 14.33-32 32-32h256c17.67 0 32 14.33 32 32V190.1z")),"label"=>__("Square Envelope","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","communication")),"square-font-awesome"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M384.5 32.5h-320c-35.3 0-64 28.7-64 64v320c0 35.3 28.7 64 64 64h320c35.3 0 64-28.7 64-64v-320C448.5 61.2 419.8 32.5 384.5 32.5zM336.5 312.5c-31.6 11.2-41.2 16-59.8 16c-31.4 0-43.2-16-74.6-16c-10.2 0-18.2 1.6-25.6 4v-32c7.4-2.2 15.4-4 25.6-4c31.2 0 43.2 16 74.6 16c10.2 0 17.8-1.4 27.8-4.6v-96c-10 3.2-17.6 4.6-27.8 4.6c-31.4 0-43.2-16-74.6-16c-25.4 0-37.4 10.4-57.6 14.4v153.6c0 8.8-7.2 16-16 16c-8.8 0-16-7.2-16-16v-192c0-8.8 7.2-16 16-16c8.8 0 16 7.2 16 16v6.4c20.2-4 32.2-14.4 57.6-14.4c31.2 0 43.2 16 74.6 16c18.6 0 28.2-4.8 59.8-16V312.5z")),"label"=>__("Font Awesome in Square","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"square-font-awesome-stroke"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M201.6 152c-25.4 0-37.4 10.4-57.6 14.4V160c0-8.8-7.2-16-16-16s-16 7.2-16 16v192c0 .8 .1 1.6 .2 2.4c.1 .4 .1 .8 .2 1.2c1.6 7.1 8 12.4 15.6 12.4s14-5.3 15.6-12.4c.1-.4 .2-.8 .2-1.2c.1-.8 .2-1.6 .2-2.4V198.4c4-.8 7.7-1.8 11.2-3c14.3-4.7 26-11.4 46.4-11.4c31.4 0 43.2 16 74.6 16c8.9 0 15.9-1.1 24.2-3.5c1.2-.3 2.4-.7 3.6-1.1v96c-10 3.2-17.6 4.6-27.8 4.6c-31.4 0-43.4-16-74.6-16c-10.2 0-18.2 1.8-25.6 4v32c7.4-2.4 15.4-4 25.6-4c31.4 0 43.2 16 74.6 16c18.6 0 28.2-4.8 59.8-16V152c-31.6 11.2-41.2 16-59.8 16C244.8 168 232.8 152 201.6 152zM384 32H64C28.7 32 0 60.7 0 96v320c0 35.3 28.7 64 64 64h320c35.3 0 64-28.7 64-64V96C448 60.7 419.3 32 384 32zM416 416c0 17.6-14.4 32-32 32H64c-17.6 0-32-14.4-32-32V96c0-17.6 14.4-32 32-32h320c17.6 0 32 14.4 32 32V416z")),"label"=>__("Font Awesome in Square with Stroke Outline","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"square-full"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M0 0H512V512H0V0z"),"regular"=>array("width"=>512,"height"=>512,"path"=>"M512 0V512H0V0H512zM464 48H48V464H464V48z")),"label"=>__("Square Full","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"square-h"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96C448 60.65 419.3 32 384 32zM336 360c0 13.25-10.75 24-24 24S288 373.3 288 360v-80H160v80C160 373.3 149.3 384 136 384S112 373.3 112 360v-208C112 138.8 122.8 128 136 128S160 138.8 160 152v80h128v-80C288 138.8 298.8 128 312 128s24 10.75 24 24V360z")),"label"=>__("Square H","ultimate-addons-for-gutenberg"),"custom_categories"=>array("education","science-and-technology","travel")),"square-minus"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM136 232C122.7 232 112 242.7 112 256C112 269.3 122.7 280 136 280H312C325.3 280 336 269.3 336 256C336 242.7 325.3 232 312 232H136z"),"regular"=>array("width"=>448,"height"=>512,"path"=>"M312 232C325.3 232 336 242.7 336 256C336 269.3 325.3 280 312 280H136C122.7 280 112 269.3 112 256C112 242.7 122.7 232 136 232H312zM0 96C0 60.65 28.65 32 64 32H384C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96zM48 96V416C48 424.8 55.16 432 64 432H384C392.8 432 400 424.8 400 416V96C400 87.16 392.8 80 384 80H64C55.16 80 48 87.16 48 96z")),"label"=>__("Square Minus","ultimate-addons-for-gutenberg"),"custom_categories"=>array("education")),"square-nfi"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M0 96C0 60.65 28.65 32 64 32H384C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96zM64 176V336C64 344.8 71.16 352 80 352C88.84 352 96 344.8 96 336V233.8L162.3 344.2C165.1 350.4 173.3 353.3 180.3 351.4C187.2 349.5 191.1 343.2 191.1 336V176C191.1 167.2 184.8 160 175.1 160C167.2 160 159.1 167.2 159.1 176V278.2L93.72 167.8C90.02 161.6 82.66 158.7 75.73 160.6C68.8 162.5 64 168.8 64 176V176zM224 336C224 344.8 231.2 352 240 352C248.8 352 256 344.8 256 336V256H304C312.8 256 320 248.8 320 240C320 231.2 312.8 224 304 224H256V192H304C312.8 192 320 184.8 320 176C320 167.2 312.8 160 304 160H240C231.2 160 224 167.2 224 176V336zM384 176C384 167.2 376.8 160 368 160C359.2 160 352 167.2 352 176V336C352 344.8 359.2 352 368 352C376.8 352 384 344.8 384 336V176z")),"label"=>__("Square Nfi","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"square-parking"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M192 256V192H240C257.7 192 272 206.3 272 224C272 241.7 257.7 256 240 256H192zM384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM336 224C336 170.1 293 128 240 128H168C145.9 128 128 145.9 128 168V352C128 369.7 142.3 384 160 384C177.7 384 192 369.7 192 352V320H240C293 320 336 277 336 224z")),"label"=>__("Square Parking","ultimate-addons-for-gutenberg"),"custom_categories"=>array("travel")),"square-pen"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM325.8 139.7C310.1 124.1 284.8 124.1 269.2 139.7L247.8 161.1L318.7 232.1L340.1 210.7C355.8 195 355.8 169.7 340.1 154.1L325.8 139.7zM111.5 303.8L96.48 363.1C95.11 369.4 96.71 375.2 100.7 379.2C104.7 383.1 110.4 384.7 115.9 383.4L176 368.3C181.6 366.9 186.8 364 190.9 359.9L296.1 254.7L225.1 183.8L119.9 288.1C115.8 293.1 112.9 298.2 111.5 303.8z")),"label"=>__("Square Pen","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","communication","design")),"square-person-confined"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM208 96C181.5 96 160 117.5 160 144C160 170.5 181.5 192 208 192C234.5 192 256 170.5 256 144C256 117.5 234.5 96 208 96zM240 306.7L198.6 265.4C191.4 258.1 181 254.8 170.9 256.4C160.7 258.1 151.1 264.5 147.4 273.7L99.39 369.7C91.48 385.5 97.89 404.7 113.7 412.6C129.5 420.5 148.7 414.1 156.6 398.3L184.8 342L239.4 396.7C251.8 409.1 268.6 416 286.1 416C322.5 416 352 386.5 352 350.1V248C352 217.1 326.9 192 296 192C265.1 192 240 217.1 240 248V306.7z")),"label"=>__("Square Person Confined","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"square-phone"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96C448 60.65 419.3 32 384 32zM351.6 321.5l-11.62 50.39c-1.633 7.125-7.9 12.11-15.24 12.11c-126.1 0-228.7-102.6-228.7-228.8c0-7.328 4.984-13.59 12.11-15.22l50.38-11.63c7.344-1.703 14.88 2.109 17.93 9.062l23.27 54.28c2.719 6.391 .8828 13.83-4.492 18.22L168.3 232c16.99 34.61 45.14 62.75 79.77 79.75l22.02-26.91c4.344-5.391 11.85-7.25 18.24-4.484l54.24 23.25C349.5 306.6 353.3 314.2 351.6 321.5z")),"label"=>__("Square Phone","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","communication","travel")),"square-phone-flip"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96c0-35.35-28.65-64-64-64H64C28.65 32 0 60.65 0 96zM105.5 303.6l54.24-23.25c6.391-2.766 13.9-.9062 18.24 4.484l22.02 26.91c34.63-17 62.77-45.14 79.77-79.75l-26.91-22.05c-5.375-4.391-7.211-11.83-4.492-18.22l23.27-54.28c3.047-6.953 10.59-10.77 17.93-9.062l50.38 11.63c7.125 1.625 12.11 7.891 12.11 15.22c0 126.1-102.6 228.8-228.7 228.8c-7.336 0-13.6-4.984-15.24-12.11l-11.62-50.39C94.71 314.2 98.5 306.6 105.5 303.6z")),"label"=>__("Square Phone Flip","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","communication","travel")),"square-plus"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM224 368C237.3 368 248 357.3 248 344V280H312C325.3 280 336 269.3 336 256C336 242.7 325.3 232 312 232H248V168C248 154.7 237.3 144 224 144C210.7 144 200 154.7 200 168V232H136C122.7 232 112 242.7 112 256C112 269.3 122.7 280 136 280H200V344C200 357.3 210.7 368 224 368z"),"regular"=>array("width"=>448,"height"=>512,"path"=>"M200 344V280H136C122.7 280 112 269.3 112 256C112 242.7 122.7 232 136 232H200V168C200 154.7 210.7 144 224 144C237.3 144 248 154.7 248 168V232H312C325.3 232 336 242.7 336 256C336 269.3 325.3 280 312 280H248V344C248 357.3 237.3 368 224 368C210.7 368 200 357.3 200 344zM0 96C0 60.65 28.65 32 64 32H384C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96zM48 96V416C48 424.8 55.16 432 64 432H384C392.8 432 400 424.8 400 416V96C400 87.16 392.8 80 384 80H64C55.16 80 48 87.16 48 96z")),"label"=>__("Square Plus","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology","travel")),"square-poll-horizontal"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M448 416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384C419.3 32 448 60.65 448 96V416zM256 160C256 142.3 241.7 128 224 128H128C110.3 128 96 142.3 96 160C96 177.7 110.3 192 128 192H224C241.7 192 256 177.7 256 160zM128 224C110.3 224 96 238.3 96 256C96 273.7 110.3 288 128 288H320C337.7 288 352 273.7 352 256C352 238.3 337.7 224 320 224H128zM192 352C192 334.3 177.7 320 160 320H128C110.3 320 96 334.3 96 352C96 369.7 110.3 384 128 384H160C177.7 384 192 369.7 192 352z")),"label"=>__("Square Poll Horizontal","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","social")),"square-poll-vertical"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM128 224C110.3 224 96 238.3 96 256V352C96 369.7 110.3 384 128 384C145.7 384 160 369.7 160 352V256C160 238.3 145.7 224 128 224zM192 352C192 369.7 206.3 384 224 384C241.7 384 256 369.7 256 352V160C256 142.3 241.7 128 224 128C206.3 128 192 142.3 192 160V352zM320 288C302.3 288 288 302.3 288 320V352C288 369.7 302.3 384 320 384C337.7 384 352 369.7 352 352V320C352 302.3 337.7 288 320 288z")),"label"=>__("Square Poll Vertical","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","social")),"square-root-variable"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M576 32.01c0-17.69-14.33-31.1-32-31.1l-224-.0049c-14.69 0-27.48 10-31.05 24.25L197.9 388.3L124.6 241.7C119.2 230.9 108.1 224 96 224L32 224c-17.67 0-32 14.31-32 31.1s14.33 32 32 32h44.22l103.2 206.3c5.469 10.91 16.6 17.68 28.61 17.68c1.172 0 2.323-.0576 3.495-.1826c13.31-1.469 24.31-11.06 27.56-24.06l105.9-423.8H544C561.7 64.01 576 49.7 576 32.01zM566.6 233.4c-12.5-12.5-32.75-12.5-45.25 0L480 274.8l-41.38-41.37c-12.5-12.5-32.75-12.5-45.25 0s-12.5 32.75 0 45.25l41.38 41.38l-41.38 41.38c-12.5 12.5-12.5 32.75 0 45.25C399.6 412.9 407.8 416 416 416s16.38-3.125 22.62-9.375L480 365.3l41.38 41.38C527.6 412.9 535.8 416 544 416s16.38-3.125 22.62-9.375c12.5-12.5 12.5-32.75 0-45.25l-41.38-41.38L566.6 278.6C579.1 266.1 579.1 245.9 566.6 233.4z")),"label"=>__("Square Root Variable","ultimate-addons-for-gutenberg"),"custom_categories"=>array("education")),"square-rss"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h320c35.35 0 64-28.66 64-64V96C448 60.66 419.3 32 384 32zM150.6 374.6C144.4 380.9 136.2 384 128 384s-16.38-3.121-22.63-9.371c-12.5-12.5-12.5-32.76 0-45.26C111.6 323.1 119.8 320 128 320s16.38 3.121 22.63 9.371C163.1 341.9 163.1 362.1 150.6 374.6zM249.6 383.9C249 383.1 248.5 384 247.1 384c-12.53 0-23.09-9.75-23.92-22.44C220.5 306.9 173.1 259.5 118.4 255.9c-13.22-.8438-23.25-12.28-22.39-25.5c.8594-13.25 12.41-22.81 25.52-22.38c77.86 5.062 145.3 72.5 150.4 150.4C272.8 371.7 262.8 383.1 249.6 383.9zM345 383.1C344.7 384 344.3 384 343.1 384c-12.8 0-23.42-10.09-23.97-23C315.6 254.6 225.4 164.4 119 159.1C105.8 159.4 95.47 148.3 96.02 135C96.58 121.8 107.9 111.2 121 112c130.7 5.469 241.5 116.3 246.1 246.1C368.5 372.3 358.3 383.4 345 383.1z")),"label"=>__("Square Rss","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication")),"square-share-nodes"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM320 96C284.7 96 256 124.7 256 160C256 162.5 256.1 164.9 256.4 167.3L174.5 212C162.8 199.7 146.3 192 128 192C92.65 192 64 220.7 64 256C64 291.3 92.65 320 128 320C146.3 320 162.8 312.3 174.5 299.1L256.4 344.7C256.1 347.1 256 349.5 256 352C256 387.3 284.7 416 320 416C355.3 416 384 387.3 384 352C384 316.7 355.3 288 320 288C304.6 288 290.5 293.4 279.4 302.5L194.1 256L279.4 209.5C290.5 218.6 304.6 224 320 224C355.3 224 384 195.3 384 160C384 124.7 355.3 96 320 96V96z")),"label"=>__("Square Share Nodes","ultimate-addons-for-gutenberg"),"custom_categories"=>array("social","brands","brands","social")),"square-up-right"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32H64C28.65 32 0 60.65 0 96v320c0 35.34 28.65 64 64 64h320c35.35 0 64-28.66 64-64V96C448 60.65 419.3 32 384 32zM330.5 323.9c0 6.473-3.889 12.3-9.877 14.78c-5.979 2.484-12.86 1.105-17.44-3.469l-45.25-45.25l-67.92 67.92c-12.5 12.5-32.72 12.46-45.21-.0411l-22.63-22.63C109.7 322.7 109.6 302.5 122.1 289.1l67.92-67.92L144.8 176.8C140.2 172.2 138.8 165.3 141.3 159.4c2.477-5.984 8.309-9.875 14.78-9.875h158.4c8.835 0 15.1 7.163 15.1 15.1V323.9z")),"label"=>__("Square Up Right","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"square-virus"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M160 224C160 206.3 174.3 192 192 192C209.7 192 224 206.3 224 224C224 241.7 209.7 256 192 256C174.3 256 160 241.7 160 224zM280 288C280 301.3 269.3 312 256 312C242.7 312 232 301.3 232 288C232 274.7 242.7 264 256 264C269.3 264 280 274.7 280 288zM384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM199.8 117.7C199.8 146.9 164.5 161.6 143.8 140.9C134.4 131.5 119.2 131.5 109.8 140.9C100.5 150.2 100.5 165.4 109.8 174.8C130.5 195.5 115.9 230.9 86.61 230.9C73.35 230.9 62.61 241.6 62.61 254.9C62.61 268.1 73.35 278.9 86.61 278.9C115.9 278.9 130.5 314.3 109.8 334.9C100.5 344.3 100.5 359.5 109.8 368.9C119.2 378.3 134.4 378.3 143.8 368.9C164.5 348.2 199.8 362.9 199.8 392.1C199.8 405.4 210.6 416.1 223.8 416.1C237.1 416.1 247.8 405.4 247.8 392.1C247.8 362.9 283.2 348.2 303.9 368.9C313.3 378.3 328.5 378.3 337.8 368.9C347.2 359.5 347.2 344.3 337.8 334.9C317.2 314.3 331.8 278.9 361.1 278.9C374.3 278.9 385.1 268.1 385.1 254.9C385.1 241.6 374.3 230.9 361.1 230.9C331.8 230.9 317.2 195.5 337.8 174.8C347.2 165.4 347.2 150.2 337.8 140.9C328.5 131.5 313.3 131.5 303.9 140.9C283.2 161.6 247.8 146.9 247.8 117.7C247.8 104.4 237.1 93.65 223.8 93.65C210.6 93.65 199.8 104.4 199.8 117.7H199.8z")),"label"=>__("Square Virus","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"square-xmark"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM143 208.1L190.1 255.1L143 303C133.7 312.4 133.7 327.6 143 336.1C152.4 346.3 167.6 346.3 176.1 336.1L223.1 289.9L271 336.1C280.4 346.3 295.6 346.3 304.1 336.1C314.3 327.6 314.3 312.4 304.1 303L257.9 255.1L304.1 208.1C314.3 199.6 314.3 184.4 304.1 175C295.6 165.7 280.4 165.7 271 175L223.1 222.1L176.1 175C167.6 165.7 152.4 165.7 143 175C133.7 184.4 133.7 199.6 143 208.1V208.1z")),"label"=>__("Square Xmark","ultimate-addons-for-gutenberg"),"custom_categories"=>array("education")),"squarespace"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M186.1 343.3c-9.65 9.65-9.65 25.29 0 34.94 9.65 9.65 25.29 9.65 34.94 0L378.2 221.1c19.29-19.29 50.57-19.29 69.86 0s19.29 50.57 0 69.86L293.1 445.1c19.27 19.29 50.53 19.31 69.82 .04l.04-.04 119.3-119.2c38.59-38.59 38.59-101.1 0-139.7-38.59-38.59-101.2-38.59-139.7 0l-157.2 157.2zm244.5-104.8c-9.65-9.65-25.29-9.65-34.93 0l-157.2 157.2c-19.27 19.29-50.53 19.31-69.82 .05l-.05-.05c-9.64-9.64-25.27-9.65-34.92-.01l-.01 .01c-9.65 9.64-9.66 25.28-.02 34.93l.02 .02c38.58 38.57 101.1 38.57 139.7 0l157.2-157.2c9.65-9.65 9.65-25.29 .01-34.93zm-261.1 87.33l157.2-157.2c9.64-9.65 9.64-25.29 0-34.94-9.64-9.64-25.27-9.64-34.91 0L133.7 290.9c-19.28 19.29-50.56 19.3-69.85 .01l-.01-.01c-19.29-19.28-19.31-50.54-.03-69.84l.03-.03L218 66.89c-19.28-19.29-50.55-19.3-69.85-.02l-.02 .02L28.93 186.1c-38.58 38.59-38.58 101.1 0 139.7 38.6 38.59 101.1 38.59 139.7 .01zm-87.33-52.4c9.64 9.64 25.27 9.64 34.91 0l157.2-157.2c19.28-19.29 50.55-19.3 69.84-.02l.02 .02c9.65 9.65 25.29 9.65 34.93 0 9.65-9.65 9.65-25.29 0-34.93-38.59-38.59-101.1-38.59-139.7 0L81.33 238.5c-9.65 9.64-9.65 25.28-.01 34.93h.01z")),"label"=>__("Squarespace","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"stack-exchange"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M17.7 332.3h412.7v22c0 37.7-29.3 68-65.3 68h-19L259.3 512v-89.7H83c-36 0-65.3-30.3-65.3-68v-22zm0-23.6h412.7v-85H17.7v85zm0-109.4h412.7v-85H17.7v85zM365 0H83C47 0 17.7 30.3 17.7 67.7V90h412.7V67.7C430.3 30.3 401 0 365 0z")),"label"=>__("Stack Exchange","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"stack-overflow"=>array("svg"=>array("brands"=>array("width"=>384,"height"=>512,"path"=>"M290.7 311L95 269.7 86.8 309l195.7 41zm51-87L188.2 95.7l-25.5 30.8 153.5 128.3zm-31.2 39.7L129.2 179l-16.7 36.5L293.7 300zM262 32l-32 24 119.3 160.3 32-24zm20.5 328h-200v39.7h200zm39.7 80H42.7V320h-40v160h359.5V320h-40z")),"label"=>__("Stack Overflow","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"stackpath"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M244.6 232.4c0 8.5-4.26 20.49-21.34 20.49h-19.61v-41.47h19.61c17.13 0 21.34 12.36 21.34 20.98zM448 32v448H0V32zM151.3 287.8c0-21.24-12.12-34.54-46.72-44.85-20.57-7.41-26-10.91-26-18.63s7-14.61 20.41-14.61c14.09 0 20.79 8.45 20.79 18.35h30.7l.19-.57c.5-19.57-15.06-41.65-51.12-41.65-23.37 0-52.55 10.75-52.55 38.29 0 19.4 9.25 31.29 50.74 44.37 17.26 6.15 21.91 10.4 21.91 19.48 0 15.2-19.13 14.23-19.47 14.23-20.4 0-25.65-9.1-25.65-21.9h-30.8l-.18 .56c-.68 31.32 28.38 45.22 56.63 45.22 29.98 0 51.12-13.55 51.12-38.29zm125.4-55.63c0-25.3-18.43-45.46-53.42-45.46h-51.78v138.2h32.17v-47.36h19.61c30.25 0 53.42-15.95 53.42-45.36zM297.9 325L347 186.8h-31.09L268 325zm106.5-138.2h-31.09L325.5 325h29.94z")),"label"=>__("Stackpath","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"staff-aesculapius"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M222.5 48H288C341 48 384 90.98 384 144C384 197 341 240 288 240H248V160H288C296.8 160 304 152.8 304 144C304 135.2 296.8 128 288 128H220L215.5 272H256C309 272 352 314.1 352 368C352 421 309 464 256 464H240V384H256C264.8 384 272 376.8 272 368C272 359.2 264.8 352 256 352H212.1L208.5 496C208.2 504.9 200.9 512 191.1 512C183.1 512 175.8 504.9 175.5 496L174.5 464H135.1C113.9 464 95.1 446.1 95.1 424C95.1 401.9 113.9 384 135.1 384H171.1L170.1 352H151.1C98.98 352 55.1 309 55.1 256C55.1 208.4 90.6 168.9 135.1 161.3V256C135.1 264.8 143.2 272 151.1 272H168.5L164 128H122.6C113.6 146.9 94.34 160 72 160H56C25.07 160 0 134.9 0 104C0 73.07 25.07 48 56 48H161.5L160.1 31.98C160.1 31.33 160.1 30.69 160.1 30.05C161.5 13.43 175.1 0 192 0C208.9 0 222.5 13.43 223 30.05C223 30.69 223 31.33 223 31.98L222.5 48zM79.1 96C79.1 87.16 72.84 80 63.1 80C55.16 80 47.1 87.16 47.1 96C47.1 104.8 55.16 112 63.1 112C72.84 112 79.1 104.8 79.1 96z")),"label"=>__("Staff Aesculapius","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"stairs"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M576 64c0 17.67-14.31 32-32 32h-96v96c0 17.67-14.31 32-32 32h-96v96c0 17.67-14.31 32-32 32H192v96c0 17.67-14.31 32-32 32H32c-17.69 0-32-14.33-32-32s14.31-32 32-32h96v-96c0-17.67 14.31-32 32-32h96V192c0-17.67 14.31-32 32-32h96V64c0-17.67 14.31-32 32-32h128C561.7 32 576 46.33 576 64z")),"label"=>__("Stairs","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","travel")),"stamp"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M366.2 256H400C461.9 256 512 306.1 512 368C512 388.9 498.6 406.7 480 413.3V464C480 490.5 458.5 512 432 512H80C53.49 512 32 490.5 32 464V413.3C13.36 406.7 0 388.9 0 368C0 306.1 50.14 256 112 256H145.8C175.7 256 200 231.7 200 201.8C200 184.3 190.8 168.5 180.1 154.8C167.5 138.5 160 118.1 160 96C160 42.98 202.1 0 256 0C309 0 352 42.98 352 96C352 118.1 344.5 138.5 331.9 154.8C321.2 168.5 312 184.3 312 201.8C312 231.7 336.3 256 366.2 256zM416 416H96V448H416V416z")),"label"=>__("Stamp","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","design")),"star"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z"),"regular"=>array("width"=>576,"height"=>512,"path"=>"M287.9 0C297.1 0 305.5 5.25 309.5 13.52L378.1 154.8L531.4 177.5C540.4 178.8 547.8 185.1 550.7 193.7C553.5 202.4 551.2 211.9 544.8 218.2L433.6 328.4L459.9 483.9C461.4 492.9 457.7 502.1 450.2 507.4C442.8 512.7 432.1 513.4 424.9 509.1L287.9 435.9L150.1 509.1C142.9 513.4 133.1 512.7 125.6 507.4C118.2 502.1 114.5 492.9 115.1 483.9L142.2 328.4L31.11 218.2C24.65 211.9 22.36 202.4 25.2 193.7C28.03 185.1 35.5 178.8 44.49 177.5L197.7 154.8L266.3 13.52C270.4 5.249 278.7 0 287.9 0L287.9 0zM287.9 78.95L235.4 187.2C231.9 194.3 225.1 199.3 217.3 200.5L98.98 217.9L184.9 303C190.4 308.5 192.9 316.4 191.6 324.1L171.4 443.7L276.6 387.5C283.7 383.7 292.2 383.7 299.2 387.5L404.4 443.7L384.2 324.1C382.9 316.4 385.5 308.5 391 303L476.9 217.9L358.6 200.5C350.7 199.3 343.9 194.3 340.5 187.2L287.9 78.95z")),"label"=>__("Star","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design","lifestyle-and-hobbies","social")),"star-and-crescent"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M340.5 466.4c-1.5 0-6.875 .5-9.25 .5c-116.3 0-210.8-94.63-210.8-210.9s94.5-210.9 210.8-210.9c2.375 0 7.75 .5 9.25 .5c7.125 0 13.25-5 14.75-12c1.375-7.25-2.625-14.5-9.5-17.12c-29.13-11-59.38-16.5-89.75-16.5c-141.1 0-256 114.9-256 256s114.9 256 256 256c30.25 0 60.25-5.5 89.38-16.38c5.875-2 10.25-7.625 10.25-14.25C355.6 473.4 349.3 466.4 340.5 466.4zM503.5 213.9l-76.38-11.12L392.9 133.5C391.1 129.9 387.5 128 384 128c-3.5 0-7.125 1.875-9 5.5l-34.13 69.25l-76.38 11.12c-8.125 1.125-11.38 11.25-5.5 17l55.25 53.88l-13 76c-1.125 6.5 3.1 11.75 9.75 11.75c1.5 0 3.125-.375 4.625-1.25l68.38-35.88l68.25 35.88c1.625 .875 3.125 1.25 4.75 1.25c5.75 0 10.88-5.25 9.75-11.75l-13-76l55.25-53.88C514.9 225.1 511.6 214.1 503.5 213.9z")),"label"=>__("Star And Crescent","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"star-half"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M288 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.995 275.8 .0131 287.1-.0391L288 439.8zM433.2 512C432.1 512.1 431 512.1 429.9 512H433.2z"),"regular"=>array("width"=>576,"height"=>512,"path"=>"M293.3 .6123C304.2 3.118 311.9 12.82 311.9 24V408.7C311.9 417.5 307.1 425.7 299.2 429.8L150.1 509.1C142.9 513.4 133.1 512.7 125.6 507.4C118.2 502.1 114.5 492.1 115.1 483.9L142.2 328.4L31.11 218.3C24.65 211.9 22.36 202.4 25.2 193.7C28.03 185.1 35.5 178.8 44.49 177.5L197.7 154.8L266.3 13.52C271.2 3.46 282.4-1.893 293.3 .6127L293.3 .6123zM263.9 128.4L235.4 187.2C231.9 194.3 225.1 199.3 217.3 200.5L98.98 217.9L184.9 303C190.4 308.5 192.9 316.4 191.6 324.1L171.4 443.7L263.9 394.3L263.9 128.4z")),"label"=>__("Star Half","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"star-half-stroke"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7zM288 376.4L288.1 376.3L399.7 435.9L378.4 309.6L469.2 219.8L343.8 201.4L288.1 86.85L288 87.14V376.4z"),"regular"=>array("width"=>576,"height"=>512,"path"=>"M378.1 154.8L531.4 177.5C540.4 178.8 547.8 185.1 550.7 193.7C553.5 202.4 551.2 211.9 544.8 218.2L433.6 328.4L459.9 483.9C461.4 492.9 457.7 502.1 450.2 507.4C442.8 512.7 432.1 513.4 424.9 509.1L287.9 435.9L150.1 509.1C142.9 513.4 133.1 512.7 125.6 507.4C118.2 502.1 114.5 492.9 115.1 483.9L142.2 328.4L31.11 218.2C24.65 211.9 22.36 202.4 25.2 193.7C28.03 185.1 35.5 178.8 44.49 177.5L197.7 154.8L266.3 13.52C270.4 5.249 278.7 0 287.9 0C297.1 0 305.5 5.25 309.5 13.52L378.1 154.8zM287.1 384.7C291.9 384.7 295.7 385.6 299.2 387.5L404.4 443.7L384.2 324.1C382.9 316.4 385.5 308.5 391 303L476.9 217.9L358.6 200.5C350.7 199.3 343.9 194.3 340.5 187.2L287.1 79.09L287.1 384.7z")),"label"=>__("Star Half Stroke","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"star-of-david"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M490.7 345.4L435.6 256l55.1-89.38c14.87-24.25-3.62-54.61-33.12-54.61l-110.6-.005l-57.87-93.1C281.7 6.003 268.9 0 256 0C243.1 0 230.3 6.003 222.9 18L165 112H54.39c-29.62 0-47.99 30.37-33.12 54.62L76.37 256l-55.1 89.38C6.4 369.6 24.77 399.1 54.39 399.1h110.6l57.87 93.1C230.3 505.1 243.1 512 256 512c12.88 0 25.74-6.002 33.12-18l57.83-93.1h110.7C487.2 399.1 505.6 369.6 490.7 345.4zM256 73.77l23.59 38.23H232.5L256 73.77zM89.48 343.1l20.59-33.35l20.45 33.35H89.48zM110 201.3L89.48 168h41.04L110 201.3zM256 438.2l-23.59-38.25h47.08L256 438.2zM313.9 343.1H198L143.8 256l54.22-87.1h116L368.3 256L313.9 343.1zM381.3 343.1l20.67-33.29l20.52 33.29H381.3zM401.1 201.3l-20.51-33.29h41.04L401.1 201.3z")),"label"=>__("Star Of David","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"star-of-life"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M489.1 363.3l-24.03 41.59c-6.635 11.48-21.33 15.41-32.82 8.78l-129.1-74.56V488c0 13.25-10.75 24-24.02 24H231.1c-13.27 0-24.02-10.75-24.02-24v-148.9L78.87 413.7c-11.49 6.629-26.19 2.698-32.82-8.78l-24.03-41.59c-6.635-11.48-2.718-26.14 8.774-32.77L159.9 256L30.8 181.5C19.3 174.8 15.39 160.2 22.02 148.7l24.03-41.59c6.635-11.48 21.33-15.41 32.82-8.781l129.1 74.56L207.1 24c0-13.25 10.75-24 24.02-24h48.04c13.27 0 24.02 10.75 24.02 24l.0005 148.9l129.1-74.56c11.49-6.629 26.19-2.698 32.82 8.78l24.02 41.59c6.637 11.48 2.718 26.14-8.774 32.77L352.1 256l129.1 74.53C492.7 337.2 496.6 351.8 489.1 363.3z")),"label"=>__("Star Of Life","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"staylinked"=>array("svg"=>array("brands"=>array("width"=>440,"height"=>512,"path"=>"M382.7 292.5l2.7 2.7-170-167.3c-3.5-3.5-9.7-3.7-13.8-.5L144.3 171c-4.2 3.2-4.6 8.7-1.1 12.2l68.1 64.3c3.6 3.5 9.9 3.7 14 .5l.1-.1c4.1-3.2 10.4-3 14 .5l84 81.3c3.6 3.5 3.2 9-.9 12.2l-93.2 74c-4.2 3.3-10.5 3.1-14.2-.4L63.2 268c-3.5-3.5-9.7-3.7-13.9-.5L3.5 302.4c-4.2 3.2-4.7 8.7-1.2 12.2L211 510.7s7.4 6.8 17.3-.8l198-163.9c4-3.2 4.4-8.7 .7-12.2zm54.5-83.4L226.7 2.5c-1.5-1.2-8-5.5-16.3 1.1L3.6 165.7c-4.2 3.2-4.8 8.7-1.2 12.2l42.3 41.7 171.7 165.1c3.7 3.5 10.1 3.7 14.3 .4l50.2-38.8-.3-.3 7.7-6c4.2-3.2 4.6-8.7 .9-12.2l-57.1-54.4c-3.6-3.5-10-3.7-14.2-.5l-.1 .1c-4.2 3.2-10.5 3.1-14.2-.4L109 180.8c-3.6-3.5-3.1-8.9 1.1-12.2l92.2-71.5c4.1-3.2 10.3-3 13.9 .5l160.4 159c3.7 3.5 10 3.7 14.1 .5l45.8-35.8c4.1-3.2 4.4-8.7 .7-12.2z")),"label"=>__("StayLinked","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"steam"=>array("svg"=>array("brands"=>array("width"=>496,"height"=>512,"path"=>"M496 256c0 137-111.2 248-248.4 248-113.8 0-209.6-76.3-239-180.4l95.2 39.3c6.4 32.1 34.9 56.4 68.9 56.4 39.2 0 71.9-32.4 70.2-73.5l84.5-60.2c52.1 1.3 95.8-40.9 95.8-93.5 0-51.6-42-93.5-93.7-93.5s-93.7 42-93.7 93.5v1.2L176.6 279c-15.5-.9-30.7 3.4-43.5 12.1L0 236.1C10.2 108.4 117.1 8 247.6 8 384.8 8 496 119 496 256zM155.7 384.3l-30.5-12.6a52.79 52.79 0 0 0 27.2 25.8c26.9 11.2 57.8-1.6 69-28.4 5.4-13 5.5-27.3 .1-40.3-5.4-13-15.5-23.2-28.5-28.6-12.9-5.4-26.7-5.2-38.9-.6l31.5 13c19.8 8.2 29.2 30.9 20.9 50.7-8.3 19.9-31 29.2-50.8 21zm173.8-129.9c-34.4 0-62.4-28-62.4-62.3s28-62.3 62.4-62.3 62.4 28 62.4 62.3-27.9 62.3-62.4 62.3zm.1-15.6c25.9 0 46.9-21 46.9-46.8 0-25.9-21-46.8-46.9-46.8s-46.9 21-46.9 46.8c.1 25.8 21.1 46.8 46.9 46.8z")),"label"=>__("Steam","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","brands","brands","social")),"steam-square"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M185.2 356.5c7.7-18.5-1-39.7-19.6-47.4l-29.5-12.2c11.4-4.3 24.3-4.5 36.4 .5 12.2 5.1 21.6 14.6 26.7 26.7 5 12.2 5 25.6-.1 37.7-10.5 25.1-39.4 37-64.6 26.5-11.6-4.8-20.4-13.6-25.4-24.2l28.5 11.8c18.6 7.8 39.9-.9 47.6-19.4zM400 32H48C21.5 32 0 53.5 0 80v160.7l116.6 48.1c12-8.2 26.2-12.1 40.7-11.3l55.4-80.2v-1.1c0-48.2 39.3-87.5 87.6-87.5s87.6 39.3 87.6 87.5c0 49.2-40.9 88.7-89.6 87.5l-79 56.3c1.6 38.5-29.1 68.8-65.7 68.8-31.8 0-58.5-22.7-64.5-52.7L0 319.2V432c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zm-99.7 222.5c-32.2 0-58.4-26.1-58.4-58.3s26.2-58.3 58.4-58.3 58.4 26.2 58.4 58.3-26.2 58.3-58.4 58.3zm.1-14.6c24.2 0 43.9-19.6 43.9-43.8 0-24.2-19.6-43.8-43.9-43.8-24.2 0-43.9 19.6-43.9 43.8 0 24.2 19.7 43.8 43.9 43.8z")),"label"=>__("Steam Square","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"steam-symbol"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M395.5 177.5c0 33.8-27.5 61-61 61-33.8 0-61-27.3-61-61s27.3-61 61-61c33.5 0 61 27.2 61 61zm52.5 .2c0 63-51 113.8-113.7 113.8L225 371.3c-4 43-40.5 76.8-84.5 76.8-40.5 0-74.7-28.8-83-67L0 358V250.7L97.2 290c15.1-9.2 32.2-13.3 52-11.5l71-101.7c.5-62.3 51.5-112.8 114-112.8C397 64 448 115 448 177.7zM203 363c0-34.7-27.8-62.5-62.5-62.5-4.5 0-9 .5-13.5 1.5l26 10.5c25.5 10.2 38 39 27.7 64.5-10.2 25.5-39.2 38-64.7 27.5-10.2-4-20.5-8.3-30.7-12.2 10.5 19.7 31.2 33.2 55.2 33.2 34.7 0 62.5-27.8 62.5-62.5zm207.5-185.3c0-42-34.3-76.2-76.2-76.2-42.3 0-76.5 34.2-76.5 76.2 0 42.2 34.3 76.2 76.5 76.2 41.9 .1 76.2-33.9 76.2-76.2z")),"label"=>__("Steam Symbol","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","brands","brands","social")),"sterling-sign"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M112 223.1H224C241.7 223.1 256 238.3 256 255.1C256 273.7 241.7 287.1 224 287.1H112V332.5C112 361.5 104.1 389.1 89.2 414.9L88.52 416H288C305.7 416 320 430.3 320 448C320 465.7 305.7 480 288 480H32C20.47 480 9.834 473.8 4.154 463.8C-1.527 453.7-1.371 441.4 4.56 431.5L34.32 381.9C43.27 367 48 349.9 48 332.5V288H32C14.33 288 0 273.7 0 256C0 238.3 14.33 224 32 224H48V160.4C48 89.47 105.5 32 176.4 32C190.2 32 203.9 34.22 216.1 38.59L298.1 65.64C314.9 71.23 323.9 89.35 318.4 106.1C312.8 122.9 294.6 131.9 277.9 126.4L196.7 99.3C190.2 97.12 183.3 96 176.4 96C140.8 96 112 124.8 112 160.4V223.1z")),"label"=>__("Sterling Sign","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"stethoscope"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M480 112c-44.18 0-80 35.82-80 80c0 32.84 19.81 60.98 48.11 73.31v78.7c0 57.25-50.25 104-112 104c-60 0-109.3-44.1-111.9-99.23C296.1 333.8 352 269.3 352 191.1V36.59c0-11.38-8.15-21.38-19.28-23.5L269.8 .4775c-13-2.625-25.54 5.766-28.16 18.77L238.4 34.99c-2.625 13 5.812 25.59 18.81 28.22l30.69 6.059L287.9 190.7c0 52.88-42.13 96.63-95.13 97.13c-53.38 .5-96.81-42.56-96.81-95.93L95.89 69.37l30.72-6.112c13-2.5 21.41-15.15 18.78-28.15L142.3 19.37c-2.5-13-15.15-21.41-28.15-18.78L51.28 12.99C40.15 15.24 32 25.09 32 36.59v155.4c0 77.25 55.11 142 128.1 156.8C162.7 439.3 240.6 512 336 512c97 0 176-75.37 176-168V265.3c28.23-12.36 48-40.46 48-73.25C560 147.8 524.2 112 480 112zM480 216c-13.25 0-24-10.75-24-24S466.7 168 480 168S504 178.7 504 192S493.3 216 480 216z")),"label"=>__("Stethoscope","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"sticker-mule"=>array("svg"=>array("brands"=>array("width"=>576,"height"=>512,"path"=>"M561.7 199.6c-1.3 .3 .3 0 0 0zm-6.2-77.4c-7.7-22.3-5.1-7.2-13.4-36.9-1.6-6.5-3.6-14.5-6.2-20-4.4-8.7-4.6-7.5-4.6-9.5 0-5.3 30.7-45.3 19-46.9-5.7-.6-12.2 11.6-20.6 17-8.6 4.2-8 5-10.3 5-2.6 0-5.7-3-6.2-5-2-5.7 1.9-25.9-3.6-25.9-3.6 0-12.3 24.8-17 25.8-5.2 1.3-27.9-11.4-75.1 18-25.3 13.2-86.9 65.2-87 65.3-6.7 4.7-20 4.7-35.5 16-44.4 30.1-109.6 9.4-110.7 9-110.6-26.8-128-15.2-159 11.5-20.8 17.9-23.7 36.5-24.2 38.9-4.2 20.4 5.2 48.3 6.7 64.3 1.8 19.3-2.7 17.7 7.7 98.3 .5 1 4.1 0 5.1 1.5 0 8.4-3.8 12.1-4.1 13-1.5 4.5-1.5 10.5 0 16 2.3 8.2 8.2 37.2 8.2 46.9 0 41.8 .4 44 2.6 49.4 3.9 10 12.5 9.1 17 12 3.1 3.5-.5 8.5 1 12.5 .5 2 3.6 4 6.2 5 9.2 3.6 27 .3 29.9-2.5 1.6-1.5 .5-4.5 3.1-5 5.1 0 10.8-.5 14.4-2.5 5.1-2.5 4.1-6 1.5-10.5-.4-.8-7-13.3-9.8-16-2.1-2-5.1-3-7.2-4.5-5.8-4.9-10.3-19.4-10.3-19.5-4.6-19.4-10.3-46.3-4.1-66.8 4.6-17.2 39.5-87.7 39.6-87.8 4.1-6.5 17-11.5 27.3-7 6 1.9 19.3 22 65.4 30.9 47.9 8.7 97.4-2 112.2-2 2.8 2-1.9 13-.5 38.9 0 26.4-.4 13.7-4.1 29.9-2.2 9.7 3.4 23.2-1.5 46.9-1.4 9.8-9.9 32.7-8.2 43.4 .5 1 1 2 1.5 3.5 .5 4.5 1.5 8.5 4.6 10 7.3 3.6 12-3.5 9.8 11.5-.7 3.1-2.6 12 1.5 15 4.4 3.7 30.6 3.4 36.5 .5 2.6-1.5 1.6-4.5 6.4-7.4 1.9-.9 11.3-.4 11.3-6.5 .3-1.8-9.2-19.9-9.3-20-2.6-3.5-9.2-4.5-11.3-8-6.9-10.1-1.7-52.6 .5-59.4 3-11 5.6-22.4 8.7-32.4 11-42.5 10.3-50.6 16.5-68.3 .8-1.8 6.4-23.1 10.3-29.9 9.3-17 21.7-32.4 33.5-47.4 18-22.9 34-46.9 52-69.8 6.1-7 8.2-13.7 18-8 10.8 5.7 21.6 7 31.9 17 14.6 12.8 10.2 18.2 11.8 22.9 1.5 5 7.7 10.5 14.9 9.5 10.4-2 13-2.5 13.4-2.5 2.6-.5 5.7-5 7.2-8 3.1-5.5 7.2-9 7.2-16.5 0-7.7-.4-2.8-20.6-52.9z")),"label"=>__("Sticker Mule","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"stop"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M384 128v255.1c0 35.35-28.65 64-64 64H64c-35.35 0-64-28.65-64-64V128c0-35.35 28.65-64 64-64H320C355.3 64 384 92.65 384 128z")),"label"=>__("Stop","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","science-and-technology")),"stopwatch"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M272 0C289.7 0 304 14.33 304 32C304 49.67 289.7 64 272 64H256V98.45C293.5 104.2 327.7 120 355.7 143L377.4 121.4C389.9 108.9 410.1 108.9 422.6 121.4C435.1 133.9 435.1 154.1 422.6 166.6L398.5 190.8C419.7 223.3 432 262.2 432 304C432 418.9 338.9 512 224 512C109.1 512 16 418.9 16 304C16 200 92.32 113.8 192 98.45V64H176C158.3 64 144 49.67 144 32C144 14.33 158.3 0 176 0L272 0zM248 192C248 178.7 237.3 168 224 168C210.7 168 200 178.7 200 192V320C200 333.3 210.7 344 224 344C237.3 344 248 333.3 248 320V192z")),"label"=>__("Stopwatch","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"stopwatch-20"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M276 256C276 249.4 281.4 244 288 244C294.6 244 300 249.4 300 256V352C300 358.6 294.6 364 288 364C281.4 364 276 358.6 276 352V256zM272 0C289.7 0 304 14.33 304 32C304 49.67 289.7 64 272 64H256V98.45C293.5 104.2 327.7 120 355.7 143L377.4 121.4C389.9 108.9 410.1 108.9 422.6 121.4C435.1 133.9 435.1 154.1 422.6 166.6L398.5 190.8C419.7 223.3 432 262.2 432 304C432 418.9 338.9 512 224 512C109.1 512 16 418.9 16 304C16 200 92.32 113.8 192 98.45V64H176C158.3 64 144 49.67 144 32C144 14.33 158.3 0 176 0L272 0zM288 204C259.3 204 236 227.3 236 256V352C236 380.7 259.3 404 288 404C316.7 404 340 380.7 340 352V256C340 227.3 316.7 204 288 204zM172 256.5V258.8C172 262.4 170.7 265.9 168.3 268.6L129.2 312.5C115.5 327.9 108 347.8 108 368.3V384C108 395 116.1 404 128 404H192C203 404 212 395 212 384C212 372.1 203 364 192 364H148.2C149.1 354.8 152.9 346.1 159.1 339.1L198.2 295.2C207.1 285.1 211.1 272.2 211.1 258.8V256.5C211.1 227.5 188.5 204 159.5 204C136.8 204 116.8 218.5 109.6 239.9L109 241.7C105.5 252.2 111.2 263.5 121.7 266.1C132.2 270.5 143.5 264.8 146.1 254.3L147.6 252.6C149.3 247.5 154.1 244 159.5 244C166.4 244 171.1 249.6 171.1 256.5L172 256.5z")),"label"=>__("Stopwatch 20","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"store"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M495.5 223.2C491.6 223.7 487.6 224 483.4 224C457.4 224 434.2 212.6 418.3 195C402.4 212.6 379.2 224 353.1 224C327 224 303.8 212.6 287.9 195C272 212.6 248.9 224 222.7 224C196.7 224 173.5 212.6 157.6 195C141.7 212.6 118.5 224 92.36 224C88.3 224 84.21 223.7 80.24 223.2C24.92 215.8-1.255 150.6 28.33 103.8L85.66 13.13C90.76 4.979 99.87 0 109.6 0H466.4C476.1 0 485.2 4.978 490.3 13.13L547.6 103.8C577.3 150.7 551 215.8 495.5 223.2H495.5zM499.7 254.9C503.1 254.4 508 253.6 512 252.6V448C512 483.3 483.3 512 448 512H128C92.66 512 64 483.3 64 448V252.6C67.87 253.6 71.86 254.4 75.97 254.9L76.09 254.9C81.35 255.6 86.83 256 92.36 256C104.8 256 116.8 254.1 128 250.6V384H448V250.7C459.2 254.1 471.1 256 483.4 256C489 256 494.4 255.6 499.7 254.9L499.7 254.9z")),"label"=>__("Store","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies")),"store-slash"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M94.92 49.09L117.7 13.13C122.8 4.98 131.9 .0007 141.6 .0007H498.4C508.1 .0007 517.2 4.979 522.3 13.13L579.6 103.8C609.3 150.7 583 215.8 527.5 223.2C523.6 223.7 519.6 224 515.4 224C489.4 224 466.2 212.6 450.3 195C434.4 212.6 411.2 224 385.1 224C359 224 335.8 212.6 319.9 195C314.4 201.1 308.1 206.4 301.2 210.7L480 350.9V250.7C491.2 254.1 503.1 256 515.4 256C521 256 526.4 255.6 531.7 254.9L531.7 254.9C535.1 254.4 540 253.6 544 252.6V401.1L630.8 469.1C641.2 477.3 643.1 492.4 634.9 502.8C626.7 513.2 611.6 515.1 601.2 506.9L9.196 42.89C-1.236 34.71-3.065 19.63 5.112 9.196C13.29-1.236 28.37-3.065 38.81 5.112L94.92 49.09zM112.2 223.2C68.36 217.3 42.82 175.1 48.9 134.5L155.3 218.4C145.7 222 135.3 224 124.4 224C120.3 224 116.2 223.7 112.2 223.2V223.2zM160 384H365.5L514.9 501.7C504.8 508.2 492.9 512 480 512H160C124.7 512 96 483.3 96 448V252.6C99.87 253.6 103.9 254.4 107.1 254.9L108.1 254.9C113.3 255.6 118.8 256 124.4 256C136.8 256 148.8 254.1 160 250.6V384z")),"label"=>__("Store Slash","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"strava"=>array("svg"=>array("brands"=>array("width"=>384,"height"=>512,"path"=>"M158.4 0L7 292h89.2l62.2-116.1L220.1 292h88.5zm150.2 292l-43.9 88.2-44.6-88.2h-67.6l112.2 220 111.5-220z")),"label"=>__("Strava","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"street-view"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M320 64C320 99.35 291.3 128 256 128C220.7 128 192 99.35 192 64C192 28.65 220.7 0 256 0C291.3 0 320 28.65 320 64zM288 160C323.3 160 352 188.7 352 224V272C352 289.7 337.7 304 320 304H318.2L307.2 403.5C305.4 419.7 291.7 432 275.4 432H236.6C220.3 432 206.6 419.7 204.8 403.5L193.8 304H192C174.3 304 160 289.7 160 272V224C160 188.7 188.7 160 224 160H288zM63.27 414.7C60.09 416.3 57.47 417.8 55.33 419.2C51.7 421.6 51.72 426.4 55.34 428.8C64.15 434.6 78.48 440.6 98.33 446.1C137.7 456.1 193.5 464 256 464C318.5 464 374.3 456.1 413.7 446.1C433.5 440.6 447.9 434.6 456.7 428.8C460.3 426.4 460.3 421.6 456.7 419.2C454.5 417.8 451.9 416.3 448.7 414.7C433.4 406.1 409.9 399.8 379.7 394.2C366.6 391.8 358 379.3 360.4 366.3C362.8 353.3 375.3 344.6 388.3 347C420.8 352.9 449.2 361.2 470.3 371.8C480.8 377.1 490.6 383.5 498 391.4C505.6 399.5 512 410.5 512 424C512 445.4 496.5 460.1 482.9 469C468.2 478.6 448.6 486.3 426.4 492.4C381.8 504.7 321.6 512 256 512C190.4 512 130.2 504.7 85.57 492.4C63.44 486.3 43.79 478.6 29.12 469C15.46 460.1 0 445.4 0 424C0 410.5 6.376 399.5 13.96 391.4C21.44 383.5 31.24 377.1 41.72 371.8C62.75 361.2 91.24 352.9 123.7 347C136.7 344.6 149.2 353.3 151.6 366.3C153.1 379.3 145.4 391.8 132.3 394.2C102.1 399.8 78.57 406.1 63.27 414.7H63.27z")),"label"=>__("Street View","ultimate-addons-for-gutenberg"),"custom_categories"=>array("travel")),"strikethrough"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M332.2 319.9c17.22 12.17 22.33 26.51 18.61 48.21c-3.031 17.59-10.88 29.34-24.72 36.99c-35.44 19.75-108.5 11.96-186-19.68c-16.34-6.686-35.03 1.156-41.72 17.53s1.188 35.05 17.53 41.71c31.75 12.93 95.69 35.37 157.6 35.37c29.62 0 58.81-5.156 83.72-18.96c30.81-17.09 50.44-45.46 56.72-82.11c3.998-23.27 2.168-42.58-3.488-59.05H332.2zM488 239.9l-176.5-.0309c-15.85-5.613-31.83-10.34-46.7-14.62c-85.47-24.62-110.9-39.05-103.7-81.33c2.5-14.53 10.16-25.96 22.72-34.03c20.47-13.15 64.06-23.84 155.4 .3438c17.09 4.531 34.59-5.654 39.13-22.74c4.531-17.09-5.656-34.59-22.75-39.12c-91.31-24.18-160.7-21.62-206.3 7.654C121.8 73.72 103.6 101.1 98.09 133.1C89.26 184.5 107.9 217.3 137.2 239.9L24 239.9c-13.25 0-24 10.75-24 23.1c0 13.25 10.75 23.1 24 23.1h464c13.25 0 24-10.75 24-23.1C512 250.7 501.3 239.9 488 239.9z")),"label"=>__("Strikethrough","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"stripe"=>array("svg"=>array("brands"=>array("width"=>640,"height"=>512,"path"=>"M165 144.7l-43.3 9.2-.2 142.4c0 26.3 19.8 43.3 46.1 43.3 14.6 0 25.3-2.7 31.2-5.9v-33.8c-5.7 2.3-33.7 10.5-33.7-15.7V221h33.7v-37.8h-33.7zm89.1 51.6l-2.7-13.1H213v153.2h44.3V233.3c10.5-13.8 28.2-11.1 33.9-9.3v-40.8c-6-2.1-26.7-6-37.1 13.1zm92.3-72.3l-44.6 9.5v36.2l44.6-9.5zM44.9 228.3c0-6.9 5.8-9.6 15.1-9.7 13.5 0 30.7 4.1 44.2 11.4v-41.8c-14.7-5.8-29.4-8.1-44.1-8.1-36 0-60 18.8-60 50.2 0 49.2 67.5 41.2 67.5 62.4 0 8.2-7.1 10.9-17 10.9-14.7 0-33.7-6.1-48.6-14.2v40c16.5 7.1 33.2 10.1 48.5 10.1 36.9 0 62.3-15.8 62.3-47.8 0-52.9-67.9-43.4-67.9-63.4zM640 261.6c0-45.5-22-81.4-64.2-81.4s-67.9 35.9-67.9 81.1c0 53.5 30.3 78.2 73.5 78.2 21.2 0 37.1-4.8 49.2-11.5v-33.4c-12.1 6.1-26 9.8-43.6 9.8-17.3 0-32.5-6.1-34.5-26.9h86.9c.2-2.3 .6-11.6 .6-15.9zm-87.9-16.8c0-20 12.3-28.4 23.4-28.4 10.9 0 22.5 8.4 22.5 28.4zm-112.9-64.6c-17.4 0-28.6 8.2-34.8 13.9l-2.3-11H363v204.8l44.4-9.4 .1-50.2c6.4 4.7 15.9 11.2 31.4 11.2 31.8 0 60.8-23.2 60.8-79.6 .1-51.6-29.3-79.7-60.5-79.7zm-10.6 122.5c-10.4 0-16.6-3.8-20.9-8.4l-.3-66c4.6-5.1 11-8.8 21.2-8.8 16.2 0 27.4 18.2 27.4 41.4 .1 23.9-10.9 41.8-27.4 41.8zm-126.7 33.7h44.6V183.2h-44.6z")),"label"=>__("Stripe","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","brands","brands","brands","brands","social","social","social")),"stripe-s"=>array("svg"=>array("brands"=>array("width"=>384,"height"=>512,"path"=>"M155.3 154.6c0-22.3 18.6-30.9 48.4-30.9 43.4 0 98.5 13.3 141.9 36.7V26.1C298.3 7.2 251.1 0 203.8 0 88.1 0 11 60.4 11 161.4c0 157.9 216.8 132.3 216.8 200.4 0 26.4-22.9 34.9-54.7 34.9-47.2 0-108.2-19.5-156.1-45.5v128.5a396.1 396.1 0 0 0 156 32.4c118.6 0 200.3-51 200.3-153.6 0-170.2-218-139.7-218-203.9z")),"label"=>__("Stripe S","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","brands","brands","brands","brands","social","social","social")),"stroopwafel"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M188.1 210.8l-45.25 45.25l45.25 45.25l45.25-45.25L188.1 210.8zM301.2 188.1l-45.25-45.25L210.7 188.1l45.25 45.25L301.2 188.1zM210.7 323.9l45.25 45.25l45.25-45.25L255.1 278.6L210.7 323.9zM256 16c-132.5 0-240 107.5-240 240s107.5 240 240 240s240-107.5 240-240S388.5 16 256 16zM442.6 295.6l-11.25 11.25c-3.125 3.125-8.25 3.125-11.38 0L391.8 278.6l-45.25 45.25l34 33.88l16.88-16.88c3.125-3.125 8.251-3.125 11.38 0l11.25 11.25c3.125 3.125 3.125 8.25 0 11.38l-16.88 16.88l16.88 17c3.125 3.125 3.125 8.25 0 11.38l-11.25 11.25c-3.125 3.125-8.251 3.125-11.38 0l-16.88-17l-17 17c-3.125 3.125-8.25 3.125-11.38 0l-11.25-11.25c-3.125-3.125-3.125-8.25 0-11.38l17-17l-34-33.88l-45.25 45.25l28.25 28.25c3.125 3.125 3.125 8.25 0 11.38l-11.25 11.25c-3.125 3.125-8.25 3.125-11.38 0l-28.25-28.25L227.7 442.6c-3.125 3.125-8.25 3.125-11.38 0l-11.25-11.25c-3.125-3.125-3.125-8.25 0-11.38l28.25-28.25l-45.25-45.25l-33.88 34l16.88 16.88c3.125 3.125 3.125 8.25 0 11.38l-11.25 11.25c-3.125 3.125-8.25 3.125-11.38 0L131.6 403.1l-16.1 16.88c-3.125 3.125-8.25 3.125-11.38 0l-11.25-11.25c-3.125-3.125-3.125-8.25 0-11.38l17-16.88l-17-17c-3.125-3.125-3.125-8.25 0-11.38l11.25-11.25c3.125-3.125 8.25-3.125 11.38 0l16.1 17l33.88-34L120.2 278.6l-28.25 28.25c-3.125 3.125-8.25 3.125-11.38 0L69.37 295.6c-3.125-3.125-3.125-8.25 0-11.38l28.25-28.25l-28.25-28.25c-3.125-3.125-3.125-8.25 0-11.38l11.25-11.25c3.125-3.125 8.25-3.125 11.38 0l28.25 28.25l45.25-45.25l-34-34l-16.88 17c-3.125 3.125-8.25 3.125-11.38 0l-11.25-11.25c-3.125-3.125-3.125-8.25 0-11.38l16.88-17l-16.88-16.88c-3.125-3.125-3.125-8.25 0-11.38l11.25-11.25c3.125-3.125 8.25-3.125 11.38 0l16.88 17l17-17c3.125-3.125 8.25-3.125 11.38 0l11.25 11.25c3.125 3.125 3.125 8.25 0 11.38l-17 16.88l34 34l45.25-45.25L205.1 92c-3.125-3.125-3.125-8.25 0-11.38l11.25-11.25c3.125-3.125 8.25-3.125 11.38 0l28.25 28.25l28.25-28.25c3.125-3.125 8.25-3.125 11.38 0l11.25 11.25c3.125 3.125 3.125 8.25 0 11.38l-28.25 28.25l45.25 45.25l34-34l-17-16.88c-3.125-3.125-3.125-8.25 0-11.38l11.25-11.25c3.125-3.125 8.25-3.125 11.38 0l17 16.88l16.88-16.88c3.125-3.125 8.251-3.125 11.38 0l11.25 11.25c3.125 3.125 3.125 8.25 0 11.38l-17 16.88l17 17c3.125 3.125 3.125 8.25 0 11.38l-11.25 11.25c-3.125 3.125-8.251 3.125-11.38 0l-16.88-17l-34 34l45.25 45.25l28.25-28.25c3.125-3.125 8.25-3.125 11.38 0l11.25 11.25c3.125 3.125 3.125 8.25 0 11.38l-28.25 28.25l28.25 28.25C445.7 287.4 445.7 292.5 442.6 295.6zM278.6 256l45.25 45.25l45.25-45.25l-45.25-45.25L278.6 256z")),"label"=>__("Stroopwafel","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"studiovinari"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M480.3 187.7l4.2 28v28l-25.1 44.1-39.8 78.4-56.1 67.5-79.1 37.8-17.7 24.5-7.7 12-9.6 4s17.3-63.6 19.4-63.6c2.1 0 20.3 .7 20.3 .7l66.7-38.6-92.5 26.1-55.9 36.8-22.8 28-6.6 1.4 20.8-73.6 6.9-5.5 20.7 12.9 88.3-45.2 56.8-51.5 14.8-68.4-125.4 23.3 15.2-18.2-173.4-53.3 81.9-10.5-166-122.9L133.5 108 32.2 0l252.9 126.6-31.5-38L378 163 234.7 64l18.7 38.4-49.6-18.1L158.3 0l194.6 122L310 66.2l108 96.4 12-8.9-21-16.4 4.2-37.8L451 89.1l29.2 24.7 11.5 4.2-7 6.2 8.5 12-13.1 7.4-10.3 20.2 10.5 23.9z")),"label"=>__("Studio Vinari","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"stumbleupon"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M502.9 266v69.7c0 62.1-50.3 112.4-112.4 112.4-61.8 0-112.4-49.8-112.4-111.3v-70.2l34.3 16 51.1-15.2V338c0 14.7 12 26.5 26.7 26.5S417 352.7 417 338v-72h85.9zm-224.7-58.2l34.3 16 51.1-15.2V173c0-60.5-51.1-109-112.1-109-60.8 0-112.1 48.2-112.1 108.2v162.4c0 14.9-12 26.7-26.7 26.7S86 349.5 86 334.6V266H0v69.7C0 397.7 50.3 448 112.4 448c61.6 0 112.4-49.5 112.4-110.8V176.9c0-14.7 12-26.7 26.7-26.7s26.7 12 26.7 26.7v30.9z")),"label"=>__("StumbleUpon Logo","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"stumbleupon-circle"=>array("svg"=>array("brands"=>array("width"=>496,"height"=>512,"path"=>"M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm0 177.5c-9.8 0-17.8 8-17.8 17.8v106.9c0 40.9-33.9 73.9-74.9 73.9-41.4 0-74.9-33.5-74.9-74.9v-46.5h57.3v45.8c0 10 8 17.8 17.8 17.8s17.8-7.9 17.8-17.8V200.1c0-40 34.2-72.1 74.7-72.1 40.7 0 74.7 32.3 74.7 72.6v23.7l-34.1 10.1-22.9-10.7v-20.6c.1-9.6-7.9-17.6-17.7-17.6zm167.6 123.6c0 41.4-33.5 74.9-74.9 74.9-41.2 0-74.9-33.2-74.9-74.2V263l22.9 10.7 34.1-10.1v47.1c0 9.8 8 17.6 17.8 17.6s17.8-7.9 17.8-17.6v-48h57.3c-.1 45.9-.1 46.4-.1 46.4z")),"label"=>__("StumbleUpon Circle","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"subscript"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M480 448v-128c0-11.09-5.75-21.38-15.17-27.22c-9.422-5.875-21.25-6.344-31.14-1.406l-32 16c-15.81 7.906-22.22 27.12-14.31 42.94c5.609 11.22 16.89 17.69 28.62 17.69v80c-17.67 0-32 14.31-32 32s14.33 32 32 32h64c17.67 0 32-14.31 32-32S497.7 448 480 448zM320 128c17.67 0 32-14.31 32-32s-14.33-32-32-32l-32-.0024c-10.44 0-20.23 5.101-26.22 13.66L176 200.2L90.22 77.67C84.23 69.11 74.44 64.01 64 64.01L32 64.01c-17.67 0-32 14.32-32 32s14.33 32 32 32h15.34L136.9 256l-89.6 128H32c-17.67 0-32 14.31-32 32s14.33 31.1 32 31.1l32-.0024c10.44 0 20.23-5.086 26.22-13.65L176 311.8l85.78 122.5C267.8 442.9 277.6 448 288 448l32 .0024c17.67 0 32-14.31 32-31.1s-14.33-32-32-32h-15.34l-89.6-128l89.6-127.1H320z")),"label"=>__("Subscript","ultimate-addons-for-gutenberg"),"custom_categories"=>array("education")),"suitcase"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M0 144v288C0 457.6 22.41 480 48 480H96V96H48C22.41 96 0 118.4 0 144zM336 0h-160C150.4 0 128 22.41 128 48V480h256V48C384 22.41 361.6 0 336 0zM336 96h-160V48h160V96zM464 96H416v384h48c25.59 0 48-22.41 48-48v-288C512 118.4 489.6 96 464 96z")),"label"=>__("Suitcase","ultimate-addons-for-gutenberg"),"custom_categories"=>array("travel")),"suitcase-medical"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M0 144v288C0 457.6 22.41 480 48 480H64V96H48C22.41 96 0 118.4 0 144zM464 96H448v384h16c25.59 0 48-22.41 48-48v-288C512 118.4 489.6 96 464 96zM384 48C384 22.41 361.6 0 336 0h-160C150.4 0 128 22.41 128 48V96H96v384h320V96h-32V48zM176 48h160V96h-160V48zM352 312C352 316.4 348.4 320 344 320H288v56c0 4.375-3.625 8-8 8h-48C227.6 384 224 380.4 224 376V320H168C163.6 320 160 316.4 160 312v-48C160 259.6 163.6 256 168 256H224V200C224 195.6 227.6 192 232 192h48C284.4 192 288 195.6 288 200V256h56C348.4 256 352 259.6 352 264V312z")),"label"=>__("Suitcase Medical","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology","travel")),"suitcase-rolling"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M368 128h-47.95l.0123-80c0-26.5-21.5-48-48-48h-96c-26.5 0-48 21.5-48 48L128 128H80C53.5 128 32 149.5 32 176v256C32 458.5 53.5 480 80 480h16.05L96 496C96 504.9 103.1 512 112 512h32C152.9 512 160 504.9 160 496L160.1 480h128L288 496c0 8.875 7.125 16 16 16h32c8.875 0 16-7.125 16-16l.0492-16H368c26.5 0 48-21.5 48-48v-256C416 149.5 394.5 128 368 128zM176.1 48h96V128h-96V48zM336 384h-224C103.2 384 96 376.8 96 368C96 359.2 103.2 352 112 352h224c8.801 0 16 7.199 16 16C352 376.8 344.8 384 336 384zM336 256h-224C103.2 256 96 248.8 96 240C96 231.2 103.2 224 112 224h224C344.8 224 352 231.2 352 240C352 248.8 344.8 256 336 256z")),"label"=>__("Suitcase Rolling","ultimate-addons-for-gutenberg"),"custom_categories"=>array("travel")),"sun"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M256 159.1c-53.02 0-95.1 42.98-95.1 95.1S202.1 351.1 256 351.1s95.1-42.98 95.1-95.1S309 159.1 256 159.1zM509.3 347L446.1 255.1l63.15-91.01c6.332-9.125 1.104-21.74-9.826-23.72l-109-19.7l-19.7-109c-1.975-10.93-14.59-16.16-23.72-9.824L256 65.89L164.1 2.736c-9.125-6.332-21.74-1.107-23.72 9.824L121.6 121.6L12.56 141.3C1.633 143.2-3.596 155.9 2.736 164.1L65.89 256l-63.15 91.01c-6.332 9.125-1.105 21.74 9.824 23.72l109 19.7l19.7 109c1.975 10.93 14.59 16.16 23.72 9.824L256 446.1l91.01 63.15c9.127 6.334 21.75 1.107 23.72-9.822l19.7-109l109-19.7C510.4 368.8 515.6 356.1 509.3 347zM256 383.1c-70.69 0-127.1-57.31-127.1-127.1c0-70.69 57.31-127.1 127.1-127.1s127.1 57.3 127.1 127.1C383.1 326.7 326.7 383.1 256 383.1z"),"regular"=>array("width"=>512,"height"=>512,"path"=>"M505.2 324.8l-47.73-68.78l47.75-68.81c7.359-10.62 8.797-24.12 3.844-36.06c-4.969-11.94-15.52-20.44-28.22-22.72l-82.39-14.88l-14.89-82.41c-2.281-12.72-10.76-23.25-22.69-28.22c-11.97-4.936-25.42-3.498-36.12 3.844L256 54.49L187.2 6.709C176.5-.6016 163.1-2.039 151.1 2.896c-11.92 4.971-20.4 15.5-22.7 28.19l-14.89 82.44L31.15 128.4C18.42 130.7 7.854 139.2 2.9 151.2C-2.051 163.1-.5996 176.6 6.775 187.2l47.73 68.78l-47.75 68.81c-7.359 10.62-8.795 24.12-3.844 36.06c4.969 11.94 15.52 20.44 28.22 22.72l82.39 14.88l14.89 82.41c2.297 12.72 10.78 23.25 22.7 28.22c11.95 4.906 25.44 3.531 36.09-3.844L256 457.5l68.83 47.78C331.3 509.7 338.8 512 346.3 512c4.906 0 9.859-.9687 14.56-2.906c11.92-4.969 20.4-15.5 22.7-28.19l14.89-82.44l82.37-14.88c12.73-2.281 23.3-10.78 28.25-22.75C514.1 348.9 512.6 335.4 505.2 324.8zM456.8 339.2l-99.61 18l-18 99.63L256 399.1L172.8 456.8l-18-99.63l-99.61-18L112.9 255.1L55.23 172.8l99.61-18l18-99.63L256 112.9l83.15-57.75l18.02 99.66l99.61 18L399.1 255.1L456.8 339.2zM256 143.1c-61.85 0-111.1 50.14-111.1 111.1c0 61.85 50.15 111.1 111.1 111.1s111.1-50.14 111.1-111.1C367.1 194.1 317.8 143.1 256 143.1zM256 319.1c-35.28 0-63.99-28.71-63.99-63.99S220.7 192 256 192s63.99 28.71 63.99 63.1S291.3 319.1 256 319.1z")),"label"=>__("Sun","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment","science-and-technology")),"sun-plant-wilt"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M192 160C192 177.7 177.7 192 160 192C142.3 192 128 177.7 128 160C128 142.3 142.3 128 160 128C177.7 128 192 142.3 192 160zM160 0C166.3 0 172 3.708 174.6 9.467L199.4 64.89L256.1 43.23C262 40.98 268.7 42.4 273.1 46.86C277.6 51.32 279 57.99 276.8 63.88L255.1 120.6L310.5 145.4C316.3 147.1 320 153.7 320 160C320 166.3 316.3 172 310.5 174.6L255.1 199.4L276.8 256.1C279 262 277.6 268.7 273.1 273.1C268.7 277.6 262 279 256.1 276.8L199.4 255.1L174.6 310.5C172 316.3 166.3 320 160 320C153.7 320 147.1 316.3 145.4 310.5L120.6 255.1L63.88 276.8C57.99 279 51.32 277.6 46.86 273.1C42.4 268.7 40.98 262 43.23 256.1L64.89 199.4L9.467 174.6C3.708 172 0 166.3 0 160C0 153.7 3.708 147.1 9.467 145.4L64.89 120.6L43.23 63.88C40.98 57.99 42.4 51.32 46.86 46.86C51.32 42.4 57.99 40.98 63.88 43.23L120.6 64.89L145.4 9.467C147.1 3.708 153.7 0 160 0V0zM160 224C195.3 224 224 195.3 224 160C224 124.7 195.3 96 160 96C124.7 96 96 124.7 96 160C96 195.3 124.7 224 160 224zM504 448H608C625.7 448 640 462.3 640 480C640 497.7 625.7 512 608 512H32C14.33 512 .0003 497.7 .0003 480C.0003 462.3 14.33 448 32 448H456V272C456 254.3 441.7 240 424 240C406.3 240 392 254.3 392 272V293.4C406.8 301.1 416 316.5 416 338C416 357.3 394.5 390.1 368 416C341.5 390.1 320 357.6 320 338C320 316.5 329.2 301.1 344 293.4V271.1C344 227.8 379.8 191.1 424 191.1C435.4 191.1 446.2 194.4 456 198.7V175.1C456 131.8 491.8 95.1 536 95.1C580.2 95.1 616 131.8 616 175.1V229.4C630.8 237.1 640 252.5 640 274C640 293.3 618.5 326.1 592 352C565.5 326.1 544 293.6 544 274C544 252.5 553.2 237.1 568 229.4V175.1C568 158.3 553.7 143.1 536 143.1C518.3 143.1 504 158.3 504 175.1V448z")),"label"=>__("Sun Plant Wilt","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment")),"superpowers"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M448 32c-83.3 11-166.8 22-250 33-92 12.5-163.3 86.7-169 180-3.3 55.5 18 109.5 57.8 148.2L0 480c83.3-11 166.5-22 249.8-33 91.8-12.5 163.3-86.8 168.7-179.8 3.5-55.5-18-109.5-57.7-148.2L448 32zm-79.7 232.3c-4.2 79.5-74 139.2-152.8 134.5-79.5-4.7-140.7-71-136.3-151 4.5-79.2 74.3-139.3 153-134.5 79.3 4.7 140.5 71 136.1 151z")),"label"=>__("Superpowers","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"superscript"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M480 160v-128c0-11.09-5.75-21.37-15.17-27.22C455.4-1.048 443.6-1.548 433.7 3.39l-32 16c-15.81 7.906-22.22 27.12-14.31 42.94C392.1 73.55 404.3 80.01 416 80.01v80c-17.67 0-32 14.31-32 32s14.33 32 32 32h64c17.67 0 32-14.31 32-32S497.7 160 480 160zM320 128c17.67 0 32-14.31 32-32s-14.33-32-32-32l-32-.0024c-10.44 0-20.23 5.101-26.22 13.66L176 200.2L90.22 77.67C84.23 69.11 74.44 64.01 64 64.01L32 64.01c-17.67 0-32 14.32-32 32s14.33 32 32 32h15.34L136.9 256l-89.6 128H32c-17.67 0-32 14.31-32 32s14.33 31.1 32 31.1l32-.0024c10.44 0 20.23-5.086 26.22-13.65L176 311.8l85.78 122.5C267.8 442.9 277.6 448 288 448l32 .0024c17.67 0 32-14.31 32-31.1s-14.33-32-32-32h-15.34l-89.6-128l89.6-127.1H320z")),"label"=>__("Superscript","ultimate-addons-for-gutenberg"),"custom_categories"=>array("education")),"supple"=>array("svg"=>array("brands"=>array("width"=>640,"height"=>512,"path"=>"M640 262.5c0 64.1-109 116.1-243.5 116.1-24.8 0-48.6-1.8-71.1-5 7.7 .4 15.5 .6 23.4 .6 134.5 0 243.5-56.9 243.5-127.1 0-29.4-19.1-56.4-51.2-78 60 21.1 98.9 55.1 98.9 93.4zM47.7 227.9c-.1-70.2 108.8-127.3 243.3-127.6 7.9 0 15.6 .2 23.3 .5-22.5-3.2-46.3-4.9-71-4.9C108.8 96.3-.1 148.5 0 212.6c.1 38.3 39.1 72.3 99.3 93.3-32.3-21.5-51.5-48.6-51.6-78zm60.2 39.9s10.5 13.2 29.3 13.2c17.9 0 28.4-11.5 28.4-25.1 0-28-40.2-25.1-40.2-39.7 0-5.4 5.3-9.1 12.5-9.1 5.7 0 11.3 2.6 11.3 6.6v3.9h14.2v-7.9c0-12.1-15.4-16.8-25.4-16.8-16.5 0-28.5 10.2-28.5 24.1 0 26.6 40.2 25.4 40.2 39.9 0 6.6-5.8 10.1-12.3 10.1-11.9 0-20.7-10.1-20.7-10.1l-8.8 10.9zm120.8-73.6v54.4c0 11.3-7.1 17.8-17.8 17.8-10.7 0-17.8-6.5-17.8-17.7v-54.5h-15.8v55c0 18.9 13.4 31.9 33.7 31.9 20.1 0 33.4-13 33.4-31.9v-55h-15.7zm34.4 85.4h15.8v-29.5h15.5c16 0 27.2-11.5 27.2-28.1s-11.2-27.8-27.2-27.8h-39.1v13.4h7.8v72zm15.8-43v-29.1h12.9c8.7 0 13.7 5.7 13.7 14.4 0 8.9-5.1 14.7-14 14.7h-12.6zm57 43h15.8v-29.5h15.5c16 0 27.2-11.5 27.2-28.1s-11.2-27.8-27.2-27.8h-39.1v13.4h7.8v72zm15.7-43v-29.1h12.9c8.7 0 13.7 5.7 13.7 14.4 0 8.9-5 14.7-14 14.7h-12.6zm57.1 34.8c0 5.8 2.4 8.2 8.2 8.2h37.6c5.8 0 8.2-2.4 8.2-8.2v-13h-14.3v5.2c0 1.7-1 2.6-2.6 2.6h-18.6c-1.7 0-2.6-1-2.6-2.6v-61.2c0-5.7-2.4-8.2-8.2-8.2H401v13.4h5.2c1.7 0 2.6 1 2.6 2.6v61.2zm63.4 0c0 5.8 2.4 8.2 8.2 8.2H519c5.7 0 8.2-2.4 8.2-8.2v-13h-14.3v5.2c0 1.7-1 2.6-2.6 2.6h-19.7c-1.7 0-2.6-1-2.6-2.6v-20.3h27.7v-13.4H488v-22.4h19.2c1.7 0 2.6 1 2.6 2.6v5.2H524v-13c0-5.7-2.5-8.2-8.2-8.2h-51.6v13.4h7.8v63.9zm58.9-76v5.9h1.6v-5.9h2.7v-1.2h-7v1.2h2.7zm5.7-1.2v7.1h1.5v-5.7l2.3 5.7h1.3l2.3-5.7v5.7h1.5v-7.1h-2.3l-2.1 5.1-2.1-5.1h-2.4z")),"label"=>__("Supple","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"suse"=>array("svg"=>array("brands"=>array("width"=>640,"height"=>512,"path"=>"M471.1 102.7s-.3 18.3-.3 20.3c-9.1-3-74.4-24.1-135.7-26.3-51.9-1.8-122.8-4.3-223 57.3-19.4 12.4-73.9 46.1-99.6 109.7C7 277-.12 307 7 335.1a111 111 0 0 0 16.5 35.7c17.4 25 46.6 41.6 78.1 44.4 44.4 3.9 78.1-16 90-53.3 8.2-25.8 0-63.6-31.5-82.9-25.6-15.7-53.3-12.1-69.2-1.6-13.9 9.2-21.8 23.5-21.6 39.2 .3 27.8 24.3 42.6 41.5 42.6a49 49 0 0 0 15.8-2.7c6.5-1.8 13.3-6.5 13.3-14.9 0-12.1-11.6-14.8-16.8-13.9-2.9 .5-4.5 2-11.8 2.4-2-.2-12-3.1-12-14V316c.2-12.3 13.2-18 25.5-16.9 32.3 2.8 47.7 40.7 28.5 65.7-18.3 23.7-76.6 23.2-99.7-20.4-26-49.2 12.7-111.2 87-98.4 33.2 5.7 83.6 35.5 102.4 104.3h45.9c-5.7-17.6-8.9-68.3 42.7-68.3 56.7 0 63.9 39.9 79.8 68.3H460c-12.8-18.3-21.7-38.7-18.9-55.8 5.6-33.8 39.7-18.4 82.4-17.4 66.5 .4 102.1-27 103.1-28 3.7-3.1 6.5-15.8 7-17.7 1.3-5.1-3.2-2.4-3.2-2.4-8.7 5.2-30.5 15.2-50.9 15.6-25.3 .5-76.2-25.4-81.6-28.2-.3-.4 .1 1.2-11-25.5 88.4 58.3 118.3 40.5 145.2 21.7 .8-.6 4.3-2.9 3.6-5.7-13.8-48.1-22.4-62.7-34.5-69.6-37-21.6-125-34.7-129.2-35.3 .1-.1-.9-.3-.9 .7zm60.4 72.8a37.54 37.54 0 0 1 38.9-36.3c33.4 1.2 48.8 42.3 24.4 65.2-24.2 22.7-64.4 4.6-63.3-28.9zm38.6-25.3a26.27 26.27 0 1 0 25.4 27.2 26.19 26.19 0 0 0 -25.4-27.2zm4.3 28.8c-15.4 0-15.4-15.6 0-15.6s15.4 15.64 0 15.64z")),"label"=>__("Suse","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"swatchbook"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M0 32C0 14.33 14.33 0 32 0H160C177.7 0 192 14.33 192 32V416C192 469 149 512 96 512C42.98 512 0 469 0 416V32zM128 64H64V128H128V64zM64 256H128V192H64V256zM96 440C109.3 440 120 429.3 120 416C120 402.7 109.3 392 96 392C82.75 392 72 402.7 72 416C72 429.3 82.75 440 96 440zM224 416V154L299.4 78.63C311.9 66.13 332.2 66.13 344.7 78.63L435.2 169.1C447.7 181.6 447.7 201.9 435.2 214.4L223.6 425.9C223.9 422.7 224 419.3 224 416V416zM374.8 320H480C497.7 320 512 334.3 512 352V480C512 497.7 497.7 512 480 512H182.8L374.8 320z")),"label"=>__("Swatchbook","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design")),"swift"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M448 156.1c0-4.51-.08-9-.2-13.52a196.3 196.3 0 0 0 -2.58-29.42 99.62 99.62 0 0 0 -9.22-28A94.08 94.08 0 0 0 394.8 44a99.17 99.17 0 0 0 -28-9.22 195 195 0 0 0 -29.43-2.59c-4.51-.12-9-.17-13.52-.2H124.1c-4.51 0-9 .08-13.52 .2-2.45 .07-4.91 .15-7.37 .27a171.7 171.7 0 0 0 -22.06 2.32 103.1 103.1 0 0 0 -21.21 6.1q-3.46 1.45-6.81 3.12a94.66 94.66 0 0 0 -18.39 12.32c-1.88 1.61-3.69 3.28-5.43 5A93.86 93.86 0 0 0 12 85.17a99.45 99.45 0 0 0 -9.22 28 196.3 196.3 0 0 0 -2.54 29.4c-.13 4.51-.18 9-.21 13.52v199.8c0 4.51 .08 9 .21 13.51a196.1 196.1 0 0 0 2.58 29.42 99.3 99.3 0 0 0 9.22 28A94.31 94.31 0 0 0 53.17 468a99.47 99.47 0 0 0 28 9.21 195 195 0 0 0 29.43 2.59c4.5 .12 9 .17 13.52 .2H323.9c4.51 0 9-.08 13.52-.2a196.6 196.6 0 0 0 29.44-2.59 99.57 99.57 0 0 0 28-9.21A94.22 94.22 0 0 0 436 426.8a99.3 99.3 0 0 0 9.22-28 194.8 194.8 0 0 0 2.59-29.42c.12-4.5 .17-9 .2-13.51V172.1c-.01-5.35-.01-10.7-.01-16.05zm-69.88 241c-20-38.93-57.23-29.27-76.31-19.47-1.72 1-3.48 2-5.25 3l-.42 .25c-39.5 21-92.53 22.54-145.9-.38A234.6 234.6 0 0 1 45 290.1a230.6 230.6 0 0 0 39.17 23.37c56.36 26.4 113 24.49 153 0-57-43.85-104.6-101-141.1-147.2a197.1 197.1 0 0 1 -18.78-25.9c43.7 40 112.7 90.22 137.5 104.1-52.57-55.49-98.89-123.9-96.72-121.7 82.79 83.42 159.2 130.6 159.2 130.6 2.88 1.58 5 2.85 6.73 4a127.4 127.4 0 0 0 4.16-12.47c13.22-48.33-1.66-103.6-35.31-149.2C329.6 141.8 375 229.3 356.4 303.4c-.44 1.73-.95 3.4-1.44 5.09 38.52 47.4 28.04 98.17 23.13 88.59z")),"label"=>__("Swift","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"symfony"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm133.7 143.5c-11.47 .41-19.4-6.45-19.77-16.87-.27-9.18 6.68-13.44 6.53-18.85-.23-6.55-10.16-6.82-12.87-6.67-39.78 1.29-48.59 57-58.89 113.8 21.43 3.15 36.65-.72 45.14-6.22 12-7.75-3.34-15.72-1.42-24.56 4-18.16 32.55-19 32 5.3-.36 17.86-25.92 41.81-77.6 35.7-10.76 59.52-18.35 115-58.2 161.7-29 34.46-58.4 39.82-71.58 40.26-24.65 .85-41-12.31-41.58-29.84-.56-17 14.45-26.26 24.31-26.59 21.89-.75 30.12 25.67 14.88 34-12.09 9.71 .11 12.61 2.05 12.55 10.42-.36 17.34-5.51 22.18-9 24-20 33.24-54.86 45.35-118.3 8.19-49.66 17-78 18.23-82-16.93-12.75-27.08-28.55-49.85-34.72-15.61-4.23-25.12-.63-31.81 7.83-7.92 10-5.29 23 2.37 30.7l12.63 14c15.51 17.93 24 31.87 20.8 50.62-5.06 29.93-40.72 52.9-82.88 39.94-36-11.11-42.7-36.56-38.38-50.62 7.51-24.15 42.36-11.72 34.62 13.6-2.79 8.6-4.92 8.68-6.28 13.07-4.56 14.77 41.85 28.4 51-1.39 4.47-14.52-5.3-21.71-22.25-39.85-28.47-31.75-16-65.49 2.95-79.67C204.2 140.1 251.9 197 262 205.3c37.17-109 100.5-105.5 102.4-105.5 25.16-.81 44.19 10.59 44.83 28.65 .25 7.69-4.17 22.59-19.52 23.13z")),"label"=>__("Symfony","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"synagogue"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M309.8 3.708C315.7-1.236 324.3-1.236 330.2 3.708L451.2 104.5C469.5 119.7 480 142.2 480 165.1V512H384V384C384 348.7 355.3 320 320 320C284.7 320 256 348.7 256 384V512H160V165.1C160 142.2 170.5 119.7 188.8 104.5L309.8 3.708zM326.1 124.3C323.9 118.9 316.1 118.9 313 124.3L297.2 152.4L264.9 152.1C258.7 152.1 254.8 158.8 257.9 164.2L274.3 191.1L257.9 219.8C254.8 225.2 258.7 231.9 264.9 231.9L297.2 231.6L313 259.7C316.1 265.1 323.9 265.1 326.1 259.7L342.8 231.6L375.1 231.9C381.3 231.9 385.2 225.2 382.1 219.8L365.7 191.1L382.1 164.2C385.2 158.8 381.3 152.1 375.1 152.1L342.8 152.4L326.1 124.3zM512 244.5L540.1 213.3C543.1 209.9 547.5 208 552 208C556.5 208 560.9 209.9 563.9 213.3L627.7 284.2C635.6 292.1 640 304.4 640 316.3V448C640 483.3 611.3 512 576 512H512V244.5zM128 244.5V512H64C28.65 512 0 483.3 0 448V316.3C0 304.4 4.389 292.1 12.32 284.2L76.11 213.3C79.14 209.9 83.46 208 88 208C92.54 208 96.86 209.9 99.89 213.3L128 244.5z")),"label"=>__("Synagogue","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"syringe"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M504.1 71.03l-64-64c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L422.1 56L384 94.06l-55.03-55.03c-9.375-9.375-24.56-9.375-33.94 0c-8.467 8.467-8.873 21.47-2.047 30.86l149.1 149.1C446.3 222.1 451.1 224 456 224c6.141 0 12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94L417.9 128L456 89.94l15.03 15.03C475.7 109.7 481.9 112 488 112s12.28-2.344 16.97-7.031C514.3 95.59 514.3 80.41 504.1 71.03zM208.8 154.1l58.56 58.56c6.25 6.25 6.25 16.38 0 22.62C264.2 238.4 260.1 240 256 240S247.8 238.4 244.7 235.3L186.1 176.8L144.8 218.1l58.56 58.56c6.25 6.25 6.25 16.38 0 22.62C200.2 302.4 196.1 304 192 304S183.8 302.4 180.7 299.3L122.1 240.8L82.75 280.1C70.74 292.1 64 308.4 64 325.4v88.68l-56.97 56.97c-9.375 9.375-9.375 24.56 0 33.94C11.72 509.7 17.86 512 24 512s12.28-2.344 16.97-7.031L97.94 448h88.69c16.97 0 33.25-6.744 45.26-18.75l187.6-187.6l-149.1-149.1L208.8 154.1z")),"label"=>__("Syringe","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"t"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M384 64.01c0 17.67-14.33 32-32 32h-128v352c0 17.67-14.33 31.99-32 31.99s-32-14.32-32-31.99v-352H32c-17.67 0-32-14.33-32-32s14.33-32 32-32h320C369.7 32.01 384 46.34 384 64.01z")),"label"=>__("T","ultimate-addons-for-gutenberg"),"custom_categories"=>array("education")),"table"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M448 32C483.3 32 512 60.65 512 96V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H448zM224 256V160H64V256H224zM64 320V416H224V320H64zM288 416H448V320H288V416zM448 256V160H288V256H448z")),"label"=>__("Table","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"table-cells"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M448 32C483.3 32 512 60.65 512 96V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H448zM152 96H64V160H152V96zM208 160H296V96H208V160zM448 96H360V160H448V96zM64 288H152V224H64V288zM296 224H208V288H296V224zM360 288H448V224H360V288zM152 352H64V416H152V352zM208 416H296V352H208V416zM448 352H360V416H448V352z")),"label"=>__("Table Cells","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"table-cells-large"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M448 32C483.3 32 512 60.65 512 96V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H448zM448 96H288V224H448V96zM448 288H288V416H448V288zM224 224V96H64V224H224zM64 416H224V288H64V416z")),"label"=>__("Table Cells Large","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"table-columns"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M0 96C0 60.65 28.65 32 64 32H448C483.3 32 512 60.65 512 96V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V96zM64 416H224V160H64V416zM448 160H288V416H448V160z")),"label"=>__("Table Columns","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"table-list"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M0 96C0 60.65 28.65 32 64 32H448C483.3 32 512 60.65 512 96V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V96zM64 160H128V96H64V160zM448 96H192V160H448V96zM64 288H128V224H64V288zM448 224H192V288H448V224zM64 416H128V352H64V416zM448 352H192V416H448V352z")),"label"=>__("Table List","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"table-tennis-paddle-ball"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M416 287.1c27.99 0 53.68 9.254 74.76 24.51c14.03-29.82 21.06-62.13 21.06-94.43c0-103.1-79.37-218.1-216.5-218.1c-59.94 0-120.4 23.71-165.5 68.95l-54.66 54.8C73.61 125.3 72.58 126.1 71.14 128.5l230.7 230.7C322.8 317.2 365.8 287.1 416 287.1zM290.3 392.1l-238.6-238.6C38.74 176.2 32.3 199.4 32.3 221.9c0 30.53 11.71 59.94 34.29 82.58l36.6 36.7l-92.38 81.32c-7.177 6.255-10.81 15.02-10.81 23.81c0 8.027 3.032 16.07 9.164 22.24l34.05 34.2c6.145 6.16 14.16 9.205 22.15 9.205c8.749 0 17.47-3.649 23.7-10.86l81.03-92.85l35.95 36.04c23.62 23.68 54.41 35.23 85.37 35.23c4.532 0 9.205-.2677 13.72-.7597c-10.56-18.61-17.12-39.89-17.12-62.81C288 408.1 288.1 400.5 290.3 392.1zM415.1 320c-52.99 0-95.99 42.1-95.99 95.1c0 52.1 42.99 95.99 95.99 95.99c52.1 0 95.99-42.1 95.99-95.99C511.1 363 468.1 320 415.1 320z")),"label"=>__("Table Tennis Paddle Ball","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"tablet"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 0H64C28.65 0 0 28.65 0 64v384c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM288 447.1C288 456.8 280.8 464 272 464H175.1C167.2 464 160 456.8 160 448S167.2 432 175.1 432h96C280.8 432 288 439.2 288 447.1z")),"label"=>__("Tablet","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"tablet-button"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 0H64C28.65 0 0 28.65 0 64v384c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM224 464c-17.75 0-32-14.25-32-32s14.25-32 32-32s32 14.25 32 32S241.8 464 224 464z")),"label"=>__("Tablet Button","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"tablet-screen-button"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M384 .0001H64c-35.35 0-64 28.65-64 64v384c0 35.35 28.65 63.1 64 63.1h320c35.35 0 64-28.65 64-63.1v-384C448 28.65 419.3 .0001 384 .0001zM224 480c-17.75 0-32-14.25-32-32s14.25-32 32-32s32 14.25 32 32S241.8 480 224 480zM384 384H64v-320h320V384z")),"label"=>__("Tablet Screen Button","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"tablets"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M159.1 191.1c-81.1 0-147.5 58.51-159.9 134.8C-.7578 331.5 3.367 336 8.365 336h303.3c4.998 0 8.996-4.5 8.248-9.25C307.4 250.5 241.1 191.1 159.1 191.1zM311.5 368H8.365c-4.998 0-9.123 4.5-8.248 9.25C12.49 453.5 78.88 512 159.1 512s147.4-58.5 159.8-134.8C320.7 372.5 316.5 368 311.5 368zM362.9 65.74c-3.502-3.502-9.504-3.252-12.25 .75c-45.52 62.76-40.52 150.4 15.88 206.9c56.52 56.51 144.2 61.39 206.1 15.88c4.002-2.875 4.252-8.877 .75-12.25L362.9 65.74zM593.4 46.61c-56.52-56.51-144.2-61.39-206.1-16c-4.002 2.877-4.252 8.877-.75 12.25l211.3 211.4c3.5 3.502 9.504 3.252 12.25-.75C654.8 190.8 649.9 103.1 593.4 46.61z")),"label"=>__("Tablets","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"tachograph-digital"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M576 64H64C28.8 64 0 92.8 0 128v256c0 35.2 28.8 64 64 64h512c35.2 0 64-28.8 64-64V128C640 92.8 611.2 64 576 64zM64 296C64 291.6 67.63 288 72 288h16C92.38 288 96 291.6 96 296v16C96 316.4 92.38 320 88 320h-16C67.63 320 64 316.4 64 312V296zM336 384h-256C71.2 384 64 376.8 64 368C64 359.2 71.2 352 79.1 352h256c8.801 0 16 7.199 16 16C352 376.8 344.8 384 336 384zM128 312v-16C128 291.6 131.6 288 136 288h16C156.4 288 160 291.6 160 296v16C160 316.4 156.4 320 152 320h-16C131.6 320 128 316.4 128 312zM192 312v-16C192 291.6 195.6 288 200 288h16C220.4 288 224 291.6 224 296v16C224 316.4 220.4 320 216 320h-16C195.6 320 192 316.4 192 312zM256 312v-16C256 291.6 259.6 288 264 288h16C284.4 288 288 291.6 288 296v16C288 316.4 284.4 320 280 320h-16C259.6 320 256 316.4 256 312zM352 312C352 316.4 348.4 320 344 320h-16C323.6 320 320 316.4 320 312v-16C320 291.6 323.6 288 328 288h16C348.4 288 352 291.6 352 296V312zM352 237.7C352 247.9 344.4 256 334.9 256H81.07C71.6 256 64 247.9 64 237.7V146.3C64 136.1 71.6 128 81.07 128h253.9C344.4 128 352 136.1 352 146.3V237.7zM560 384h-160c-8.801 0-16-7.201-16-16c0-8.801 7.199-16 16-16h160c8.801 0 16 7.199 16 16C576 376.8 568.8 384 560 384z")),"label"=>__("Tachograph Digital","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"tag"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M48 32H197.5C214.5 32 230.7 38.74 242.7 50.75L418.7 226.7C443.7 251.7 443.7 292.3 418.7 317.3L285.3 450.7C260.3 475.7 219.7 475.7 194.7 450.7L18.75 274.7C6.743 262.7 0 246.5 0 229.5V80C0 53.49 21.49 32 48 32L48 32zM112 176C129.7 176 144 161.7 144 144C144 126.3 129.7 112 112 112C94.33 112 80 126.3 80 144C80 161.7 94.33 176 112 176z")),"label"=>__("Tag","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies","travel")),"tags"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M472.8 168.4C525.1 221.4 525.1 306.6 472.8 359.6L360.8 472.9C351.5 482.3 336.3 482.4 326.9 473.1C317.4 463.8 317.4 448.6 326.7 439.1L438.6 325.9C472.5 291.6 472.5 236.4 438.6 202.1L310.9 72.87C301.5 63.44 301.6 48.25 311.1 38.93C320.5 29.61 335.7 29.7 344.1 39.13L472.8 168.4zM.0003 229.5V80C.0003 53.49 21.49 32 48 32H197.5C214.5 32 230.7 38.74 242.7 50.75L410.7 218.7C435.7 243.7 435.7 284.3 410.7 309.3L277.3 442.7C252.3 467.7 211.7 467.7 186.7 442.7L18.75 274.7C6.743 262.7 0 246.5 0 229.5L.0003 229.5zM112 112C94.33 112 80 126.3 80 144C80 161.7 94.33 176 112 176C129.7 176 144 161.7 144 144C144 126.3 129.7 112 112 112z")),"label"=>__("Tags","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies","travel")),"tape"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M288 256C288 291.3 259.3 320 224 320C188.7 320 160 291.3 160 256C160 220.7 188.7 192 224 192C259.3 192 288 220.7 288 256zM544 416C561.7 416 576 430.3 576 448C576 465.7 561.7 480 544 480H224C100.3 480 0 379.7 0 256C0 132.3 100.3 32 224 32C347.7 32 448 132.3 448 256C448 318.7 422.3 375.3 380.8 416H544zM224 352C277 352 320 309 320 256C320 202.1 277 160 224 160C170.1 160 128 202.1 128 256C128 309 170.1 352 224 352z")),"label"=>__("Tape","ultimate-addons-for-gutenberg"),"custom_categories"=>array("travel")),"tarp"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M576 288H448C430.3 288 416 302.3 416 320V448H64C28.65 448 0 419.3 0 384V128C0 92.65 28.65 64 64 64H512C547.3 64 576 92.65 576 128V288zM96 192C113.7 192 128 177.7 128 160C128 142.3 113.7 128 96 128C78.33 128 64 142.3 64 160C64 177.7 78.33 192 96 192zM448 448V320H576L448 448z")),"label"=>__("Tarp","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies")),"tarp-droplet"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M224 100C224 75.95 257.7 29.93 276.2 6.49C282.3-1.226 293.7-1.226 299.8 6.49C318.3 29.93 352 75.95 352 100C352 133.1 323.3 160 288 160C252.7 160 224 133.1 224 100V100zM64 128H197.5C210.6 165.3 246.2 192 288 192C329.8 192 365.4 165.3 378.5 128H512C547.3 128 576 156.7 576 192V352H448C430.3 352 416 366.3 416 384V512H64C28.65 512 0 483.3 0 448V192C0 156.7 28.65 128 64 128V128zM96 256C113.7 256 128 241.7 128 224C128 206.3 113.7 192 96 192C78.33 192 64 206.3 64 224C64 241.7 78.33 256 96 256zM448 512V384H576L448 512z")),"label"=>__("Tarp Droplet","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies")),"taxi"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M352 0C369.7 0 384 14.33 384 32V64L384 64.15C422.6 66.31 456.3 91.49 469.2 128.3L504.4 228.8C527.6 238.4 544 261.3 544 288V480C544 497.7 529.7 512 512 512H480C462.3 512 448 497.7 448 480V432H128V480C128 497.7 113.7 512 96 512H64C46.33 512 32 497.7 32 480V288C32 261.3 48.36 238.4 71.61 228.8L106.8 128.3C119.7 91.49 153.4 66.31 192 64.15L192 64V32C192 14.33 206.3 0 224 0L352 0zM197.4 128C183.8 128 171.7 136.6 167.2 149.4L141.1 224H434.9L408.8 149.4C404.3 136.6 392.2 128 378.6 128H197.4zM128 352C145.7 352 160 337.7 160 320C160 302.3 145.7 288 128 288C110.3 288 96 302.3 96 320C96 337.7 110.3 352 128 352zM448 288C430.3 288 416 302.3 416 320C416 337.7 430.3 352 448 352C465.7 352 480 337.7 480 320C480 302.3 465.7 288 448 288z")),"label"=>__("Taxi","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"teamspeak"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M244.2 346.8c2.4-12.3-12-30-32.4-48.7-20.9-19.2-48.2-39.1-63.4-46.6-21.7-12-41.7-1.8-46.3 22.7-5 26.2 0 51.4 14.5 73.9 10.2 15.5 25.4 22.7 43.4 24 11.6 .6 52.5 2.2 61.7-1 11.9-4.3 20.1-11.8 22.5-24.3zm205 20.8a5.22 5.22 0 0 0 -8.3 2.4c-8 25.4-44.7 112.5-172.1 121.5-149.7 10.5 80.3 43.6 145.4-6.4 22.7-17.4 47.6-35 46.6-85.4-.4-10.1-4.9-26.69-11.6-32.1zm62-122.4c-.3-18.9-8.6-33.4-26-42.2-2.9-1.3-5-2.7-5.9-6.4A222.6 222.6 0 0 0 438.9 103c-1.1-1.5-3.5-3.2-2.2-5 8.5-11.5-.3-18-7-24.4Q321.4-31.11 177.4 13.09c-40.1 12.3-73.9 35.6-102 67.4-4 4.3-6.7 9.1-3 14.5 3 4 1.3 6.2-1 9.3C51.6 132 38.2 162.6 32.1 196c-.7 4.3-2.9 6-6.4 7.8-14.2 7-22.5 18.5-24.9 34L0 264.3v20.9c0 30.8 21 50.4 51.8 49 7.7-.3 11.7-4.3 12-11.5 2-77.5-2.4-95.4 3.7-125.8C92.1 72.39 234.3 5 345.3 65.39 411.4 102 445.7 159 447.6 234.8c.8 28.2 0 56.5 0 84.6 0 7 2.2 12.5 9.4 14.2 24.1 5 49.2-12 53.2-36.7 2.9-17.1 1-34.5 1-51.7zm-159.6 131.5c36.5 2.8 59.3-28.5 58.4-60.5-2.1-45.2-66.2-16.5-87.8-8-73.2 28.1-45 54.9-22.2 60.8z")),"label"=>__("TeamSpeak","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"teeth"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M480 32H96C42.98 32 0 74.98 0 128v256c0 53.02 42.98 96 96 96h384c53.02 0 96-42.98 96-96V128C576 74.98 533 32 480 32zM144 336C144 362.5 122.5 384 96 384s-48-21.5-48-48v-32C48 295.1 55.13 288 64 288h64c8.875 0 16 7.125 16 16V336zM144 240C144 248.9 136.9 256 128 256H64C55.13 256 48 248.9 48 240v-32C48 181.5 69.5 160 96 160s48 21.5 48 48V240zM272 336C272 362.5 250.5 384 224 384s-48-21.5-48-48v-32C176 295.1 183.1 288 192 288h64c8.875 0 16 7.125 16 16V336zM272 242.3C272 249.9 265.9 256 258.3 256H189.7C182.1 256 176 249.9 176 242.3V176C176 149.5 197.5 128 224 128s48 21.54 48 48V242.3zM400 336c0 26.5-21.5 48-48 48s-48-21.5-48-48v-32C304 295.1 311.1 288 320 288h64c8.875 0 16 7.125 16 16V336zM400 242.3C400 249.9 393.9 256 386.3 256h-68.57C310.1 256 304 249.9 304 242.3V176C304 149.5 325.5 128 352 128s48 21.54 48 48V242.3zM528 336c0 26.5-21.5 48-48 48s-48-21.5-48-48v-32C432 295.1 439.1 288 448 288h64c8.875 0 16 7.125 16 16V336zM528 240C528 248.9 520.9 256 512 256h-64c-8.875 0-16-7.125-16-16v-32C432 181.5 453.5 160 480 160s48 21.5 48 48V240z")),"label"=>__("Teeth","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"teeth-open"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M512 288H64c-35.35 0-64 28.65-64 64v32c0 53.02 42.98 96 96 96h384c53.02 0 96-42.98 96-96v-32C576 316.7 547.3 288 512 288zM144 368C144 394.5 122.5 416 96 416s-48-21.5-48-48v-32C48 327.1 55.13 320 64 320h64c8.875 0 16 7.125 16 16V368zM272 368C272 394.5 250.5 416 224 416s-48-21.5-48-48v-32C176 327.1 183.1 320 192 320h64c8.875 0 16 7.125 16 16V368zM400 368c0 26.5-21.5 48-48 48s-48-21.5-48-48v-32c0-8.875 7.125-16 16-16h64c8.875 0 16 7.125 16 16V368zM528 368c0 26.5-21.5 48-48 48s-48-21.5-48-48v-32c0-8.875 7.125-16 16-16h64c8.875 0 16 7.125 16 16V368zM480 32H96C42.98 32 0 74.98 0 128v64c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V128C576 74.98 533 32 480 32zM144 208C144 216.9 136.9 224 128 224H64C55.13 224 48 216.9 48 208v-32C48 149.5 69.5 128 96 128s48 21.5 48 48V208zM272 210.3C272 217.9 265.9 224 258.3 224H189.7C182.1 224 176 217.9 176 210.3V144C176 117.5 197.5 96 224 96s48 21.54 48 48V210.3zM400 210.3C400 217.9 393.9 224 386.3 224h-68.57C310.1 224 304 217.9 304 210.3V144C304 117.5 325.5 96 352 96s48 21.54 48 48V210.3zM528 208C528 216.9 520.9 224 512 224h-64c-8.875 0-16-7.125-16-16v-32C432 149.5 453.5 128 480 128s48 21.5 48 48V208z")),"label"=>__("Teeth Open","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"telegram"=>array("svg"=>array("brands"=>array("width"=>496,"height"=>512,"path"=>"M248 8C111 8 0 119 0 256S111 504 248 504 496 392.1 496 256 384.1 8 248 8zM362.1 176.7c-3.732 39.22-19.88 134.4-28.1 178.3-3.476 18.58-10.32 24.82-16.95 25.42-14.4 1.326-25.34-9.517-39.29-18.66-21.83-14.31-34.16-23.22-55.35-37.18-24.49-16.14-8.612-25 5.342-39.5 3.652-3.793 67.11-61.51 68.33-66.75 .153-.655 .3-3.1-1.154-4.384s-3.59-.849-5.135-.5q-3.283 .746-104.6 69.14-14.85 10.19-26.89 9.934c-8.855-.191-25.89-5.006-38.55-9.123-15.53-5.048-27.88-7.717-26.8-16.29q.84-6.7 18.45-13.7 108.4-47.25 144.6-62.3c68.87-28.65 83.18-33.62 92.51-33.79 2.052-.034 6.639 .474 9.61 2.885a10.45 10.45 0 0 1 3.53 6.716A43.76 43.76 0 0 1 362.1 176.7z")),"label"=>__("Telegram","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"temperature-arrow-down"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M159.1 322.9l-.0002-18.92C159.1 295.1 152.9 287.1 144 287.1c-8.875 0-15.1 7.115-15.1 15.99L128 322.9c-22 7.875-35.25 30.38-31.25 53.38C100.6 399.4 120.6 416.1 144 416.1c23.37 0 43.37-16.71 47.25-39.83C195.2 353.3 181.1 330.8 159.1 322.9zM255.1 112C255.1 50.13 205.9 0 144 0C82.13 0 32 50.13 32 112v166.5C12.25 303.3 0 334 0 368C0 447.5 64.5 512 144 512c79.5 0 143.1-64.5 143.1-144c0-34-12.25-64.88-32-89.5V112zM219.9 393.4C208.1 426.1 178.4 447.1 144 447.1c-34.38 0-65-21.84-75.88-54.59C57.25 360.8 68.5 324.9 96 304.3V112C96 85.5 117.5 64 144 64c26.5 0 47.1 21.5 47.1 48v192.3C219.5 324.9 230.7 360.8 219.9 393.4zM499.1 343c-13.77-11.03-33.92-8.75-44.97 5L448 356.8V64c0-17.69-14.33-32-32-32s-32 14.31-32 32v292.8L376.1 348c-11.03-13.81-31.19-16.03-44.97-5c-13.81 11.06-16.05 31.19-5 45l64 80C397.1 475.6 406.3 480 416 480s18.92-4.406 24.98-12l64-80C516 374.2 513.8 354.1 499.1 343z")),"label"=>__("Temperature Arrow Down","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment","lifestyle-and-hobbies")),"temperature-arrow-up"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M159.1 322.9V112C159.1 103.1 152.9 96 144 96C135.1 96 128 103.1 128 112v210.9c-22 7.875-35.25 30.38-31.25 53.38C100.6 399.4 120.6 416.1 144 416.1c23.37 0 43.37-16.71 47.25-39.83C195.2 353.3 181.1 330.8 159.1 322.9zM255.1 112C255.1 50.13 205.9 0 144 0C82.13 0 32 50.13 32 112v166.5C12.25 303.3 0 334 0 368C0 447.5 64.5 512 144 512c79.5 0 143.1-64.5 143.1-144c0-34-12.25-64.88-32-89.5V112zM219.9 393.4C208.1 426.1 178.4 447.1 144 447.1c-34.38 0-65-21.84-75.88-54.59C57.25 360.8 68.5 324.9 96 304.3V112c0-26.5 21.5-48.01 48-48.01c26.5 0 47.1 21.51 47.1 48.01v192.3C219.5 324.9 230.7 360.8 219.9 393.4zM504.1 124l-64-80c-12.12-15.19-37.84-15.19-49.97 0l-64 80c-11.05 13.81-8.812 33.94 5 45c13.75 11.03 33.94 8.781 44.97-5L384 155.2V448c0 17.69 14.33 32 32 32s32-14.31 32-32V155.2L455 164c6.312 7.906 15.61 12 25 12c7.016 0 14.08-2.281 19.97-7C513.8 157.9 516 137.8 504.1 124z")),"label"=>__("Temperature Arrow Up","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment","lifestyle-and-hobbies")),"temperature-empty"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M272 278.5V112c0-61.87-50.12-112-111.1-112S48 50.13 48 112v166.5c-19.75 24.75-32 55.5-32 89.5c0 79.5 64.5 143.1 144 143.1S304 447.5 304 368C304 334 291.8 303.1 272 278.5zM160 448c-44.13 0-80-35.87-80-79.1c0-25.5 12.25-48.88 32-63.75v-192.3c0-26.5 21.5-48 48-48s48 21.5 48 48v192.3c19.75 14.75 32 38.25 32 63.75C240 412.1 204.1 448 160 448zM160 320c-26.51 0-48 21.49-48 48s21.49 48 48 48s48-21.49 48-48S186.5 320 160 320z")),"label"=>__("Temperature Empty","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment")),"temperature-full"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M176 322.9V112c0-8.75-7.25-16-16-16s-16 7.25-16 16v210.9c-18.62 6.625-32 24.25-32 45.13c0 26.5 21.5 48 48 48s48-21.5 48-48C208 347.1 194.6 329.5 176 322.9zM272 278.5V112c0-61.87-50.12-112-111.1-112S48 50.13 48 112v166.5c-19.75 24.75-32 55.5-32 89.5c0 79.5 64.5 143.1 144 143.1S304 447.5 304 368C304 334 291.8 303.1 272 278.5zM160 448c-44.13 0-80-35.87-80-79.1c0-25.5 12.25-48.88 32-63.75v-192.3c0-26.5 21.5-48 48-48s48 21.5 48 48v192.3c19.75 14.75 32 38.25 32 63.75C240 412.1 204.1 448 160 448z")),"label"=>__("Temperature Full","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment")),"temperature-half"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M176 322.9l.0002-114.9c0-8.75-7.25-16-16-16s-15.1 7.25-15.1 16L144 322.9c-18.62 6.625-32 24.25-32 45.13c0 26.5 21.5 48 48 48s48-21.5 48-48C208 347.1 194.6 329.5 176 322.9zM272 278.5V112c0-61.87-50.12-112-111.1-112S48 50.13 48 112v166.5c-19.75 24.75-32 55.5-32 89.5c0 79.5 64.5 143.1 144 143.1S304 447.5 304 368C304 334 291.8 303.1 272 278.5zM160 448c-44.13 0-80-35.87-80-79.1c0-25.5 12.25-48.88 32-63.75v-192.3c0-26.5 21.5-48 48-48s48 21.5 48 48v192.3c19.75 14.75 32 38.25 32 63.75C240 412.1 204.1 448 160 448z")),"label"=>__("Temperature Half","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment")),"temperature-high"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M160 322.9V112C160 103.3 152.8 96 144 96S128 103.3 128 112v210.9C109.4 329.5 96 347.1 96 368C96 394.5 117.5 416 144 416S192 394.5 192 368C192 347.1 178.6 329.5 160 322.9zM416 0c-52.88 0-96 43.13-96 96s43.13 96 96 96s96-43.13 96-96S468.9 0 416 0zM416 128c-17.75 0-32-14.25-32-32s14.25-32 32-32s32 14.25 32 32S433.8 128 416 128zM256 112c0-61.88-50.13-112-112-112s-112 50.13-112 112v166.5c-19.75 24.75-32 55.5-32 89.5c0 79.5 64.5 144 144 144s144-64.5 144-144c0-33.1-12.25-64.88-32-89.5V112zM144 448c-44.13 0-80-35.88-80-80c0-25.5 12.25-48.88 32-63.75v-192.3c0-26.5 21.5-48 48-48S192 85.5 192 112V304.3c19.75 14.75 32 38.25 32 63.75C224 412.1 188.1 448 144 448z")),"label"=>__("Temperature High","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment","science-and-technology")),"temperature-low"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M160 322.9V304C160 295.3 152.8 288 144 288S128 295.3 128 304v18.88C109.4 329.5 96 347.1 96 368C96 394.5 117.5 416 144 416S192 394.5 192 368C192 347.1 178.6 329.5 160 322.9zM256 112c0-61.88-50.13-112-112-112s-112 50.13-112 112v166.5c-19.75 24.75-32 55.5-32 89.5c0 79.5 64.5 144 144 144s144-64.5 144-144c0-33.1-12.25-64.88-32-89.5V112zM144 448c-44.13 0-80-35.88-80-80c0-25.5 12.25-48.88 32-63.75v-192.3c0-26.5 21.5-48 48-48s48 21.5 48 48v192.1c19.75 14.75 32 38.38 32 63.88C224 412.1 188.1 448 144 448zM416 0c-52.88 0-96 43.13-96 96s43.13 96 96 96s96-43.13 96-96S468.9 0 416 0zM416 128c-17.75 0-32-14.25-32-32s14.25-32 32-32s32 14.25 32 32S433.8 128 416 128z")),"label"=>__("Temperature Low","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment","science-and-technology")),"temperature-quarter"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M176 322.9l.0002-50.88c0-8.75-7.25-16-16-16s-15.1 7.25-15.1 16L144 322.9c-18.62 6.625-32 24.25-32 45.13c0 26.5 21.5 48 48 48s48-21.5 48-48C208 347.1 194.6 329.5 176 322.9zM272 278.5V112c0-61.87-50.12-112-111.1-112S48 50.13 48 112v166.5c-19.75 24.75-32 55.5-32 89.5c0 79.5 64.5 143.1 144 143.1S304 447.5 304 368C304 334 291.8 303.1 272 278.5zM160 448c-44.13 0-80-35.87-80-79.1c0-25.5 12.25-48.88 32-63.75v-192.3c0-26.5 21.5-48 48-48s48 21.5 48 48v192.3c19.75 14.75 32 38.25 32 63.75C240 412.1 204.1 448 160 448z")),"label"=>__("Temperature Quarter","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment")),"temperature-three-quarters"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M176 322.9V160c0-8.75-7.25-16-16-16s-16 7.25-16 16v162.9c-18.62 6.625-32 24.25-32 45.13c0 26.5 21.5 48 48 48s48-21.5 48-48C208 347.1 194.6 329.5 176 322.9zM272 278.5V112c0-61.87-50.12-112-111.1-112S48 50.13 48 112v166.5c-19.75 24.75-32 55.5-32 89.5c0 79.5 64.5 143.1 144 143.1S304 447.5 304 368C304 334 291.8 303.1 272 278.5zM160 448c-44.13 0-80-35.87-80-79.1c0-25.5 12.25-48.88 32-63.75v-192.3c0-26.5 21.5-48 48-48s48 21.5 48 48v192.3c19.75 14.75 32 38.25 32 63.75C240 412.1 204.1 448 160 448z")),"label"=>__("Temperature Three Quarters","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment")),"tencent-weibo"=>array("svg"=>array("brands"=>array("width"=>384,"height"=>512,"path"=>"M72.3 495.8c1.4 19.9-27.6 22.2-29.7 2.9C31 368.8 73.7 259.2 144 185.5c-15.6-34 9.2-77.1 50.6-77.1 30.3 0 55.1 24.6 55.1 55.1 0 44-49.5 70.8-86.9 45.1-65.7 71.3-101.4 169.8-90.5 287.2zM192 .1C66.1 .1-12.3 134.3 43.7 242.4 52.4 259.8 79 246.9 70 229 23.7 136.4 91 29.8 192 29.8c75.4 0 136.9 61.4 136.9 136.9 0 90.8-86.9 153.9-167.7 133.1-19.1-4.1-25.6 24.4-6.6 29.1 110.7 23.2 204-60 204-162.3C358.6 74.7 284 .1 192 .1z")),"label"=>__("Tencent Weibo","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","brands","social","social")),"tenge-sign"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M0 64C0 46.33 14.33 32 32 32H352C369.7 32 384 46.33 384 64C384 81.67 369.7 96 352 96H32C14.33 96 0 81.67 0 64zM0 192C0 174.3 14.33 160 32 160H352C369.7 160 384 174.3 384 192C384 209.7 369.7 224 352 224H224V448C224 465.7 209.7 480 192 480C174.3 480 160 465.7 160 448V224H32C14.33 224 0 209.7 0 192z")),"label"=>__("Tenge Sign","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"tent"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M269.4 5.961C280.5-1.987 295.5-1.987 306.6 5.961L530.6 165.1C538 171.2 542.8 179.4 543.8 188.5L575.8 476.5C576.8 485.5 573.9 494.6 567.8 501.3C561.8 508.1 553.1 512 544 512H416L288 288V512H32C22.9 512 14.23 508.1 8.156 501.3C2.086 494.6-.8093 485.5 .1958 476.5L32.2 188.5C33.2 179.4 38 171.2 45.4 165.1L269.4 5.961z")),"label"=>__("Tent","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies")),"tent-arrow-down-to-line"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M241.8 111.9C250.7 121.8 249.9 136.1 240.1 145.8L160.1 217.8C150.9 226.1 137.1 226.1 127.9 217.8L47.94 145.8C38.09 136.1 37.29 121.8 46.16 111.9C55.03 102.1 70.2 101.3 80.05 110.2L119.1 146.1V24C119.1 10.75 130.7 0 143.1 0C157.3 0 167.1 10.75 167.1 24V146.1L207.9 110.2C217.8 101.3 232.1 102.1 241.8 111.9H241.8zM364.6 134.5C376.1 125.8 391.9 125.8 403.4 134.5L571.4 262.5C578 267.6 582.4 275 583.6 283.3L608.4 448C625.9 448.2 640 462.4 640 480C640 497.7 625.7 512 608 512H32C14.33 512 0 497.7 0 480C0 462.3 14.33 448 32 448H159.6L184.4 283.3C185.6 275 189.1 267.6 196.6 262.5L364.6 134.5zM384 448H460.8L384 320V448z")),"label"=>__("Tent Arrow Down To Line","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies")),"tent-arrow-left-right"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M568.1 78.16C573.1 82.71 576 89.2 576 96C576 102.8 573.1 109.3 568.1 113.8L488.1 185.8C478.2 194.7 463 193.9 454.2 184.1C445.3 174.2 446.1 159 455.9 150.2L489.5 120H86.54L120.1 150.2C129.9 159 130.7 174.2 121.8 184.1C112.1 193.9 97.8 194.7 87.94 185.8L7.945 113.8C2.888 109.3 0 102.8 0 96C0 89.2 2.888 82.71 7.945 78.16L87.94 6.161C97.8-2.706 112.1-1.907 121.8 7.945C130.7 17.8 129.9 32.97 120.1 41.84L86.54 72H489.5L455.9 41.84C446.1 32.97 445.3 17.8 454.2 7.945C463-1.907 478.2-2.706 488.1 6.161L568.1 78.16zM475.4 294.5C482 299.6 486.4 307 487.6 315.3L511.6 475.3C513 484.5 510.3 493.8 504.2 500.9C498.2 507.9 489.3 512 480 512H384L287.1 352V512H96C86.68 512 77.83 507.9 71.75 500.9C65.67 493.8 62.97 484.5 64.35 475.3L88.35 315.3C89.59 307 93.98 299.6 100.6 294.5L268.6 166.5C280.1 157.8 295.9 157.8 307.4 166.5L475.4 294.5z")),"label"=>__("Tent Arrow Left Right","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies")),"tent-arrow-turn-left"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M86.54 72H456C522.3 72 576 125.7 576 192V232C576 245.3 565.3 256 552 256C538.7 256 528 245.3 528 232V192C528 152.2 495.8 120 456 120H86.54L120.1 150.2C129.9 159 130.7 174.2 121.8 184.1C112.1 193.9 97.8 194.7 87.94 185.8L7.945 113.8C2.888 109.3 0 102.8 0 96C0 89.2 2.888 82.71 7.945 78.16L87.94 6.161C97.8-2.706 112.1-1.907 121.8 7.945C130.7 17.8 129.9 32.97 120.1 41.84L86.54 72zM475.4 294.5C482 299.6 486.4 307 487.6 315.3L511.6 475.3C513 484.5 510.3 493.8 504.2 500.9C498.2 507.9 489.3 512 480 512H384L287.1 352V512H96C86.68 512 77.83 507.9 71.75 500.9C65.67 493.8 62.97 484.5 64.35 475.3L88.35 315.3C89.59 307 93.98 299.6 100.6 294.5L268.6 166.5C280.1 157.8 295.9 157.8 307.4 166.5L475.4 294.5z")),"label"=>__("Tent Arrow Turn Left","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies")),"tent-arrows-down"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M209.8 111.9C218.7 121.8 217.9 136.1 208.1 145.8L128.1 217.8C118.9 226.1 105.1 226.1 95.94 217.8L15.94 145.8C6.093 136.1 5.294 121.8 14.16 111.9C23.03 102.1 38.2 101.3 48.06 110.2L88 146.1V24C88 10.75 98.75 0 112 0C125.3 0 136 10.75 136 24V146.1L175.9 110.2C185.8 101.3 200.1 102.1 209.8 111.9H209.8zM561.8 111.9C570.7 121.8 569.9 136.1 560.1 145.8L480.1 217.8C470.9 226.1 457.1 226.1 447.9 217.8L367.9 145.8C358.1 136.1 357.3 121.8 366.2 111.9C375 102.1 390.2 101.3 400.1 110.2L440 146.1V24C440 10.75 450.7 0 464 0C477.3 0 488 10.75 488 24V146.1L527.9 110.2C537.8 101.3 552.1 102.1 561.8 111.9H561.8zM475.4 294.5C482 299.6 486.4 307 487.6 315.3L511.6 475.3C513 484.5 510.3 493.8 504.2 500.9C498.2 507.9 489.3 512 480 512H384L287.1 352V512H96C86.68 512 77.83 507.9 71.75 500.9C65.67 493.8 62.97 484.5 64.35 475.3L88.35 315.3C89.59 307 93.98 299.6 100.6 294.5L268.6 166.5C280.1 157.8 295.9 157.8 307.4 166.5L475.4 294.5z")),"label"=>__("Tent Arrows Down","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies")),"tents"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M396.6 6.546C408.1-2.182 423.9-2.182 435.4 6.546L603.4 134.5C610 139.6 614.4 147 615.6 155.3L639.6 315.3C641 324.5 638.3 333.8 632.2 340.9C626.2 347.9 617.3 352 608 352H461.5L455.3 310.5C452.8 294 444 279.2 430.8 269.1L262.8 141.1C254.6 134.9 245.4 130.9 235.8 129.1L396.6 6.546zM411.4 294.5C418 299.6 422.4 307 423.6 315.3L447.6 475.3C449 484.5 446.3 493.8 440.2 500.9C434.2 507.9 425.3 512 416 512H319.1L223.1 352V512H32C22.68 512 13.83 507.9 7.753 500.9C1.674 493.8-1.028 484.5 .3542 475.3L24.35 315.3C25.59 307 29.98 299.6 36.61 294.5L204.6 166.5C216.1 157.8 231.9 157.8 243.4 166.5L411.4 294.5z")),"label"=>__("Tents","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies")),"terminal"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M9.372 86.63C-3.124 74.13-3.124 53.87 9.372 41.37C21.87 28.88 42.13 28.88 54.63 41.37L246.6 233.4C259.1 245.9 259.1 266.1 246.6 278.6L54.63 470.6C42.13 483.1 21.87 483.1 9.372 470.6C-3.124 458.1-3.124 437.9 9.372 425.4L178.7 256L9.372 86.63zM544 416C561.7 416 576 430.3 576 448C576 465.7 561.7 480 544 480H256C238.3 480 224 465.7 224 448C224 430.3 238.3 416 256 416H544z")),"label"=>__("Terminal","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"text-height"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M288 32.01H32c-17.67 0-32 14.31-32 32v64c0 17.69 14.33 32 32 32s32-14.31 32-32v-32h64v320H96c-17.67 0-32 14.31-32 32s14.33 32 32 32h128c17.67 0 32-14.31 32-32s-14.33-32-32-32H192v-320h64v32c0 17.69 14.33 32 32 32s32-14.31 32-32v-64C320 46.33 305.7 32.01 288 32.01zM521.4 361.4L512 370.8V141.3l9.375 9.375C527.6 156.9 535.8 160 544 160s16.38-3.125 22.62-9.375c12.5-12.5 12.5-32.75 0-45.25l-64-64c-12.5-12.5-32.75-12.5-45.25 0l-64 64c-12.5 12.5-12.5 32.75 0 45.25s32.75 12.5 45.25 0L448 141.3v229.5l-9.375-9.375c-12.5-12.5-32.75-12.5-45.25 0s-12.5 32.75 0 45.25l64 64C463.6 476.9 471.8 480 480 480s16.38-3.118 22.62-9.368l64-64c12.5-12.5 12.5-32.75 0-45.25S533.9 348.9 521.4 361.4z")),"label"=>__("Text Height","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"text-slash"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M352 416H306.7l18.96-64.1L271.4 308.5L239.1 416H192c-17.67 0-32 14.31-32 32s14.33 31.99 31.1 31.99h160C369.7 480 384 465.7 384 448S369.7 416 352 416zM630.8 469.1l-276.4-216.7l45.63-156.5H512v32c0 17.69 14.33 32 32 32s32-14.31 32-32v-64c0-17.69-14.33-32-32-32H192c-17.67 0-32 14.31-32 32v36.11L38.81 5.13c-10.47-8.219-25.53-6.37-33.7 4.068s-6.349 25.54 4.073 33.69l591.1 463.1c4.406 3.469 9.61 5.127 14.8 5.127c7.125 0 14.17-3.164 18.9-9.195C643.1 492.4 641.2 477.3 630.8 469.1zM300.1 209.9l-82.08-64.33C221.5 140.5 224 134.7 224 128v-32h109.3L300.1 209.9z")),"label"=>__("Text Slash","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"text-width"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M416 32.01H32c-17.67 0-32 14.31-32 32v63.1c0 17.69 14.33 32 32 32s32-14.31 32-32v-32h128v128H176c-17.67 0-32 14.31-32 31.1s14.33 32 32 32h96c17.67 0 32-14.31 32-32s-14.33-31.1-32-31.1H256v-128h128v32c0 17.69 14.33 32 32 32s32-14.32 32-32V64.01C448 46.33 433.7 32.01 416 32.01zM374.6 297.4c-12.5-12.5-32.75-12.5-45.25 0s-12.5 32.75 0 45.25l9.375 9.375h-229.5L118.6 342.6c12.5-12.5 12.5-32.75 0-45.25s-32.75-12.5-45.25 0l-64 64c-12.5 12.5-12.5 32.75 0 45.25l64 64C79.63 476.9 87.81 480 96 480s16.38-3.118 22.62-9.368c12.5-12.5 12.5-32.75 0-45.25l-9.375-9.375h229.5l-9.375 9.375c-12.5 12.5-12.5 32.75 0 45.25C335.6 476.9 343.8 480 352 480s16.38-3.118 22.62-9.368l64-64c12.5-12.5 12.5-32.75 0-45.25L374.6 297.4z")),"label"=>__("Text Width","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"the-red-yeti"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M488.2 241.7l20.7 7.1c-9.6-23.9-23.9-37-31.7-44.8l7.1-18.2c.2 0 12.3-27.8-2.5-30.7-.6-11.3-6.6-27-18.4-27-7.6-10.6-17.7-12.3-30.7-5.9a122.2 122.2 0 0 0 -25.3 16.5c-5.3-6.4-3 .4-3-29.8-37.1-24.3-45.4-11.7-74.8 3l.5 .5a239.4 239.4 0 0 0 -68.4-13.3c-5.5-8.7-18.6-19.1-25.1-25.1l24.8 7.1c-5.5-5.5-26.8-12.9-34.2-15.2 18.2-4.1 29.8-20.8 42.5-33-34.9-10.1-67.9-5.9-97.9 11.8l12-44.2L182 0c-31.6 24.2-33 41.9-33.7 45.5-.9-2.4-6.3-19.6-15.2-27a35.12 35.12 0 0 0 -.5 25.3c3 8.4 5.9 14.8 8.4 18.9-16-3.3-28.3-4.9-49.2 0h-3.7l33 14.3a194.3 194.3 0 0 0 -46.7 67.4l-1.7 8.4 1.7 1.7 7.6-4.7c-3.3 11.6-5.3 19.4-6.6 25.8a200.2 200.2 0 0 0 -27.8 40.3c-15 1-31.8 10.8-40.3 14.3l3 3.4 28.8 1c-.5 1-.7 2.2-1.2 3.2-7.3 6.4-39.8 37.7-33 80.7l20.2-22.4c.5 1.7 .7 3.4 1.2 5.2 0 25.5 .4 89.6 64.9 150.5 43.6 40 96 60.2 157.5 60.2 121.7 0 223-87.3 223-211.5 6.8-9.7-1.2 3 16.7-25.1l13 14.3 2.5-.5A181.8 181.8 0 0 0 495 255a44.74 44.74 0 0 0 -6.8-13.3zM398 111.2l-.5 21.9c5.5 18.1 16.9 17.2 22.4 17.2l-3.4-4.7 22.4-5.4a242.4 242.4 0 0 1 -27 0c12.8-2.1 33.3-29 43-11.3 3.4 7.6 6.4 17.2 9.3 27.8l1.7-5.9a56.38 56.38 0 0 1 -1.7-15.2c5.4 .5 8.8 3.4 9.3 10.1 .5 6.4 1.7 14.8 3.4 25.3l4.7-11.3c4.6 0 4.5-3.6-2.5 20.7-20.9-8.7-35.1-8.4-46.5-8.4l18.2-16c-25.3 8.2-33 10.8-54.8 20.9-1.1-5.4-5-13.5-16-19.9-3.2 3.8-2.8 .9-.7 14.8h-2.5a62.32 62.32 0 0 0 -8.4-23.1l4.2-3.4c8.4-7.1 11.8-14.3 10.6-21.9-.5-6.4-5.4-13.5-13.5-20.7 5.6-3.4 15.2-.4 28.3 8.5zm-39.6-10.1c2.7 1.9 11.4 5.4 18.9 17.2 4.2 8.4 4 9.8 3.4 11.1-.5 2.4-.5 4.3-3 7.1-1.7 2.5-5.4 4.7-11.8 7.6-7.6-13-16.5-23.6-27.8-31.2zM91 143.1l1.2-1.7c1.2-2.9 4.2-7.6 9.3-15.2l2.5-3.4-13 12.3 5.4-4.7-10.1 9.3-4.2 1.2c12.3-24.1 23.1-41.3 32.5-50.2 9.3-9.3 16-16 20.2-19.4l-6.4 1.2c-11.3-4.2-19.4-7.1-24.8-8.4 2.5-.5 3.7-.5 3.2-.5 10.3 0 17.5 .5 20.9 1.2a52.35 52.35 0 0 0 16 2.5l.5-1.7-8.4-35.8 13.5 29a42.89 42.89 0 0 0 5.9-14.3c1.7-6.4 5.4-13 10.1-19.4s7.6-10.6 9.3-11.3a234.7 234.7 0 0 0 -6.4 25.3l-1.7 7.1-.5 4.7 2.5 2.5C190.4 39.9 214 34 239.8 34.5l21.1 .5c-11.8 13.5-27.8 21.9-48.5 24.8a201.3 201.3 0 0 1 -23.4 2.9l-.2-.5-2.5-1.2a20.75 20.75 0 0 0 -14 2c-2.5-.2-4.9-.5-7.1-.7l-2.5 1.7 .5 1.2c2 .2 3.9 .5 6.2 .7l-2 3.4 3.4-.5-10.6 11.3c-4.2 3-5.4 6.4-4.2 9.3l5.4-3.4h1.2a39.4 39.4 0 0 1 25.3-15.2v-3c6.4 .5 13 1 19.4 1.2 6.4 0 8.4 .5 5.4 1.2a189.6 189.6 0 0 1 20.7 13.5c13.5 10.1 23.6 21.9 30 35.4 8.8 18.2 13.5 37.1 13.5 56.6a141.1 141.1 0 0 1 -3 28.3 209.9 209.9 0 0 1 -16 46l2.5 .5c18.2-19.7 41.9-16 49.2-16l-6.4 5.9 22.4 17.7-1.7 30.7c-5.4-12.3-16.5-21.1-33-27.8 16.5 14.8 23.6 21.1 21.9 20.2-4.8-2.8-3.5-1.9-10.8-3.7 4.1 4.1 17.5 18.8 18.2 20.7l.2 .2-.2 .2c0 1.8 1.6-1.2-14 22.9-75.2-15.3-106.3-42.7-141.2-63.2l11.8 1.2c-11.8-18.5-15.6-17.7-38.4-26.1L149 225c-8.8-3-18.2-3-28.3 .5l7.6-10.6-1.2-1.7c-14.9 4.3-19.8 9.2-22.6 11.3-1.1-5.5-2.8-12.4-12.3-28.8l-1.2 27-13.2-5c1.5-25.2 5.4-50.5 13.2-74.6zm276.5 330c-49.9 25-56.1 22.4-59 23.9-29.8-11.8-50.9-31.7-63.5-58.8l30 16.5c-9.8-9.3-18.3-16.5-38.4-44.3l11.8 23.1-17.7-7.6c14.2 21.1 23.5 51.7 66.6 73.5-120.8 24.2-199-72.1-200.9-74.3a262.6 262.6 0 0 0 35.4 24.8c3.4 1.7 7.1 2.5 10.1 1.2l-16-20.7c9.2 4.2 9.5 4.5 69.1 29-42.5-20.7-73.8-40.8-93.2-60.2-.5 6.4-1.2 10.1-1.2 10.1a80.25 80.25 0 0 1 20.7 26.6c-39-18.9-57.6-47.6-71.3-82.6 49.9 55.1 118.9 37.5 120.5 37.1 34.8 16.4 69.9 23.6 113.9 10.6 3.3 0 20.3 17 25.3 39.1l4.2-3-2.5-23.6c9 9 24.9 22.6 34.4 13-15.6-5.3-23.5-9.5-29.5-31.7 4.6 4.2 7.6 9 27.8 15l1.2-1.2-10.5-14.2c11.7-4.8-3.5 1 32-10.8 4.3 34.3 9 49.2 .7 89.5zm115.3-214.4l-2.5 .5 3 9.3c-3.5 5.9-23.7 44.3-71.6 79.7-39.5 29.8-76.6 39.1-80.9 40.3l-7.6-7.1-1.2 3 14.3 16-7.1-4.7 3.4 4.2h-1.2l-21.9-13.5 9.3 26.6-19-27.9-1.2 2.5 7.6 29c-6.1-8.2-21-32.6-56.8-39.6l32.5 21.2a214.8 214.8 0 0 1 -93.2-6.4c-4.2-1.2-8.9-2.5-13.5-4.2l1.2-3-44.8-22.4 26.1 22.4c-57.7 9.1-113-25.4-126.4-83.4l-2.5-16.4-22.27 22.3c19.5-57.5 25.6-57.9 51.4-70.1-9.1-5.3-1.6-3.3-38.4-9.3 15.8-5.8 33-15.4 73 5.2a18.5 18.5 0 0 1 3.7-1.7c.6-3.2 .4-.8 1-11.8 3.9 10 3.6 8.7 3 9.3l1.7 .5c12.7-6.5 8.9-4.5 17-8.9l-5.4 13.5 22.3-5.8-8.4 8.4 2.5 2.5c4.5-1.8 30.3 3.4 40.8 16l-23.6-2.5c39.4 23 51.5 54 55.8 69.6l1.7-1.2c-2.8-22.3-12.4-33.9-16-40.1 4.2 5 39.2 34.6 110.4 46-11.3-.5-23.1 5.4-34.9 18.9l46.7-20.2-9.3 21.9c7.6-10.1 14.8-23.6 21.2-39.6v-.5l1.2-3-1.2 16c13.5-41.8 25.3-78.5 35.4-109.7l13.5-27.8v-2l-5.4-4.2h10.1l5.9 4.2 2.5-1.2-3.4-16 12.3 18.9 41.8-20.2-14.8 13 .5 2.9 17.7-.5a184 184 0 0 1 33 4.2l-23.6 2.5-1.2 3 26.6 23.1a254.2 254.2 0 0 1 27 32c-11.2-3.3-10.3-3.4-21.2-3.4l12.3 32.5zm-6.1-71.3l-3.9 13-14.3-11.8zm-254.8 7.1c1.7 10.6 4.7 17.7 8.8 21.9-9.3 6.6-27.5 13.9-46.5 16l.5 1.2a50.22 50.22 0 0 0 24.8-2.5l-7.1 13c4.2-1.7 10.1-7.1 17.7-14.8 11.9-5.5 12.7-5.1 20.2-16-12.7-6.4-15.7-13.7-18.4-18.8zm3.7-102.3c-6.4-3.4-10.6 3-12.3 18.9s2.5 29.5 11.8 39.6 18.2 10.6 26.1 3 3.4-23.6-11.3-47.7a39.57 39.57 0 0 0 -14.27-13.8zm-4.7 46.3c5.4 2.2 10.5 1.9 12.3-10.6v-4.7l-1.2 .5c-4.3-3.1-2.5-4.5-1.7-6.2l.5-.5c-.9-1.2-5-8.1-12.5 4.7-.5-13.5 .5-21.9 3-24.8 1.2-2.5 4.7-1.2 11.3 4.2 6.4 5.4 11.3 16 15.2 32.5 6.5 28-19.8 26.2-26.9 4.9zm-45-5.5c1.6 .3 9.3-1.1 9.3-14.8h-.5c-5.4-1.1-2.2-5.5-.7-5.9-1.7-3-3.4-4.2-5.4-4.7-8.1 0-11.6 12.7-8.1 21.2a7.51 7.51 0 0 0 5.43 4.2zM216 82.9l-2.5 .5 .5 3a48.94 48.94 0 0 1 26.1 5.9c-2.5-5.5-10-14.3-28.3-14.3l.5 2.5zm-71.8 49.4c21.7 16.8 16.5 21.4 46.5 23.6l-2.9-4.7a42.67 42.67 0 0 0 14.8-28.3c1.7-16-1.2-29.5-8.8-41.3l13-7.6a2.26 2.26 0 0 0 -.5-1.7 14.21 14.21 0 0 0 -13.5 1.7c-12.7 6.7-28 20.9-29 22.4-1.7 1.7-3.4 5.9-5.4 13.5a99.61 99.61 0 0 0 -2.9 23.6c-4.7-8-10.5-6.4-19.9-5.9l7.1 7.6c-16.5 0-23.3 15.4-23.6 16 6.8 0 4.6-7.6 30-12.3-4.3-6.3-3.3-5-4.9-6.6zm18.7-18.7c1.2-7.6 3.4-13 6.4-17.2 5.4-6.4 10.6-10.1 16-11.8 4.2-1.7 7.1 1.2 10.1 9.3a72.14 72.14 0 0 1 3 25.3c-.5 9.3-3.4 17.2-8.4 23.1-2.9 3.4-5.4 5.9-6.4 7.6a39.21 39.21 0 0 1 -11.3-.5l-7.1-3.4-5.4-6.4c.8-10 1.3-18.8 3.1-26zm42 56.1c-34.8 14.4-34.7 14-36.1 14.3-20.8 4.7-19-24.4-18.9-24.8l5.9-1.2-.5-2.5c-20.2-2.6-31 4.2-32.5 4.9 .5 .5 3 3.4 5.9 9.3 4.2-6.4 8.8-10.1 15.2-10.6a83.47 83.47 0 0 0 1.7 33.7c.1 .5 2.6 17.4 27.5 24.1 11.3 3 27 1.2 48.9-5.4l-9.2 .5c-4.2-14.8-6.4-24.8-5.9-29.5 11.3-8.8 21.9-11.3 30.7-7.6h2.5l-11.8-7.6-7.1 .5c-5.9 1.2-12.3 4.2-19.4 8.4z")),"label"=>__("The Red Yeti","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"themeco"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M202.9 8.43c9.9-5.73 26-5.82 35.95-.21L430 115.8c10 5.6 18 19.44 18 30.86V364c0 11.44-8.06 25.29-18 31L238.8 503.7c-9.93 5.66-26 5.57-35.85-.21L17.86 395.1C8 389.3 0 375.4 0 364V146.7c0-11.44 8-25.36 17.91-31.08zm-77.4 199.8c-15.94 0-31.89 .14-47.83 .14v101.4H96.8V280h28.7c49.71 0 49.56-71.74 0-71.74zm140.1 100.3l-30.73-34.64c37-7.51 34.8-65.23-10.87-65.51-16.09 0-32.17-.14-48.26-.14v101.6h19.13v-33.91h18.41l29.56 33.91h22.76zm-41.59-82.32c23.34 0 23.26 32.46 0 32.46h-29.13v-32.46zm-95.56-1.6c21.18 0 21.11 38.85 0 38.85H96.18v-38.84zm192.6-18.25c-68.46 0-71 105.8 0 105.8 69.48-.01 69.41-105.8 0-105.8zm0 17.39c44.12 0 44.8 70.86 0 70.86s-44.43-70.86 0-70.86z")),"label"=>__("Themeco","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"themeisle"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M208 88.29c0-10 6.286-21.71 17.72-21.71 11.14 0 17.71 11.71 17.71 21.71 0 10.28-6.572 21.71-17.71 21.71C214.3 110 208 98.57 208 88.29zm304 160c0 36-11.43 102.3-36.29 129.7-22.86 24.86-87.43 61.14-120.9 70.57l-1.143 .286v32.57c0 16.29-12.57 30.57-29.14 30.57-10 0-19.43-5.714-24.57-14.29-5.427 8.572-14.86 14.29-24.86 14.29-10 0-19.43-5.714-24.86-14.29-5.142 8.572-14.57 14.29-24.57 14.29-10.29 0-19.43-5.714-24.86-14.29-5.143 8.572-14.57 14.29-24.57 14.29-18.86 0-29.43-15.71-29.43-32.86-16.29 12.28-35.72 19.43-56.57 19.43-22 0-43.43-8.285-60.29-22.86 10.28-.286 20.57-2.286 30.28-5.714-20.86-5.714-39.43-18.86-52-36.29 21.37 4.645 46.21 1.673 67.14-11.14-22-22-56.57-58.86-68.57-87.43C1.143 321.7 0 303.7 0 289.4c0-49.71 20.29-160 86.29-160 10.57 0 18.86 4.858 23.14 14.86a158.8 158.8 0 0 1 12-15.43c2-2.572 5.714-5.429 7.143-8.286 7.999-12.57 11.71-21.14 21.71-34C182.6 45.43 232 17.14 285.1 17.14c6 0 12 .285 17.71 1.143C313.7 6.571 328.9 0 344.6 0c14.57 0 29.71 6 40 16.29 .857 .858 1.428 2.286 1.428 3.428 0 3.714-10.28 13.43-12.86 16.29 4.286 1.429 15.71 6.858 15.71 12 0 2.857-2.857 5.143-4.571 7.143 31.43 27.71 49.43 67.14 56.29 108 4.286-5.143 10.28-8.572 17.14-8.572 10.57 0 20.86 7.144 28.57 14C507.1 187.1 512 221.7 512 248.3zM188 89.43c0 18.29 12.57 37.14 32.29 37.14 19.71 0 32.28-18.86 32.28-37.14 0-18-12.57-36.86-32.28-36.86-19.72 0-32.29 18.86-32.29 36.86zM237.7 194c0-19.71 3.714-39.14 8.571-58.29-52.04 79.53-13.53 184.6 68.86 184.6 21.43 0 42.57-7.714 60-20 2-7.429 3.714-14.86 3.714-22.57 0-14.29-6.286-21.43-20.57-21.43-4.571 0-9.143 .857-13.43 1.714-63.34 12.67-107.1 3.669-107.1-63.1zm-41.14 254.9c0-11.14-8.858-20.86-20.29-20.86-11.43 0-20 9.715-20 20.86v32.57c0 11.14 8.571 21.14 20 21.14 11.43 0 20.29-9.715 20.29-21.14v-32.57zm49.14 0c0-11.14-8.572-20.86-20-20.86-11.43 0-20.29 9.715-20.29 20.86v32.57c0 11.14 8.857 21.14 20.29 21.14 11.43 0 20-10 20-21.14v-32.57zm49.71 0c0-11.14-8.857-20.86-20.28-20.86-11.43 0-20.29 9.715-20.29 20.86v32.57c0 11.14 8.857 21.14 20.29 21.14 11.43 0 20.28-9.715 20.28-21.14v-32.57zm49.72 0c0-11.14-8.857-20.86-20.29-20.86-11.43 0-20.29 9.715-20.29 20.86v32.57c0 11.14 8.858 21.14 20.29 21.14 11.43 0 20.29-10 20.29-21.14v-32.57zM421.7 286c-30.86 59.14-90.29 102.6-158.6 102.6-96.57 0-160.6-84.57-160.6-176.6 0-16.86 2-33.43 6-49.71-20 33.72-29.71 72.57-29.71 111.4 0 60.29 24.86 121.7 71.43 160.9 5.143-9.714 14.86-16.29 26-16.29 10 0 19.43 5.714 24.57 14.29 5.429-8.571 14.57-14.29 24.86-14.29 10 0 19.43 5.714 24.57 14.29 5.429-8.571 14.86-14.29 24.86-14.29 10 0 19.43 5.714 24.86 14.29 5.143-8.571 14.57-14.29 24.57-14.29 10.86 0 20.86 6.572 25.71 16 43.43-36.29 68.57-92 71.43-148.3zm10.57-99.71c0-53.71-34.57-105.7-92.57-105.7-30.28 0-58.57 15.14-78.86 36.86C240.9 183.8 233.4 254 302.3 254c28.81 0 97.36-28.54 84.29 36.86 28.86-26 45.71-65.71 45.71-104.6z")),"label"=>__("ThemeIsle","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"thermometer"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M483.1 162.6L229.8 415.9l-99.87-.0001l-88.99 89.02c-9.249 9.377-24.5 9.377-33.87 0c-9.374-9.252-9.374-24.51 0-33.88l88.99-89.02l.0003-100.9l49.05-49.39l51.6 51.59c3.125 3.126 7.218 4.688 11.31 4.688s8.187-1.563 11.31-4.688c6.249-6.252 6.249-16.38 0-22.63L167.6 209.1l41.24-41.52l51.81 51.81c3.125 3.126 7.218 4.688 11.31 4.688s8.187-1.563 11.31-4.688c6.249-6.252 6.249-16.38 0-22.63L231.4 144.8l41.24-41.52l52.02 52.02c3.125 3.126 7.218 4.688 11.31 4.688s8.187-1.563 11.31-4.688c6.249-6.252 6.249-16.38 0-22.63l-52.09-52.09l49.68-50.02c36.37-36.51 94.37-40.88 131.9-10.25C526.2 61.11 518.9 127.8 483.1 162.6z")),"label"=>__("Thermometer","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"think-peaks"=>array("svg"=>array("brands"=>array("width"=>576,"height"=>512,"path"=>"M465.4 409.4l87.1-150.2-32-.3-55.1 95L259.2 0 23 407.4l32 .3L259.2 55.6zm-355.3-44.1h32.1l117.4-202.5L463 511.9l32.5 .1-235.8-404.6z")),"label"=>__("Think Peaks","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"thumbs-down"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M96 32.04H32c-17.67 0-32 14.32-32 31.1v223.1c0 17.67 14.33 31.1 32 31.1h64c17.67 0 32-14.33 32-31.1V64.03C128 46.36 113.7 32.04 96 32.04zM467.3 240.2C475.1 231.7 480 220.4 480 207.9c0-23.47-16.87-42.92-39.14-47.09C445.3 153.6 448 145.1 448 135.1c0-21.32-14-39.18-33.25-45.43C415.5 87.12 416 83.61 416 79.98C416 53.47 394.5 32 368 32h-58.69c-34.61 0-68.28 11.22-95.97 31.98L179.2 89.57C167.1 98.63 160 112.9 160 127.1l.1074 160c0 0-.0234-.0234 0 0c.0703 13.99 6.123 27.94 17.91 37.36l16.3 13.03C276.2 403.9 239.4 480 302.5 480c30.96 0 49.47-24.52 49.47-48.11c0-15.15-11.76-58.12-34.52-96.02H464c26.52 0 48-21.47 48-47.98C512 262.5 492.2 241.9 467.3 240.2z"),"regular"=>array("width"=>512,"height"=>512,"path"=>"M128 288V64.03c0-17.67-14.33-31.1-32-31.1H32c-17.67 0-32 14.33-32 31.1v223.1c0 17.67 14.33 31.1 32 31.1h64C113.7 320 128 305.7 128 288zM481.5 229.1c1.234-5.092 1.875-10.32 1.875-15.64c0-22.7-11.44-43.13-29.28-55.28c.4219-3.015 .6406-6.076 .6406-9.122c0-22.32-11.06-42.6-28.83-54.83c-2.438-34.71-31.47-62.2-66.8-62.2h-52.53c-35.94 0-71.55 11.87-100.3 33.41L169.6 92.93c-6.285 4.71-9.596 11.85-9.596 19.13c0 12.76 10.29 24.04 24.03 24.04c5.013 0 10.07-1.565 14.38-4.811l36.66-27.51c20.48-15.34 45.88-23.81 71.5-23.81h52.53c10.45 0 18.97 8.497 18.97 18.95c0 3.5-1.11 4.94-1.11 9.456c0 26.97 29.77 17.91 29.77 40.64c0 9.254-6.392 10.96-6.392 22.25c0 13.97 10.85 21.95 19.58 23.59c8.953 1.671 15.45 9.481 15.45 18.56c0 13.04-11.39 13.37-11.39 28.91c0 12.54 9.702 23.08 22.36 23.94C456.2 266.1 464 275.2 464 284.1c0 10.43-8.516 18.93-18.97 18.93H307.4c-12.44 0-24 10.02-24 23.1c0 4.038 1.02 8.078 3.066 11.72C304.4 371.7 312 403.8 312 411.2c0 8.044-5.984 20.79-22.06 20.79c-12.53 0-14.27-.9059-24.94-28.07c-24.75-62.91-61.74-99.9-80.98-99.9c-13.8 0-24.02 11.27-24.02 23.99c0 7.041 3.083 14.02 9.016 18.76C238.1 402 211.4 480 289.9 480C333.8 480 360 445 360 411.2c0-12.7-5.328-35.21-14.83-59.33h99.86C481.1 351.9 512 321.9 512 284.1C512 261.8 499.9 241 481.5 229.1z")),"label"=>__("Thumbs Down","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","social")),"thumbs-up"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M128 447.1V223.1c0-17.67-14.33-31.1-32-31.1H32c-17.67 0-32 14.33-32 31.1v223.1c0 17.67 14.33 31.1 32 31.1h64C113.7 479.1 128 465.6 128 447.1zM512 224.1c0-26.5-21.48-47.98-48-47.98h-146.5c22.77-37.91 34.52-80.88 34.52-96.02C352 56.52 333.5 32 302.5 32c-63.13 0-26.36 76.15-108.2 141.6L178 186.6C166.2 196.1 160.2 210 160.1 224c-.0234 .0234 0 0 0 0L160 384c0 15.1 7.113 29.33 19.2 38.39l34.14 25.59C241 468.8 274.7 480 309.3 480H368c26.52 0 48-21.47 48-47.98c0-3.635-.4805-7.143-1.246-10.55C434 415.2 448 397.4 448 376c0-9.148-2.697-17.61-7.139-24.88C463.1 347 480 327.5 480 304.1c0-12.5-4.893-23.78-12.72-32.32C492.2 270.1 512 249.5 512 224.1z"),"regular"=>array("width"=>512,"height"=>512,"path"=>"M96 191.1H32c-17.67 0-32 14.33-32 31.1v223.1c0 17.67 14.33 31.1 32 31.1h64c17.67 0 32-14.33 32-31.1V223.1C128 206.3 113.7 191.1 96 191.1zM512 227c0-36.89-30.05-66.92-66.97-66.92h-99.86C354.7 135.1 360 113.5 360 100.8c0-33.8-26.2-68.78-70.06-68.78c-46.61 0-59.36 32.44-69.61 58.5c-31.66 80.5-60.33 66.39-60.33 93.47c0 12.84 10.36 23.99 24.02 23.99c5.256 0 10.55-1.721 14.97-5.26c76.76-61.37 57.97-122.7 90.95-122.7c16.08 0 22.06 12.75 22.06 20.79c0 7.404-7.594 39.55-25.55 71.59c-2.046 3.646-3.066 7.686-3.066 11.72c0 13.92 11.43 23.1 24 23.1h137.6C455.5 208.1 464 216.6 464 227c0 9.809-7.766 18.03-17.67 18.71c-12.66 .8593-22.36 11.4-22.36 23.94c0 15.47 11.39 15.95 11.39 28.91c0 25.37-35.03 12.34-35.03 42.15c0 11.22 6.392 13.03 6.392 22.25c0 22.66-29.77 13.76-29.77 40.64c0 4.515 1.11 5.961 1.11 9.456c0 10.45-8.516 18.95-18.97 18.95h-52.53c-25.62 0-51.02-8.466-71.5-23.81l-36.66-27.51c-4.315-3.245-9.37-4.811-14.38-4.811c-13.85 0-24.03 11.38-24.03 24.04c0 7.287 3.312 14.42 9.596 19.13l36.67 27.52C235 468.1 270.6 480 306.6 480h52.53c35.33 0 64.36-27.49 66.8-62.2c17.77-12.23 28.83-32.51 28.83-54.83c0-3.046-.2187-6.107-.6406-9.122c17.84-12.15 29.28-32.58 29.28-55.28c0-5.311-.6406-10.54-1.875-15.64C499.9 270.1 512 250.2 512 227z")),"label"=>__("Thumbs Up","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","social")),"thumbtack"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M32 32C32 14.33 46.33 0 64 0H320C337.7 0 352 14.33 352 32C352 49.67 337.7 64 320 64H290.5L301.9 212.2C338.6 232.1 367.5 265.4 381.4 306.9L382.4 309.9C385.6 319.6 383.1 330.4 377.1 338.7C371.9 347.1 362.3 352 352 352H32C21.71 352 12.05 347.1 6.04 338.7C.0259 330.4-1.611 319.6 1.642 309.9L2.644 306.9C16.47 265.4 45.42 232.1 82.14 212.2L93.54 64H64C46.33 64 32 49.67 32 32zM224 384V480C224 497.7 209.7 512 192 512C174.3 512 160 497.7 160 480V384H224z")),"label"=>__("Thumbtack","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","communication","social","travel")),"ticket"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M128 160H448V352H128V160zM512 64C547.3 64 576 92.65 576 128V208C549.5 208 528 229.5 528 256C528 282.5 549.5 304 576 304V384C576 419.3 547.3 448 512 448H64C28.65 448 0 419.3 0 384V304C26.51 304 48 282.5 48 256C48 229.5 26.51 208 0 208V128C0 92.65 28.65 64 64 64H512zM96 352C96 369.7 110.3 384 128 384H448C465.7 384 480 369.7 480 352V160C480 142.3 465.7 128 448 128H128C110.3 128 96 142.3 96 160V352z")),"label"=>__("Ticket","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","travel")),"ticket-simple"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M0 128C0 92.65 28.65 64 64 64H512C547.3 64 576 92.65 576 128V208C549.5 208 528 229.5 528 256C528 282.5 549.5 304 576 304V384C576 419.3 547.3 448 512 448H64C28.65 448 0 419.3 0 384V304C26.51 304 48 282.5 48 256C48 229.5 26.51 208 0 208V128z")),"label"=>__("Ticket Simple","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design","travel")),"tiktok"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M448 209.9a210.1 210.1 0 0 1 -122.8-39.25V349.4A162.6 162.6 0 1 1 185 188.3V278.2a74.62 74.62 0 1 0 52.23 71.18V0l88 0a121.2 121.2 0 0 0 1.86 22.17h0A122.2 122.2 0 0 0 381 102.4a121.4 121.4 0 0 0 67 20.14z")),"label"=>__("TikTok","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"timeline"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M160 224H480V169.3C451.7 156.1 432 128.8 432 96C432 51.82 467.8 16 512 16C556.2 16 592 51.82 592 96C592 128.8 572.3 156.1 544 169.3V224H608C625.7 224 640 238.3 640 256C640 273.7 625.7 288 608 288H352V342.7C380.3 355 400 383.2 400 416C400 460.2 364.2 496 320 496C275.8 496 240 460.2 240 416C240 383.2 259.7 355 288 342.7V288H32C14.33 288 0 273.7 0 256C0 238.3 14.33 224 32 224H96V169.3C67.75 156.1 48 128.8 48 96C48 51.82 83.82 16 128 16C172.2 16 208 51.82 208 96C208 128.8 188.3 156.1 160 169.3V224zM128 120C141.3 120 152 109.3 152 96C152 82.75 141.3 72 128 72C114.7 72 104 82.75 104 96C104 109.3 114.7 120 128 120zM512 72C498.7 72 488 82.75 488 96C488 109.3 498.7 120 512 120C525.3 120 536 109.3 536 96C536 82.75 525.3 72 512 72zM320 440C333.3 440 344 429.3 344 416C344 402.7 333.3 392 320 392C306.7 392 296 402.7 296 416C296 429.3 306.7 440 320 440z")),"label"=>__("Timeline","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"toggle-off"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M192 352C138.1 352 96 309 96 256C96 202.1 138.1 160 192 160C245 160 288 202.1 288 256C288 309 245 352 192 352zM384 448H192C85.96 448 0 362 0 256C0 149.1 85.96 64 192 64H384C490 64 576 149.1 576 256C576 362 490 448 384 448zM384 128H192C121.3 128 64 185.3 64 256C64 326.7 121.3 384 192 384H384C454.7 384 512 326.7 512 256C512 185.3 454.7 128 384 128z")),"label"=>__("Toggle Off","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"toggle-on"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M384 64C490 64 576 149.1 576 256C576 362 490 448 384 448H192C85.96 448 0 362 0 256C0 149.1 85.96 64 192 64H384zM384 352C437 352 480 309 480 256C480 202.1 437 160 384 160C330.1 160 288 202.1 288 256C288 309 330.1 352 384 352z")),"label"=>__("Toggle On","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"toilet"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M432 48C440.8 48 448 40.75 448 32V16C448 7.25 440.8 0 432 0h-416C7.25 0 0 7.25 0 16V32c0 8.75 7.25 16 16 16H32v158.7C11.82 221.2 0 237.1 0 256c0 60.98 33.28 115.2 84.1 150.4l-19.59 64.36C59.16 491.3 74.53 512 96.03 512h255.9c21.5 0 36.88-20.75 30.62-41.25L363 406.4C414.7 371.2 448 316.1 448 256c0-18.04-11.82-34.85-32-49.26V48H432zM96 72C96 67.63 99.63 64 104 64h48C156.4 64 160 67.63 160 72v16C160 92.38 156.4 96 152 96h-48C99.63 96 96 92.38 96 88V72zM224 288C135.6 288 64 273.7 64 256c0-17.67 71.63-32 160-32s160 14.33 160 32C384 273.7 312.4 288 224 288z")),"label"=>__("Toilet","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","travel")),"toilet-paper"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M127.1 0C74.98 0 31.98 86 31.98 192v172.1c0 41.12-9.751 62.75-31.13 126.9C-2.65 501.2 5.101 512 15.98 512h280.9c13.88 0 26-8.75 30.38-21.88c12.88-38.5 24.75-72.37 24.75-126L351.1 192c0-83.62 23.62-153.5 60.5-192H127.1zM95.99 224C87.11 224 79.99 216.9 79.99 208S87.11 192 95.99 192s16 7.125 16 16S104.9 224 95.99 224zM159.1 224c-8.875 0-16-7.125-16-16S151.1 192 159.1 192s16 7.125 16 16S168.9 224 159.1 224zM223.1 224C215.1 224 207.1 216.9 207.1 208S215.1 192 223.1 192c8.875 0 16 7.125 16 16S232.9 224 223.1 224zM287.1 224C279.1 224 271.1 216.9 271.1 208S279.1 192 287.1 192c8.875 0 16 7.125 16 16S296.9 224 287.1 224zM479.1 0c-53 0-96 86.06-96 192.1C383.1 298.1 426.1 384 479.1 384S576 298 576 192C576 86 532.1 0 479.1 0zM479.1 256c-17.63 0-32-28.62-32-64s14.38-64 32-64c17.63 0 32 28.62 32 64S497.6 256 479.1 256z")),"label"=>__("Toilet Paper","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","travel")),"toilet-paper-slash"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M63.98 191.1v172.1c0 41.12-9.75 62.75-31.13 126.9c-3.5 10.25 4.25 20.1 15.13 20.1l280.9-.0059c13.87 0 25.1-8.75 30.37-21.87c10.08-30.15 19.46-57.6 23.1-93.78L66.51 148.8C64.9 162.7 63.98 177.1 63.98 191.1zM630.8 469.1l-109.8-86.02c48.75-9.144 86.94-91.2 86.94-191.1C607.1 86 564.1 0 511.1 0s-96 86-96 191.1c0 49.25 9.362 94.03 24.62 128l-56.62-44.38l.0049-83.65c0-83.62 23.62-153.5 60.5-191.1H159.1C135.2 0 112.7 18.93 95.72 49.72L38.81 5.109C34.41 1.672 29.19 0 24.03 0c-7.125 0-14.19 3.156-18.91 9.187C-3.061 19.62-1.249 34.72 9.189 42.89l591.1 463.1c10.5 8.203 25.56 6.328 33.69-4.078C643.1 492.4 641.2 477.3 630.8 469.1zM479.1 191.1c0-35.37 14.37-64 32-64c17.62 0 32 28.63 32 64S529.6 255.1 511.1 255.1C494.4 255.1 479.1 227.4 479.1 191.1z")),"label"=>__("Toilet Paper Slash","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"toilet-portable"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M0 32C0 14.33 14.33 0 32 0H288C305.7 0 320 14.33 320 32V64H0V32zM320 96V488C320 501.3 309.3 512 296 512C282.7 512 272 501.3 272 488V480H48V488C48 501.3 37.25 512 24 512C10.75 512 0 501.3 0 488V96H320zM256 240C256 231.2 248.8 224 240 224C231.2 224 224 231.2 224 240V304C224 312.8 231.2 320 240 320C248.8 320 256 312.8 256 304V240z")),"label"=>__("Toilet Portable","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"toilets-portable"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M224 0C241.7 0 256 14.33 256 32V64H0V32C0 14.33 14.33 0 32 0H224zM0 96H256V488C256 501.3 245.3 512 232 512C218.7 512 208 501.3 208 488V480H48V488C48 501.3 37.25 512 24 512C10.75 512 0 501.3 0 488V96zM176 240V304C176 312.8 183.2 320 192 320C200.8 320 208 312.8 208 304V240C208 231.2 200.8 224 192 224C183.2 224 176 231.2 176 240zM544 0C561.7 0 576 14.33 576 32V64H320V32C320 14.33 334.3 0 352 0H544zM320 96H576V488C576 501.3 565.3 512 552 512C538.7 512 528 501.3 528 488V480H368V488C368 501.3 357.3 512 344 512C330.7 512 320 501.3 320 488V96zM496 240V304C496 312.8 503.2 320 512 320C520.8 320 528 312.8 528 304V240C528 231.2 520.8 224 512 224C503.2 224 496 231.2 496 240z")),"label"=>__("Toilets Portable","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"toolbox"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M502.6 182.6l-45.25-45.25C451.4 131.4 443.3 128 434.8 128H384V80C384 53.5 362.5 32 336 32h-160C149.5 32 128 53.5 128 80V128H77.25c-8.5 0-16.62 3.375-22.62 9.375L9.375 182.6C3.375 188.6 0 196.8 0 205.3V304h128v-32C128 263.1 135.1 256 144 256h32C184.9 256 192 263.1 192 272v32h128v-32C320 263.1 327.1 256 336 256h32C376.9 256 384 263.1 384 272v32h128V205.3C512 196.8 508.6 188.6 502.6 182.6zM336 128h-160V80h160V128zM384 368c0 8.875-7.125 16-16 16h-32c-8.875 0-16-7.125-16-16v-32H192v32C192 376.9 184.9 384 176 384h-32C135.1 384 128 376.9 128 368v-32H0V448c0 17.62 14.38 32 32 32h448c17.62 0 32-14.38 32-32v-112h-128V368z")),"label"=>__("Toolbox","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"tooth"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M394.1 212.8c-20.04 27.67-28.07 60.15-31.18 93.95c-3.748 41.34-8.785 82.46-17.89 122.8l-6.75 29.64c-2.68 12.14-13.29 20.78-25.39 20.78c-12 0-22.39-8.311-25.29-20.23l-29.57-121.2C254.1 322.6 240.1 311.4 224 311.4c-16.18 0-30.21 11.26-34.07 27.23l-29.57 121.2c-2.893 11.92-13.39 20.23-25.29 20.23c-12.21 0-22.71-8.639-25.5-20.78l-6.643-29.64c-9.105-40.36-14.14-81.48-17.1-122.8C81.93 272.1 73.9 240.5 53.86 212.8c-18.75-25.92-27.11-60.15-18.43-96.57c9.428-39.59 40.39-71.75 78.85-82.03c20.14-5.25 39.54-.4375 57.32 9.077l86.14 56.54c6.643 4.375 15.11 1.86 18.96-4.264c4.07-6.454 2.25-15.09-4.18-19.36l-24.21-15.86c3-1.531 6.215-2.735 9-4.813c22.39-16.84 48.75-28.65 76.39-21.33c38.46 10.28 69.43 42.43 78.85 82.03C421.2 152.7 412.9 187 394.1 212.8z")),"label"=>__("Tooth","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"torii-gate"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M0 80V0L71.37 23.79C87.68 29.23 104.8 32 121.1 32H390C407.2 32 424.3 29.23 440.6 23.79L512 0V80C512 106.5 490.5 128 464 128H448V192H384V128H288V192H224V128H128V192H64V128H48C21.49 128 0 106.5 0 80zM32 288C14.33 288 0 273.7 0 256C0 238.3 14.33 224 32 224H480C497.7 224 512 238.3 512 256C512 273.7 497.7 288 480 288H448V480C448 497.7 433.7 512 416 512C398.3 512 384 497.7 384 480V288H128V480C128 497.7 113.7 512 96 512C78.33 512 64 497.7 64 480V288H32z")),"label"=>__("Torii Gate","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"tornado"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M407.8 42.09c7.531-6.562 10.22-17.12 6.688-26.5C410.1 6.219 401.1 0 391.1 0L24.16 .0313c-13 0-23.66 10.38-24 23.38C-.5495 50.32 1.349 74.22 4.945 95.98h353.9C367.9 80.76 383.4 63.34 407.8 42.09zM387.7 195.9c-22.02-25.33-38.96-44.87-39-67.93H12.05c11.47 40.4 30.38 71.34 53.15 96h345.8C403.4 214.1 395.4 204.8 387.7 195.9zM303.6 485.3c-1.125 10.12 4.249 19.84 13.44 24.28C320.3 511.2 323.9 512 327.4 512c6.219 0 12.34-2.406 16.94-7c43.73-43.61 73.32-83.63 89.35-121h-148.6C300.8 408.6 308.7 440 303.6 485.3zM431.7 255.1H100.5C127.1 276.3 155.8 291.6 182.4 305.8c28.14 15.01 54.04 28.9 74.73 46.14h186.8C446.4 341.1 447.1 330.4 448 320C448 295.4 441.4 274.6 431.7 255.1z")),"label"=>__("Tornado","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment")),"tower-broadcast"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M160.9 59.01C149.3 52.6 134.7 56.76 128.3 68.39C117.6 87.6 112 109.4 112 131.4c0 19.03 4.031 37.44 11.98 54.62c4.047 8.777 12.73 13.93 21.8 13.93c3.375 0 6.797-.7187 10.05-2.219C167.9 192.2 173.1 177.1 167.5 165.9C162.5 155.1 160 143.5 160 131.4c0-13.93 3.547-27.69 10.25-39.81C176.7 80.04 172.5 65.42 160.9 59.01zM62.61 2.363C46.17-4.32 27.58 3.676 20.95 20.02C7.047 54.36 0 90.69 0 127.1C0 165.3 7.047 201.7 20.95 236C25.98 248.5 37.97 256 50.63 256C54.61 256 58.69 255.3 62.61 253.7C79 247 86.91 228.4 80.27 212C69.47 185.3 64 157.1 64 128c0-29.06 5.469-57.3 16.27-83.99C86.91 27.64 79 8.988 62.61 2.363zM555 20.02c-6.609-16.41-25.23-24.31-41.66-17.66c-16.39 6.625-24.3 25.28-17.66 41.65C506.5 70.7 512 98.95 512 128c0 29.06-5.469 57.31-16.27 83.1C489.1 228.4 497 247 513.4 253.7C517.3 255.3 521.4 256 525.4 256c12.66 0 24.64-7.562 29.67-20C568.1 201.7 576 165.3 576 127.1C576 90.69 568.1 54.36 555 20.02zM420.2 58.23c-12.03 5.562-17.28 19.81-11.72 31.84C413.5 100.9 416 112.5 416 124.6c0 13.94-3.547 27.69-10.25 39.81c-6.422 11.59-2.219 26.22 9.375 32.62c3.688 2.031 7.672 3 11.61 3c8.438 0 16.64-4.47 21.02-12.37C458.4 168.4 464 146.6 464 124.6c0-19.03-4.031-37.43-11.98-54.62C446.5 57.89 432.1 52.7 420.2 58.23zM301.8 65.45C260.5 56.78 224 88.13 224 128c0 23.63 12.95 44.04 32 55.12v296.9c0 17.67 14.33 32 32 32s32-14.33 32-32V183.1c23.25-13.54 37.42-40.96 30.03-71.18C344.4 88.91 325 70.31 301.8 65.45z")),"label"=>__("Tower Broadcast","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","science-and-technology","travel")),"tower-cell"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M62.62 2.339C78.1 8.97 86.9 27.63 80.27 44.01C69.79 69.9 64 98.24 64 128C64 157.8 69.79 186.1 80.27 211.1C86.9 228.4 78.1 247 62.62 253.7C46.23 260.3 27.58 252.4 20.95 236C7.428 202.6 0 166.1 0 128C0 89.87 7.428 53.39 20.95 19.99C27.58 3.612 46.23-4.293 62.62 2.339V2.339zM513.4 2.339C529.8-4.293 548.4 3.612 555.1 19.99C568.6 53.39 576 89.87 576 128C576 166.1 568.6 202.6 555.1 236C548.4 252.4 529.8 260.3 513.4 253.7C497 247 489.1 228.4 495.7 211.1C506.2 186.1 512 157.8 512 128C512 98.24 506.2 69.9 495.7 44.01C489.1 27.63 497 8.969 513.4 2.338V2.339zM477.1 466.8C484.4 482.8 477.3 501.8 461.2 509.1C445.2 516.4 426.2 509.3 418.9 493.2L398.3 448H177.7L157.1 493.2C149.8 509.3 130.8 516.4 114.8 509.1C98.67 501.8 91.56 482.8 98.87 466.8L235.9 165.2C228.4 154.7 224 141.9 224 128C224 92.65 252.7 64 288 64C323.3 64 352 92.65 352 128C352 141.9 347.6 154.7 340.1 165.2L477.1 466.8zM369.2 384L354.7 352H221.3L206.8 384H369.2zM250.4 288H325.6L288 205.3L250.4 288zM152 128C152 147.4 156 165.8 163.3 182.4C168.6 194.5 163.1 208.7 150.9 213.1C138.8 219.3 124.6 213.8 119.3 201.6C109.5 179 104 154.1 104 128C104 101.9 109.5 76.96 119.3 54.39C124.6 42.25 138.8 36.7 150.9 42.01C163.1 47.31 168.6 61.46 163.3 73.61C156 90.23 152 108.6 152 128V128zM472 128C472 154.1 466.5 179 456.7 201.6C451.4 213.8 437.2 219.3 425.1 213.1C412.9 208.7 407.4 194.5 412.7 182.4C419.1 165.8 424 147.4 424 128C424 108.6 419.1 90.24 412.7 73.61C407.4 61.46 412.9 47.32 425.1 42.01C437.2 36.7 451.4 42.25 456.7 54.39C466.5 76.96 472 101.9 472 128V128z")),"label"=>__("Tower Cell","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","science-and-technology","travel")),"tower-observation"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M241.7 3.378C250.7-1.126 261.3-1.126 270.3 3.378L430.3 83.38C446.1 91.28 452.5 110.5 444.6 126.3C439 137.5 427.7 143.1 416 144V224C416 241.7 401.7 256 384 256H379.1L411.1 448H480C497.7 448 512 462.3 512 480C512 497.7 497.7 512 480 512H384.5C384.2 512 383.8 512 383.4 512H128.6C128.2 512 127.9 512 127.5 512H32C14.33 512 0 497.7 0 480C0 462.3 14.33 448 32 448H100.9L132.9 256H128C110.3 256 96 241.7 96 224V144C84.27 143.1 72.98 137.5 67.38 126.3C59.47 110.5 65.88 91.28 81.69 83.38L241.7 3.378zM314.5 448L256 399.2L197.5 448H314.5zM193.1 284.3L256 336.8L318.9 284.3L314.2 256H197.8L193.1 284.3zM183.9 339.2L172.8 406.1L218.5 368L183.9 339.2zM293.5 368L339.2 406.1L328.1 339.2L293.5 368zM176 128C167.2 128 160 135.2 160 144C160 152.8 167.2 160 176 160H336C344.8 160 352 152.8 352 144C352 135.2 344.8 128 336 128H176z")),"label"=>__("Tower Observation","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","science-and-technology")),"tractor"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M96 64C96 28.65 124.7 0 160 0H266.3C292.5 0 316 15.93 325.8 40.23L373.7 160H480V126.2C480 101.4 485.8 76.88 496.9 54.66L499.4 49.69C507.3 33.88 526.5 27.47 542.3 35.38C558.1 43.28 564.5 62.5 556.6 78.31L554.1 83.28C547.5 96.61 544 111.3 544 126.2V160H600C622.1 160 640 177.9 640 200V245.4C640 261.9 631.5 277.3 617.4 286.1L574.1 313.2C559.9 307.3 544.3 304 528 304C488.7 304 453.9 322.9 431.1 352H352C352 369.7 337.7 384 320 384H311.8C310.1 388.8 308.2 393.5 305.1 398.1L311.8 403.9C324.3 416.4 324.3 436.6 311.8 449.1L289.1 471.8C276.6 484.3 256.4 484.3 243.9 471.8L238.1 465.1C233.5 468.2 228.8 470.1 224 471.8V480C224 497.7 209.7 512 192 512H160C142.3 512 128 497.7 128 480V471.8C123.2 470.1 118.5 468.2 113.9 465.1L108.1 471.8C95.62 484.3 75.36 484.3 62.86 471.8L40.24 449.1C27.74 436.6 27.74 416.4 40.24 403.9L46.03 398.1C43.85 393.5 41.9 388.8 40.19 384H32C14.33 384 0 369.7 0 352V320C0 302.3 14.33 288 32 288H40.19C41.9 283.2 43.85 278.5 46.03 273.9L40.24 268.1C27.74 255.6 27.74 235.4 40.24 222.9L62.86 200.2C71.82 191.3 84.78 188.7 96 192.6L96 64zM160 64V160H304.7L266.3 64H160zM176 256C131.8 256 96 291.8 96 336C96 380.2 131.8 416 176 416C220.2 416 256 380.2 256 336C256 291.8 220.2 256 176 256zM440 424C440 394.2 454.8 367.9 477.4 352C491.7 341.9 509.2 336 528 336C530.7 336 533.3 336.1 535.9 336.3C580.8 340.3 616 378.1 616 424C616 472.6 576.6 512 528 512C479.4 512 440 472.6 440 424zM528 448C541.3 448 552 437.3 552 424C552 410.7 541.3 400 528 400C514.7 400 504 410.7 504 424C504 437.3 514.7 448 528 448z")),"label"=>__("Tractor","ultimate-addons-for-gutenberg"),"custom_categories"=>array("travel")),"trade-federation"=>array("svg"=>array("brands"=>array("width"=>496,"height"=>512,"path"=>"M248 8.8c-137 0-248 111-248 248s111 248 248 248 248-111 248-248-111-248-248-248zm0 482.8c-129.7 0-234.8-105.1-234.8-234.8S118.3 22 248 22s234.8 105.1 234.8 234.8S377.7 491.6 248 491.6zm155.1-328.5v-46.8H209.3V198H54.2l36.7 46h117.7v196.8h48.8V245h83.3v-47h-83.3v-34.8h145.7zm-73.3 45.1v23.9h-82.9v197.4h-26.8V232.1H96.3l-20.1-23.9h143.9v-80.6h171.8V152h-145v56.2zm-161.3-69l-12.4-20.7 2.1 23.8-23.5 5.4 23.3 5.4-2.1 24 12.3-20.5 22.2 9.5-15.7-18.1 15.8-18.1zm-29.6-19.7l9.3-11.5-12.7 5.9-8-12.4 1.7 13.9-14.3 3.8 13.7 2.7-.8 14.7 6.8-12.2 13.8 5.3zm165.4 145.2l-13.1 5.6-7.3-12.2 1.3 14.2-13.9 3.2 13.9 3.2-1.2 14.2 7.3-12.2 13.1 5.5-9.4-10.7zm106.9-77.2l-20.9 9.1-12-19.6 2.2 22.7-22.3 5.4 22.2 4.9-1.8 22.9 11.5-19.6 21.2 8.8-15.1-17zM248 29.9c-125.3 0-226.9 101.6-226.9 226.9S122.7 483.7 248 483.7s226.9-101.6 226.9-226.9S373.3 29.9 248 29.9zM342.6 196v51h-83.3v195.7h-52.7V245.9H89.9l-40-49.9h157.4v-81.6h197.8v50.7H259.4V196zM248 43.2c60.3 0 114.8 25 153.6 65.2H202.5V190H45.1C73.1 104.8 153.4 43.2 248 43.2zm0 427.1c-117.9 0-213.6-95.6-213.6-213.5 0-21.2 3.1-41.8 8.9-61.1L87.1 252h114.7v196.8h64.6V253h83.3v-62.7h-83.2v-19.2h145.6v-50.8c30.8 37 49.3 84.6 49.3 136.5 .1 117.9-95.5 213.5-213.4 213.5zM178.8 275l-11-21.4 1.7 24.5-23.7 3.9 23.8 5.9-3.7 23.8 13-20.9 21.5 10.8-15.8-18.8 16.9-17.1z")),"label"=>__("Trade Federation","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"trademark"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M618.1 97.67c-13.02-4.375-27.45 .1562-35.72 11.16L464 266.7l-118.4-157.8c-8.266-11.03-22.64-15.56-35.72-11.16C296.8 102 288 114.2 288 128v256c0 17.69 14.33 32 32 32s32-14.31 32-32v-160l86.41 115.2c12.06 16.12 39.13 16.12 51.19 0L576 224v160c0 17.69 14.33 32 32 32s32-14.31 32-32v-256C640 114.2 631.2 102 618.1 97.67zM224 96.01H32c-17.67 0-32 14.31-32 32s14.33 32 32 32h64v223.1c0 17.69 14.33 31.99 32 31.99s32-14.3 32-31.99V160h64c17.67 0 32-14.31 32-32S241.7 96.01 224 96.01z")),"label"=>__("Trademark","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","brands","brands","social")),"traffic-light"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M256 0C291.3 0 320 28.65 320 64V352C320 440.4 248.4 512 160 512C71.63 512 0 440.4 0 352V64C0 28.65 28.65 0 64 0H256zM160 320C133.5 320 112 341.5 112 368C112 394.5 133.5 416 160 416C186.5 416 208 394.5 208 368C208 341.5 186.5 320 160 320zM160 288C186.5 288 208 266.5 208 240C208 213.5 186.5 192 160 192C133.5 192 112 213.5 112 240C112 266.5 133.5 288 160 288zM160 64C133.5 64 112 85.49 112 112C112 138.5 133.5 160 160 160C186.5 160 208 138.5 208 112C208 85.49 186.5 64 160 64z")),"label"=>__("Traffic Light","ultimate-addons-for-gutenberg"),"custom_categories"=>array("travel")),"trailer"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M496 32C522.5 32 544 53.49 544 80V320H608C625.7 320 640 334.3 640 352C640 369.7 625.7 384 608 384H286.9C279.1 329.7 232.4 288 176 288C119.6 288 72.9 329.7 65.13 384H48C21.49 384 0 362.5 0 336V80C0 53.49 21.49 32 48 32H496zM64 112V264.2C73.83 256.1 84.55 249 96 243.2V112C96 103.2 88.84 96 80 96C71.16 96 64 103.2 64 112V112zM176 224C181.4 224 186.7 224.2 192 224.7V112C192 103.2 184.8 96 176 96C167.2 96 160 103.2 160 112V224.7C165.3 224.2 170.6 224 176 224zM256 243.2C267.4 249 278.2 256.1 288 264.2V112C288 103.2 280.8 96 272 96C263.2 96 256 103.2 256 112V243.2zM352 112V304C352 312.8 359.2 320 368 320C376.8 320 384 312.8 384 304V112C384 103.2 376.8 96 368 96C359.2 96 352 103.2 352 112zM480 112C480 103.2 472.8 96 464 96C455.2 96 448 103.2 448 112V304C448 312.8 455.2 320 464 320C472.8 320 480 312.8 480 304V112zM96 400C96 355.8 131.8 320 176 320C220.2 320 256 355.8 256 400C256 444.2 220.2 480 176 480C131.8 480 96 444.2 96 400zM176 432C193.7 432 208 417.7 208 400C208 382.3 193.7 368 176 368C158.3 368 144 382.3 144 400C144 417.7 158.3 432 176 432z")),"label"=>__("Trailer","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies","travel")),"train"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M352 0C405 0 448 42.98 448 96V352C448 399.1 412.8 439.7 366.9 446.9L412.9 492.9C419.9 499.9 414.9 512 404.1 512H365.3C356.8 512 348.6 508.6 342.6 502.6L288 448H160L105.4 502.6C99.37 508.6 91.23 512 82.75 512H43.04C33.06 512 28.06 499.9 35.12 492.9L81.14 446.9C35.18 439.7 0 399.1 0 352V96C0 42.98 42.98 0 96 0H352zM64 192C64 209.7 78.33 224 96 224H352C369.7 224 384 209.7 384 192V96C384 78.33 369.7 64 352 64H96C78.33 64 64 78.33 64 96V192zM224 384C250.5 384 272 362.5 272 336C272 309.5 250.5 288 224 288C197.5 288 176 309.5 176 336C176 362.5 197.5 384 224 384z")),"label"=>__("Train","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"train-subway"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M352 0C405 0 448 42.98 448 96V352C448 399.1 412.8 439.7 366.9 446.9L412.9 492.9C419.9 499.9 414.9 512 404.1 512H365.3C356.8 512 348.6 508.6 342.6 502.6L288 448H160L105.4 502.6C99.37 508.6 91.23 512 82.75 512H43.04C33.06 512 28.06 499.9 35.12 492.9L81.14 446.9C35.18 439.7 0 399.1 0 352V96C0 42.98 42.98 0 96 0H352zM64 224C64 241.7 78.33 256 96 256H176C193.7 256 208 241.7 208 224V128C208 110.3 193.7 96 176 96H96C78.33 96 64 110.3 64 128V224zM272 96C254.3 96 240 110.3 240 128V224C240 241.7 254.3 256 272 256H352C369.7 256 384 241.7 384 224V128C384 110.3 369.7 96 352 96H272zM96 320C78.33 320 64 334.3 64 352C64 369.7 78.33 384 96 384C113.7 384 128 369.7 128 352C128 334.3 113.7 320 96 320zM352 384C369.7 384 384 369.7 384 352C384 334.3 369.7 320 352 320C334.3 320 320 334.3 320 352C320 369.7 334.3 384 352 384z")),"label"=>__("Train Subway","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"train-tram"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M86.76 48C74.61 48 63.12 53.52 55.53 63.01L42.74 78.99C34.46 89.34 19.36 91.02 9.007 82.74C-1.343 74.46-3.021 59.36 5.259 49.01L18.04 33.03C34.74 12.15 60.03 0 86.76 0H361.2C387.1 0 413.3 12.15 429.1 33.03L442.7 49.01C451 59.36 449.3 74.46 438.1 82.74C428.6 91.02 413.5 89.34 405.3 78.99L392.5 63.01C384.9 53.52 373.4 48 361.2 48H248V96H288C341 96 384 138.1 384 192V352C384 382.6 369.7 409.8 347.4 427.4L412.9 492.9C419.9 499.9 414.9 512 404.1 512H365.3C356.8 512 348.6 508.6 342.6 502.6L288 448H160L105.4 502.6C99.37 508.6 91.23 512 82.74 512H43.04C33.06 512 28.06 499.9 35.12 492.9L100.6 427.4C78.3 409.8 64 382.6 64 352V192C64 138.1 106.1 96 160 96H200V48H86.76zM160 160C142.3 160 128 174.3 128 192V224C128 241.7 142.3 256 160 256H288C305.7 256 320 241.7 320 224V192C320 174.3 305.7 160 288 160H160zM160 320C142.3 320 128 334.3 128 352C128 369.7 142.3 384 160 384C177.7 384 192 369.7 192 352C192 334.3 177.7 320 160 320zM288 384C305.7 384 320 369.7 320 352C320 334.3 305.7 320 288 320C270.3 320 256 334.3 256 352C256 369.7 270.3 384 288 384z")),"label"=>__("Train Tram","ultimate-addons-for-gutenberg"),"custom_categories"=>array("travel")),"transgender"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M498.6 .0003h-94.37c-17.96 0-26.95 21.71-14.25 34.41L411.1 55.61l-67.01 67.01C318.8 105.9 288.6 96 256 96S193.2 105.9 167.9 122.6L151.6 106.3l6.061-6.062c6.25-6.248 6.25-16.38 0-22.63L146.3 66.34c-6.25-6.248-16.38-6.248-22.63 0L117.7 72.41L100.9 55.61L122.1 34.41c12.7-12.7 3.703-34.41-14.25-34.41H13.44C6.016 .0003 0 6.016 0 13.44v94.37c0 17.96 21.71 26.95 34.41 14.25l21.2-21.2l16.8 16.8L66.35 123.7c-6.25 6.248-6.25 16.38 0 22.63l11.31 11.31c6.25 6.248 16.38 6.248 22.63 0l6.061-6.061L122.6 167.9C105.9 193.2 96 223.4 96 256c0 77.4 54.97 141.9 128 156.8v19.23l-16-.0014c-8.836 0-16 7.165-16 16v15.1c0 8.836 7.164 16 16 16L224 480v16c0 8.836 7.164 16 16 16h32c8.836 0 16-7.164 16-16v-16l16-.0001c8.836 0 16-7.164 16-16v-15.1c0-8.836-7.164-16-16-16L288 432v-19.23c73.03-14.83 128-79.37 128-156.8c0-32.6-9.867-62.85-26.61-88.14l67.01-67.01l21.2 21.2C490.3 134.8 512 125.8 512 107.8V13.44C512 6.016 505.1 .0003 498.6 .0003zM256 336c-44.11 0-80-35.89-80-80c0-44.11 35.89-80 80-80c44.11 0 80 35.89 80 80C336 300.1 300.1 336 256 336z")),"label"=>__("Transgender","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"trash"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M135.2 17.69C140.6 6.848 151.7 0 163.8 0H284.2C296.3 0 307.4 6.848 312.8 17.69L320 32H416C433.7 32 448 46.33 448 64C448 81.67 433.7 96 416 96H32C14.33 96 0 81.67 0 64C0 46.33 14.33 32 32 32H128L135.2 17.69zM394.8 466.1C393.2 492.3 372.3 512 346.9 512H101.1C75.75 512 54.77 492.3 53.19 466.1L31.1 128H416L394.8 466.1z")),"label"=>__("Trash","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design")),"trash-arrow-up"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M284.2 0C296.3 0 307.4 6.848 312.8 17.69L320 32H416C433.7 32 448 46.33 448 64C448 81.67 433.7 96 416 96H32C14.33 96 0 81.67 0 64C0 46.33 14.33 32 32 32H128L135.2 17.69C140.6 6.848 151.7 0 163.8 0H284.2zM31.1 128H416L394.8 466.1C393.2 492.3 372.3 512 346.9 512H101.1C75.75 512 54.77 492.3 53.19 466.1L31.1 128zM207 199L127 279C117.7 288.4 117.7 303.6 127 312.1C136.4 322.3 151.6 322.3 160.1 312.1L199.1 273.9V408C199.1 421.3 210.7 432 223.1 432C237.3 432 248 421.3 248 408V273.9L287 312.1C296.4 322.3 311.6 322.3 320.1 312.1C330.3 303.6 330.3 288.4 320.1 279L240.1 199C236.5 194.5 230.4 191.1 223.1 191.1C217.6 191.1 211.5 194.5 207 199V199z")),"label"=>__("Trash Arrow Up","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design")),"trash-can"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M135.2 17.69C140.6 6.848 151.7 0 163.8 0H284.2C296.3 0 307.4 6.848 312.8 17.69L320 32H416C433.7 32 448 46.33 448 64C448 81.67 433.7 96 416 96H32C14.33 96 0 81.67 0 64C0 46.33 14.33 32 32 32H128L135.2 17.69zM31.1 128H416V448C416 483.3 387.3 512 352 512H95.1C60.65 512 31.1 483.3 31.1 448V128zM111.1 208V432C111.1 440.8 119.2 448 127.1 448C136.8 448 143.1 440.8 143.1 432V208C143.1 199.2 136.8 192 127.1 192C119.2 192 111.1 199.2 111.1 208zM207.1 208V432C207.1 440.8 215.2 448 223.1 448C232.8 448 240 440.8 240 432V208C240 199.2 232.8 192 223.1 192C215.2 192 207.1 199.2 207.1 208zM304 208V432C304 440.8 311.2 448 320 448C328.8 448 336 440.8 336 432V208C336 199.2 328.8 192 320 192C311.2 192 304 199.2 304 208z"),"regular"=>array("width"=>448,"height"=>512,"path"=>"M160 400C160 408.8 152.8 416 144 416C135.2 416 128 408.8 128 400V192C128 183.2 135.2 176 144 176C152.8 176 160 183.2 160 192V400zM240 400C240 408.8 232.8 416 224 416C215.2 416 208 408.8 208 400V192C208 183.2 215.2 176 224 176C232.8 176 240 183.2 240 192V400zM320 400C320 408.8 312.8 416 304 416C295.2 416 288 408.8 288 400V192C288 183.2 295.2 176 304 176C312.8 176 320 183.2 320 192V400zM317.5 24.94L354.2 80H424C437.3 80 448 90.75 448 104C448 117.3 437.3 128 424 128H416V432C416 476.2 380.2 512 336 512H112C67.82 512 32 476.2 32 432V128H24C10.75 128 0 117.3 0 104C0 90.75 10.75 80 24 80H93.82L130.5 24.94C140.9 9.357 158.4 0 177.1 0H270.9C289.6 0 307.1 9.358 317.5 24.94H317.5zM151.5 80H296.5L277.5 51.56C276 49.34 273.5 48 270.9 48H177.1C174.5 48 171.1 49.34 170.5 51.56L151.5 80zM80 432C80 449.7 94.33 464 112 464H336C353.7 464 368 449.7 368 432V128H80V432z")),"label"=>__("Trash Can","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design")),"trash-can-arrow-up"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M284.2 0C296.3 0 307.4 6.848 312.8 17.69L320 32H416C433.7 32 448 46.33 448 64C448 81.67 433.7 96 416 96H32C14.33 96 0 81.67 0 64C0 46.33 14.33 32 32 32H128L135.2 17.69C140.6 6.848 151.7 0 163.8 0H284.2zM31.1 128H416V448C416 483.3 387.3 512 352 512H95.1C60.65 512 31.1 483.3 31.1 448V128zM207 199L127 279C117.7 288.4 117.7 303.6 127 312.1C136.4 322.3 151.6 322.3 160.1 312.1L199.1 273.9V408C199.1 421.3 210.7 432 223.1 432C237.3 432 248 421.3 248 408V273.9L287 312.1C296.4 322.3 311.6 322.3 320.1 312.1C330.3 303.6 330.3 288.4 320.1 279L240.1 199C236.5 194.5 230.4 191.1 223.1 191.1C217.6 191.1 211.5 194.5 207 199V199z")),"label"=>__("Trash Can Arrow Up","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design")),"tree"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M413.8 447.1L256 448l0 31.99C256 497.7 241.8 512 224.1 512c-17.67 0-32.1-14.32-32.1-31.99l0-31.99l-158.9-.0099c-28.5 0-43.69-34.49-24.69-56.4l68.98-79.59H62.22c-25.41 0-39.15-29.8-22.67-49.13l60.41-70.85H89.21c-21.28 0-32.87-22.5-19.28-37.31l134.8-146.5c10.4-11.3 28.22-11.3 38.62-.0033l134.9 146.5c13.62 14.81 2.001 37.31-19.28 37.31h-10.77l60.35 70.86c16.46 19.34 2.716 49.12-22.68 49.12h-15.2l68.98 79.59C458.7 413.7 443.1 447.1 413.8 447.1z")),"label"=>__("Tree","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment","lifestyle-and-hobbies","travel")),"tree-city"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M288 48C288 21.49 309.5 0 336 0H432C458.5 0 480 21.49 480 48V192H520V120C520 106.7 530.7 96 544 96C557.3 96 568 106.7 568 120V192H592C618.5 192 640 213.5 640 240V464C640 490.5 618.5 512 592 512H336C309.5 512 288 490.5 288 464V48zM352 112C352 120.8 359.2 128 368 128H400C408.8 128 416 120.8 416 112V80C416 71.16 408.8 64 400 64H368C359.2 64 352 71.16 352 80V112zM368 160C359.2 160 352 167.2 352 176V208C352 216.8 359.2 224 368 224H400C408.8 224 416 216.8 416 208V176C416 167.2 408.8 160 400 160H368zM352 304C352 312.8 359.2 320 368 320H400C408.8 320 416 312.8 416 304V272C416 263.2 408.8 256 400 256H368C359.2 256 352 263.2 352 272V304zM528 256C519.2 256 512 263.2 512 272V304C512 312.8 519.2 320 528 320H560C568.8 320 576 312.8 576 304V272C576 263.2 568.8 256 560 256H528zM512 400C512 408.8 519.2 416 528 416H560C568.8 416 576 408.8 576 400V368C576 359.2 568.8 352 560 352H528C519.2 352 512 359.2 512 368V400zM224 160C224 166 223 171 222 176C242 190 256 214 256 240C256 285 220 320 176 320H160V480C160 498 145 512 128 512C110 512 96 498 96 480V320H80C35 320 0 285 0 240C0 214 13 190 33 176C32 171 32 166 32 160C32 107 74 64 128 64C181 64 224 107 224 160z")),"label"=>__("Tree City","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"trello"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M392.3 32H56.1C25.1 32 0 57.1 0 88c-.1 0 0-4 0 336 0 30.9 25.1 56 56 56h336.2c30.8-.2 55.7-25.2 55.7-56V88c.1-30.8-24.8-55.8-55.6-56zM197 371.3c-.2 14.7-12.1 26.6-26.9 26.6H87.4c-14.8 .1-26.9-11.8-27-26.6V117.1c0-14.8 12-26.9 26.9-26.9h82.9c14.8 0 26.9 12 26.9 26.9v254.2zm193.1-112c0 14.8-12 26.9-26.9 26.9h-81c-14.8 0-26.9-12-26.9-26.9V117.2c0-14.8 12-26.9 26.8-26.9h81.1c14.8 0 26.9 12 26.9 26.9v142.1z")),"label"=>__("Trello","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","brands","social","social")),"triangle-exclamation"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M506.3 417l-213.3-364c-16.33-28-57.54-28-73.98 0l-213.2 364C-10.59 444.9 9.849 480 42.74 480h426.6C502.1 480 522.6 445 506.3 417zM232 168c0-13.25 10.75-24 24-24S280 154.8 280 168v128c0 13.25-10.75 24-23.1 24S232 309.3 232 296V168zM256 416c-17.36 0-31.44-14.08-31.44-31.44c0-17.36 14.07-31.44 31.44-31.44s31.44 14.08 31.44 31.44C287.4 401.9 273.4 416 256 416z")),"label"=>__("Triangle Exclamation","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"trophy"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M572.1 82.38C569.5 71.59 559.8 64 548.7 64h-100.8c.2422-12.45 .1078-23.7-.1559-33.02C447.3 13.63 433.2 0 415.8 0H160.2C142.8 0 128.7 13.63 128.2 30.98C127.1 40.3 127.8 51.55 128.1 64H27.26C16.16 64 6.537 71.59 3.912 82.38C3.1 85.78-15.71 167.2 37.07 245.9c37.44 55.82 100.6 95.03 187.5 117.4c18.7 4.805 31.41 22.06 31.41 41.37C256 428.5 236.5 448 212.6 448H208c-26.51 0-47.99 21.49-47.99 48c0 8.836 7.163 16 15.1 16h223.1c8.836 0 15.1-7.164 15.1-16c0-26.51-21.48-48-47.99-48h-4.644c-23.86 0-43.36-19.5-43.36-43.35c0-19.31 12.71-36.57 31.41-41.37c86.96-22.34 150.1-61.55 187.5-117.4C591.7 167.2 572.9 85.78 572.1 82.38zM77.41 219.8C49.47 178.6 47.01 135.7 48.38 112h80.39c5.359 59.62 20.35 131.1 57.67 189.1C137.4 281.6 100.9 254.4 77.41 219.8zM498.6 219.8c-23.44 34.6-59.94 61.75-109 81.22C426.9 243.1 441.9 171.6 447.2 112h80.39C528.1 135.7 526.5 178.7 498.6 219.8z")),"label"=>__("Trophy","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","travel")),"trowel"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M343.9 213.4L245.3 312L310.6 377.4C318.5 385.3 321.8 396.8 319.1 407.6C316.4 418.5 308.2 427.2 297.5 430.5L41.55 510.5C30.18 514.1 17.79 511 9.373 502.6C.9565 494.2-2.093 481.8 1.458 470.5L81.46 214.5C84.8 203.8 93.48 195.6 104.4 192.9C115.2 190.3 126.7 193.5 134.6 201.4L200 266.7L298.6 168.1C284.4 153.5 284.5 130.1 298.9 115.6L394.4 20.18C421.3-6.728 464.9-6.728 491.8 20.18C518.7 47.1 518.7 90.73 491.8 117.6L396.4 213.1C381.9 227.5 358.5 227.6 343.9 213.4V213.4z")),"label"=>__("Trowel","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"trowel-bricks"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M240.8 4.779C250.3 10.61 256 20.91 256 32V104H345C348.6 90.2 361.1 80 376 80H464C490.5 80 512 101.5 512 128C512 154.5 490.5 176 464 176H376C361.1 176 348.6 165.8 345 152H256V224C256 235.1 250.3 245.4 240.8 251.2C231.4 257.1 219.6 257.6 209.7 252.6L17.69 156.6C6.848 151.2 0 140.1 0 128C0 115.9 6.848 104.8 17.69 99.38L209.7 3.378C219.6-1.581 231.4-1.051 240.8 4.779V4.779zM288 256C288 238.3 302.3 224 320 224H480C497.7 224 512 238.3 512 256V320C512 337.7 497.7 352 480 352H320C302.3 352 288 337.7 288 320V256zM128 384C145.7 384 160 398.3 160 416V480C160 497.7 145.7 512 128 512H32C14.33 512 0 497.7 0 480V416C0 398.3 14.33 384 32 384H128zM480 384C497.7 384 512 398.3 512 416V480C512 497.7 497.7 512 480 512H224C206.3 512 192 497.7 192 480V416C192 398.3 206.3 384 224 384H480z")),"label"=>__("Trowel Bricks","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"truck"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M368 0C394.5 0 416 21.49 416 48V96H466.7C483.7 96 499.1 102.7 512 114.7L589.3 192C601.3 204 608 220.3 608 237.3V352C625.7 352 640 366.3 640 384C640 401.7 625.7 416 608 416H576C576 469 533 512 480 512C426.1 512 384 469 384 416H256C256 469 213 512 160 512C106.1 512 64 469 64 416H48C21.49 416 0 394.5 0 368V48C0 21.49 21.49 0 48 0H368zM416 160V256H544V237.3L466.7 160H416zM160 368C133.5 368 112 389.5 112 416C112 442.5 133.5 464 160 464C186.5 464 208 442.5 208 416C208 389.5 186.5 368 160 368zM480 464C506.5 464 528 442.5 528 416C528 389.5 506.5 368 480 368C453.5 368 432 389.5 432 416C432 442.5 453.5 464 480 464z")),"label"=>__("Truck","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies","travel")),"truck-arrow-right"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M0 48C0 21.49 21.49 0 48 0H368C394.5 0 416 21.49 416 48V96H466.7C483.7 96 499.1 102.7 512 114.7L589.3 192C601.3 204 608 220.3 608 237.3V352C625.7 352 640 366.3 640 384C640 401.7 625.7 416 608 416H576C576 469 533 512 480 512C426.1 512 384 469 384 416H256C256 469 213 512 160 512C106.1 512 64 469 64 416H48C21.49 416 0 394.5 0 368V48zM544 256V237.3L466.7 160H416V256H544zM160 464C186.5 464 208 442.5 208 416C208 389.5 186.5 368 160 368C133.5 368 112 389.5 112 416C112 442.5 133.5 464 160 464zM480 368C453.5 368 432 389.5 432 416C432 442.5 453.5 464 480 464C506.5 464 528 442.5 528 416C528 389.5 506.5 368 480 368zM256.1 95.03C247.6 85.66 232.4 85.66 223 95.03C213.7 104.4 213.7 119.6 223 128.1L262.1 168H96C82.75 168 72 178.7 72 192C72 205.3 82.75 216 96 216H262.1L223 255C213.7 264.4 213.7 279.6 223 288.1C232.4 298.3 247.6 298.3 256.1 288.1L336.1 208.1C346.3 199.6 346.3 184.4 336.1 175L256.1 95.03z")),"label"=>__("Truck Arrow Right","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"truck-droplet"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M0 48C0 21.49 21.49 0 48 0H368C394.5 0 416 21.49 416 48V96H466.7C483.7 96 499.1 102.7 512 114.7L589.3 192C601.3 204 608 220.3 608 237.3V352C625.7 352 640 366.3 640 384C640 401.7 625.7 416 608 416H576C576 469 533 512 480 512C426.1 512 384 469 384 416H256C256 469 213 512 160 512C106.1 512 64 469 64 416H48C21.49 416 0 394.5 0 368V48zM544 256V237.3L466.7 160H416V256H544zM160 464C186.5 464 208 442.5 208 416C208 389.5 186.5 368 160 368C133.5 368 112 389.5 112 416C112 442.5 133.5 464 160 464zM480 368C453.5 368 432 389.5 432 416C432 442.5 453.5 464 480 464C506.5 464 528 442.5 528 416C528 389.5 506.5 368 480 368zM208 272C247.8 272 280 242.4 280 205.1C280 179 240.6 123 220.1 95.71C213.1 87.54 202 87.54 195.9 95.71C175.4 123 136 179 136 205.1C136 242.4 168.2 272 208 272V272z")),"label"=>__("Truck Droplet","ultimate-addons-for-gutenberg"),"custom_categories"=>array("travel")),"truck-fast"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M112 0C85.49 0 64 21.49 64 48V96H16C7.163 96 0 103.2 0 112C0 120.8 7.163 128 16 128H272C280.8 128 288 135.2 288 144C288 152.8 280.8 160 272 160H48C39.16 160 32 167.2 32 176C32 184.8 39.16 192 48 192H240C248.8 192 256 199.2 256 208C256 216.8 248.8 224 240 224H16C7.163 224 0 231.2 0 240C0 248.8 7.163 256 16 256H208C216.8 256 224 263.2 224 272C224 280.8 216.8 288 208 288H64V416C64 469 106.1 512 160 512C213 512 256 469 256 416H384C384 469 426.1 512 480 512C533 512 576 469 576 416H608C625.7 416 640 401.7 640 384C640 366.3 625.7 352 608 352V237.3C608 220.3 601.3 204 589.3 192L512 114.7C499.1 102.7 483.7 96 466.7 96H416V48C416 21.49 394.5 0 368 0H112zM544 237.3V256H416V160H466.7L544 237.3zM160 464C133.5 464 112 442.5 112 416C112 389.5 133.5 368 160 368C186.5 368 208 389.5 208 416C208 442.5 186.5 464 160 464zM528 416C528 442.5 506.5 464 480 464C453.5 464 432 442.5 432 416C432 389.5 453.5 368 480 368C506.5 368 528 389.5 528 416z")),"label"=>__("Truck Fast","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","lifestyle-and-hobbies")),"truck-field"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M32 96C32 60.65 60.65 32 96 32H320C343.7 32 364.4 44.87 375.4 64H427.2C452.5 64 475.4 78.9 485.7 102L538.5 220.8C538.1 221.9 539.4 222.9 539.8 223.1H544C579.3 223.1 608 252.7 608 287.1V319.1C625.7 319.1 640 334.3 640 352C640 369.7 625.7 384 608 384H576C576 437 533 480 480 480C426.1 480 384 437 384 384H256C256 437 213 480 160 480C106.1 480 64 437 64 384H32C14.33 384 0 369.7 0 352C0 334.3 14.33 319.1 32 319.1V287.1C14.33 287.1 0 273.7 0 255.1V159.1C0 142.3 14.33 127.1 32 127.1V96zM469.9 224L427.2 128H384V224H469.9zM160 432C186.5 432 208 410.5 208 384C208 357.5 186.5 336 160 336C133.5 336 112 357.5 112 384C112 410.5 133.5 432 160 432zM480 336C453.5 336 432 357.5 432 384C432 410.5 453.5 432 480 432C506.5 432 528 410.5 528 384C528 357.5 506.5 336 480 336z")),"label"=>__("Truck Field","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"truck-field-un"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M320 32C343.7 32 364.4 44.87 375.4 64H427.2C452.5 64 475.4 78.9 485.7 102L538.5 220.8C538.1 221.9 539.4 222.9 539.8 224H544C579.3 224 608 252.7 608 288V320C625.7 320 640 334.3 640 352C640 369.7 625.7 384 608 384H576C576 437 533 480 480 480C426.1 480 384 437 384 384H256C256 437 213 480 160 480C106.1 480 64 437 64 384H32C14.33 384 0 369.7 0 352C0 334.3 14.33 320 32 320V288C14.33 288 0 273.7 0 256V160C0 142.3 14.33 128 32 128V96C32 60.65 60.65 32 96 32L320 32zM384 128V224H469.9L427.2 128H384zM160 336C133.5 336 112 357.5 112 384C112 410.5 133.5 432 160 432C186.5 432 208 410.5 208 384C208 357.5 186.5 336 160 336zM480 432C506.5 432 528 410.5 528 384C528 357.5 506.5 336 480 336C453.5 336 432 357.5 432 384C432 410.5 453.5 432 480 432zM253.3 135.1C249.4 129.3 242.1 126.6 235.4 128.7C228.6 130.7 224 136.9 224 144V240C224 248.8 231.2 256 240 256C248.8 256 256 248.8 256 240V196.8L290.7 248.9C294.6 254.7 301.9 257.4 308.6 255.3C315.4 253.3 320 247.1 320 240V144C320 135.2 312.8 128 304 128C295.2 128 288 135.2 288 144V187.2L253.3 135.1zM128 144C128 135.2 120.8 128 112 128C103.2 128 96 135.2 96 144V208C96 234.5 117.5 256 144 256C170.5 256 192 234.5 192 208V144C192 135.2 184.8 128 176 128C167.2 128 160 135.2 160 144V208C160 216.8 152.8 224 144 224C135.2 224 128 216.8 128 208V144z")),"label"=>__("Truck Field Un","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"truck-front"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M0 80C0 35.82 35.82 0 80 0H432C476.2 0 512 35.82 512 80V368C512 394.2 499.4 417.4 480 432V480C480 497.7 465.7 512 448 512H416C398.3 512 384 497.7 384 480V448H128V480C128 497.7 113.7 512 96 512H64C46.33 512 32 497.7 32 480V432C12.57 417.4 0 394.2 0 368V80zM129.9 152.2L112 224H400L382.1 152.2C378.5 137.1 365.7 128 351 128H160.1C146.3 128 133.5 137.1 129.9 152.2H129.9zM96 288C78.33 288 64 302.3 64 320C64 337.7 78.33 352 96 352C113.7 352 128 337.7 128 320C128 302.3 113.7 288 96 288zM416 352C433.7 352 448 337.7 448 320C448 302.3 433.7 288 416 288C398.3 288 384 302.3 384 320C384 337.7 398.3 352 416 352z")),"label"=>__("Truck Front","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"truck-medical"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M368 0C394.5 0 416 21.49 416 48V96H466.7C483.7 96 499.1 102.7 512 114.7L589.3 192C601.3 204 608 220.3 608 237.3V352C625.7 352 640 366.3 640 384C640 401.7 625.7 416 608 416H576C576 469 533 512 480 512C426.1 512 384 469 384 416H256C256 469 213 512 160 512C106.1 512 64 469 64 416H48C21.49 416 0 394.5 0 368V48C0 21.49 21.49 0 48 0H368zM416 160V256H544V237.3L466.7 160H416zM160 368C133.5 368 112 389.5 112 416C112 442.5 133.5 464 160 464C186.5 464 208 442.5 208 416C208 389.5 186.5 368 160 368zM480 464C506.5 464 528 442.5 528 416C528 389.5 506.5 368 480 368C453.5 368 432 389.5 432 416C432 442.5 453.5 464 480 464zM112 176C112 184.8 119.2 192 128 192H176V240C176 248.8 183.2 256 192 256H224C232.8 256 240 248.8 240 240V192H288C296.8 192 304 184.8 304 176V144C304 135.2 296.8 128 288 128H240V80C240 71.16 232.8 64 224 64H192C183.2 64 176 71.16 176 80V128H128C119.2 128 112 135.2 112 144V176z")),"label"=>__("Truck Medical","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","science-and-technology","travel")),"truck-monster"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M419.2 25.6L496 128H576C593.7 128 608 142.3 608 160V224C625.7 224 640 238.3 640 256C640 273.7 625.7 287.1 608 288C578.8 249.1 532.3 224 480 224C427.7 224 381.2 249.1 351.1 288H288C258.8 249.1 212.3 224 160 224C107.7 224 61.18 249.1 31.99 288C14.32 287.1 0 273.7 0 256C0 238.3 14.33 224 32 224V160C32 142.3 46.33 128 64 128H224V48C224 21.49 245.5 0 272 0H368C388.1 0 407.1 9.484 419.2 25.6H419.2zM288 128H416L368 64H288V128zM168 256C180.1 256 190.1 264.9 191.8 276.6C199.4 278.8 206.7 281.9 213.5 285.6C222.9 278.5 236.3 279.3 244.9 287.8L256.2 299.1C264.7 307.7 265.5 321.1 258.4 330.5C262.1 337.3 265.2 344.6 267.4 352.2C279.1 353.9 288 363.9 288 376V392C288 404.1 279.1 414.1 267.4 415.8C265.2 423.4 262.1 430.7 258.4 437.5C265.5 446.9 264.7 460.3 256.2 468.9L244.9 480.2C236.3 488.7 222.9 489.5 213.5 482.4C206.7 486.1 199.4 489.2 191.8 491.4C190.1 503.1 180.1 512 167.1 512H151.1C139.9 512 129.9 503.1 128.2 491.4C120.6 489.2 113.3 486.1 106.5 482.4C97.09 489.5 83.7 488.7 75.15 480.2L63.83 468.9C55.28 460.3 54.53 446.9 61.58 437.5C57.85 430.7 54.81 423.4 52.57 415.8C40.94 414.1 31.1 404.1 31.1 392V376C31.1 363.9 40.94 353.9 52.57 352.2C54.81 344.6 57.85 337.3 61.58 330.5C54.53 321.1 55.28 307.7 63.83 299.1L75.15 287.8C83.7 279.3 97.09 278.5 106.5 285.6C113.3 281.9 120.6 278.8 128.2 276.6C129.9 264.9 139.9 255.1 151.1 255.1L168 256zM160 432C186.5 432 208 410.5 208 384C208 357.5 186.5 336 160 336C133.5 336 112 357.5 112 384C112 410.5 133.5 432 160 432zM448.2 276.6C449.9 264.9 459.9 256 472 256H488C500.1 256 510.1 264.9 511.8 276.6C519.4 278.8 526.7 281.9 533.5 285.6C542.9 278.5 556.3 279.3 564.9 287.8L576.2 299.1C584.7 307.7 585.5 321.1 578.4 330.5C582.1 337.3 585.2 344.6 587.4 352.2C599.1 353.9 608 363.9 608 376V392C608 404.1 599.1 414.1 587.4 415.8C585.2 423.4 582.1 430.7 578.4 437.5C585.5 446.9 584.7 460.3 576.2 468.9L564.9 480.2C556.3 488.7 542.9 489.5 533.5 482.4C526.7 486.1 519.4 489.2 511.8 491.4C510.1 503.1 500.1 512 488 512H472C459.9 512 449.9 503.1 448.2 491.4C440.6 489.2 433.3 486.1 426.5 482.4C417.1 489.5 403.7 488.7 395.1 480.2L383.8 468.9C375.3 460.3 374.5 446.9 381.6 437.5C377.9 430.7 374.8 423.4 372.6 415.8C360.9 414.1 352 404.1 352 392V376C352 363.9 360.9 353.9 372.6 352.2C374.8 344.6 377.9 337.3 381.6 330.5C374.5 321.1 375.3 307.7 383.8 299.1L395.1 287.8C403.7 279.3 417.1 278.5 426.5 285.6C433.3 281.9 440.6 278.8 448.2 276.6L448.2 276.6zM480 336C453.5 336 432 357.5 432 384C432 410.5 453.5 432 480 432C506.5 432 528 410.5 528 384C528 357.5 506.5 336 480 336z")),"label"=>__("Truck Monster","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"truck-moving"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M416 32C451.3 32 480 60.65 480 96V144H528.8C545.6 144 561.5 151.5 572.2 164.5L630.1 236.4C636.8 243.5 640 252.5 640 261.7V352C640 369.7 625.7 384 608 384H606.4C607.4 389.2 608 394.5 608 400C608 444.2 572.2 480 528 480C483.8 480 448 444.2 448 400C448 394.5 448.6 389.2 449.6 384H286.4C287.4 389.2 288 394.5 288 400C288 444.2 252.2 480 208 480C181.8 480 158.6 467.4 144 448C129.4 467.4 106.2 480 80 480C35.82 480 0 444.2 0 400V96C0 60.65 28.65 32 64 32H416zM535 194.9C533.5 193.1 531.2 192 528.8 192H480V256H584.1L535 194.9zM528 432C545.7 432 560 417.7 560 400C560 382.3 545.7 368 528 368C510.3 368 496 382.3 496 400C496 417.7 510.3 432 528 432zM208 368C190.3 368 176 382.3 176 400C176 417.7 190.3 432 208 432C225.7 432 240 417.7 240 400C240 382.3 225.7 368 208 368zM80 432C97.67 432 112 417.7 112 400C112 382.3 97.67 368 80 368C62.33 368 48 382.3 48 400C48 417.7 62.33 432 80 432z")),"label"=>__("Truck Moving","ultimate-addons-for-gutenberg"),"custom_categories"=>array("travel")),"truck-pickup"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M272 32H368.6C388.1 32 406.5 40.84 418.6 56.02L527.4 192H576C593.7 192 608 206.3 608 224V288C625.7 288 640 302.3 640 320C640 337.7 625.7 352 608 352H574.9C575.6 357.2 576 362.6 576 368C576 429.9 525.9 480 464 480C402.1 480 352 429.9 352 368C352 362.6 352.4 357.2 353.1 352H286.9C287.6 357.2 288 362.6 288 368C288 429.9 237.9 480 176 480C114.1 480 64 429.9 64 368C64 362.6 64.39 357.2 65.13 352H32C14.33 352 0 337.7 0 320C0 302.3 14.33 288 32 288V224C32 206.3 46.33 192 64 192H224V80C224 53.49 245.5 32 272 32H272zM368.6 96H288V192H445.4L368.6 96zM176 416C202.5 416 224 394.5 224 368C224 341.5 202.5 320 176 320C149.5 320 128 341.5 128 368C128 394.5 149.5 416 176 416zM464 416C490.5 416 512 394.5 512 368C512 341.5 490.5 320 464 320C437.5 320 416 341.5 416 368C416 394.5 437.5 416 464 416z")),"label"=>__("Truck Pickup","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"truck-plane"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M256 86.06L256 182.9L256 184V411.5L256.1 411.6C257.3 433.8 269.8 452.9 288 463.4V496C288 501.2 288.8 506.3 290.4 510.1L200 480.9L109.1 511.2C104.2 512.8 98.82 511.1 94.64 508.1C90.47 505.1 88 501.1 88 496V464C88 459.1 90.21 454.5 94 451.5L144 411.5V330.3L20.6 367.3C15.75 368.8 10.51 367.9 6.449 364.8C2.391 361.8 0 357.1 0 352V288C0 282.4 2.949 277.2 7.768 274.3L144 192.5V86.06C144 54.68 169.4 0 200 0C231.5 0 256 54.68 256 86.06V86.06zM288 176C288 149.5 309.5 128 336 128H592C618.5 128 640 149.5 640 176V400C640 420.9 626.6 438.7 608 445.3V488C608 501.3 597.3 512 584 512H568C554.7 512 544 501.3 544 488V448H384V488C384 501.3 373.3 512 360 512H344C330.7 512 320 501.3 320 488V445.3C301.4 438.7 288 420.9 288 400V176zM367.8 254.7L352 304H576L560.2 254.7C556.9 246 548.9 240 539.7 240H388.3C379.1 240 371.1 246 367.8 254.7H367.8zM568 400C581.3 400 592 389.3 592 376C592 362.7 581.3 352 568 352C554.7 352 544 362.7 544 376C544 389.3 554.7 400 568 400zM360 352C346.7 352 336 362.7 336 376C336 389.3 346.7 400 360 400C373.3 400 384 389.3 384 376C384 362.7 373.3 352 360 352z")),"label"=>__("Truck Plane","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"truck-ramp-box"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M640 .0003V400C640 461.9 589.9 512 528 512C467 512 417.5 463.3 416 402.7L48.41 502.9C31.36 507.5 13.77 497.5 9.126 480.4C4.48 463.4 14.54 445.8 31.59 441.1L352 353.8V64C352 28.65 380.7 0 416 0L640 .0003zM528 352C501.5 352 480 373.5 480 400C480 426.5 501.5 448 528 448C554.5 448 576 426.5 576 400C576 373.5 554.5 352 528 352zM23.11 207.7C18.54 190.6 28.67 173.1 45.74 168.5L92.1 156.1L112.8 233.4C115.1 241.9 123.9 246.1 132.4 244.7L163.3 236.4C171.8 234.1 176.9 225.3 174.6 216.8L153.9 139.5L200.3 127.1C217.4 122.5 234.9 132.7 239.5 149.7L280.9 304.3C285.5 321.4 275.3 338.9 258.3 343.5L103.7 384.9C86.64 389.5 69.1 379.3 64.52 362.3L23.11 207.7z")),"label"=>__("Truck Ramp Box","ultimate-addons-for-gutenberg"),"custom_categories"=>array("travel")),"tty"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M271.1 364v40c0 6.625 5.375 12 12 12h40c6.625 0 12-5.375 12-12v-40c0-6.625-5.375-12-12-12h-40C277.3 352 271.1 357.4 271.1 364zM367.1 364v40c0 6.625 5.375 12 12 12h40c6.625 0 12-5.375 12-12v-40c0-6.625-5.375-12-12-12h-40C373.3 352 367.1 357.4 367.1 364zM275.1 256h-40c-6.625 0-12 5.375-12 12v40c0 6.625 5.376 12 12 12h39.1c6.625 0 12-5.375 12-12v-40C287.1 261.4 282.6 256 275.1 256zM83.96 448h-40c-6.625 0-12 5.375-12 12v40c0 6.625 5.375 12 12 12h40c6.625 0 12-5.375 12-12v-40C95.96 453.4 90.59 448 83.96 448zM175.1 364v40c0 6.625 5.375 12 12 12h40c6.625 0 12-5.375 12-12v-40c0-6.625-5.375-12-12-12h-40C181.3 352 175.1 357.4 175.1 364zM371.1 256h-40c-6.625 0-12 5.375-12 12v40c0 6.625 5.372 12 11.1 12h39.1c6.625 0 12-5.375 12-12v-40C383.1 261.4 378.6 256 371.1 256zM467.1 256h-40c-6.625 0-12 5.375-12 12v40c0 6.625 5.369 12 11.99 12h39.1c6.625 0 12.01-5.375 12.01-12v-40C479.1 261.4 474.6 256 467.1 256zM371.1 448h-232c-6.625 0-12 5.375-12 12v40c0 6.625 5.375 12 12 12h232c6.625 0 12-5.375 12-12v-40C383.1 453.4 378.6 448 371.1 448zM179.1 256h-40c-6.625 0-12 5.375-12 12v40c0 6.625 5.38 12 12 12h39.1c6.625 0 11.1-5.375 11.1-12v-40C191.1 261.4 186.6 256 179.1 256zM467.1 448h-40c-6.625 0-12 5.375-12 12v40c0 6.625 5.375 12 12 12h40c6.625 0 12-5.375 12-12v-40C479.1 453.4 474.6 448 467.1 448zM79.96 364v40c0 6.625 5.375 12 12 12h40c6.625 0 12-5.375 12-12v-40c0-6.625-5.375-12-12-12h-40C85.34 352 79.96 357.4 79.96 364zM83.96 256h-40c-6.625 0-12 5.375-12 12v40c0 6.625 5.383 12 12.01 12H83.97c6.625 0 11.99-5.375 11.99-12v-40C95.96 261.4 90.59 256 83.96 256zM504.9 102.9C367.7-34.31 144.3-34.32 7.083 102.9c-7.975 7.973-9.375 20.22-3.391 29.74l42.17 67.47c6.141 9.844 18.47 13.88 29.35 9.632l84.36-33.74C169.5 172.1 175.6 161.1 174.5 151.3l-5.303-53.27c56.15-19.17 117.4-19.17 173.6 .0059L337.5 151.3c-1.139 10.59 4.997 20.78 14.96 24.73l84.35 33.73c10.83 4.303 23.22 .1608 29.33-9.615l42.18-67.48C514.3 123.2 512.9 110.9 504.9 102.9z")),"label"=>__("Tty","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","design","travel")),"tumblr"=>array("svg"=>array("brands"=>array("width"=>320,"height"=>512,"path"=>"M309.8 480.3c-13.6 14.5-50 31.7-97.4 31.7-120.8 0-147-88.8-147-140.6v-144H17.9c-5.5 0-10-4.5-10-10v-68c0-7.2 4.5-13.6 11.3-16 62-21.8 81.5-76 84.3-117.1 .8-11 6.5-16.3 16.1-16.3h70.9c5.5 0 10 4.5 10 10v115.2h83c5.5 0 10 4.4 10 9.9v81.7c0 5.5-4.5 10-10 10h-83.4V360c0 34.2 23.7 53.6 68 35.8 4.8-1.9 9-3.2 12.7-2.2 3.5 .9 5.8 3.4 7.4 7.9l22 64.3c1.8 5 3.3 10.6-.4 14.5z")),"label"=>__("Tumblr","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"tumblr-square"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zm-82.3 364.2c-8.5 9.1-31.2 19.8-60.9 19.8-75.5 0-91.9-55.5-91.9-87.9v-90h-29.7c-3.4 0-6.2-2.8-6.2-6.2v-42.5c0-4.5 2.8-8.5 7.1-10 38.8-13.7 50.9-47.5 52.7-73.2 .5-6.9 4.1-10.2 10-10.2h44.3c3.4 0 6.2 2.8 6.2 6.2v72h51.9c3.4 0 6.2 2.8 6.2 6.2v51.1c0 3.4-2.8 6.2-6.2 6.2h-52.1V321c0 21.4 14.8 33.5 42.5 22.4 3-1.2 5.6-2 8-1.4 2.2 .5 3.6 2.1 4.6 4.9l13.8 40.2c1 3.2 2 6.7-.3 9.1z")),"label"=>__("Tumblr Square","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"turkish-lira-sign"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M96 32C113.7 32 128 46.33 128 64V99.29L247.2 65.23C264.2 60.38 281.9 70.22 286.8 87.21C291.6 104.2 281.8 121.9 264.8 126.8L128 165.9V195.3L247.2 161.2C264.2 156.4 281.9 166.2 286.8 183.2C291.6 200.2 281.8 217.9 264.8 222.8L128 261.9V416H191.8C260 416 316.2 362.5 319.6 294.4L320 286.4C320.9 268.8 335.9 255.2 353.6 256C371.2 256.9 384.8 271.9 383.1 289.6L383.6 297.6C378.5 399.8 294.1 480 191.8 480H96C78.33 480 64 465.7 64 448V280.1L40.79 286.8C23.8 291.6 6.087 281.8 1.232 264.8C-3.623 247.8 6.217 230.1 23.21 225.2L64 213.6V184.1L40.79 190.8C23.8 195.6 6.087 185.8 1.232 168.8C-3.623 151.8 6.216 134.1 23.21 129.2L64 117.6V64C64 46.33 78.33 32 96 32L96 32z")),"label"=>__("Turkish Lira Sign","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"turn-down"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M313.6 392.3l-104 112c-9.5 10.23-25.69 10.23-35.19 0l-104-112c-6.484-6.984-8.219-17.17-4.406-25.92S78.45 352 88 352H160V80C160 71.19 152.8 64 144 64H32C14.33 64 0 49.69 0 32s14.33-32 32-32h112C188.1 0 224 35.88 224 80V352h72c9.547 0 18.19 5.656 22 14.41S320.1 385.3 313.6 392.3z")),"label"=>__("Turn Down","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"turn-up"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M318 145.6c-3.812 8.75-12.45 14.41-22 14.41L224 160v272c0 44.13-35.89 80-80 80H32c-17.67 0-32-14.31-32-32s14.33-32 32-32h112C152.8 448 160 440.8 160 432V160L88 159.1c-9.547 0-18.19-5.656-22-14.41S63.92 126.7 70.41 119.7l104-112c9.498-10.23 25.69-10.23 35.19 0l104 112C320.1 126.7 321.8 136.8 318 145.6z")),"label"=>__("Turn Up","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"tv"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M512 448H127.1C110.3 448 96 462.3 96 479.1S110.3 512 127.1 512h384C529.7 512 544 497.7 544 480S529.7 448 512 448zM592 0h-544C21.5 0 0 21.5 0 48v320C0 394.5 21.5 416 48 416h544c26.5 0 48-21.5 48-48v-320C640 21.5 618.5 0 592 0zM576 352H64v-288h512V352z")),"label"=>__("Tv","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","lifestyle-and-hobbies","science-and-technology","travel")),"twitch"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M391.2 103.5H352.5v109.7h38.63zM285 103H246.4V212.8H285zM120.8 0 24.31 91.42V420.6H140.1V512l96.53-91.42h77.25L487.7 256V0zM449.1 237.8l-77.22 73.12H294.6l-67.6 64v-64H140.1V36.58H449.1z")),"label"=>__("Twitch","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","brands","brands","social")),"twitter"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M459.4 151.7c.325 4.548 .325 9.097 .325 13.65 0 138.7-105.6 298.6-298.6 298.6-59.45 0-114.7-17.22-161.1-47.11 8.447 .974 16.57 1.299 25.34 1.299 49.06 0 94.21-16.57 130.3-44.83-46.13-.975-84.79-31.19-98.11-72.77 6.498 .974 12.99 1.624 19.82 1.624 9.421 0 18.84-1.3 27.61-3.573-48.08-9.747-84.14-51.98-84.14-102.1v-1.299c13.97 7.797 30.21 12.67 47.43 13.32-28.26-18.84-46.78-51.01-46.78-87.39 0-19.49 5.197-37.36 14.29-52.95 51.65 63.67 129.3 105.3 216.4 109.8-1.624-7.797-2.599-15.92-2.599-24.04 0-57.83 46.78-104.9 104.9-104.9 30.21 0 57.5 12.67 76.67 33.14 23.72-4.548 46.46-13.32 66.6-25.34-7.798 24.37-24.37 44.83-46.13 57.83 21.12-2.273 41.58-8.122 60.43-16.24-14.29 20.79-32.16 39.31-52.63 54.25z")),"label"=>__("Twitter","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"x-twitter"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z")),"label"=>__("Twitter","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"twitter-square"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zm-48.9 158.8c.2 2.8 .2 5.7 .2 8.5 0 86.7-66 186.6-186.6 186.6-37.2 0-71.7-10.8-100.7-29.4 5.3 .6 10.4 .8 15.8 .8 30.7 0 58.9-10.4 81.4-28-28.8-.6-53-19.5-61.3-45.5 10.1 1.5 19.2 1.5 29.6-1.2-30-6.1-52.5-32.5-52.5-64.4v-.8c8.7 4.9 18.9 7.9 29.6 8.3a65.45 65.45 0 0 1 -29.2-54.6c0-12.2 3.2-23.4 8.9-33.1 32.3 39.8 80.8 65.8 135.2 68.6-9.3-44.5 24-80.6 64-80.6 18.9 0 35.9 7.9 47.9 20.7 14.8-2.8 29-8.3 41.6-15.8-4.9 15.2-15.2 28-28.8 36.1 13.2-1.4 26-5.1 37.8-10.2-8.9 13.1-20.1 24.7-32.9 34z")),"label"=>__("Twitter Square","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"typo3"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M178.7 78.4c0-24.7 5.4-32.4 13.9-39.4-69.5 8.5-149.3 34-176.3 66.4-5.4 7.7-9.3 20.8-9.3 37.1C7 246 113.8 480 191.1 480c36.3 0 97.3-59.5 146.7-139-7 2.3-11.6 2.3-18.5 2.3-57.2 0-140.6-198.5-140.6-264.9zM301.5 32c-30.1 0-41.7 5.4-41.7 36.3 0 66.4 53.8 198.5 101.7 198.5 26.3 0 78.8-99.7 78.8-182.3 0-40.9-67-52.5-138.8-52.5z")),"label"=>__("Typo3","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"u"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M384 64.01v225.7c0 104.1-86.13 190.3-192 190.3s-192-85.38-192-190.3V64.01C0 46.34 14.33 32.01 32 32.01S64 46.34 64 64.01v225.7c0 69.67 57.42 126.3 128 126.3s128-56.67 128-126.3V64.01c0-17.67 14.33-32 32-32S384 46.34 384 64.01z")),"label"=>__("U","ultimate-addons-for-gutenberg"),"custom_categories"=>array("education")),"uber"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M414.1 32H33.9C15.2 32 0 47.2 0 65.9V446c0 18.8 15.2 34 33.9 34H414c18.7 0 33.9-15.2 33.9-33.9V65.9C448 47.2 432.8 32 414.1 32zM237.6 391.1C163 398.6 96.4 344.2 88.9 269.6h94.4V290c0 3.7 3 6.8 6.8 6.8H258c3.7 0 6.8-3 6.8-6.8v-67.9c0-3.7-3-6.8-6.8-6.8h-67.9c-3.7 0-6.8 3-6.8 6.8v20.4H88.9c7-69.4 65.4-122.2 135.1-122.2 69.7 0 128.1 52.8 135.1 122.2 7.5 74.5-46.9 141.1-121.5 148.6z")),"label"=>__("Uber","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"ubuntu"=>array("svg"=>array("brands"=>array("width"=>496,"height"=>512,"path"=>"M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm52.7 93c8.8-15.2 28.3-20.5 43.5-11.7 15.3 8.8 20.5 28.3 11.7 43.6-8.8 15.2-28.3 20.5-43.5 11.7-15.3-8.9-20.5-28.4-11.7-43.6zM87.4 287.9c-17.6 0-31.9-14.3-31.9-31.9 0-17.6 14.3-31.9 31.9-31.9 17.6 0 31.9 14.3 31.9 31.9 0 17.6-14.3 31.9-31.9 31.9zm28.1 3.1c22.3-17.9 22.4-51.9 0-69.9 8.6-32.8 29.1-60.7 56.5-79.1l23.7 39.6c-51.5 36.3-51.5 112.5 0 148.8L172 370c-27.4-18.3-47.8-46.3-56.5-79zm228.7 131.7c-15.3 8.8-34.7 3.6-43.5-11.7-8.8-15.3-3.6-34.8 11.7-43.6 15.2-8.8 34.7-3.6 43.5 11.7 8.8 15.3 3.6 34.8-11.7 43.6zm.3-69.5c-26.7-10.3-56.1 6.6-60.5 35-5.2 1.4-48.9 14.3-96.7-9.4l22.5-40.3c57 26.5 123.4-11.7 128.9-74.4l46.1 .7c-2.3 34.5-17.3 65.5-40.3 88.4zm-5.9-105.3c-5.4-62-71.3-101.2-128.9-74.4l-22.5-40.3c47.9-23.7 91.5-10.8 96.7-9.4 4.4 28.3 33.8 45.3 60.5 35 23.1 22.9 38 53.9 40.2 88.5l-46 .6z")),"label"=>__("Ubuntu","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"uikit"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M443.9 128v256L218 512 0 384V169.7l87.6 45.1v117l133.5 75.5 135.8-75.5v-151l-101.1-57.6 87.6-53.1L443.9 128zM308.6 49.1L223.8 0l-88.6 54.8 86 47.3 87.4-53z")),"label"=>__("UIkit","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"umbraco"=>array("svg"=>array("brands"=>array("width"=>510,"height"=>512,"path"=>"M255.4 8C118.4 7.83 7.14 118.7 7 255.7c-.07 137 111 248.2 248 248.3 136.9 0 247.8-110.7 248-247.7S392.3 8.17 255.4 8zm145 266q-1.14 40.68-14 65t-43.51 35q-30.61 10.7-85.45 10.47h-4.6q-54.78 .22-85.44-10.47t-43.52-35q-12.85-24.36-14-65a224.8 224.8 0 0 1 0-30.71 418.4 418.4 0 0 1 3.6-43.88c1.88-13.39 3.57-22.58 5.4-32 1-4.88 1.28-6.42 1.82-8.45a5.09 5.09 0 0 1 4.9-3.89h.69l32 5a5.07 5.07 0 0 1 4.16 5 5 5 0 0 1 0 .77l-1.7 8.78q-2.41 13.25-4.84 33.68a380.6 380.6 0 0 0 -2.64 42.15q-.28 40.43 8.13 59.83a43.87 43.87 0 0 0 31.31 25.18A243 243 0 0 0 250 340.6h10.25a242.6 242.6 0 0 0 57.27-5.16 43.86 43.86 0 0 0 31.15-25.23q8.53-19.42 8.13-59.78a388 388 0 0 0 -2.6-42.15q-2.48-20.38-4.89-33.68l-1.69-8.78a5 5 0 0 1 0-.77 5 5 0 0 1 4.2-5l32-5h.82a5 5 0 0 1 4.9 3.89c.55 2.05 .81 3.57 1.83 8.45 1.82 9.62 3.52 18.78 5.39 32a415.7 415.7 0 0 1 3.61 43.88 228.1 228.1 0 0 1 -.04 30.73z")),"label"=>__("Umbraco","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"umbrella"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M255.1 301.7v130.3c0 8.814-7.188 16-16 16c-7.814 0-13.19-5.314-15.1-10.69c-5.906-16.72-24.1-25.41-40.81-19.5c-16.69 5.875-25.41 24.19-19.5 40.79C175.8 490.6 206.2 512 239.1 512C284.1 512 320 476.1 320 431.1v-130.3c-9.094-7.908-19.81-13.61-32-13.61C275.7 288.1 265.6 292.9 255.1 301.7zM575.7 280.9C547.1 144.5 437.3 62.61 320 49.91V32.01c0-17.69-14.31-32.01-32-32.01S255.1 14.31 255.1 32.01v17.91C138.3 62.61 29.48 144.5 .2949 280.9C-1.926 290.1 8.795 302.1 18.98 292.2c52-55.01 107.7-52.39 158.6 37.01c5.312 9.502 14.91 8.625 19.72 0C217.5 293.9 242.2 256 287.1 256c58.5 0 88.19 68.82 90.69 73.2c4.812 8.625 14.41 9.502 19.72 0c51-89.52 107.1-91.39 158.6-37.01C567.3 302.2 577.9 290.1 575.7 280.9z")),"label"=>__("Umbrella","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment","travel")),"umbrella-beach"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M115.4 136.8l102.1 37.35c35.13-81.62 86.25-144.4 139-173.7c-95.88-4.875-188.8 36.96-248.5 111.7C101.2 120.6 105.2 133.2 115.4 136.8zM247.6 185l238.5 86.87c35.75-121.4 18.62-231.6-42.63-253.9c-7.375-2.625-15.12-4.062-23.12-4.062C362.4 13.88 292.1 83.13 247.6 185zM521.5 60.51c6.25 16.25 10.75 34.62 13.13 55.25c5.75 49.87-1.376 108.1-18.88 166.9l102.6 37.37c10.13 3.75 21.25-3.375 21.5-14.12C642.3 210.1 598 118.4 521.5 60.51zM528 448h-207l65-178.5l-60.13-21.87l-72.88 200.4H48C21.49 448 0 469.5 0 496C0 504.8 7.163 512 16 512h544c8.837 0 16-7.163 16-15.1C576 469.5 554.5 448 528 448z")),"label"=>__("Umbrella Beach","ultimate-addons-for-gutenberg"),"custom_categories"=>array("travel")),"uncharted"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M171.7 232.8A5.381 5.381 0 0 0 176.7 229.5 48.08 48.08 0 0 1 191.6 204.2c1.243-.828 1.657-2.484 1.657-4.141a4.22 4.22 0 0 0 -2.071-3.312L74.43 128.5 148.1 85a9.941 9.941 0 0 0 4.968-8.281 9.108 9.108 0 0 0 -4.968-8.281L126.6 55.6a9.748 9.748 0 0 0 -9.523 0l-100.2 57.97a9.943 9.943 0 0 0 -4.969 8.281V236.1a9.109 9.109 0 0 0 4.969 8.281L39.24 258.1a8.829 8.829 0 0 0 4.968 1.242 9.4 9.4 0 0 0 6.625-2.484 10.8 10.8 0 0 0 2.9-7.039V164.5L169.7 232.4A4.5 4.5 0 0 0 171.7 232.8zM323.3 377.7a12.48 12.48 0 0 0 -4.969 1.242l-74.53 43.06V287.9c0-2.9-2.9-5.8-6.211-4.555a53.04 53.04 0 0 1 -28.98 .414 4.86 4.86 0 0 0 -6.21 4.555V421.6l-74.53-43.06a8.83 8.83 0 0 0 -4.969-1.242 9.631 9.631 0 0 0 -9.523 9.523v26.08a9.107 9.107 0 0 0 4.969 8.281l100.2 57.55A8.829 8.829 0 0 0 223.5 480a11.03 11.03 0 0 0 4.969-1.242l100.2-57.55a9.941 9.941 0 0 0 4.968-8.281V386.8C332.8 382.3 328.2 377.7 323.3 377.7zM286 78a23 23 0 1 0 -23-23A23 23 0 0 0 286 78zm63.63-10.09a23 23 0 1 0 23 23A23 23 0 0 0 349.6 67.91zM412.8 151.6a23 23 0 1 0 -23-23A23 23 0 0 0 412.8 151.6zm-63.18-9.2a23 23 0 1 0 23 23A23 23 0 0 0 349.6 142.4zm-63.63 83.24a23 23 0 1 0 -23-23A23 23 0 0 0 286 225.6zm-62.07 36.36a23 23 0 1 0 -23-23A23 23 0 0 0 223.9 262zm188.9-82.36a23 23 0 1 0 23 23A23 23 0 0 0 412.8 179.6zm0 72.27a23 23 0 1 0 23 23A23 23 0 0 0 412.8 251.9z")),"label"=>__("Uncharted Software","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"underline"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M416 448H32c-17.69 0-32 14.31-32 32s14.31 32 32 32h384c17.69 0 32-14.31 32-32S433.7 448 416 448zM48 64.01H64v160c0 88.22 71.78 159.1 160 159.1s160-71.78 160-159.1v-160h16c17.69 0 32-14.32 32-32s-14.31-31.1-32-31.1l-96-.0049c-17.69 0-32 14.32-32 32s14.31 32 32 32H320v160c0 52.94-43.06 95.1-96 95.1S128 276.1 128 224v-160h16c17.69 0 32-14.31 32-32s-14.31-32-32-32l-96 .0049c-17.69 0-32 14.31-32 31.1S30.31 64.01 48 64.01z")),"label"=>__("Underline","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"uniregistry"=>array("svg"=>array("brands"=>array("width"=>384,"height"=>512,"path"=>"M192 480c39.5 0 76.2-11.8 106.8-32.2H85.3C115.8 468.2 152.5 480 192 480zm-89.1-193.1v-12.4H0v12.4c0 2.5 0 5 .1 7.4h103.1c-.2-2.4-.3-4.9-.3-7.4zm20.5 57H8.5c2.6 8.5 5.8 16.8 9.6 24.8h138.3c-12.9-5.7-24.1-14.2-33-24.8zm-17.7-34.7H1.3c.9 7.6 2.2 15 3.9 22.3h109.7c-4-6.9-7.2-14.4-9.2-22.3zm-2.8-69.3H0v17.3h102.9zm0-173.2H0v4.9h102.9zm0-34.7H0v2.5h102.9zm0 69.3H0v7.4h102.9zm0 104H0v14.8h102.9zm0-69.3H0v9.9h102.9zm0 34.6H0V183h102.9zm166.2 160.9h109.7c1.8-7.3 3.1-14.7 3.9-22.3H278.3c-2.1 7.9-5.2 15.4-9.2 22.3zm12-185.7H384V136H281.1zm0 37.2H384v-12.4H281.1zm0-74.3H384v-7.4H281.1zm0-76.7v2.5H384V32zm-203 410.9h227.7c11.8-8.7 22.7-18.6 32.2-29.7H44.9c9.6 11 21.4 21 33.2 29.7zm203-371.3H384v-4.9H281.1zm0 148.5H384v-14.8H281.1zM38.8 405.7h305.3c6.7-8.5 12.6-17.6 17.8-27.2H23c5.2 9.6 9.2 18.7 15.8 27.2zm188.8-37.1H367c3.7-8 5.8-16.2 8.5-24.8h-115c-8.8 10.7-20.1 19.2-32.9 24.8zm53.5-81.7c0 2.5-.1 5-.4 7.4h103.1c.1-2.5 .2-4.9 .2-7.4v-12.4H281.1zm0-29.7H384v-17.3H281.1z")),"label"=>__("Uniregistry","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"unity"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M243.6 91.6L323.7 138.4C326.6 140 326.7 144.6 323.7 146.2L228.5 201.9C225.6 203.6 222.2 203.4 219.5 201.9L124.4 146.2C121.4 144.6 121.4 139.1 124.4 138.4L204.4 91.6V0L0 119.4V358.3L78.38 312.5V218.9C78.33 215.6 82.21 213.2 85.09 214.1L180.3 270.6C183.2 272.3 184.8 275.3 184.8 278.5V389.7C184.8 393 180.1 395.4 178.1 393.6L97.97 346.8L19.58 392.6L224 512L428.4 392.6L350 346.8L269.9 393.6C267.1 395.3 263.1 393.1 263.2 389.7V278.5C263.2 275.1 265.1 272.2 267.7 270.6L362.9 214.1C365.7 213.2 369.7 215.5 369.6 218.9V312.5L448 358.3V119.4L243.6 0V91.6z")),"label"=>__("Unity 3D","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"universal-access"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 80c22.09 0 40 17.91 40 40S278.1 160 256 160S216 142.1 216 120S233.9 80 256 80zM374.6 215.1L315.3 232C311.6 233.1 307.8 233.6 304 234.4v62.32l30.64 87.34c4.391 12.5-2.188 26.19-14.69 30.59C317.3 415.6 314.6 416 312 416c-9.906 0-19.19-6.188-22.64-16.06l-25.85-70.65c-2.562-7.002-12.46-7.002-15.03 0l-25.85 70.65C219.2 409.8 209.9 416 200 416c-2.641 0-5.312-.4375-7.953-1.344c-12.5-4.406-19.08-18.09-14.69-30.59L208 296.7V234.4C204.2 233.6 200.4 233.1 196.7 232L137.4 215.1C124.7 211.4 117.3 198.2 120.9 185.4S137.9 165.2 150.6 168.9l59.25 16.94c30.17 8.623 62.15 8.623 92.31 0l59.25-16.94c12.7-3.781 26.02 3.719 29.67 16.47C394.7 198.2 387.3 211.4 374.6 215.1z")),"label"=>__("Universal Access","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design")),"unlock"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M144 192H384C419.3 192 448 220.7 448 256V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V256C0 220.7 28.65 192 64 192H80V144C80 64.47 144.5 0 224 0C281.5 0 331 33.69 354.1 82.27C361.7 98.23 354.9 117.3 338.1 124.9C322.1 132.5 303.9 125.7 296.3 109.7C283.4 82.63 255.9 64 224 64C179.8 64 144 99.82 144 144L144 192z")),"label"=>__("Unlock","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"unlock-keyhole"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M224 64C179.8 64 144 99.82 144 144V192H384C419.3 192 448 220.7 448 256V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V256C0 220.7 28.65 192 64 192H80V144C80 64.47 144.5 0 224 0C281.5 0 331 33.69 354.1 82.27C361.7 98.23 354.9 117.3 338.1 124.9C322.1 132.5 303.9 125.7 296.3 109.7C283.4 82.63 255.9 64 224 64H224zM256 384C273.7 384 288 369.7 288 352C288 334.3 273.7 320 256 320H192C174.3 320 160 334.3 160 352C160 369.7 174.3 384 192 384H256z")),"label"=>__("Unlock Keyhole","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"unsplash"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M448 230.2V480H0V230.2H141.1V355.1H306.9V230.2zM306.9 32H141.1V156.9H306.9z")),"label"=>__("Unsplash","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","design","brands","brands","social")),"untappd"=>array("svg"=>array("brands"=>array("width"=>640,"height"=>512,"path"=>"M401.3 49.9c-79.8 160.1-84.6 152.5-87.9 173.2l-5.2 32.8c-1.9 12-6.6 23.5-13.7 33.4L145.6 497.1c-7.6 10.6-20.4 16.2-33.4 14.6-40.3-5-77.8-32.2-95.3-68.5-5.7-11.8-4.5-25.8 3.1-36.4l148.9-207.9c7.1-9.9 16.4-18 27.2-23.7l29.3-15.5c18.5-9.8 9.7-11.9 135.6-138.9 1-4.8 1-7.3 3.6-8 3-.7 6.6-1 6.3-4.6l-.4-4.6c-.2-1.9 1.3-3.6 3.2-3.6 4.5-.1 13.2 1.2 25.6 10 12.3 8.9 16.4 16.8 17.7 21.1 .6 1.8-.6 3.7-2.4 4.2l-4.5 1.1c-3.4 .9-2.5 4.4-2.3 7.4 .1 2.8-2.3 3.6-6.5 6.1zM230.1 36.4c3.4 .9 2.5 4.4 2.3 7.4-.2 2.7 2.1 3.5 6.4 6 7.9 15.9 15.3 30.5 22.2 44 .7 1.3 2.3 1.5 3.3 .5 11.2-12 24.6-26.2 40.5-42.6 1.3-1.4 1.4-3.5 .1-4.9-8-8.2-16.5-16.9-25.6-26.1-1-4.7-1-7.3-3.6-8-3-.8-6.6-1-6.3-4.6 .3-3.3 1.4-8.1-2.8-8.2-4.5-.1-13.2 1.1-25.6 10-12.3 8.9-16.4 16.8-17.7 21.1-1.4 4.2 3.6 4.6 6.8 5.4zM620 406.7L471.2 198.8c-13.2-18.5-26.6-23.4-56.4-39.1-11.2-5.9-14.2-10.9-30.5-28.9-1-1.1-2.9-.9-3.6 .5-46.3 88.8-47.1 82.8-49 94.8-1.7 10.7-1.3 20 .3 29.8 1.9 12 6.6 23.5 13.7 33.4l148.9 207.9c7.6 10.6 20.2 16.2 33.1 14.7 40.3-4.9 78-32 95.7-68.6 5.4-11.9 4.3-25.9-3.4-36.6z")),"label"=>__("Untappd","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"up-down"=>array("svg"=>array("solid"=>array("width"=>256,"height"=>512,"path"=>"M249.6 392.3l-104 112c-9.094 9.781-26.09 9.781-35.19 0l-103.1-112c-6.484-6.984-8.219-17.17-4.406-25.92S14.45 352 24 352H80V160H24C14.45 160 5.812 154.3 1.999 145.6C-1.813 136.8-.0781 126.7 6.406 119.7l104-112c9.094-9.781 26.09-9.781 35.19 0l104 112c6.484 6.984 8.219 17.17 4.406 25.92C250.2 154.3 241.5 160 232 160H176v192h56c9.547 0 18.19 5.656 22 14.41S256.1 385.3 249.6 392.3z")),"label"=>__("Up Down","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"up-down-left-right"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M512 256c0 6.797-2.891 13.28-7.938 17.84l-80 72C419.6 349.9 413.8 352 408 352c-3.312 0-6.625-.6875-9.766-2.078C389.6 346.1 384 337.5 384 328V288h-96v96l40-.0013c9.484 0 18.06 5.578 21.92 14.23s2.25 18.78-4.078 25.83l-72 80C269.3 509.1 262.8 512 255.1 512s-13.28-2.89-17.84-7.937l-71.1-80c-6.328-7.047-7.938-17.17-4.078-25.83s12.44-14.23 21.92-14.23l39.1 .0013V288H128v40c0 9.484-5.578 18.06-14.23 21.92C110.6 351.3 107.3 352 104 352c-5.812 0-11.56-2.109-16.06-6.156l-80-72C2.891 269.3 0 262.8 0 256s2.891-13.28 7.938-17.84l80-72C95 159.8 105.1 158.3 113.8 162.1C122.4 165.9 128 174.5 128 184V224h95.1V128l-39.1-.0013c-9.484 0-18.06-5.578-21.92-14.23S159.8 94.99 166.2 87.94l71.1-80c9.125-10.09 26.56-10.09 35.69 0l72 80c6.328 7.047 7.938 17.17 4.078 25.83s-12.44 14.23-21.92 14.23l-40 .0013V224H384V184c0-9.484 5.578-18.06 14.23-21.92c8.656-3.812 18.77-2.266 25.83 4.078l80 72C509.1 242.7 512 249.2 512 256z")),"label"=>__("Up Down Left Right","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"up-long"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M285.1 145.7c-3.81 8.758-12.45 14.42-21.1 14.42L192 160.1V480c0 17.69-14.33 32-32 32s-32-14.31-32-32V160.1L55.1 160.1c-9.547 0-18.19-5.658-22-14.42c-3.811-8.758-2.076-18.95 4.408-25.94l104-112.1c9.498-10.24 25.69-10.24 35.19 0l104 112.1C288.1 126.7 289.8 136.9 285.1 145.7z")),"label"=>__("Up Long","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"up-right-and-down-left-from-center"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M208 281.4c-12.5-12.5-32.76-12.5-45.26-.002l-78.06 78.07l-30.06-30.06c-6.125-6.125-14.31-9.367-22.63-9.367c-4.125 0-8.279 .7891-12.25 2.43c-11.97 4.953-19.75 16.62-19.75 29.56v135.1C.0013 501.3 10.75 512 24 512h136c12.94 0 24.63-7.797 29.56-19.75c4.969-11.97 2.219-25.72-6.938-34.87l-30.06-30.06l78.06-78.07c12.5-12.49 12.5-32.75 .002-45.25L208 281.4zM487.1 0h-136c-12.94 0-24.63 7.797-29.56 19.75c-4.969 11.97-2.219 25.72 6.938 34.87l30.06 30.06l-78.06 78.07c-12.5 12.5-12.5 32.76 0 45.26l22.62 22.62c12.5 12.5 32.76 12.5 45.26 0l78.06-78.07l30.06 30.06c9.156 9.141 22.87 11.84 34.87 6.937C504.2 184.6 512 172.9 512 159.1V23.1C512 10.74 501.3 0 487.1 0z")),"label"=>__("Up Right And Down Left From Center","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","science-and-technology")),"up-right-from-square"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M384 320c-17.67 0-32 14.33-32 32v96H64V160h96c17.67 0 32-14.32 32-32s-14.33-32-32-32L64 96c-35.35 0-64 28.65-64 64V448c0 35.34 28.65 64 64 64h288c35.35 0 64-28.66 64-64v-96C416 334.3 401.7 320 384 320zM488 0H352c-12.94 0-24.62 7.797-29.56 19.75c-4.969 11.97-2.219 25.72 6.938 34.88L370.8 96L169.4 297.4c-12.5 12.5-12.5 32.75 0 45.25C175.6 348.9 183.8 352 192 352s16.38-3.125 22.62-9.375L416 141.3l41.38 41.38c9.156 9.141 22.88 11.84 34.88 6.938C504.2 184.6 512 172.9 512 160V24C512 10.74 501.3 0 488 0z")),"label"=>__("Up Right From Square","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"upload"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M105.4 182.6c12.5 12.49 32.76 12.5 45.25 .001L224 109.3V352c0 17.67 14.33 32 32 32c17.67 0 32-14.33 32-32V109.3l73.38 73.38c12.49 12.49 32.75 12.49 45.25-.001c12.49-12.49 12.49-32.75 0-45.25l-128-128C272.4 3.125 264.2 0 256 0S239.6 3.125 233.4 9.375L105.4 137.4C92.88 149.9 92.88 170.1 105.4 182.6zM480 352h-160c0 35.35-28.65 64-64 64s-64-28.65-64-64H32c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h448c17.67 0 32-14.33 32-32v-96C512 366.3 497.7 352 480 352zM432 456c-13.2 0-24-10.8-24-24c0-13.2 10.8-24 24-24s24 10.8 24 24C456 445.2 445.2 456 432 456z")),"label"=>__("Upload","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"ups"=>array("svg"=>array("brands"=>array("width"=>384,"height"=>512,"path"=>"M103.2 303c-5.2 3.6-32.6 13.1-32.6-19V180H37.9v102.6c0 74.9 80.2 51.1 97.9 39V180h-32.6zM4 74.82v220.9c0 103.7 74.9 135.2 187.7 184.1 112.4-48.9 187.7-80.2 187.7-184.1V74.82c-116.3-61.6-281.8-49.6-375.4 0zm358.1 220.9c0 86.6-53.2 113.6-170.4 165.3-117.5-51.8-170.5-78.7-170.5-165.3v-126.4c102.3-93.8 231.6-100 340.9-89.8zm-209.6-107.4v212.8h32.7v-68.7c24.4 7.3 71.7-2.6 71.7-78.5 0-97.4-80.7-80.92-104.4-65.6zm32.7 117.3v-100.3c8.4-4.2 38.4-12.7 38.4 49.3 0 67.9-36.4 51.8-38.4 51zm79.1-86.4c.1 47.3 51.6 42.5 52.2 70.4 .6 23.5-30.4 23-50.8 4.9v30.1c36.2 21.5 81.9 8.1 83.2-33.5 1.7-51.5-54.1-46.6-53.4-73.2 .6-20.3 30.6-20.5 48.5-2.2v-28.4c-28.5-22-79.9-9.2-79.7 31.9z")),"label"=>__("UPS","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"usb"=>array("svg"=>array("brands"=>array("width"=>640,"height"=>512,"path"=>"M641.5 256c0 3.1-1.7 6.1-4.5 7.5L547.9 317c-1.4 .8-2.8 1.4-4.5 1.4-1.4 0-3.1-.3-4.5-1.1-2.8-1.7-4.5-4.5-4.5-7.8v-35.6H295.7c25.3 39.6 40.5 106.9 69.6 106.9H392V354c0-5 3.9-8.9 8.9-8.9H490c5 0 8.9 3.9 8.9 8.9v89.1c0 5-3.9 8.9-8.9 8.9h-89.1c-5 0-8.9-3.9-8.9-8.9v-26.7h-26.7c-75.4 0-81.1-142.5-124.7-142.5H140.3c-8.1 30.6-35.9 53.5-69 53.5C32 327.3 0 295.3 0 256s32-71.3 71.3-71.3c33.1 0 61 22.8 69 53.5 39.1 0 43.9 9.5 74.6-60.4C255 88.7 273 95.7 323.8 95.7c7.5-20.9 27-35.6 50.4-35.6 29.5 0 53.5 23.9 53.5 53.5s-23.9 53.5-53.5 53.5c-23.4 0-42.9-14.8-50.4-35.6H294c-29.1 0-44.3 67.4-69.6 106.9h310.1v-35.6c0-3.3 1.7-6.1 4.5-7.8 2.8-1.7 6.4-1.4 8.9 .3l89.1 53.5c2.8 1.1 4.5 4.1 4.5 7.2z")),"label"=>__("USB","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"user"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M224 256c70.7 0 128-57.31 128-128s-57.3-128-128-128C153.3 0 96 57.31 96 128S153.3 256 224 256zM274.7 304H173.3C77.61 304 0 381.6 0 477.3c0 19.14 15.52 34.67 34.66 34.67h378.7C432.5 512 448 496.5 448 477.3C448 381.6 370.4 304 274.7 304z"),"regular"=>array("width"=>448,"height"=>512,"path"=>"M272 304h-96C78.8 304 0 382.8 0 480c0 17.67 14.33 32 32 32h384c17.67 0 32-14.33 32-32C448 382.8 369.2 304 272 304zM48.99 464C56.89 400.9 110.8 352 176 352h96c65.16 0 119.1 48.95 127 112H48.99zM224 256c70.69 0 128-57.31 128-128c0-70.69-57.31-128-128-128S96 57.31 96 128C96 198.7 153.3 256 224 256zM224 48c44.11 0 80 35.89 80 80c0 44.11-35.89 80-80 80S144 172.1 144 128C144 83.89 179.9 48 224 48z")),"label"=>__("User","ultimate-addons-for-gutenberg"),"custom_categories"=>array("social")),"user-astronaut"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M176 448C167.3 448 160 455.3 160 464V512h32v-48C192 455.3 184.8 448 176 448zM272 448c-8.75 0-16 7.25-16 16s7.25 16 16 16s16-7.25 16-16S280.8 448 272 448zM164 172l8.205 24.62c1.215 3.645 6.375 3.645 7.59 0L188 172l24.62-8.203c3.646-1.219 3.646-6.375 0-7.594L188 148L179.8 123.4c-1.215-3.648-6.375-3.648-7.59 0L164 148L139.4 156.2c-3.646 1.219-3.646 6.375 0 7.594L164 172zM336.1 315.4C304 338.6 265.1 352 224 352s-80.03-13.43-112.1-36.59C46.55 340.2 0 403.3 0 477.3C0 496.5 15.52 512 34.66 512H128v-64c0-17.75 14.25-32 32-32h128c17.75 0 32 14.25 32 32v64h93.34C432.5 512 448 496.5 448 477.3C448 403.3 401.5 340.2 336.1 315.4zM64 224h13.5C102.3 280.5 158.4 320 224 320s121.8-39.5 146.5-96H384c8.75 0 16-7.25 16-16v-96C400 103.3 392.8 96 384 96h-13.5C345.8 39.5 289.6 0 224 0S102.3 39.5 77.5 96H64C55.25 96 48 103.3 48 112v96C48 216.8 55.25 224 64 224zM104 136C104 113.9 125.5 96 152 96h144c26.5 0 48 17.88 48 40V160c0 53-43 96-96 96h-48c-53 0-96-43-96-96V136z")),"label"=>__("User Astronaut","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"user-check"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M274.7 304H173.3C77.61 304 0 381.6 0 477.3C0 496.5 15.52 512 34.66 512H413.3C432.5 512 448 496.5 448 477.3C448 381.6 370.4 304 274.7 304zM224 256c70.7 0 128-57.31 128-128S294.7 0 224 0C153.3 0 96 57.31 96 128S153.3 256 224 256zM632.3 134.4c-9.703-9-24.91-8.453-33.92 1.266l-87.05 93.75l-38.39-38.39c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l56 56C499.5 285.5 505.6 288 512 288h.4375c6.531-.125 12.72-2.891 17.16-7.672l104-112C642.6 158.6 642 143.4 632.3 134.4z")),"label"=>__("User Check","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"user-clock"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M496 224c-79.63 0-144 64.38-144 144s64.38 144 144 144s144-64.38 144-144S575.6 224 496 224zM544 384h-54.25C484.4 384 480 379.6 480 374.3V304c0-8.836 7.164-16 16-16c8.838 0 16 7.164 16 16v48h32c8.838 0 16 7.164 16 15.1S552.8 384 544 384zM224 256c70.7 0 128-57.31 128-128S294.7 0 224 0C153.3 0 96 57.31 96 128S153.3 256 224 256zM320 368c0-19.3 3.221-37.82 8.961-55.2C311.9 307.2 293.6 304 274.7 304H173.3C77.61 304 0 381.7 0 477.4C0 496.5 15.52 512 34.66 512H395C349.7 480.2 320 427.6 320 368z")),"label"=>__("User Clock","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"user-doctor"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M352 128C352 198.7 294.7 256 223.1 256C153.3 256 95.1 198.7 95.1 128C95.1 57.31 153.3 0 223.1 0C294.7 0 352 57.31 352 128zM287.1 362C260.4 369.1 239.1 394.2 239.1 424V448C239.1 452.2 241.7 456.3 244.7 459.3L260.7 475.3C266.9 481.6 277.1 481.6 283.3 475.3C289.6 469.1 289.6 458.9 283.3 452.7L271.1 441.4V424C271.1 406.3 286.3 392 303.1 392C321.7 392 336 406.3 336 424V441.4L324.7 452.7C318.4 458.9 318.4 469.1 324.7 475.3C330.9 481.6 341.1 481.6 347.3 475.3L363.3 459.3C366.3 456.3 368 452.2 368 448V424C368 394.2 347.6 369.1 320 362V308.8C393.5 326.7 448 392.1 448 472V480C448 497.7 433.7 512 416 512H32C14.33 512 0 497.7 0 480V472C0 393 54.53 326.7 128 308.8V370.3C104.9 377.2 88 398.6 88 424C88 454.9 113.1 480 144 480C174.9 480 200 454.9 200 424C200 398.6 183.1 377.2 160 370.3V304.2C162.7 304.1 165.3 304 168 304H280C282.7 304 285.3 304.1 288 304.2L287.1 362zM167.1 424C167.1 437.3 157.3 448 143.1 448C130.7 448 119.1 437.3 119.1 424C119.1 410.7 130.7 400 143.1 400C157.3 400 167.1 410.7 167.1 424z")),"label"=>__("User Doctor","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"user-gear"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M425.1 482.6c-2.303-1.25-4.572-2.559-6.809-3.93l-7.818 4.493c-6.002 3.504-12.83 5.352-19.75 5.352c-10.71 0-21.13-4.492-28.97-12.75c-18.41-20.09-32.29-44.15-40.22-69.9c-5.352-18.06 2.343-36.87 17.83-45.24l8.018-4.669c-.0664-2.621-.0664-5.242 0-7.859l-7.655-4.461c-12.3-6.953-19.4-19.66-19.64-33.38C305.6 306.3 290.4 304 274.7 304H173.3C77.61 304 0 381.7 0 477.4C0 496.5 15.52 512 34.66 512H413.3c5.727 0 10.9-1.727 15.66-4.188c-2.271-4.984-3.86-10.3-3.86-16.06V482.6zM224 256c70.7 0 128-57.31 128-128S294.7 0 224 0C153.3 0 96 57.31 96 128S153.3 256 224 256zM610.5 373.3c2.625-14 2.625-28.5 0-42.5l25.75-15c3-1.625 4.375-5.125 3.375-8.5c-6.75-21.5-18.25-41.13-33.25-57.38c-2.25-2.5-6-3.125-9-1.375l-25.75 14.88c-10.88-9.25-23.38-16.5-36.88-21.25V212.3c0-3.375-2.5-6.375-5.75-7c-22.25-5-45-4.875-66.25 0c-3.25 .625-5.625 3.625-5.625 7v29.88c-13.5 4.75-26 12-36.88 21.25L394.4 248.5c-2.875-1.75-6.625-1.125-9 1.375c-15 16.25-26.5 35.88-33.13 57.38c-1 3.375 .3751 6.875 3.25 8.5l25.75 15c-2.5 14-2.5 28.5 0 42.5l-25.75 15c-3 1.625-4.25 5.125-3.25 8.5c6.625 21.5 18.13 41 33.13 57.38c2.375 2.5 6 3.125 9 1.375l25.88-14.88c10.88 9.25 23.38 16.5 36.88 21.25v29.88c0 3.375 2.375 6.375 5.625 7c22.38 5 45 4.875 66.25 0c3.25-.625 5.75-3.625 5.75-7v-29.88c13.5-4.75 26-12 36.88-21.25l25.75 14.88c2.875 1.75 6.75 1.125 9-1.375c15-16.25 26.5-35.88 33.25-57.38c1-3.375-.3751-6.875-3.375-8.5L610.5 373.3zM496 400.5c-26.75 0-48.5-21.75-48.5-48.5s21.75-48.5 48.5-48.5c26.75 0 48.5 21.75 48.5 48.5S522.8 400.5 496 400.5z")),"label"=>__("User Gear","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"user-graduate"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M45.63 79.75L52 81.25v58.5C45 143.9 40 151.3 40 160c0 8.375 4.625 15.38 11.12 19.75L35.5 242C33.75 248.9 37.63 256 43.13 256h41.75c5.5 0 9.375-7.125 7.625-13.1L76.88 179.8C83.38 175.4 88 168.4 88 160c0-8.75-5-16.12-12-20.25V87.13L128 99.63l.001 60.37c0 70.75 57.25 128 128 128s127.1-57.25 127.1-128L384 99.62l82.25-19.87c18.25-4.375 18.25-27 0-31.5l-190.4-46c-13-3-26.62-3-39.63 0l-190.6 46C27.5 52.63 27.5 75.38 45.63 79.75zM359.2 312.8l-103.2 103.2l-103.2-103.2c-69.93 22.3-120.8 87.2-120.8 164.5C32 496.5 47.53 512 66.67 512h378.7C464.5 512 480 496.5 480 477.3C480 400 429.1 335.1 359.2 312.8z")),"label"=>__("User Graduate","ultimate-addons-for-gutenberg"),"custom_categories"=>array("education")),"user-group"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M224 256c70.7 0 128-57.31 128-128S294.7 0 224 0C153.3 0 96 57.31 96 128S153.3 256 224 256zM274.7 304H173.3c-95.73 0-173.3 77.6-173.3 173.3C0 496.5 15.52 512 34.66 512H413.3C432.5 512 448 496.5 448 477.3C448 381.6 370.4 304 274.7 304zM479.1 320h-73.85C451.2 357.7 480 414.1 480 477.3C480 490.1 476.2 501.9 470 512h138C625.7 512 640 497.6 640 479.1C640 391.6 568.4 320 479.1 320zM432 256C493.9 256 544 205.9 544 144S493.9 32 432 32c-25.11 0-48.04 8.555-66.72 22.51C376.8 76.63 384 101.4 384 128c0 35.52-11.93 68.14-31.59 94.71C372.7 243.2 400.8 256 432 256z")),"label"=>__("User Group","ultimate-addons-for-gutenberg"),"custom_categories"=>array("social")),"user-injured"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M277.4 11.98C261.1 4.469 243.1 0 224 0C170.3 0 124.5 33.13 105.5 80h81.07L277.4 11.98zM342.5 80c-7.895-19.47-20.66-36.19-36.48-49.51L240 80H342.5zM224 256c70.7 0 128-57.31 128-128c0-5.48-.9453-10.7-1.613-16H97.61C96.95 117.3 96 122.5 96 128C96 198.7 153.3 256 224 256zM272 416h-45.14l58.64 93.83C305.4 503.1 320 485.8 320 464C320 437.5 298.5 416 272 416zM274.7 304H173.3c-5.393 0-10.71 .3242-15.98 .8047L206.9 384H272c44.13 0 80 35.88 80 80c0 18.08-6.252 34.59-16.4 48h77.73C432.5 512 448 496.5 448 477.3C448 381.6 370.4 304 274.7 304zM0 477.3C0 496.5 15.52 512 34.66 512H64v-169.1C24.97 374.7 0 423.1 0 477.3zM96 322.4V512h153.1L123.7 311.3C114.1 314.2 104.8 317.9 96 322.4z")),"label"=>__("User Injured","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"user-large"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M256 288c79.53 0 144-64.47 144-144s-64.47-144-144-144c-79.52 0-144 64.47-144 144S176.5 288 256 288zM351.1 320H160c-88.36 0-160 71.63-160 160c0 17.67 14.33 32 31.1 32H480c17.67 0 31.1-14.33 31.1-32C512 391.6 440.4 320 351.1 320z")),"label"=>__("User Large","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"user-large-slash"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M284.9 320l-60.9-.0002c-88.36 0-160 71.63-160 159.1C63.1 497.7 78.33 512 95.1 512l448-.0039c.0137 0-.0137 0 0 0l-14.13-.0013L284.9 320zM630.8 469.1l-249.5-195.5c48.74-22.1 82.65-72.1 82.65-129.6c0-79.53-64.47-143.1-143.1-143.1c-69.64 0-127.3 49.57-140.6 115.3L38.81 5.109C34.41 1.672 29.19 0 24.03 0C16.91 0 9.845 3.156 5.127 9.187c-8.187 10.44-6.375 25.53 4.062 33.7L601.2 506.9c10.5 8.203 25.56 6.328 33.69-4.078C643.1 492.4 641.2 477.3 630.8 469.1z")),"label"=>__("User Large Slash","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"user-lock"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M592 288H576V212.7c0-41.84-30.03-80.04-71.66-84.27C456.5 123.6 416 161.1 416 208V288h-16C373.6 288 352 309.6 352 336v128c0 26.4 21.6 48 48 48h192c26.4 0 48-21.6 48-48v-128C640 309.6 618.4 288 592 288zM496 432c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S513.6 432 496 432zM528 288h-64V208c0-17.62 14.38-32 32-32s32 14.38 32 32V288zM224 256c70.7 0 128-57.31 128-128S294.7 0 224 0C153.3 0 96 57.31 96 128S153.3 256 224 256zM320 336c0-8.672 1.738-16.87 4.303-24.7C308.6 306.6 291.9 304 274.7 304H173.3C77.61 304 0 381.7 0 477.4C0 496.5 15.52 512 34.66 512h301.7C326.3 498.6 320 482.1 320 464V336z")),"label"=>__("User Lock","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"user-minus"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M274.7 304H173.3C77.61 304 0 381.6 0 477.3C0 496.5 15.52 512 34.66 512h378.7C432.5 512 448 496.5 448 477.3C448 381.6 370.4 304 274.7 304zM224 256c70.7 0 128-57.31 128-128S294.7 0 224 0C153.3 0 96 57.31 96 128S153.3 256 224 256zM616 200h-144C458.8 200 448 210.8 448 224s10.75 24 24 24h144C629.3 248 640 237.3 640 224S629.3 200 616 200z")),"label"=>__("User Minus","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"user-ninja"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M64 192c27.25 0 51.75-11.5 69.25-29.75c15 54 64 93.75 122.8 93.75c70.75 0 127.1-57.25 127.1-128s-57.25-128-127.1-128c-50.38 0-93.63 29.38-114.5 71.75C124.1 47.75 96 32 64 32c0 33.37 17.12 62.75 43.13 80C81.13 129.3 64 158.6 64 192zM208 96h95.1C321.7 96 336 110.3 336 128h-160C176 110.3 190.3 96 208 96zM337.8 306.9L256 416L174.2 306.9C93.36 321.6 32 392.2 32 477.3c0 19.14 15.52 34.67 34.66 34.67H445.3c19.14 0 34.66-15.52 34.66-34.67C480 392.2 418.6 321.6 337.8 306.9z")),"label"=>__("User Ninja","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"user-nurse"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M224 304c70.75 0 128-57.25 128-128V65.88c0-13.38-8.25-25.38-20.75-30L246.5 4.125C239.3 1.375 231.6 0 224 0S208.8 1.375 201.5 4.125L116.8 35.88C104.3 40.5 96 52.5 96 65.88V176C96 246.8 153.3 304 224 304zM184 71.63c0-2.75 2.25-5 5-5h21.62V45c0-2.75 2.25-5 5-5h16.75c2.75 0 5 2.25 5 5v21.62H259c2.75 0 5 2.25 5 5v16.75c0 2.75-2.25 5-5 5h-21.62V115c0 2.75-2.25 5-5 5H215.6c-2.75 0-5-2.25-5-5V93.38H189c-2.75 0-5-2.25-5-5V71.63zM144 160h160v16C304 220.1 268.1 256 224 256S144 220.1 144 176V160zM327.2 312.8L224 416L120.8 312.8c-69.93 22.3-120.8 87.25-120.8 164.6C.0006 496.5 15.52 512 34.66 512H413.3c19.14 0 34.66-15.46 34.66-34.61C447.1 400.1 397.1 335.1 327.2 312.8z")),"label"=>__("User Nurse","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"user-pen"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M223.1 256c70.7 0 128-57.31 128-128s-57.3-128-128-128C153.3 0 96 57.31 96 128S153.3 256 223.1 256zM274.7 304H173.3C77.61 304 0 381.7 0 477.4C0 496.5 15.52 512 34.66 512h286.4c-1.246-5.531-1.43-11.31-.2832-17.04l14.28-71.41c1.943-9.723 6.676-18.56 13.68-25.56l45.72-45.72C363.3 322.4 321.2 304 274.7 304zM371.4 420.6c-2.514 2.512-4.227 5.715-4.924 9.203l-14.28 71.41c-1.258 6.289 4.293 11.84 10.59 10.59l71.42-14.29c3.482-.6992 6.682-2.406 9.195-4.922l125.3-125.3l-72.01-72.01L371.4 420.6zM629.5 255.7l-21.1-21.11c-14.06-14.06-36.85-14.06-50.91 0l-38.13 38.14l72.01 72.01l38.13-38.13C643.5 292.5 643.5 269.7 629.5 255.7z")),"label"=>__("User Pen","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"user-plus"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M224 256c70.7 0 128-57.31 128-128S294.7 0 224 0C153.3 0 96 57.31 96 128S153.3 256 224 256zM274.7 304H173.3C77.61 304 0 381.6 0 477.3C0 496.5 15.52 512 34.66 512h378.7C432.5 512 448 496.5 448 477.3C448 381.6 370.4 304 274.7 304zM616 200h-48v-48C568 138.8 557.3 128 544 128s-24 10.75-24 24v48h-48C458.8 200 448 210.8 448 224s10.75 24 24 24h48v48C520 309.3 530.8 320 544 320s24-10.75 24-24v-48h48C629.3 248 640 237.3 640 224S629.3 200 616 200z")),"label"=>__("User Plus","ultimate-addons-for-gutenberg"),"custom_categories"=>array("social")),"user-secret"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M377.7 338.8l37.15-92.87C419 235.4 411.3 224 399.1 224h-57.48C348.5 209.2 352 193 352 176c0-4.117-.8359-8.057-1.217-12.08C390.7 155.1 416 142.3 416 128c0-16.08-31.75-30.28-80.31-38.99C323.8 45.15 304.9 0 277.4 0c-10.38 0-19.62 4.5-27.38 10.5c-15.25 11.88-36.75 11.88-52 0C190.3 4.5 181.1 0 170.7 0C143.2 0 124.4 45.16 112.5 88.98C63.83 97.68 32 111.9 32 128c0 14.34 25.31 27.13 65.22 35.92C96.84 167.9 96 171.9 96 176C96 193 99.47 209.2 105.5 224H48.02C36.7 224 28.96 235.4 33.16 245.9l37.15 92.87C27.87 370.4 0 420.4 0 477.3C0 496.5 15.52 512 34.66 512H413.3C432.5 512 448 496.5 448 477.3C448 420.4 420.1 370.4 377.7 338.8zM176 479.1L128 288l64 32l16 32L176 479.1zM271.1 479.1L240 352l16-32l64-32L271.1 479.1zM320 186C320 207 302.8 224 281.6 224h-12.33c-16.46 0-30.29-10.39-35.63-24.99C232.1 194.9 228.4 192 224 192S215.9 194.9 214.4 199C209 213.6 195.2 224 178.8 224h-12.33C145.2 224 128 207 128 186V169.5C156.3 173.6 188.1 176 224 176s67.74-2.383 96-6.473V186z")),"label"=>__("User Secret","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"user-shield"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M622.3 271.1l-115.1-45.01c-4.125-1.629-12.62-3.754-22.25 0L369.8 271.1C359 275.2 352 285.1 352 295.1c0 111.6 68.75 188.8 132.9 213.9c9.625 3.75 18 1.625 22.25 0C558.4 489.9 640 420.5 640 295.1C640 285.1 633 275.2 622.3 271.1zM496 462.4V273.2l95.5 37.38C585.9 397.8 530.6 446 496 462.4zM224 256c70.7 0 128-57.31 128-128S294.7 0 224 0C153.3 0 96 57.31 96 128S153.3 256 224 256zM320.6 310.3C305.9 306.3 290.6 304 274.7 304H173.3C77.61 304 0 381.7 0 477.4C0 496.5 15.52 512 34.66 512H413.3c3.143 0 5.967-1.004 8.861-1.789C369.7 469.8 324.1 400.3 320.6 310.3z")),"label"=>__("User Shield","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"user-slash"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M95.1 477.3c0 19.14 15.52 34.67 34.66 34.67h378.7c5.625 0 10.73-1.65 15.42-4.029L264.9 304.3C171.3 306.7 95.1 383.1 95.1 477.3zM630.8 469.1l-277.1-217.9c54.69-14.56 95.18-63.95 95.18-123.2C447.1 57.31 390.7 0 319.1 0C250.2 0 193.7 55.93 192.3 125.4l-153.4-120.3C34.41 1.672 29.19 0 24.03 0C16.91 0 9.845 3.156 5.127 9.187c-8.187 10.44-6.375 25.53 4.062 33.7L601.2 506.9c10.5 8.203 25.56 6.328 33.69-4.078C643.1 492.4 641.2 477.3 630.8 469.1z")),"label"=>__("User Slash","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"user-tag"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M351.8 367.3v-44.1C328.5 310.7 302.4 304 274.7 304H173.3c-95.73 0-173.3 77.65-173.3 173.4C.0005 496.5 15.52 512 34.66 512h378.7c11.86 0 21.82-6.337 28.07-15.43l-61.65-61.57C361.7 416.9 351.8 392.9 351.8 367.3zM224 256c70.7 0 128-57.31 128-128S294.7 0 224 0C153.3 0 96 57.31 96 128S153.3 256 224 256zM630.6 364.8L540.3 274.8C528.3 262.8 512 256 495 256h-79.23c-17.75 0-31.99 14.25-31.99 32l.0147 79.2c0 17 6.647 33.15 18.65 45.15l90.31 90.27c12.5 12.5 32.74 12.5 45.24 0l92.49-92.5C643.1 397.6 643.1 377.3 630.6 364.8zM447.8 343.9c-13.25 0-24-10.62-24-24c0-13.25 10.75-24 24-24c13.38 0 24 10.75 24 24S461.1 343.9 447.8 343.9z")),"label"=>__("User Tag","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"user-tie"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M352 128C352 198.7 294.7 256 224 256C153.3 256 96 198.7 96 128C96 57.31 153.3 0 224 0C294.7 0 352 57.31 352 128zM209.1 359.2L176 304H272L238.9 359.2L272.2 483.1L311.7 321.9C388.9 333.9 448 400.7 448 481.3C448 498.2 434.2 512 417.3 512H30.72C13.75 512 0 498.2 0 481.3C0 400.7 59.09 333.9 136.3 321.9L175.8 483.1L209.1 359.2z")),"label"=>__("User Tie","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"user-xmark"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M274.7 304H173.3C77.61 304 0 381.6 0 477.3C0 496.5 15.52 512 34.66 512h378.7C432.5 512 448 496.5 448 477.3C448 381.6 370.4 304 274.7 304zM224 256c70.7 0 128-57.31 128-128S294.7 0 224 0C153.3 0 96 57.31 96 128S153.3 256 224 256zM577.9 223.1l47.03-47.03c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0L544 190.1l-47.03-47.03c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l47.03 47.03l-47.03 47.03c-9.375 9.375-9.375 24.56 0 33.94c9.373 9.373 24.56 9.381 33.94 0L544 257.9l47.03 47.03c9.373 9.373 24.56 9.381 33.94 0c9.375-9.375 9.375-24.56 0-33.94L577.9 223.1z")),"label"=>__("User Xmark","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"users"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M319.9 320c57.41 0 103.1-46.56 103.1-104c0-57.44-46.54-104-103.1-104c-57.41 0-103.1 46.56-103.1 104C215.9 273.4 262.5 320 319.9 320zM369.9 352H270.1C191.6 352 128 411.7 128 485.3C128 500.1 140.7 512 156.4 512h327.2C499.3 512 512 500.1 512 485.3C512 411.7 448.4 352 369.9 352zM512 160c44.18 0 80-35.82 80-80S556.2 0 512 0c-44.18 0-80 35.82-80 80S467.8 160 512 160zM183.9 216c0-5.449 .9824-10.63 1.609-15.91C174.6 194.1 162.6 192 149.9 192H88.08C39.44 192 0 233.8 0 285.3C0 295.6 7.887 304 17.62 304h199.5C196.7 280.2 183.9 249.7 183.9 216zM128 160c44.18 0 80-35.82 80-80S172.2 0 128 0C83.82 0 48 35.82 48 80S83.82 160 128 160zM551.9 192h-61.84c-12.8 0-24.88 3.037-35.86 8.24C454.8 205.5 455.8 210.6 455.8 216c0 33.71-12.78 64.21-33.16 88h199.7C632.1 304 640 295.6 640 285.3C640 233.8 600.6 192 551.9 192z")),"label"=>__("Users","ultimate-addons-for-gutenberg"),"custom_categories"=>array("social")),"users-between-lines"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M0 24C0 10.75 10.75 0 24 0H616C629.3 0 640 10.75 640 24C640 37.25 629.3 48 616 48H24C10.75 48 0 37.25 0 24zM0 488C0 474.7 10.75 464 24 464H616C629.3 464 640 474.7 640 488C640 501.3 629.3 512 616 512H24C10.75 512 0 501.3 0 488zM211.2 160C211.2 195.3 182.5 224 147.2 224C111.9 224 83.2 195.3 83.2 160C83.2 124.7 111.9 96 147.2 96C182.5 96 211.2 124.7 211.2 160zM32 320C32 284.7 60.65 256 96 256H192C204.2 256 215.7 259.4 225.4 265.4C188.2 280.5 159.8 312.6 149.6 352H64C46.33 352 32 337.7 32 320V320zM415.9 264.6C425.3 259.1 436.3 256 448 256H544C579.3 256 608 284.7 608 320C608 337.7 593.7 352 576 352H493.6C483.2 311.9 453.1 279.4 415.9 264.6zM391.2 290.4C423.3 297.8 449.3 321.3 460.1 352C463.7 362 465.6 372.8 465.6 384C465.6 401.7 451.3 416 433.6 416H209.6C191.9 416 177.6 401.7 177.6 384C177.6 372.8 179.5 362 183.1 352C193.6 322.3 218.3 299.2 249.1 291.1C256.1 289.1 265.1 288 273.6 288H369.6C377 288 384.3 288.8 391.2 290.4zM563.2 160C563.2 195.3 534.5 224 499.2 224C463.9 224 435.2 195.3 435.2 160C435.2 124.7 463.9 96 499.2 96C534.5 96 563.2 124.7 563.2 160zM241.6 176C241.6 131.8 277.4 96 321.6 96C365.8 96 401.6 131.8 401.6 176C401.6 220.2 365.8 256 321.6 256C277.4 256 241.6 220.2 241.6 176z")),"label"=>__("Users Between Lines","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"users-gear"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M512 160c44.18 0 80-35.82 80-80S556.2 0 512 0c-44.18 0-80 35.82-80 80S467.8 160 512 160zM128 160c44.18 0 80-35.82 80-80S172.2 0 128 0C83.82 0 48 35.82 48 80S83.82 160 128 160zM319.9 320c57.41 0 103.1-46.56 103.1-104c0-57.44-46.54-104-103.1-104c-57.41 0-103.1 46.56-103.1 104C215.9 273.4 262.5 320 319.9 320zM368 400c0-16.69 3.398-32.46 8.619-47.36C374.3 352.5 372.2 352 369.9 352H270.1C191.6 352 128 411.7 128 485.3C128 500.1 140.7 512 156.4 512h266.1C389.5 485.6 368 445.5 368 400zM183.9 216c0-5.449 .9824-10.63 1.609-15.91C174.6 194.1 162.6 192 149.9 192H88.08C39.44 192 0 233.8 0 285.3C0 295.6 7.887 304 17.62 304h199.5C196.7 280.2 183.9 249.7 183.9 216zM551.9 192h-61.84c-12.8 0-24.88 3.037-35.86 8.24C454.8 205.5 455.8 210.6 455.8 216c0 21.47-5.625 41.38-14.65 59.34C462.2 263.4 486.1 256 512 256c42.48 0 80.27 18.74 106.6 48h3.756C632.1 304 640 295.6 640 285.3C640 233.8 600.6 192 551.9 192zM618.1 366.7c-5.025-16.01-13.59-30.62-24.75-42.71c-1.674-1.861-4.467-2.326-6.699-1.023l-19.17 11.07c-8.096-6.887-17.4-12.28-27.45-15.82V295.1c0-2.514-1.861-4.746-4.281-5.213c-16.56-3.723-33.5-3.629-49.32 0C484.9 291.2 483.1 293.5 483.1 295.1v22.24c-10.05 3.537-19.36 8.932-27.45 15.82l-19.26-11.07c-2.139-1.303-4.932-.8379-6.697 1.023c-11.17 12.1-19.73 26.71-24.66 42.71c-.7441 2.512 .2793 5.117 2.42 6.326l19.17 11.17c-1.859 10.42-1.859 21.21 0 31.64l-19.17 11.17c-2.234 1.209-3.164 3.816-2.42 6.328c4.932 16.01 13.49 30.52 24.66 42.71c1.766 1.863 4.467 2.328 6.697 1.025l19.26-11.07c8.094 6.887 17.4 12.28 27.45 15.82v22.24c0 2.514 1.77 4.746 4.188 5.211c16.66 3.723 33.5 3.629 49.32 0c2.42-.4648 4.281-2.697 4.281-5.211v-22.24c10.05-3.535 19.36-8.932 27.45-15.82l19.17 11.07c2.141 1.303 5.025 .8379 6.699-1.025c11.17-12.1 19.73-26.7 24.75-42.71c.7441-2.512-.2773-5.119-2.512-6.328l-19.17-11.17c1.953-10.42 1.953-21.22 0-31.64l19.17-11.17C618.7 371.8 619.7 369.2 618.1 366.7zM512 432c-17.67 0-32-14.33-32-32c0-17.67 14.33-32 32-32s32 14.33 32 32C544 417.7 529.7 432 512 432z")),"label"=>__("Users Gear","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"users-line"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M211.2 96C211.2 131.3 182.5 160 147.2 160C111.9 160 83.2 131.3 83.2 96C83.2 60.65 111.9 32 147.2 32C182.5 32 211.2 60.65 211.2 96zM32 256C32 220.7 60.65 192 96 192H192C204.2 192 215.7 195.4 225.4 201.4C188.2 216.5 159.8 248.6 149.6 288H64C46.33 288 32 273.7 32 256V256zM415.9 200.6C425.3 195.1 436.3 192 448 192H544C579.3 192 608 220.7 608 256C608 273.7 593.7 288 576 288H493.6C483.2 247.9 453.1 215.4 415.9 200.6zM391.2 226.4C423.3 233.8 449.3 257.3 460.1 288C463.7 298 465.6 308.8 465.6 320C465.6 337.7 451.3 352 433.6 352H209.6C191.9 352 177.6 337.7 177.6 320C177.6 308.8 179.5 298 183.1 288C193.6 258.3 218.3 235.2 249.1 227.1C256.1 225.1 265.1 224 273.6 224H369.6C377 224 384.3 224.8 391.2 226.4zM563.2 96C563.2 131.3 534.5 160 499.2 160C463.9 160 435.2 131.3 435.2 96C435.2 60.65 463.9 32 499.2 32C534.5 32 563.2 60.65 563.2 96zM241.6 112C241.6 67.82 277.4 32 321.6 32C365.8 32 401.6 67.82 401.6 112C401.6 156.2 365.8 192 321.6 192C277.4 192 241.6 156.2 241.6 112zM608 416C625.7 416 640 430.3 640 448C640 465.7 625.7 480 608 480H32C14.33 480 0 465.7 0 448C0 430.3 14.33 416 32 416H608z")),"label"=>__("Users Line","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"users-rays"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M112.1 79.03C122.3 88.4 122.3 103.6 112.1 112.1C103.6 122.3 88.4 122.3 79.03 112.1L7.029 40.97C-2.343 31.6-2.343 16.4 7.029 7.029C16.4-2.343 31.6-2.343 40.97 7.029L112.1 79.03zM599 7.029C608.4-2.343 623.6-2.343 632.1 7.029C642.3 16.4 642.3 31.6 632.1 40.97L560.1 112.1C551.6 122.3 536.4 122.3 527 112.1C517.7 103.6 517.7 88.4 527 79.03L599 7.029zM7.029 471L79.03 399C88.4 389.7 103.6 389.7 112.1 399C122.3 408.4 122.3 423.6 112.1 432.1L40.97 504.1C31.6 514.3 16.4 514.3 7.029 504.1C-2.343 495.6-2.343 480.4 7.029 471V471zM527 432.1C517.7 423.6 517.7 408.4 527 399C536.4 389.7 551.6 389.7 560.1 399L632.1 471C642.3 480.4 642.3 495.6 632.1 504.1C623.6 514.3 608.4 514.3 599 504.1L527 432.1zM256 192C256 156.7 284.7 128 320 128C355.3 128 384 156.7 384 192C384 227.3 355.3 256 320 256C284.7 256 256 227.3 256 192zM265.5 289.5C266.3 289.3 267.1 289.1 267.1 288.1C271.9 288.3 275.9 288 280 288H360C364.1 288 368.1 288.3 372 288.1C396.6 293.1 416.9 309.7 426.3 331.1C426.9 333.3 427.4 334.6 427.9 336C430.6 343.5 432 351.6 432 360C432 373.3 421.3 384 408 384H232C218.7 384 208 373.3 208 360C208 351.6 209.4 343.5 212.1 336C220.4 312.5 240.6 294.6 265.5 289.5V289.5zM127.8 176C127.8 149.5 149.3 128 175.8 128C202.3 128 223.8 149.5 223.8 176C223.8 202.5 202.3 224 175.8 224C149.3 224 127.8 202.5 127.8 176V176zM218.7 256C227.8 256 236.5 258.3 244 262.4C211.6 274.3 186.8 301.9 178.8 336H122.7C107.9 336 96 324.1 96 309.3C96 279.9 119.9 256 149.3 256H218.7zM517.3 336H461.2C453.2 301.9 428.4 274.3 395.1 262.4C403.5 258.3 412.2 256 421.3 256H490.7C520.1 256 544 279.9 544 309.3C544 324.1 532.1 336 517.3 336H517.3zM416 176C416 149.5 437.5 128 464 128C490.5 128 512 149.5 512 176C512 202.5 490.5 224 464 224C437.5 224 416 202.5 416 176z")),"label"=>__("Users Rays","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"users-rectangle"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M223.8 176C223.8 202.5 202.3 224 175.8 224C149.3 224 127.8 202.5 127.8 176C127.8 149.5 149.3 128 175.8 128C202.3 128 223.8 149.5 223.8 176zM96 309.3C96 279.9 119.9 256 149.3 256H218.7C227.8 256 236.5 258.3 244 262.4C211.6 274.3 186.8 301.9 178.8 336H122.7C107.9 336 96 324.1 96 309.3H96zM395.1 262.4C403.5 258.3 412.2 256 421.3 256H490.7C520.1 256 544 279.9 544 309.3C544 324.1 532.1 336 517.3 336H461.2C453.2 301.9 428.4 274.3 395.1 262.4H395.1zM372 288.1C398 293.4 419.3 311.7 427.9 336C430.6 343.5 432 351.6 432 360C432 373.3 421.3 384 408 384H232C218.7 384 208 373.3 208 360C208 351.6 209.4 343.5 212.1 336C220.7 311.7 241.1 293.4 267.1 288.1C271.9 288.3 275.9 288 280 288H360C364.1 288 368.1 288.3 372 288.1V288.1zM512 176C512 202.5 490.5 224 464 224C437.5 224 416 202.5 416 176C416 149.5 437.5 128 464 128C490.5 128 512 149.5 512 176zM256 192C256 156.7 284.7 128 320 128C355.3 128 384 156.7 384 192C384 227.3 355.3 256 320 256C284.7 256 256 227.3 256 192zM544 0C597 0 640 42.98 640 96V416C640 469 597 512 544 512H96C42.98 512 0 469 0 416V96C0 42.98 42.98 0 96 0H544zM64 416C64 433.7 78.33 448 96 448H544C561.7 448 576 433.7 576 416V96C576 78.33 561.7 64 544 64H96C78.33 64 64 78.33 64 96V416z")),"label"=>__("Users Rectangle","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"users-slash"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M512 160c44.18 0 80-35.82 80-80S556.2 0 512 0c-44.18 0-80 35.82-80 80S467.8 160 512 160zM490.1 192c-12.8 0-24.88 3.037-35.86 8.24C454.8 205.5 455.8 210.6 455.8 216c0 33.71-12.78 64.21-33.16 88h199.7C632.1 304 640 295.6 640 285.3C640 233.8 600.6 192 551.9 192H490.1zM396.6 285.5C413.4 267.2 423.8 242.9 423.8 216c0-57.44-46.54-104-103.1-104c-35.93 0-67.07 18.53-85.59 46.3L193.1 126.1C202.4 113.1 208 97.24 208 80C208 35.82 172.2 0 128 0C103.8 0 82.52 10.97 67.96 27.95L38.81 5.109C34.41 1.672 29.19 0 24.03 0C16.91 0 9.846 3.156 5.127 9.188C-3.061 19.62-1.248 34.72 9.189 42.89l591.1 463.1c10.5 8.203 25.56 6.328 33.69-4.078c8.188-10.44 6.375-25.53-4.062-33.7L396.6 285.5zM270.1 352C191.6 352 128 411.7 128 485.3C128 500.1 140.7 512 156.4 512h327.2c11.62 0 21.54-6.583 25.95-15.96L325.7 352H270.1zM186.1 243.2L121.6 192H88.08C39.44 192 0 233.8 0 285.3C0 295.6 7.887 304 17.62 304h199.5C202.4 286.8 191.8 266.1 186.1 243.2z")),"label"=>__("Users Slash","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"users-viewfinder"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M48 136C48 149.3 37.25 160 24 160C10.75 160 0 149.3 0 136V32C0 14.33 14.33 0 32 0H136C149.3 0 160 10.75 160 24C160 37.25 149.3 48 136 48H48V136zM127.8 176C127.8 149.5 149.3 128 175.8 128C202.3 128 223.8 149.5 223.8 176C223.8 202.5 202.3 224 175.8 224C149.3 224 127.8 202.5 127.8 176V176zM218.7 256C227.8 256 236.5 258.3 244 262.4C211.6 274.3 186.8 301.9 178.8 336H122.7C107.9 336 96 324.1 96 309.3C96 279.9 119.9 256 149.3 256H218.7zM517.3 336H461.2C453.2 301.9 428.4 274.3 395.1 262.4C403.5 258.3 412.2 256 421.3 256H490.7C520.1 256 544 279.9 544 309.3C544 324.1 532.1 336 517.3 336H517.3zM432 360C432 373.3 421.3 384 408 384H232C218.7 384 208 373.3 208 360C208 351.6 209.4 343.5 212.1 336C220.7 311.7 241.1 293.4 267.1 288.1C271.9 288.3 275.9 288 280 288H360C364.1 288 368.1 288.3 372 288.1C398 293.4 419.3 311.7 427.9 336C430.6 343.5 432 351.6 432 360zM416 176C416 149.5 437.5 128 464 128C490.5 128 512 149.5 512 176C512 202.5 490.5 224 464 224C437.5 224 416 202.5 416 176zM384 192C384 227.3 355.3 256 320 256C284.7 256 256 227.3 256 192C256 156.7 284.7 128 320 128C355.3 128 384 156.7 384 192zM480 24C480 10.75 490.7 0 504 0H608C625.7 0 640 14.33 640 32V136C640 149.3 629.3 160 616 160C602.7 160 592 149.3 592 136V48H504C490.7 48 480 37.25 480 24zM48 464H136C149.3 464 160 474.7 160 488C160 501.3 149.3 512 136 512H32C14.33 512 0 497.7 0 480V376C0 362.7 10.75 352 24 352C37.25 352 48 362.7 48 376V464zM504 464H592V376C592 362.7 602.7 352 616 352C629.3 352 640 362.7 640 376V480C640 497.7 625.7 512 608 512H504C490.7 512 480 501.3 480 488C480 474.7 490.7 464 504 464z")),"label"=>__("Users Viewfinder","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"usps"=>array("svg"=>array("brands"=>array("width"=>576,"height"=>512,"path"=>"M460.3 241.7c25.8-41.3 15.2-48.8-11.7-48.8h-27c-.1 0-1.5-1.4-10.9 8-11.2 5.6-37.9 6.3-37.9 8.7 0 4.5 70.3-3.1 88.1 0 9.5 1.5-1.5 20.4-4.4 32-.5 4.5 2.4 2.3 3.8 .1zm-112.1 22.6c64-21.3 97.3-23.9 102-26.2 4.4-2.9-4.4-6.6-26.2-5.8-51.7 2.2-137.6 37.1-172.6 53.9l-30.7-93.3h196.6c-2.7-28.2-152.9-22.6-337.9-22.6L27 415.8c196.4-97.3 258.9-130.3 321.2-151.5zM94.7 96c253.3 53.7 330 65.7 332.1 85.2 36.4 0 45.9 0 52.4 6.6 21.1 19.7-14.6 67.7-14.6 67.7-4.4 2.9-406.4 160.2-406.4 160.2h423.1L549 96z")),"label"=>__("United States Postal Service","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"ussunnah"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M156.8 285.1l5.7 14.4h-8.2c-1.3-3.2-3.1-7.7-3.8-9.5-2.5-6.3-1.1-8.4 0-10 1.9-2.7 3.2-4.4 3.6-5.2 0 2.2 .8 5.7 2.7 10.3zm297.3 18.8c-2.1 13.8-5.7 27.1-10.5 39.7l43 23.4-44.8-18.8c-5.3 13.2-12 25.6-19.9 37.2l34.2 30.2-36.8-26.4c-8.4 11.8-18 22.6-28.7 32.3l24.9 34.7-28.1-31.8c-11 9.6-23.1 18-36.1 25.1l15.7 37.2-19.3-35.3c-13.1 6.8-27 12.1-41.6 15.9l6.7 38.4-10.5-37.4c-14.3 3.4-29.2 5.3-44.5 5.4L256 512l-1.9-38.4c-15.3-.1-30.2-2-44.5-5.3L199 505.6l6.7-38.2c-14.6-3.7-28.6-9.1-41.7-15.8l-19.2 35.1 15.6-37c-13-7-25.2-15.4-36.2-25.1l-27.9 31.6 24.7-34.4c-10.7-9.7-20.4-20.5-28.8-32.3l-36.5 26.2 33.9-29.9c-7.9-11.6-14.6-24.1-20-37.3l-44.4 18.7L67.8 344c-4.8-12.7-8.4-26.1-10.5-39.9l-51 9 50.3-14.2c-1.1-8.5-1.7-17.1-1.7-25.9 0-4.7 .2-9.4 .5-14.1L0 256l56-2.8c1.3-13.1 3.8-25.8 7.5-38.1L6.4 199l58.9 10.4c4-12 9.1-23.5 15.2-34.4l-55.1-30 58.3 24.6C90 159 97.2 149.2 105.3 140L55.8 96.4l53.9 38.7c8.1-8.6 17-16.5 26.6-23.6l-40-55.6 45.6 51.6c9.5-6.6 19.7-12.3 30.3-17.2l-27.3-64.9 33.8 62.1c10.5-4.4 21.4-7.9 32.7-10.4L199 6.4l19.5 69.2c11-2.1 22.3-3.2 33.8-3.4L256 0l3.6 72.2c11.5 .2 22.8 1.4 33.8 3.5L313 6.4l-12.4 70.7c11.3 2.6 22.2 6.1 32.6 10.5l33.9-62.2-27.4 65.1c10.6 4.9 20.7 10.7 30.2 17.2l45.8-51.8-40.1 55.9c9.5 7.1 18.4 15 26.5 23.6l54.2-38.9-49.7 43.9c8 9.1 15.2 18.9 21.5 29.4l58.7-24.7-55.5 30.2c6.1 10.9 11.1 22.3 15.1 34.3l59.3-10.4-57.5 16.2c3.7 12.2 6.2 24.9 7.5 37.9L512 256l-56 2.8c.3 4.6 .5 9.3 .5 14.1 0 8.7-.6 17.3-1.6 25.8l50.7 14.3-51.5-9.1zm-21.8-31c0-97.5-79-176.5-176.5-176.5s-176.5 79-176.5 176.5 79 176.5 176.5 176.5 176.5-79 176.5-176.5zm-24 0c0 84.3-68.3 152.6-152.6 152.6s-152.6-68.3-152.6-152.6 68.3-152.6 152.6-152.6 152.6 68.3 152.6 152.6zM195 241c0 2.1 1.3 3.8 3.6 5.1 3.3 1.9 6.2 4.6 8.2 8.2 2.8-5.7 4.3-9.5 4.3-11.2 0-2.2-1.1-4.4-3.2-7-2.1-2.5-3.2-5.2-3.3-7.7-6.5 6.8-9.6 10.9-9.6 12.6zm-40.7-19c0 2.1 1.3 3.8 3.6 5.1 3.5 1.9 6.2 4.6 8.2 8.2 2.8-5.7 4.3-9.5 4.3-11.2 0-2.2-1.1-4.4-3.2-7-2.1-2.5-3.2-5.2-3.3-7.7-6.5 6.8-9.6 10.9-9.6 12.6zm-19 0c0 2.1 1.3 3.8 3.6 5.1 3.3 1.9 6.2 4.6 8.2 8.2 2.8-5.7 4.3-9.5 4.3-11.2 0-2.2-1.1-4.4-3.2-7-2.1-2.5-3.2-5.2-3.3-7.7-6.4 6.8-9.6 10.9-9.6 12.6zm204.9 87.9c-8.4-3-8.7-6.8-8.7-15.6V182c-8.2 12.5-14.2 18.6-18 18.6 6.3 14.4 9.5 23.9 9.5 28.3v64.3c0 2.2-2.2 6.5-4.7 6.5h-18c-2.8-7.5-10.2-26.9-15.3-40.3-2 2.5-7.2 9.2-10.7 13.7 2.4 1.6 4.1 3.6 5.2 6.3 2.6 6.7 6.4 16.5 7.9 20.2h-9.2c-3.9-10.4-9.6-25.4-11.8-31.1-2 2.5-7.2 9.2-10.7 13.7 2.4 1.6 4.1 3.6 5.2 6.3 .8 2 2.8 7.3 4.3 10.9H256c-1.5-4.1-5.6-14.6-8.4-22-2 2.5-7.2 9.2-10.7 13.7 2.5 1.6 4.3 3.6 5.2 6.3 .2 .6 .5 1.4 .6 1.7H225c-4.6-13.9-11.4-27.7-11.4-34.1 0-2.2 .3-5.1 1.1-8.2-8.8 10.8-14 15.9-14 25 0 7.5 10.4 28.3 10.4 33.3 0 1.7-.5 3.3-1.4 4.9-9.6-12.7-15.5-20.7-18.8-20.7h-12l-11.2-28c-3.8-9.6-5.7-16-5.7-18.8 0-3.8 .5-7.7 1.7-12.2-1 1.3-3.7 4.7-5.5 7.1-.8-2.1-3.1-7.7-4.6-11.5-2.1 2.5-7.5 9.1-11.2 13.6 .9 2.3 3.3 8.1 4.9 12.2-2.5 3.3-9.1 11.8-13.6 17.7-4 5.3-5.8 13.3-2.7 21.8 2.5 6.7 2 7.9-1.7 14.1H191c5.5 0 14.3 14 15.5 22 13.2-16 15.4-19.6 16.8-21.6h107c3.9 0 7.2-1.9 9.9-5.8zm20.1-26.6V181.7c-9 12.5-15.9 18.6-20.7 18.6 7.1 14.4 10.7 23.9 10.7 28.3v66.3c0 17.5 8.6 20.4 24 20.4 8.1 0 12.5-.8 13.7-2.7-4.3-1.6-7.6-2.5-9.9-3.3-8.1-3.2-17.8-7.4-17.8-26z")),"label"=>__("us-Sunnah Foundation","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"utensils"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M221.6 148.7C224.7 161.3 224.8 174.5 222.1 187.2C219.3 199.1 213.6 211.9 205.6 222.1C191.1 238.6 173 249.1 151.1 254.1V472C151.1 482.6 147.8 492.8 140.3 500.3C132.8 507.8 122.6 512 111.1 512C101.4 512 91.22 507.8 83.71 500.3C76.21 492.8 71.1 482.6 71.1 472V254.1C50.96 250.1 31.96 238.9 18.3 222.4C10.19 212.2 4.529 200.3 1.755 187.5C-1.019 174.7-.8315 161.5 2.303 148.8L32.51 12.45C33.36 8.598 35.61 5.197 38.82 2.9C42.02 .602 45.97-.4297 49.89 .0026C53.82 .4302 57.46 2.303 60.1 5.259C62.74 8.214 64.18 12.04 64.16 16V160H81.53L98.62 11.91C99.02 8.635 100.6 5.621 103.1 3.434C105.5 1.248 108.7 .0401 111.1 .0401C115.3 .0401 118.5 1.248 120.9 3.434C123.4 5.621 124.1 8.635 125.4 11.91L142.5 160H159.1V16C159.1 12.07 161.4 8.268 163.1 5.317C166.6 2.366 170.2 .474 174.1 .0026C178-.4262 181.1 .619 185.2 2.936C188.4 5.253 190.6 8.677 191.5 12.55L221.6 148.7zM448 472C448 482.6 443.8 492.8 436.3 500.3C428.8 507.8 418.6 512 408 512C397.4 512 387.2 507.8 379.7 500.3C372.2 492.8 368 482.6 368 472V352H351.2C342.8 352 334.4 350.3 326.6 347.1C318.9 343.8 311.8 339.1 305.8 333.1C299.9 327.1 295.2 320 291.1 312.2C288.8 304.4 287.2 296 287.2 287.6L287.1 173.8C288 136.9 299.1 100.8 319.8 70.28C340.5 39.71 369.8 16.05 404.1 2.339C408.1 .401 414.2-.3202 419.4 .2391C424.6 .7982 429.6 2.62 433.9 5.546C438.2 8.472 441.8 12.41 444.2 17.03C446.7 21.64 447.1 26.78 448 32V472z")),"label"=>__("Utensils","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","travel")),"v"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M381.5 76.33l-160 384C216.6 472.2 204.9 480 192 480s-24.56-7.757-29.53-19.68l-160-384c-6.797-16.31 .9062-35.05 17.22-41.84c16.38-6.859 35.08 .9219 41.84 17.22L192 364.8l130.5-313.1c6.766-16.3 25.47-24.09 41.84-17.22C380.6 41.28 388.3 60.01 381.5 76.33z")),"label"=>__("V","ultimate-addons-for-gutenberg"),"custom_categories"=>array("education")),"vaadin"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M224.5 140.7c1.5-17.6 4.9-52.7 49.8-52.7h98.6c20.7 0 32.1-7.8 32.1-21.6V54.1c0-12.2 9.3-22.1 21.5-22.1S448 41.9 448 54.1v36.5c0 42.9-21.5 62-66.8 62H280.7c-30.1 0-33 14.7-33 27.1 0 1.3-.1 2.5-.2 3.7-.7 12.3-10.9 22.2-23.4 22.2s-22.7-9.8-23.4-22.2c-.1-1.2-.2-2.4-.2-3.7 0-12.3-3-27.1-33-27.1H66.8c-45.3 0-66.8-19.1-66.8-62V54.1C0 41.9 9.4 32 21.6 32s21.5 9.9 21.5 22.1v12.3C43.1 80.2 54.5 88 75.2 88h98.6c44.8 0 48.3 35.1 49.8 52.7h.9zM224 456c11.5 0 21.4-7 25.7-16.3 1.1-1.8 97.1-169.6 98.2-171.4 11.9-19.6-3.2-44.3-27.2-44.3-13.9 0-23.3 6.4-29.8 20.3L224 362l-66.9-117.7c-6.4-13.9-15.9-20.3-29.8-20.3-24 0-39.1 24.6-27.2 44.3 1.1 1.9 97.1 169.6 98.2 171.4 4.3 9.3 14.2 16.3 25.7 16.3z")),"label"=>__("Vaadin","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"van-shuttle"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M592 384H576C576 437 533 480 480 480C426.1 480 384 437 384 384H256C256 437 213 480 160 480C106.1 480 64 437 64 384H48C21.49 384 0 362.5 0 336V104C0 64.24 32.24 32 72 32H465.1C483.1 32 501.9 40.34 514.1 54.78L624.1 186.5C634.7 197.1 640 212.6 640 227.7V336C640 362.5 618.5 384 592 384zM64 192H160V96H72C67.58 96 64 99.58 64 104V192zM545.1 192L465.1 96H384V192H545.1zM320 192V96H224V192H320zM480 336C453.5 336 432 357.5 432 384C432 410.5 453.5 432 480 432C506.5 432 528 410.5 528 384C528 357.5 506.5 336 480 336zM160 432C186.5 432 208 410.5 208 384C208 357.5 186.5 336 160 336C133.5 336 112 357.5 112 384C112 410.5 133.5 432 160 432z")),"label"=>__("Van Shuttle","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"vault"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M144 240C144 195.8 179.8 160 224 160C268.2 160 304 195.8 304 240C304 284.2 268.2 320 224 320C179.8 320 144 284.2 144 240zM512 0C547.3 0 576 28.65 576 64V416C576 451.3 547.3 480 512 480H496L480 512H416L400 480H176L160 512H96L80 480H64C28.65 480 0 451.3 0 416V64C0 28.65 28.65 0 64 0H512zM224 400C312.4 400 384 328.4 384 240C384 151.6 312.4 80 224 80C135.6 80 64 151.6 64 240C64 328.4 135.6 400 224 400zM480 221.3C498.6 214.7 512 196.9 512 176C512 149.5 490.5 128 464 128C437.5 128 416 149.5 416 176C416 196.9 429.4 214.7 448 221.3V336C448 344.8 455.2 352 464 352C472.8 352 480 344.8 480 336V221.3z")),"label"=>__("Vault","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","science-and-technology")),"vector-square"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M416 32C433.7 32 448 46.33 448 64V128C448 145.7 433.7 160 416 160V352C433.7 352 448 366.3 448 384V448C448 465.7 433.7 480 416 480H352C334.3 480 320 465.7 320 448H128C128 465.7 113.7 480 96 480H32C14.33 480 0 465.7 0 448V384C0 366.3 14.33 352 32 352V160C14.33 160 0 145.7 0 128V64C0 46.33 14.33 32 32 32H96C113.7 32 128 46.33 128 64H320C320 46.33 334.3 32 352 32H416zM368 80V112H400V80H368zM96 160V352C113.7 352 128 366.3 128 384H320C320 366.3 334.3 352 352 352V160C334.3 160 320 145.7 320 128H128C128 145.7 113.7 160 96 160zM48 400V432H80V400H48zM400 432V400H368V432H400zM80 112V80H48V112H80z")),"label"=>__("Vector Square","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design")),"venus"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M368 176c0-97.2-78.8-176-176-176c-97.2 0-176 78.8-176 176c0 86.26 62.1 157.9 144 172.1v35.05H112c-8.836 0-16 7.162-16 16v32c0 8.836 7.164 16 16 16H160v48c0 8.836 7.164 16 16 16h32c8.838 0 16-7.164 16-16v-48h48c8.838 0 16-7.164 16-16v-32c0-8.838-7.162-16-16-16H224v-35.05C305.9 333.9 368 262.3 368 176zM192 272c-52.93 0-96-43.07-96-96c0-52.94 43.07-96 96-96c52.94 0 96 43.06 96 96C288 228.9 244.9 272 192 272z")),"label"=>__("Venus","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"venus-double"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M368 176c0-97.2-78.8-176-176-176c-97.2 0-176 78.8-176 176c0 86.26 62.1 157.9 144 172.1v35.05H112c-8.836 0-16 7.162-16 16v32c0 8.836 7.164 16 16 16H160v48c0 8.836 7.164 16 16 16h32c8.838 0 16-7.164 16-16v-48h48c8.838 0 16-7.164 16-16v-32c0-8.838-7.162-16-16-16H224v-35.05C305.9 333.9 368 262.3 368 176zM192 272c-52.93 0-96-43.07-96-96c0-52.94 43.07-96 96-96c52.94 0 96 43.06 96 96C288 228.9 244.9 272 192 272zM624 176C624 78.8 545.2 0 448 0c-39.02 0-74.95 12.85-104.1 34.34c18.38 19.7 32.94 42.91 42.62 68.58C403.2 88.83 424.5 80 448 80c52.94 0 96 43.06 96 96c0 52.93-43.06 96-96 96c-23.57 0-44.91-8.869-61.63-23.02c-9.572 25.45-23.95 48.54-42.23 68.23C365.1 332.7 389.3 344 416 348.1V384h-48c-8.836 0-16 7.162-16 16v32c0 8.836 7.164 16 16 16H416v48c0 8.836 7.164 16 16 16h32c8.838 0 16-7.164 16-16V448h48c8.838 0 16-7.164 16-16v-32c0-8.838-7.162-16-16-16H480v-35.05C561.9 333.9 624 262.3 624 176z")),"label"=>__("Venus Double","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"venus-mars"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M256 384H208v-35.05C289.9 333.9 352 262.3 352 176c0-97.2-78.8-176-176-176c-97.2 0-176 78.8-176 176c0 86.26 62.1 157.9 144 172.1v35.05H96c-8.836 0-16 7.162-16 16v32c0 8.836 7.164 16 16 16h48v48c0 8.836 7.164 16 16 16h32c8.838 0 16-7.164 16-16v-48H256c8.838 0 16-7.164 16-16v-32C272 391.2 264.8 384 256 384zM176 272c-52.93 0-96-43.07-96-96c0-52.94 43.07-96 96-96c52.94 0 96 43.06 96 96C272 228.9 228.9 272 176 272zM624 0h-112.4c-21.38 0-32.09 25.85-16.97 40.97l29.56 29.56l-24.55 24.55c-29.97-20.66-64.81-31.05-99.74-31.05c-15.18 0-30.42 2.225-45.19 6.132c13.55 22.8 22.82 48.36 26.82 75.67c6.088-1.184 12.27-1.785 18.45-1.785c24.58 0 49.17 9.357 67.88 28.07c37.43 37.43 37.43 98.33 0 135.8c-18.71 18.71-43.3 28.07-67.88 28.07c-23.55 0-46.96-8.832-65.35-26.01c-15.92 18.84-34.93 35.1-56.75 47.35c11.45 5.898 20.17 16.3 23.97 28.82C331.5 406 365.7 416 400 416c45.04 0 90.08-17.18 124.5-51.55c60.99-60.99 67.73-155.6 20.47-224.1l24.55-24.55l29.56 29.56c4.889 4.889 10.9 7.078 16.8 7.078C628.2 152.4 640 142.8 640 128.4V16C640 7.164 632.8 0 624 0z")),"label"=>__("Venus Mars","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"vest"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M437.3 239.9L384 160V32c0-17.67-14.33-32-32-32h-32c-4.75 0-9.375 1.406-13.31 4.031l-25 16.66c-35.03 23.38-80.28 23.38-115.4 0l-25-16.66C137.4 1.406 132.8 0 128 0H96C78.33 0 64 14.33 64 32v128L10.75 239.9C3.74 250.4 0 262.7 0 275.4V480c0 17.67 14.33 32 32 32h160V288c0-3.439 .5547-6.855 1.643-10.12l13.49-40.48L150.2 66.56C173.2 79.43 198.5 86.25 224 86.25s50.79-6.824 73.81-19.69L224 288v224h192c17.67 0 32-14.33 32-32V275.4C448 262.7 444.3 250.4 437.3 239.9zM131.3 371.3l-48 48C80.19 422.4 76.09 424 72 424s-8.188-1.562-11.31-4.688c-6.25-6.25-6.25-16.38 0-22.62l48-48c6.25-6.25 16.38-6.25 22.62 0S137.6 365.1 131.3 371.3zM387.3 419.3C384.2 422.4 380.1 424 376 424s-8.188-1.562-11.31-4.688l-48-48c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.62 0l48 48C393.6 402.9 393.6 413.1 387.3 419.3z")),"label"=>__("Vest","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","travel")),"vest-patches"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M437.3 239.9L384 160V32c0-17.67-14.33-32-32-32h-32c-4.75 0-9.375 1.406-13.31 4.031l-25 16.66c-35.03 23.38-80.28 23.38-115.4 0l-25-16.66C137.4 1.406 132.8 0 128 0H96C78.33 0 64 14.33 64 32v128L10.75 239.9C3.74 250.4 0 262.7 0 275.4V480c0 17.67 14.33 32 32 32h160V288c0-3.439 .5547-6.855 1.643-10.12l13.49-40.48L150.2 66.56C173.2 79.43 198.5 86.25 224 86.25s50.79-6.824 73.81-19.69L224 288v224h192c17.67 0 32-14.33 32-32V275.4C448 262.7 444.3 250.4 437.3 239.9zM63.5 272.5c-4.656-4.688-4.656-12.31 0-17c4.688-4.688 12.31-4.688 17 0L96 271l15.5-15.5c4.688-4.688 12.31-4.688 17 0c4.656 4.688 4.656 12.31 0 17L113 288l15.5 15.5c4.656 4.688 4.656 12.31 0 17C126.2 322.8 123.1 324 120 324s-6.156-1.156-8.5-3.5L96 305l-15.5 15.5C78.16 322.8 75.06 324 72 324s-6.156-1.156-8.5-3.5c-4.656-4.688-4.656-12.31 0-17L79 288L63.5 272.5zM96 456c-22.09 0-40-17.91-40-40S73.91 376 96 376S136 393.9 136 416S118.1 456 96 456zM359.2 335.8L310.7 336C306.1 336 303.1 333 304 329.3l.2158-48.53c.1445-14.4 12.53-25.98 27.21-24.67c12.79 1.162 22.13 12.62 22.06 25.42l-.0557 5.076l5.069-.0566c12.83-.0352 24.24 9.275 25.4 22.08C385.2 323.3 373.7 335.7 359.2 335.8z")),"label"=>__("Vest Patches","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","travel")),"viacoin"=>array("svg"=>array("brands"=>array("width"=>384,"height"=>512,"path"=>"M384 32h-64l-80.7 192h-94.5L64 32H0l48 112H0v48h68.5l13.8 32H0v48h102.8L192 480l89.2-208H384v-48h-82.3l13.8-32H384v-48h-48l48-112zM192 336l-27-64h54l-27 64z")),"label"=>__("Viacoin","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"viadeo"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M276.2 150.5v.7C258.3 98.6 233.6 47.8 205.4 0c43.3 29.2 67 100 70.8 150.5zm32.7 121.7c7.6 18.2 11 37.5 11 57 0 77.7-57.8 141-137.8 139.4l3.8-.3c74.2-46.7 109.3-118.6 109.3-205.1 0-38.1-6.5-75.9-18.9-112 1 11.7 1 23.7 1 35.4 0 91.8-18.1 241.6-116.6 280C95 455.2 49.4 398 49.4 329.2c0-75.6 57.4-142.3 135.4-142.3 16.8 0 33.7 3.1 49.1 9.6 1.7-15.1 6.5-29.9 13.4-43.3-19.9-7.2-41.2-10.7-62.5-10.7-161.5 0-238.7 195.9-129.9 313.7 67.9 74.6 192 73.9 259.8 0 56.6-61.3 60.9-142.4 36.4-201-12.7 8-27.1 13.9-42.2 17zM418.1 11.7c-31 66.5-81.3 47.2-115.8 80.1-12.4 12-20.6 34-20.6 50.5 0 14.1 4.5 27.1 12 38.8 47.4-11 98.3-46 118.2-90.7-.7 5.5-4.8 14.4-7.2 19.2-20.3 35.7-64.6 65.6-99.7 84.9 14.8 14.4 33.7 25.8 55 25.8 79 0 110.1-134.6 58.1-208.6z")),"label"=>__("Viadeo","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"viadeo-square"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM280.7 381.2c-42.4 46.2-120 46.6-162.4 0-68-73.6-19.8-196.1 81.2-196.1 13.3 0 26.6 2.1 39.1 6.7-4.3 8.4-7.3 17.6-8.4 27.1-9.7-4.1-20.2-6-30.7-6-48.8 0-84.6 41.7-84.6 88.9 0 43 28.5 78.7 69.5 85.9 61.5-24 72.9-117.6 72.9-175 0-7.3 0-14.8-.6-22.1-11.2-32.9-26.6-64.6-44.2-94.5 27.1 18.3 41.9 62.5 44.2 94.1v.4c7.7 22.5 11.8 46.2 11.8 70 0 54.1-21.9 99-68.3 128.2l-2.4 .2c50 1 86.2-38.6 86.2-87.2 0-12.2-2.1-24.3-6.9-35.7 9.5-1.9 18.5-5.6 26.4-10.5 15.3 36.6 12.6 87.3-22.8 125.6zM309 233.7c-13.3 0-25.1-7.1-34.4-16.1 21.9-12 49.6-30.7 62.3-53 1.5-3 4.1-8.6 4.5-12-12.5 27.9-44.2 49.8-73.9 56.7-4.7-7.3-7.5-15.5-7.5-24.3 0-10.3 5.2-24.1 12.9-31.6 21.6-20.5 53-8.5 72.4-50 32.5 46.2 13.1 130.3-36.3 130.3z")),"label"=>__("Viadeo Square","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"vial"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M502.6 169.4l-160-160C336.4 3.125 328.2 0 320 0s-16.38 3.125-22.62 9.375c-12.5 12.5-12.5 32.75 0 45.25l6.975 6.977l-271.4 271c-38.75 38.75-45.13 102-9.375 143.5C44.08 500 72.76 512 101.5 512h.4473c26.38 0 52.75-9.1 72.88-30.12l275.2-274.6l7.365 7.367C463.6 220.9 471.8 224 480 224s16.38-3.125 22.62-9.375C515.1 202.1 515.1 181.9 502.6 169.4zM310.6 256H200.2l149.3-149.1l55.18 55.12L310.6 256z")),"label"=>__("Vial","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"vial-circle-check"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M0 64C0 46.33 14.33 32 32 32H224C241.7 32 256 46.33 256 64C256 81.67 241.7 96 224 96V266.8C203.8 295.4 192 330.3 192 368C192 393.2 197.3 417.1 206.8 438.8C189.5 463.7 160.6 480 128 480C74.98 480 32 437 32 384V96C14.33 96 0 81.67 0 64V64zM96 192H160V96H96V192zM512 368C512 447.5 447.5 512 368 512C288.5 512 224 447.5 224 368C224 288.5 288.5 224 368 224C447.5 224 512 288.5 512 368zM412.7 324.7L352 385.4L323.3 356.7C317.1 350.4 306.9 350.4 300.7 356.7C294.4 362.9 294.4 373.1 300.7 379.3L340.7 419.3C346.9 425.6 357.1 425.6 363.3 419.3L435.3 347.3C441.6 341.1 441.6 330.9 435.3 324.7C429.1 318.4 418.9 318.4 412.7 324.7H412.7z")),"label"=>__("Vial Circle Check","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"vial-virus"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M256 32C273.7 32 288 46.33 288 64C288 81.67 273.7 96 256 96V207.1C252.9 209.1 249.9 211.5 247.2 214.2C225.3 236.1 225.3 271.6 247.2 293.4C247.4 293.6 247.4 293.7 247.5 293.8L247.5 293.8C247.5 293.9 247.5 294.1 247.4 294.4C247.3 294.6 247.1 294.8 247.1 294.8L247 294.9C246.1 294.9 246.8 294.9 246.6 294.9C215.7 294.9 190.6 319.1 190.6 350.9C190.6 381.8 215.7 406.9 246.6 406.9C246.8 406.9 246.1 406.9 247 406.9L247.1 406.9C247.1 406.1 247.3 407.1 247.4 407.4C247.5 407.7 247.5 407.9 247.5 407.1L247.5 408C247.4 408.1 247.4 408.2 247.2 408.3C236 419.5 230.6 434.2 230.8 448.8C213.3 467.1 188 480 160 480C106.1 480 64 437 64 384V96C46.33 96 32 81.67 32 64C32 46.33 46.33 32 64 32H256zM192 192V96H128V192H192zM383.8 189.7C397.1 189.7 407.8 200.4 407.8 213.7C407.8 242.9 443.2 257.6 463.9 236.9C473.3 227.5 488.5 227.5 497.8 236.9C507.2 246.2 507.2 261.4 497.8 270.8C477.2 291.5 491.8 326.9 521.1 326.9C534.3 326.9 545.1 337.6 545.1 350.9C545.1 364.1 534.3 374.9 521.1 374.9C491.8 374.9 477.2 410.3 497.8 430.9C507.2 440.3 507.2 455.5 497.8 464.9C488.5 474.3 473.3 474.3 463.9 464.9C443.2 444.2 407.8 458.9 407.8 488.1C407.8 501.4 397.1 512.1 383.8 512.1C370.6 512.1 359.8 501.4 359.8 488.1C359.8 458.9 324.5 444.2 303.8 464.9C294.4 474.3 279.2 474.3 269.8 464.9C260.5 455.5 260.5 440.3 269.8 430.9C290.5 410.3 275.9 374.9 246.6 374.9C233.4 374.9 222.6 364.1 222.6 350.9C222.6 337.6 233.4 326.9 246.6 326.9C275.9 326.9 290.5 291.5 269.8 270.8C260.5 261.4 260.5 246.2 269.8 236.9C279.2 227.5 294.4 227.5 303.8 236.9C324.5 257.6 359.8 242.9 359.8 213.7C359.8 200.4 370.6 189.7 383.8 189.7H383.8zM352 352C369.7 352 384 337.7 384 320C384 302.3 369.7 288 352 288C334.3 288 320 302.3 320 320C320 337.7 334.3 352 352 352zM416 360C402.7 360 392 370.7 392 384C392 397.3 402.7 408 416 408C429.3 408 440 397.3 440 384C440 370.7 429.3 360 416 360z")),"label"=>__("Vial Virus","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"vials"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M200 32h-176C10.75 32 0 42.74 0 56C0 69.25 10.75 80 24 80H32v320C32 444.1 67.88 480 112 480S192 444.1 192 400v-320h8C213.3 80 224 69.25 224 56C224 42.74 213.3 32 200 32zM144 256h-64V80h64V256zM488 32h-176C298.7 32 288 42.74 288 56c0 13.25 10.75 24 24 24H320v320c0 44.13 35.88 80 80 80s80-35.88 80-80v-320h8C501.3 80 512 69.25 512 56C512 42.74 501.3 32 488 32zM432 256h-64V80h64V256z")),"label"=>__("Vials","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"viber"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M444 49.9C431.3 38.2 379.9 .9 265.3 .4c0 0-135.1-8.1-200.9 52.3C27.8 89.3 14.9 143 13.5 209.5c-1.4 66.5-3.1 191.1 117 224.9h.1l-.1 51.6s-.8 20.9 13 25.1c16.6 5.2 26.4-10.7 42.3-27.8 8.7-9.4 20.7-23.2 29.8-33.7 82.2 6.9 145.3-8.9 152.5-11.2 16.6-5.4 110.5-17.4 125.7-142 15.8-128.6-7.6-209.8-49.8-246.5zM457.9 287c-12.9 104-89 110.6-103 115.1-6 1.9-61.5 15.7-131.2 11.2 0 0-52 62.7-68.2 79-5.3 5.3-11.1 4.8-11-5.7 0-6.9 .4-85.7 .4-85.7-.1 0-.1 0 0 0-101.8-28.2-95.8-134.3-94.7-189.8 1.1-55.5 11.6-101 42.6-131.6 55.7-50.5 170.4-43 170.4-43 96.9 .4 143.3 29.6 154.1 39.4 35.7 30.6 53.9 103.8 40.6 211.1zm-139-80.8c.4 8.6-12.5 9.2-12.9 .6-1.1-22-11.4-32.7-32.6-33.9-8.6-.5-7.8-13.4 .7-12.9 27.9 1.5 43.4 17.5 44.8 46.2zm20.3 11.3c1-42.4-25.5-75.6-75.8-79.3-8.5-.6-7.6-13.5 .9-12.9 58 4.2 88.9 44.1 87.8 92.5-.1 8.6-13.1 8.2-12.9-.3zm47 13.4c.1 8.6-12.9 8.7-12.9 .1-.6-81.5-54.9-125.9-120.8-126.4-8.5-.1-8.5-12.9 0-12.9 73.7 .5 133 51.4 133.7 139.2zM374.9 329v.2c-10.8 19-31 40-51.8 33.3l-.2-.3c-21.1-5.9-70.8-31.5-102.2-56.5-16.2-12.8-31-27.9-42.4-42.4-10.3-12.9-20.7-28.2-30.8-46.6-21.3-38.5-26-55.7-26-55.7-6.7-20.8 14.2-41 33.3-51.8h.2c9.2-4.8 18-3.2 23.9 3.9 0 0 12.4 14.8 17.7 22.1 5 6.8 11.7 17.7 15.2 23.8 6.1 10.9 2.3 22-3.7 26.6l-12 9.6c-6.1 4.9-5.3 14-5.3 14s17.8 67.3 84.3 84.3c0 0 9.1 .8 14-5.3l9.6-12c4.6-6 15.7-9.8 26.6-3.7 14.7 8.3 33.4 21.2 45.8 32.9 7 5.7 8.6 14.4 3.8 23.6z")),"label"=>__("Viber","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"video"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M384 112v288c0 26.51-21.49 48-48 48h-288c-26.51 0-48-21.49-48-48v-288c0-26.51 21.49-48 48-48h288C362.5 64 384 85.49 384 112zM576 127.5v256.9c0 25.5-29.17 40.39-50.39 25.79L416 334.7V177.3l109.6-75.56C546.9 87.13 576 102.1 576 127.5z")),"label"=>__("Video","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","social")),"video-slash"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M32 399.1c0 26.51 21.49 47.1 47.1 47.1h287.1c19.57 0 36.34-11.75 43.81-28.56L32 121.8L32 399.1zM630.8 469.1l-89.21-69.92l15.99 11.02c21.22 14.59 50.41-.2971 50.41-25.8V127.5c0-25.41-29.07-40.37-50.39-25.76l-109.6 75.56l.0001 148.5l-32-25.08l.0001-188.7c0-26.51-21.49-47.1-47.1-47.1H113.9L38.81 5.111C34.41 1.673 29.19 0 24.03 0C16.91 0 9.84 3.158 5.121 9.189C-3.066 19.63-1.249 34.72 9.189 42.89l591.1 463.1c10.5 8.203 25.57 6.328 33.69-4.078C643.1 492.4 641.2 477.3 630.8 469.1z")),"label"=>__("Video Slash","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication")),"vihara"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M280.1 22.03L305.8 4.661C307.1 3.715 308.4 2.908 309.9 2.246C313.1 .7309 316.6-.0029 319.1 0C323.4-.0029 326.9 .7309 330.1 2.246C331.6 2.909 332.9 3.716 334.2 4.661L359 22.03C392.1 45.8 430.8 63.52 470.8 74.42L493.8 80.71C495.6 81.17 497.4 81.83 499 82.68C502.2 84.33 504.1 86.66 507.1 89.43C510.8 94.38 512.7 100.7 511.8 107.2C511.4 109.1 510.6 112.6 509.3 115C507.7 118.2 505.3 120.1 502.6 123.1C498.3 126.3 492.1 128.1 487.5 128H480V184.1L491.7 193.3C512.8 210 536.6 222.9 562.2 231.4L591.1 241.1C592.7 241.6 594.2 242.2 595.7 243C598.8 244.8 601.4 247.2 603.5 249.1C605.5 252.8 606.9 256 607.6 259.6C608.1 262.2 608.2 265 607.7 267.8C607.2 270.6 606.3 273.3 604.1 275.7C603.2 278.8 600.8 281.5 598 283.5C595.2 285.5 591.1 286.9 588.4 287.6C586.8 287.9 585.1 288 583.4 288H544V353.9C564.5 376.7 591.4 393 621.4 400.6C632 403 640 412.6 640 424C640 437.3 629.3 448 616 448H576V480C576 497.7 561.7 512 544 512C526.3 512 512 497.7 512 480V448H352V480C352 497.7 337.7 512 320 512C302.3 512 288 497.7 288 480V448H128V480C128 497.7 113.7 512 96 512C78.33 512 64 497.7 64 480V448H24C10.75 448 0 437.3 0 424C0 412.6 7.962 403 18.63 400.6C48.61 393 75.51 376.7 96 353.9V288H56.55C54.87 288 53.2 287.9 51.57 287.6C48.03 286.9 44.77 285.5 41.96 283.5C39.16 281.5 36.77 278.8 35.03 275.7C33.69 273.3 32.76 270.6 32.31 267.8C31.85 265 31.9 262.2 32.41 259.6C33.07 256 34.51 252.8 36.53 249.1C38.55 247.2 41.19 244.8 44.34 243C45.78 242.2 47.32 241.6 48.94 241.1L77.81 231.4C103.4 222.9 127.2 210 148.3 193.3L160 184.1V128H152.5C147 128.1 141.7 126.3 137.4 123.1C134.7 120.1 132.3 118.2 130.7 115C129.4 112.6 128.6 109.1 128.2 107.2C127.3 100.7 129.2 94.38 132.9 89.43C135 86.66 137.8 84.33 140.1 82.68C142.6 81.83 144.4 81.17 146.2 80.71L169.2 74.42C209.2 63.52 247 45.8 280.1 22.03H280.1zM223.1 128V192H416V128H223.1zM159.1 352H480V288H159.1V352z")),"label"=>__("Vihara","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"vimeo"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M403.2 32H44.8C20.1 32 0 52.1 0 76.8v358.4C0 459.9 20.1 480 44.8 480h358.4c24.7 0 44.8-20.1 44.8-44.8V76.8c0-24.7-20.1-44.8-44.8-44.8zM377 180.8c-1.4 31.5-23.4 74.7-66 129.4-44 57.2-81.3 85.8-111.7 85.8-18.9 0-34.8-17.4-47.9-52.3-25.5-93.3-36.4-148-57.4-148-2.4 0-10.9 5.1-25.4 15.2l-15.2-19.6c37.3-32.8 72.9-69.2 95.2-71.2 25.2-2.4 40.7 14.8 46.5 51.7 20.7 131.2 29.9 151 67.6 91.6 13.5-21.4 20.8-37.7 21.8-48.9 3.5-33.2-25.9-30.9-45.8-22.4 15.9-52.1 46.3-77.4 91.2-76 33.3 .9 49 22.5 47.1 64.7z")),"label"=>__("Vimeo","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"vimeo-square"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zm-16.2 149.6c-1.4 31.1-23.2 73.8-65.3 127.9-43.5 56.5-80.3 84.8-110.4 84.8-18.7 0-34.4-17.2-47.3-51.6-25.2-92.3-35.9-146.4-56.7-146.4-2.4 0-10.8 5-25.1 15.1L64 192c36.9-32.4 72.1-68.4 94.1-70.4 24.9-2.4 40.2 14.6 46 51.1 20.5 129.6 29.6 149.2 66.8 90.5 13.4-21.2 20.6-37.2 21.5-48.3 3.4-32.8-25.6-30.6-45.2-22.2 15.7-51.5 45.8-76.5 90.1-75.1 32.9 1 48.4 22.4 46.5 64z")),"label"=>__("Vimeo Square","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"vimeo-v"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M447.8 153.6c-2 43.6-32.4 103.3-91.4 179.1-60.9 79.2-112.4 118.8-154.6 118.8-26.1 0-48.2-24.1-66.3-72.3C100.3 250 85.3 174.3 56.2 174.3c-3.4 0-15.1 7.1-35.2 21.1L0 168.2c51.6-45.3 100.9-95.7 131.8-98.5 34.9-3.4 56.3 20.5 64.4 71.5 28.7 181.5 41.4 208.9 93.6 126.7 18.7-29.6 28.8-52.1 30.2-67.6 4.8-45.9-35.8-42.8-63.3-31 22-72.1 64.1-107.1 126.2-105.1 45.8 1.2 67.5 31.1 64.9 89.4z")),"label"=>__("Vimeo","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"vine"=>array("svg"=>array("brands"=>array("width"=>384,"height"=>512,"path"=>"M384 254.7v52.1c-18.4 4.2-36.9 6.1-52.1 6.1-36.9 77.4-103 143.8-125.1 156.2-14 7.9-27.1 8.4-42.7-.8C137 452 34.2 367.7 0 102.7h74.5C93.2 261.8 139 343.4 189.3 404.5c27.9-27.9 54.8-65.1 75.6-106.9-49.8-25.3-80.1-80.9-80.1-145.6 0-65.6 37.7-115.1 102.2-115.1 114.9 0 106.2 127.9 81.6 181.5 0 0-46.4 9.2-63.5-20.5 3.4-11.3 8.2-30.8 8.2-48.5 0-31.3-11.3-46.6-28.4-46.6-18.2 0-30.8 17.1-30.8 50 .1 79.2 59.4 118.7 129.9 101.9z")),"label"=>__("Vine","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"virus"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M288 43.55C288 93.44 348.3 118.4 383.6 83.15L391.8 74.98C404.3 62.48 424.5 62.48 437 74.98C449.5 87.48 449.5 107.7 437 120.2L428.9 128.4C393.6 163.7 418.6 224 468.5 224H480C497.7 224 512 238.3 512 256C512 273.7 497.7 288 480 288H468.5C418.6 288 393.6 348.3 428.9 383.6L437 391.8C449.5 404.3 449.5 424.5 437 437C424.5 449.5 404.3 449.5 391.8 437L383.6 428.9C348.3 393.6 288 418.6 288 468.5V480C288 497.7 273.7 512 256 512C238.3 512 224 497.7 224 480V468.5C224 418.6 163.7 393.6 128.4 428.9L120.2 437C107.7 449.5 87.48 449.5 74.98 437C62.48 424.5 62.48 404.3 74.98 391.8L83.15 383.6C118.4 348.3 93.44 288 43.55 288H32C14.33 288 0 273.7 0 256C0 238.3 14.33 224 32 224H43.55C93.44 224 118.4 163.7 83.15 128.4L74.98 120.2C62.48 107.7 62.48 87.48 74.98 74.98C87.48 62.48 107.7 62.48 120.2 74.98L128.4 83.15C163.7 118.4 224 93.44 224 43.55V32C224 14.33 238.3 0 256 0C273.7 0 288 14.33 288 32V43.55zM224 176C197.5 176 176 197.5 176 224C176 250.5 197.5 272 224 272C250.5 272 272 250.5 272 224C272 197.5 250.5 176 224 176zM304 328C317.3 328 328 317.3 328 304C328 290.7 317.3 280 304 280C290.7 280 280 290.7 280 304C280 317.3 290.7 328 304 328z")),"label"=>__("Virus","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"virus-covid"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M192 24C192 10.75 202.7 0 216 0H296C309.3 0 320 10.75 320 24C320 37.25 309.3 48 296 48H280V81.62C310.7 85.8 338.8 97.88 362.3 115.7L386.1 91.95L374.8 80.64C365.4 71.26 365.4 56.07 374.8 46.7C384.2 37.32 399.4 37.32 408.7 46.7L465.3 103.3C474.7 112.6 474.7 127.8 465.3 137.2C455.9 146.6 440.7 146.6 431.4 137.2L420 125.9L396.3 149.7C414.1 173.2 426.2 201.3 430.4 232H464V216C464 202.7 474.7 192 488 192C501.3 192 512 202.7 512 216V296C512 309.3 501.3 320 488 320C474.7 320 464 309.3 464 296V280H430.4C426.2 310.7 414.1 338.8 396.3 362.3L420 386.1L431.4 374.8C440.7 365.4 455.9 365.4 465.3 374.8C474.7 384.2 474.7 399.4 465.3 408.7L408.7 465.3C399.4 474.7 384.2 474.7 374.8 465.3C365.4 455.9 365.4 440.7 374.8 431.4L386.1 420L362.3 396.3C338.8 414.1 310.7 426.2 280 430.4V464H296C309.3 464 320 474.7 320 488C320 501.3 309.3 512 296 512H216C202.7 512 192 501.3 192 488C192 474.7 202.7 464 216 464H232V430.4C201.3 426.2 173.2 414.1 149.7 396.3L125.9 420.1L137.2 431.4C146.6 440.7 146.6 455.9 137.2 465.3C127.8 474.7 112.6 474.7 103.3 465.3L46.7 408.7C37.32 399.4 37.32 384.2 46.7 374.8C56.07 365.4 71.27 365.4 80.64 374.8L91.95 386.1L115.7 362.3C97.88 338.8 85.8 310.7 81.62 280H48V296C48 309.3 37.25 320 24 320C10.75 320 0 309.3 0 296V216C0 202.7 10.75 192 24 192C37.25 192 48 202.7 48 216V232H81.62C85.8 201.3 97.88 173.2 115.7 149.7L91.95 125.9L80.64 137.2C71.26 146.6 56.07 146.6 46.7 137.2C37.32 127.8 37.32 112.6 46.7 103.3L103.3 46.7C112.6 37.33 127.8 37.33 137.2 46.7C146.6 56.07 146.6 71.27 137.2 80.64L125.9 91.95L149.7 115.7C173.2 97.88 201.3 85.8 232 81.62V48H216C202.7 48 192 37.26 192 24V24zM192 176C165.5 176 144 197.5 144 224C144 250.5 165.5 272 192 272C218.5 272 240 250.5 240 224C240 197.5 218.5 176 192 176zM304 328C317.3 328 328 317.3 328 304C328 290.7 317.3 280 304 280C290.7 280 280 290.7 280 304C280 317.3 290.7 328 304 328z")),"label"=>__("Virus Covid","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"virus-covid-slash"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M134.1 79.83L167.3 46.7C176.6 37.33 191.8 37.33 201.2 46.7C210.6 56.07 210.6 71.27 201.2 80.64L189.9 91.95L213.7 115.7C237.2 97.88 265.3 85.8 295.1 81.62V48H279.1C266.7 48 255.1 37.26 255.1 24C255.1 10.75 266.7 .0003 279.1 .0003H360C373.3 .0003 384 10.75 384 24C384 37.26 373.3 48 360 48H344V81.62C374.7 85.8 402.8 97.88 426.3 115.7L450.1 91.95L438.8 80.64C429.4 71.26 429.4 56.07 438.8 46.7C448.2 37.32 463.4 37.32 472.7 46.7L529.3 103.3C538.7 112.6 538.7 127.8 529.3 137.2C519.9 146.6 504.7 146.6 495.4 137.2L484 125.9L460.3 149.7C478.1 173.2 490.2 201.3 494.4 232H528V216C528 202.7 538.7 192 552 192C565.3 192 576 202.7 576 216V296C576 309.3 565.3 320 552 320C538.7 320 528 309.3 528 296V280H494.4C491.2 303.3 483.4 325.2 472.1 344.7L630.8 469.1C641.2 477.3 643.1 492.4 634.9 502.8C626.7 513.2 611.6 515.1 601.2 506.9L9.196 42.89C-1.236 34.71-3.065 19.63 5.112 9.196C13.29-1.236 28.37-3.065 38.81 5.112L134.1 79.83zM149.2 213.5L401.3 412.2C383.7 421.3 364.4 427.6 344 430.4V464H360C373.3 464 384 474.7 384 488C384 501.3 373.3 512 360 512H279.1C266.7 512 255.1 501.3 255.1 488C255.1 474.7 266.7 464 279.1 464H295.1V430.4C265.3 426.2 237.2 414.1 213.7 396.3L189.9 420.1L201.2 431.4C210.6 440.7 210.6 455.9 201.2 465.3C191.8 474.7 176.6 474.7 167.3 465.3L110.7 408.7C101.3 399.4 101.3 384.2 110.7 374.8C120.1 365.4 135.3 365.4 144.6 374.8L155.1 386.1L179.7 362.3C161.9 338.8 149.8 310.7 145.6 280H111.1V296C111.1 309.3 101.3 320 87.1 320C74.74 320 63.1 309.3 63.1 296V216C63.1 202.7 74.74 192 87.1 192C101.3 192 111.1 202.7 111.1 216V232H145.6C146.5 225.7 147.7 219.6 149.2 213.5L149.2 213.5z")),"label"=>__("Virus Covid Slash","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"virus-slash"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M113.1 227.6H92.44c-15.72 0-28.45 12.72-28.45 28.45s12.72 28.44 28.45 28.44h21.55c50.68 0 76.06 61.28 40.23 97.11l-15.25 15.25c-11.11 11.11-11.11 29.11-.0006 40.22c5.555 5.555 12.83 8.332 20.11 8.332c7.277 0 14.55-2.779 20.11-8.334l15.24-15.25c35.84-35.84 97.12-10.45 97.12 40.23v21.55c0 15.72 12.72 28.45 28.45 28.45c15.72 0 28.45-12.72 28.45-28.45v-21.55c0-30.08 21.69-50.85 46.74-55.6L150 214.3C140.5 222.2 128.5 227.6 113.1 227.6zM630.8 469.1l-161.2-126.4c-.5176-29.6 21.73-58.3 56.41-58.3h21.55c15.72 0 28.45-12.72 28.45-28.44s-12.72-28.45-28.45-28.45h-21.55c-50.68 0-76.06-61.28-40.23-97.11l15.25-15.25c11.11-11.11 11.11-29.11 .0011-40.22c-11.11-11.11-29.11-11.11-40.22 .0007l-15.24 15.24c-35.84 35.84-97.12 10.46-97.12-40.23V28.44C348.4 12.72 335.7 0 319.1 0C304.3 0 291.6 12.72 291.6 28.44v21.55c0 50.68-61.28 76.06-97.12 40.23L179.2 74.97c-11.11-11.11-29.11-11.11-40.22 0C137.3 76.63 136.2 78.61 135 80.53L38.81 5.112C34.41 1.675 29.19 0 24.03 0C16.91 0 9.845 3.159 5.126 9.19C-3.061 19.63-1.248 34.72 9.189 42.89l591.1 463.1c10.5 8.203 25.56 6.328 33.69-4.078C643.1 492.4 641.2 477.3 630.8 469.1zM334.1 236.6L264.6 182.1c6.904-3.885 14.86-6.109 23.36-6.109c26.51 0 47.1 21.49 47.1 47.1C335.1 228.4 335.2 232.5 334.1 236.6z")),"label"=>__("Virus Slash","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"viruses"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M346.5 213.3h16.16C374.5 213.3 384 203.8 384 192c0-11.79-9.541-21.33-21.33-21.33h-16.16c-38.01 0-57.05-45.96-30.17-72.84l11.44-11.44c8.332-8.332 8.331-21.83-.0012-30.17c-8.334-8.334-21.83-8.332-30.17 .002L286.2 67.66C259.3 94.54 213.3 75.51 213.3 37.49V21.33C213.3 9.542 203.8 0 192 0S170.7 9.542 170.7 21.33v16.16c0 38.01-45.96 57.05-72.84 30.17L86.4 56.23c-8.334-8.334-21.83-8.336-30.17-.002c-8.332 8.334-8.333 21.84-.0012 30.17L67.66 97.83c26.88 26.88 7.842 72.84-30.17 72.84H21.33C9.541 170.7 0 180.2 0 192c0 11.79 9.541 21.33 21.33 21.33h16.16c38.01 0 57.05 45.96 30.17 72.84L56.23 297.6c-8.332 8.334-8.328 21.84 .0043 30.17c4.168 4.168 9.621 6.248 15.08 6.248s10.92-2.082 15.08-6.25L97.83 316.3c26.88-26.88 72.84-7.842 72.84 30.17v16.16C170.7 374.5 180.2 384 192 384s21.33-9.543 21.33-21.33v-16.16c0-38.01 45.96-57.05 72.84-30.17l11.43 11.43c4.168 4.168 9.625 6.25 15.08 6.25s10.91-2.08 15.08-6.248c8.332-8.332 8.333-21.83 .0012-30.17L316.3 286.2C289.5 259.3 308.5 213.3 346.5 213.3zM160 192C142.3 192 128 177.7 128 160c0-17.67 14.33-32 32-32s32 14.33 32 32C192 177.7 177.7 192 160 192zM240 224C231.2 224 224 216.8 224 208C224 199.2 231.2 192 240 192S256 199.2 256 208C256 216.8 248.8 224 240 224zM624 352h-12.12c-28.51 0-42.79-34.47-22.63-54.63l8.576-8.576c6.25-6.25 6.25-16.37 0-22.62s-16.38-6.253-22.62-.0031l-8.576 8.576C546.5 294.9 512 280.6 512 252.1V240C512 231.2 504.8 224 496 224S480 231.2 480 240v12.12c0 28.51-34.47 42.79-54.63 22.63l-8.576-8.576c-6.25-6.25-16.37-6.253-22.62-.0031s-6.253 16.38-.0031 22.63l8.576 8.576C422.9 317.5 408.6 352 380.1 352H368c-8.844 0-16 7.156-16 16s7.156 16 16 16h12.12c28.51 0 42.79 34.47 22.63 54.63l-8.576 8.576c-6.25 6.25-6.253 16.37-.0031 22.62c3.125 3.125 7.222 4.691 11.32 4.691s8.188-1.562 11.31-4.688l8.576-8.576C445.5 441.1 480 455.4 480 483.9V496c0 8.844 7.156 16 16 16s16-7.156 16-16v-12.12c0-28.51 34.47-42.79 54.63-22.63l8.576 8.576c3.125 3.125 7.219 4.688 11.31 4.688s8.184-1.559 11.31-4.684c6.25-6.25 6.253-16.38 .0031-22.63l-8.576-8.576C569.1 418.5 583.4 384 611.9 384H624c8.844 0 16-7.156 16-16S632.8 352 624 352zM480 384c-17.67 0-32-14.33-32-32c0-17.67 14.33-32 32-32s32 14.33 32 32C512 369.7 497.7 384 480 384z")),"label"=>__("Viruses","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"vk"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M31.49 63.49C0 94.98 0 145.7 0 247V264.1C0 366.3 0 417 31.49 448.5C62.98 480 113.7 480 215 480H232.1C334.3 480 385 480 416.5 448.5C448 417 448 366.3 448 264.1V247C448 145.7 448 94.98 416.5 63.49C385 32 334.3 32 232.1 32H215C113.7 32 62.98 32 31.49 63.49zM75.6 168.3H126.7C128.4 253.8 166.1 289.1 196 297.4V168.3H244.2V242C273.7 238.8 304.6 205.2 315.1 168.3H363.3C359.3 187.4 351.5 205.6 340.2 221.6C328.9 237.6 314.5 251.1 297.7 261.2C316.4 270.5 332.9 283.6 346.1 299.8C359.4 315.9 369 334.6 374.5 354.7H321.4C316.6 337.3 306.6 321.6 292.9 309.8C279.1 297.9 262.2 290.4 244.2 288.1V354.7H238.4C136.3 354.7 78.03 284.7 75.6 168.3z")),"label"=>__("VK","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"vnv"=>array("svg"=>array("brands"=>array("width"=>640,"height"=>512,"path"=>"M104.9 352c-34.1 0-46.4-30.4-46.4-30.4L2.6 210.1S-7.8 192 13 192h32.8c10.4 0 13.2 8.7 18.8 18.1l36.7 74.5s5.2 13.1 21.1 13.1 21.1-13.1 21.1-13.1l36.7-74.5c5.6-9.5 8.4-18.1 18.8-18.1h32.8c20.8 0 10.4 18.1 10.4 18.1l-55.8 111.5S174.2 352 140 352h-35.1zm395 0c-34.1 0-46.4-30.4-46.4-30.4l-55.9-111.5S387.2 192 408 192h32.8c10.4 0 13.2 8.7 18.8 18.1l36.7 74.5s5.2 13.1 21.1 13.1 21.1-13.1 21.1-13.1l36.8-74.5c5.6-9.5 8.4-18.1 18.8-18.1H627c20.8 0 10.4 18.1 10.4 18.1l-55.9 111.5S569.3 352 535.1 352h-35.2zM337.6 192c34.1 0 46.4 30.4 46.4 30.4l55.9 111.5s10.4 18.1-10.4 18.1h-32.8c-10.4 0-13.2-8.7-18.8-18.1l-36.7-74.5s-5.2-13.1-21.1-13.1c-15.9 0-21.1 13.1-21.1 13.1l-36.7 74.5c-5.6 9.4-8.4 18.1-18.8 18.1h-32.9c-20.8 0-10.4-18.1-10.4-18.1l55.9-111.5s12.2-30.4 46.4-30.4h35.1z")),"label"=>__("VNV","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"voicemail"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M495.1 96c-53.13 0-102 29.25-127 76.13c-25 46.88-22.25 103.8 7.25 147.9H263.7c36.63-54.88 31.25-127.8-13-176.8c-44.38-48.87-116.4-61.37-174.6-30.25s-87.88 97.88-71.75 162c16 64 73.63 108.1 139.6 108.1h352C575.5 384 640 319.5 640 240S575.5 96 495.1 96zM63.99 240c0-44.12 35.88-80 80-80s80 35.88 80 80s-35.88 79.1-80 79.1S63.99 284.1 63.99 240zM495.1 320c-44.13 0-80-35.88-80-79.1s35.88-80 80-80s80 35.88 80 80S540.1 320 495.1 320z")),"label"=>__("Voicemail","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication")),"volcano"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M304.4 224H207.6C197.7 224 188.5 228.5 182.4 236.3l-55.63 71l13.25 16.5C149.7 336 170.2 336 180.1 323.8c10.75-13.5 26.75-21.25 44.13-21.5c17.13-1.5 33.5 7 44.75 20l31.63 36.88c9.751 11.38 29.13 11.38 39 0l45.13-52.62l-55-70.25C323.5 228.5 314.3 224 304.4 224zM159.1 144c12.88 0 24.75-3.875 34.75-10.38L223.1 192h64l29.25-58.38C327.3 140.1 339.1 144 352 144c35.25 0 64-28.75 64-64s-28.75-64-64-64c-15.75 0-30 5.875-41.25 15.38C299.6 12.75 279.4 0 255.1 0C232.6 0 212.4 12.75 201.2 31.38C189.1 21.88 175.7 16 159.1 16c-35.25 0-64 28.75-64 64S124.7 144 159.1 144zM505.5 460.8l-100.8-128.6l-41 47.63C352.8 392.6 336.8 400 320 400s-32.75-7.25-43.75-20.25L244.6 343C239.7 337.3 232.6 334 225.1 334H224.7c-7.751 .25-14.88 3.75-19.63 9.75c-22.13 27.5-68.13 27.5-90.13 0l-8.376-10.62l-100.1 127.6C-9.397 481.9 5.727 512 32.1 512h447.9C506.3 512 521.4 481.9 505.5 460.8z")),"label"=>__("Volcano","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment")),"volleyball"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M200.3 106C185.4 80.24 165.2 53.9 137.4 29.26C55.75 72.05 0 157.4 0 256c0 21.33 2.898 41.94 7.814 61.75C53.59 182.1 155.1 124.9 200.3 106zM381.7 281.1c1.24-9.223 2.414-22.08 2.414-37.65c0-59.1-16.93-157.2-111.5-242.6C267.1 .4896 261.6 0 256 0C225.5 0 196.5 5.591 169.4 15.36c93.83 90.15 102.6 198.5 102.8 231.7C287.8 255.9 327.3 275.1 381.7 281.1zM240.1 246.5C239.1 228.5 236.9 184.7 214.9 134.6C173.6 151.6 60.4 211.7 26.67 369.2c15.66 31.64 37.52 59.66 64.22 82.23C122 325.1 211.5 263.3 240.1 246.5zM326.5 10.07c74.79 84.9 89.5 175.9 89.5 234c0 15.45-1.042 28.56-2.27 38.61l.5501 .0005c29.54 0 62.2-4.325 97.16-15.99C511.6 263.1 512 259.6 512 256C512 139.1 433.6 40.72 326.5 10.07zM255.7 274.5c-15.43 9.086-51.89 33.63-84.32 77.86c26.34 20.33 93.51 63.27 189.5 63.27c32.83 0 69.02-5.021 108.1-17.69c19.08-28.59 32.41-61.34 38.71-96.47C474.5 311.1 443 315 414.4 315C334.6 315 276.5 286.3 255.7 274.5zM153.1 379.3c-14.91 25.71-27.62 56.33-35.03 92.72C158.6 497.2 205.5 512 256 512c69 0 131.5-27.43 177.5-71.82c-25.42 5.105-49.71 7.668-72.38 7.668C258.6 447.8 185.5 402.1 153.1 379.3z")),"label"=>__("Volleyball","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"volume-high"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M412.6 182c-10.28-8.334-25.41-6.867-33.75 3.402c-8.406 10.24-6.906 25.35 3.375 33.74C393.5 228.4 400 241.8 400 255.1c0 14.17-6.5 27.59-17.81 36.83c-10.28 8.396-11.78 23.5-3.375 33.74c4.719 5.806 11.62 8.802 18.56 8.802c5.344 0 10.75-1.779 15.19-5.399C435.1 311.5 448 284.6 448 255.1S435.1 200.4 412.6 182zM473.1 108.2c-10.22-8.334-25.34-6.898-33.78 3.34c-8.406 10.24-6.906 25.35 3.344 33.74C476.6 172.1 496 213.3 496 255.1s-19.44 82.1-53.31 110.7c-10.25 8.396-11.75 23.5-3.344 33.74c4.75 5.775 11.62 8.771 18.56 8.771c5.375 0 10.75-1.779 15.22-5.431C518.2 366.9 544 313 544 255.1S518.2 145 473.1 108.2zM534.4 33.4c-10.22-8.334-25.34-6.867-33.78 3.34c-8.406 10.24-6.906 25.35 3.344 33.74C559.9 116.3 592 183.9 592 255.1s-32.09 139.7-88.06 185.5c-10.25 8.396-11.75 23.5-3.344 33.74C505.3 481 512.2 484 519.2 484c5.375 0 10.75-1.779 15.22-5.431C601.5 423.6 640 342.5 640 255.1S601.5 88.34 534.4 33.4zM301.2 34.98c-11.5-5.181-25.01-3.076-34.43 5.29L131.8 160.1H48c-26.51 0-48 21.48-48 47.96v95.92c0 26.48 21.49 47.96 48 47.96h83.84l134.9 119.8C272.7 477 280.3 479.8 288 479.8c4.438 0 8.959-.9314 13.16-2.835C312.7 471.8 320 460.4 320 447.9V64.12C320 51.55 312.7 40.13 301.2 34.98z")),"label"=>__("Volume High","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","lifestyle-and-hobbies","science-and-technology")),"volume-low"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M412.6 181.9c-10.28-8.344-25.41-6.875-33.75 3.406c-8.406 10.25-6.906 25.37 3.375 33.78C393.5 228.4 400 241.8 400 256c0 14.19-6.5 27.62-17.81 36.87c-10.28 8.406-11.78 23.53-3.375 33.78c4.719 5.812 11.62 8.812 18.56 8.812c5.344 0 10.75-1.781 15.19-5.406C435.1 311.6 448 284.7 448 256S435.1 200.4 412.6 181.9zM301.2 34.84c-11.5-5.187-25.01-3.116-34.43 5.259L131.8 160H48c-26.51 0-48 21.49-48 47.1v95.1c0 26.51 21.49 47.1 48 47.1h83.84l134.9 119.9C272.7 477.2 280.3 480 288 480c4.438 0 8.959-.9313 13.16-2.837C312.7 472 320 460.6 320 448V64C320 51.41 312.7 39.1 301.2 34.84z")),"label"=>__("Volume Low","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","lifestyle-and-hobbies","science-and-technology")),"volume-off"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M320 64v383.1c0 12.59-7.337 24.01-18.84 29.16C296.1 479.1 292.4 480 288 480c-7.688 0-15.28-2.781-21.27-8.094l-134.9-119.9H48c-26.51 0-48-21.49-48-47.1V208c0-26.51 21.49-47.1 48-47.1h83.84l134.9-119.9c9.422-8.375 22.93-10.45 34.43-5.259C312.7 39.1 320 51.41 320 64z")),"label"=>__("Volume Off","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","lifestyle-and-hobbies","science-and-technology")),"volume-xmark"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M301.2 34.85c-11.5-5.188-25.02-3.122-34.44 5.253L131.8 160H48c-26.51 0-48 21.49-48 47.1v95.1c0 26.51 21.49 47.1 48 47.1h83.84l134.9 119.9c5.984 5.312 13.58 8.094 21.26 8.094c4.438 0 8.972-.9375 13.17-2.844c11.5-5.156 18.82-16.56 18.82-29.16V64C319.1 51.41 312.7 40 301.2 34.85zM513.9 255.1l47.03-47.03c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0L480 222.1L432.1 175c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l47.03 47.03l-47.03 47.03c-9.375 9.375-9.375 24.56 0 33.94c9.373 9.373 24.56 9.381 33.94 0L480 289.9l47.03 47.03c9.373 9.373 24.56 9.381 33.94 0c9.375-9.375 9.375-24.56 0-33.94L513.9 255.1z")),"label"=>__("Volume Xmark","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","lifestyle-and-hobbies","science-and-technology")),"vr-cardboard"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M576 64H64c-35.2 0-64 28.8-64 64v256c0 35.2 28.8 64 64 64l128.3 .0001c25.18 0 48.03-14.77 58.37-37.73l27.76-61.65c7.875-17.5 24-28.63 41.63-28.63s33.75 11.13 41.63 28.63l27.75 61.63c10.35 22.98 33.2 37.75 58.4 37.75L576 448c35.2 0 64-28.8 64-64v-256C640 92.8 611.2 64 576 64zM160 304c-35.38 0-64-28.63-64-64s28.62-63.1 64-63.1s64 28.62 64 63.1S195.4 304 160 304zM480 304c-35.38 0-64-28.63-64-64s28.62-63.1 64-63.1s64 28.62 64 63.1S515.4 304 480 304z")),"label"=>__("Vr Cardboard","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"vuejs"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M356.9 64.3H280l-56 88.6-48-88.6H0L224 448 448 64.3h-91.1zm-301.2 32h53.8L224 294.5 338.4 96.3h53.8L224 384.5 55.7 96.3z")),"label"=>__("Vue.js","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"w"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M573.1 75.25l-144 384c-4.703 12.53-16.67 20.77-29.95 20.77c-.4062 0-.8125 0-1.219-.0156c-13.77-.5156-25.66-9.797-29.52-23.03L288 178.3l-81.28 278.7c-3.859 13.23-15.75 22.52-29.52 23.03c-13.75 .4687-26.33-7.844-31.17-20.75l-144-384c-6.203-16.55 2.188-34.98 18.73-41.2C37.31 27.92 55.75 36.23 61.97 52.78l110.2 293.1l85.08-291.7C261.3 41.41 273.8 32.01 288 32.01s26.73 9.396 30.72 23.05l85.08 291.7l110.2-293.1c6.219-16.55 24.67-24.86 41.2-18.73C571.8 40.26 580.2 58.7 573.1 75.25z")),"label"=>__("W","ultimate-addons-for-gutenberg"),"custom_categories"=>array("education")),"walkie-talkie"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M352 96h-32V80C320 71.16 312.8 64 304 64h-32C263.2 64 256 71.16 256 80V96h-32V80C224 71.16 216.8 64 208 64h-32C167.2 64 160 71.16 160 80V96H112V23.1C112 10.74 101.3 0 88 0S64 10.74 64 23.1V96H32C14.4 96 0 110.4 0 128v178.7c0 8.484 3.373 16.62 9.371 22.62L32 352v112C32 490.5 53.49 512 80 512h224c26.51 0 48-21.49 48-48V352l22.63-22.63C380.6 323.4 384 315.2 384 306.7V128C384 110.4 369.6 96 352 96zM288 312C288 316.4 284.4 320 280 320h-176C99.63 320 96 316.4 96 312v-16C96 291.6 99.63 288 104 288h176C284.4 288 288 291.6 288 296V312zM288 248C288 252.4 284.4 256 280 256h-176C99.63 256 96 252.4 96 248v-16C96 227.6 99.63 224 104 224h176C284.4 224 288 227.6 288 232V248zM288 184C288 188.4 284.4 192 280 192h-176C99.63 192 96 188.4 96 184v-16C96 163.6 99.63 160 104 160h176C284.4 160 288 163.6 288 168V184z")),"label"=>__("Walkie Talkie","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","science-and-technology")),"wallet"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M448 32C465.7 32 480 46.33 480 64C480 81.67 465.7 96 448 96H80C71.16 96 64 103.2 64 112C64 120.8 71.16 128 80 128H448C483.3 128 512 156.7 512 192V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H448zM416 336C433.7 336 448 321.7 448 304C448 286.3 433.7 272 416 272C398.3 272 384 286.3 384 304C384 321.7 398.3 336 416 336z")),"label"=>__("Wallet","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"wand-magic"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M14.06 463.3C-4.686 444.6-4.686 414.2 14.06 395.4L395.4 14.06C414.2-4.686 444.6-4.686 463.3 14.06L497.9 48.64C516.6 67.38 516.6 97.78 497.9 116.5L116.5 497.9C97.78 516.6 67.38 516.6 48.64 497.9L14.06 463.3zM347.6 187.6L452.6 82.58L429.4 59.31L324.3 164.3L347.6 187.6z")),"label"=>__("Wand Magic","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design")),"wand-magic-sparkles"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M248.8 4.994C249.9 1.99 252.8 .0001 256 .0001C259.2 .0001 262.1 1.99 263.2 4.994L277.3 42.67L315 56.79C318 57.92 320 60.79 320 64C320 67.21 318 70.08 315 71.21L277.3 85.33L263.2 123C262.1 126 259.2 128 256 128C252.8 128 249.9 126 248.8 123L234.7 85.33L196.1 71.21C193.1 70.08 192 67.21 192 64C192 60.79 193.1 57.92 196.1 56.79L234.7 42.67L248.8 4.994zM427.4 14.06C446.2-4.686 476.6-4.686 495.3 14.06L529.9 48.64C548.6 67.38 548.6 97.78 529.9 116.5L148.5 497.9C129.8 516.6 99.38 516.6 80.64 497.9L46.06 463.3C27.31 444.6 27.31 414.2 46.06 395.4L427.4 14.06zM461.4 59.31L356.3 164.3L379.6 187.6L484.6 82.58L461.4 59.31zM7.491 117.2L64 96L85.19 39.49C86.88 34.98 91.19 32 96 32C100.8 32 105.1 34.98 106.8 39.49L128 96L184.5 117.2C189 118.9 192 123.2 192 128C192 132.8 189 137.1 184.5 138.8L128 160L106.8 216.5C105.1 221 100.8 224 96 224C91.19 224 86.88 221 85.19 216.5L64 160L7.491 138.8C2.985 137.1 0 132.8 0 128C0 123.2 2.985 118.9 7.491 117.2zM359.5 373.2L416 352L437.2 295.5C438.9 290.1 443.2 288 448 288C452.8 288 457.1 290.1 458.8 295.5L480 352L536.5 373.2C541 374.9 544 379.2 544 384C544 388.8 541 393.1 536.5 394.8L480 416L458.8 472.5C457.1 477 452.8 480 448 480C443.2 480 438.9 477 437.2 472.5L416 416L359.5 394.8C354.1 393.1 352 388.8 352 384C352 379.2 354.1 374.9 359.5 373.2z")),"label"=>__("Wand Magic Sparkles","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design")),"wand-sparkles"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M3.682 149.1L53.32 170.7L74.02 220.3c1.016 2.043 3.698 3.696 5.977 3.696c.0078 0-.0078 0 0 0c2.271-.0156 4.934-1.661 5.946-3.696l20.72-49.63l49.62-20.71c2.023-1.008 3.68-3.681 3.691-5.947C159.1 141.7 158.3 139 156.3 138L106.9 117.4L106.5 117L85.94 67.7C84.93 65.66 82.27 64.02 80 64c-.0078 0 .0078 0 0 0c-2.279 0-4.966 1.649-5.981 3.692L53.32 117.3L3.682 138C1.652 139.1 0 141.7 0 144C0 146.3 1.652 148.9 3.682 149.1zM511.1 368c-.0039-2.273-1.658-4.95-3.687-5.966l-49.57-20.67l-20.77-49.67C436.9 289.7 434.3 288 432 288c-2.281 0-4.948 1.652-5.964 3.695l-20.7 49.63l-49.64 20.71c-2.027 1.016-3.684 3.683-3.687 5.956c.0039 2.262 1.662 4.954 3.687 5.966l49.57 20.67l20.77 49.67C427.1 446.3 429.7 448 432 448c2.277 0 4.944-1.656 5.96-3.699l20.69-49.63l49.65-20.71C510.3 372.9 511.1 370.3 511.1 368zM207.1 64l12.42 29.78C221 95.01 222.6 96 223.1 96s2.965-.9922 3.575-2.219L239.1 64l29.78-12.42c1.219-.6094 2.215-2.219 2.215-3.578c0-1.367-.996-2.969-2.215-3.578L239.1 32L227.6 2.219C226.1 .9922 225.4 0 223.1 0S221 .9922 220.4 2.219L207.1 32L178.2 44.42C176.1 45.03 176 46.63 176 48c0 1.359 .9928 2.969 2.21 3.578L207.1 64zM399.1 191.1c8.875 0 15.1-7.127 15.1-16v-28l91.87-101.7c5.75-6.371 5.5-15.1-.4999-22.12L487.8 4.774c-6.125-6.125-15.75-6.375-22.12-.625L186.6 255.1H144c-8.875 0-15.1 7.125-15.1 15.1v36.88l-117.5 106c-13.5 12.25-14.14 33.34-1.145 46.34l41.4 41.41c12.1 12.1 34.13 12.36 46.37-1.133l279.2-309.5H399.1z")),"label"=>__("Wand Sparkles","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"warehouse"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M0 488V171.3C0 145.2 15.93 121.6 40.23 111.9L308.1 4.753C315.7 1.702 324.3 1.702 331.9 4.753L599.8 111.9C624.1 121.6 640 145.2 640 171.3V488C640 501.3 629.3 512 616 512H568C554.7 512 544 501.3 544 488V223.1C544 206.3 529.7 191.1 512 191.1H128C110.3 191.1 96 206.3 96 223.1V488C96 501.3 85.25 512 72 512H24C10.75 512 0 501.3 0 488zM152 512C138.7 512 128 501.3 128 488V432H512V488C512 501.3 501.3 512 488 512H152zM128 336H512V400H128V336zM128 224H512V304H128V224z")),"label"=>__("Warehouse","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"watchman-monitoring"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M256 16C123.5 16 16 123.5 16 256S123.5 496 256 496 496 388.5 496 256 388.5 16 256 16zM121.7 429.1C70.06 388.1 36.74 326.3 36.74 256a218.5 218.5 0 0 1 9.587-64.12l102.9-17.9-.121 10.97-13.94 2.013s-.144 12.5-.144 19.55a12.78 12.78 0 0 0 4.887 10.35l9.468 7.4zm105.7-283.3 8.48-7.618s6.934-5.38-.143-9.344c-7.188-4.024-39.53-34.5-39.53-34.5-5.348-5.477-8.257-7.347-15.46 0 0 0-32.34 30.47-39.53 34.5-7.078 3.964-.144 9.344-.144 9.344l8.481 7.618-.048 4.369L75.98 131c39.64-56.94 105.5-94.3 180-94.3A218.8 218.8 0 0 1 420.9 111.8l-193.5 37.7zm34.06 329.3-33.9-250.9 9.467-7.4a12.78 12.78 0 0 0 4.888-10.35c0-7.044-.144-19.55-.144-19.55l-13.94-2.013-.116-10.47 241.7 31.39A218.9 218.9 0 0 1 475.3 256C475.3 375.1 379.8 472.2 261.4 475.1z")),"label"=>__("Watchman Monitoring","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"water"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M549.8 237.5c-31.23-5.719-46.84-20.06-47.13-20.31C490.4 205 470.3 205.1 457.7 216.8c-1 .9375-25.14 23-73.73 23s-72.73-22.06-73.38-22.62C298.4 204.9 278.3 205.1 265.7 216.8c-1 .9375-25.14 23-73.73 23S119.3 217.8 118.6 217.2C106.4 204.9 86.35 205 73.74 216.9C73.09 217.4 57.48 231.8 26.24 237.5c-17.38 3.188-28.89 19.84-25.72 37.22c3.188 17.38 19.78 29.09 37.25 25.72C63.1 295.8 82.49 287.1 95.96 279.2c19.5 11.53 51.47 24.68 96.04 24.68c44.55 0 76.49-13.12 96-24.65c19.52 11.53 51.45 24.59 96 24.59c44.58 0 76.55-13.09 96.05-24.62c13.47 7.938 32.86 16.62 58.19 21.25c17.56 3.375 34.06-8.344 37.25-25.72C578.7 257.4 567.2 240.7 549.8 237.5zM549.8 381.7c-31.23-5.719-46.84-20.06-47.13-20.31c-12.22-12.19-32.31-12.12-44.91-.375C456.7 361.9 432.6 384 384 384s-72.73-22.06-73.38-22.62c-12.22-12.25-32.3-12.12-44.89-.375C264.7 361.9 240.6 384 192 384s-72.73-22.06-73.38-22.62c-12.22-12.25-32.28-12.16-44.89-.3438c-.6562 .5938-16.27 14.94-47.5 20.66c-17.38 3.188-28.89 19.84-25.72 37.22C3.713 436.3 20.31 448 37.78 444.6C63.1 440 82.49 431.3 95.96 423.4c19.5 11.53 51.51 24.62 96.08 24.62c44.55 0 76.45-13.06 95.96-24.59C307.5 434.9 339.5 448 384.1 448c44.58 0 76.5-13.09 95.1-24.62c13.47 7.938 32.86 16.62 58.19 21.25C555.8 448 572.3 436.3 575.5 418.9C578.7 401.5 567.2 384.9 549.8 381.7zM37.78 156.4c25.33-4.625 44.72-13.31 58.19-21.25c19.5 11.53 51.47 24.68 96.04 24.68c44.55 0 76.49-13.12 96-24.65c19.52 11.53 51.45 24.59 96 24.59c44.58 0 76.55-13.09 96.05-24.62c13.47 7.938 32.86 16.62 58.19 21.25c17.56 3.375 34.06-8.344 37.25-25.72c3.172-17.38-8.344-34.03-25.72-37.22c-31.23-5.719-46.84-20.06-47.13-20.31c-12.22-12.19-32.31-12.12-44.91-.375c-1 .9375-25.14 23-73.73 23s-72.73-22.06-73.38-22.62c-12.22-12.25-32.3-12.12-44.89-.375c-1 .9375-25.14 23-73.73 23S119.3 73.76 118.6 73.2C106.4 60.95 86.35 61.04 73.74 72.85C73.09 73.45 57.48 87.79 26.24 93.51c-17.38 3.188-28.89 19.84-25.72 37.22C3.713 148.1 20.31 159.8 37.78 156.4z")),"label"=>__("Water","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment","science-and-technology","travel")),"water-ladder"=>array("svg"=>array("solid"=>array("width"=>576,"height"=>512,"path"=>"M320 128c0 .375-.1992 .6855-.2129 1.057C319.8 129.9 320 130.7 320 131.6V128zM192 383.1V288h192v95.99c39.6-.1448 53.95-17.98 64-26.83V128c0-17.62 14.38-32 32-32s32 14.38 32 32c0 17.67 14.33 32 32 32s32-14.33 32-32c0-53-42.1-95.1-95.1-95.1C420.1 32 384 81.94 384 131.6V224H192V128c0-17.62 14.38-32 32-32s32 14.38 32 32c0 17.67 14.33 32 32 32c17.3 0 31.2-13.79 31.79-30.94c-1.227-49.01-37.99-97.06-95.79-97.06C170.1 32 128 74.1 128 128v229.2C138.5 366.4 151.4 383.8 192 383.1zM576 445c0-15.14-10.82-28.59-26.25-31.42c-48.52-8.888-45.5-29.48-69.6-29.48c-25.02 0-31.19 31.79-96.18 31.79c-48.59 0-72.72-22.06-73.38-22.62c-6.141-6.157-14.26-9.188-22.42-9.188c-24.75 0-31.59 31.81-96.2 31.81c-48.59 0-72.69-22.03-73.41-22.59c-6.125-6.157-14.24-9.196-22.4-9.196c-8.072 0-16.18 2.976-22.45 8.852c-29.01 26.25-73.75 12.54-73.75 52.08c0 16.08 12.77 32.07 31.71 32.07c9.77 0 39.65-7.34 64.26-21.84c19.5 11.53 51.51 24.69 96.08 24.69s76.46-13.12 95.96-24.66c19.53 11.53 51.52 24.62 96.06 24.62c44.59 0 76.51-13.12 96.01-24.66c24.71 14.57 54.74 21.83 64.24 21.83C563.2 477.1 576 461.3 576 445z")),"label"=>__("Water Ladder","ultimate-addons-for-gutenberg"),"custom_categories"=>array("travel")),"wave-square"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M476 480h-152c-19.88 0-36-16.12-36-36v-348H192v156c0 19.88-16.12 36-36 36H31.1C14.33 288 0 273.7 0 256s14.33-31.1 31.1-31.1H128v-156c0-19.88 16.12-36 36-36h152c19.88 0 36 16.12 36 36v348h96v-156c0-19.88 16.12-36 36-36h124C625.7 224 640 238.3 640 256s-14.33 32-31.1 32H512v156C512 463.9 495.9 480 476 480z")),"label"=>__("Wave Square","ultimate-addons-for-gutenberg"),"custom_categories"=>array("education")),"waze"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M502.2 201.7C516.7 287.5 471.2 369.6 389 409.8c13 34.1-12.4 70.2-48.32 70.2a51.68 51.68 0 0 1 -51.57-49c-6.44 .19-64.2 0-76.33-.64A51.69 51.69 0 0 1 159 479.9c-33.86-1.36-57.95-34.84-47-67.92-37.21-13.11-72.54-34.87-99.62-70.8-13-17.28-.48-41.8 20.84-41.8 46.31 0 32.22-54.17 43.15-110.3C94.8 95.2 193.1 32 288.1 32c102.5 0 197.1 70.67 214.1 169.7zM373.5 388.3c42-19.18 81.33-56.71 96.29-102.1 40.48-123.1-64.15-228-181.7-228-83.45 0-170.3 55.42-186.1 136-9.53 48.91 5 131.4-68.75 131.4C58.21 358.6 91.6 378.1 127 389.5c24.66-21.8 63.87-15.47 79.83 14.34 14.22 1 79.19 1.18 87.9 .82a51.69 51.69 0 0 1 78.78-16.42zM205.1 187.1c0-34.74 50.84-34.75 50.84 0s-50.84 34.74-50.84 0zm116.6 0c0-34.74 50.86-34.75 50.86 0s-50.86 34.75-50.86 0zm-122.6 70.69c-3.44-16.94 22.18-22.18 25.62-5.21l.06 .28c4.14 21.42 29.85 44 64.12 43.07 35.68-.94 59.25-22.21 64.11-42.77 4.46-16.05 28.6-10.36 25.47 6-5.23 22.18-31.21 62-91.46 62.9-42.55 0-80.88-27.84-87.9-64.25z")),"label"=>__("Waze","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"weebly"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M425.1 65.83c-39.88 0-73.28 25.73-83.66 64.33-18.16-58.06-65.5-64.33-84.95-64.33-19.78 0-66.8 6.28-85.28 64.33-10.38-38.6-43.45-64.33-83.66-64.33C38.59 65.83 0 99.72 0 143c0 28.96 4.18 33.27 77.17 233.5 22.37 60.57 67.77 69.35 92.74 69.35 39.23 0 70.04-19.46 85.93-53.98 15.89 34.83 46.69 54.29 85.93 54.29 24.97 0 70.36-9.1 92.74-69.67 76.55-208.6 77.5-205.6 77.5-227.2 .63-48.32-36.01-83.47-86.92-83.47zm26.34 114.8l-65.57 176.4c-7.92 21.49-21.22 37.22-46.24 37.22-23.44 0-37.38-12.41-44.03-33.9l-39.28-117.4h-.95L216.1 360.4c-6.96 21.5-20.9 33.6-44.02 33.6-25.02 0-38.33-15.74-46.24-37.22L60.88 181.6c-5.38-14.83-7.92-23.91-7.92-34.5 0-16.34 15.84-29.36 38.33-29.36 18.69 0 31.99 11.8 36.11 29.05l44.03 139.8h.95l44.66-136.8c6.02-19.67 16.47-32.08 38.96-32.08s32.94 12.11 38.96 32.08l44.66 136.8h.95l44.03-139.8c4.12-17.25 17.42-29.05 36.11-29.05 22.17 0 38.33 13.32 38.33 35.71-.32 7.87-4.12 16.04-7.61 27.24z")),"label"=>__("Weebly","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"weibo"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M407 177.6c7.6-24-13.4-46.8-37.4-41.7-22 4.8-28.8-28.1-7.1-32.8 50.1-10.9 92.3 37.1 76.5 84.8-6.8 21.2-38.8 10.8-32-10.3zM214.8 446.7C108.5 446.7 0 395.3 0 310.4c0-44.3 28-95.4 76.3-143.7C176 67 279.5 65.8 249.9 161c-4 13.1 12.3 5.7 12.3 6 79.5-33.6 140.5-16.8 114 51.4-3.7 9.4 1.1 10.9 8.3 13.1 135.7 42.3 34.8 215.2-169.7 215.2zm143.7-146.3c-5.4-55.7-78.5-94-163.4-85.7-84.8 8.6-148.8 60.3-143.4 116s78.5 94 163.4 85.7c84.8-8.6 148.8-60.3 143.4-116zM347.9 35.1c-25.9 5.6-16.8 43.7 8.3 38.3 72.3-15.2 134.8 52.8 111.7 124-7.4 24.2 29.1 37 37.4 12 31.9-99.8-55.1-195.9-157.4-174.3zm-78.5 311c-17.1 38.8-66.8 60-109.1 46.3-40.8-13.1-58-53.4-40.3-89.7 17.7-35.4 63.1-55.4 103.4-45.1 42 10.8 63.1 50.2 46 88.5zm-86.3-30c-12.9-5.4-30 .3-38 12.9-8.3 12.9-4.3 28 8.6 34 13.1 6 30.8 .3 39.1-12.9 8-13.1 3.7-28.3-9.7-34zm32.6-13.4c-5.1-1.7-11.4 .6-14.3 5.4-2.9 5.1-1.4 10.6 3.7 12.9 5.1 2 11.7-.3 14.6-5.4 2.8-5.2 1.1-10.9-4-12.9z")),"label"=>__("Weibo","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"weight-hanging"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M510.3 445.9L437.3 153.8C433.5 138.5 420.8 128 406.4 128H346.1c3.625-9.1 5.875-20.75 5.875-32c0-53-42.1-96-96-96S159.1 43 159.1 96c0 11.25 2.25 22 5.875 32H105.6c-14.38 0-27.13 10.5-30.88 25.75l-73.01 292.1C-6.641 479.1 16.36 512 47.99 512h416C495.6 512 518.6 479.1 510.3 445.9zM256 128C238.4 128 223.1 113.6 223.1 96S238.4 64 256 64c17.63 0 32 14.38 32 32S273.6 128 256 128z")),"label"=>__("Weight Hanging","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"weight-scale"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M310.3 97.25c-8-3.5-17.5 .25-21 8.5L255.8 184C233.8 184.3 216 202 216 224c0 22.12 17.88 40 40 40S296 246.1 296 224c0-10.5-4.25-20-11-27.12l33.75-78.63C322.3 110.1 318.4 100.8 310.3 97.25zM448 64h-56.23C359.5 24.91 310.7 0 256 0S152.5 24.91 120.2 64H64C28.75 64 0 92.75 0 128v320c0 35.25 28.75 64 64 64h384c35.25 0 64-28.75 64-64V128C512 92.75 483.3 64 448 64zM256 304c-70.58 0-128-57.42-128-128s57.42-128 128-128c70.58 0 128 57.42 128 128S326.6 304 256 304z")),"label"=>__("Weight Scale","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"weixin"=>array("svg"=>array("brands"=>array("width"=>576,"height"=>512,"path"=>"M385.2 167.6c6.4 0 12.6 .3 18.8 1.1C387.4 90.3 303.3 32 207.7 32 100.5 32 13 104.8 13 197.4c0 53.4 29.3 97.5 77.9 131.6l-19.3 58.6 68-34.1c24.4 4.8 43.8 9.7 68.2 9.7 6.2 0 12.1-.3 18.3-.8-4-12.9-6.2-26.6-6.2-40.8-.1-84.9 72.9-154 165.3-154zm-104.5-52.9c14.5 0 24.2 9.7 24.2 24.4 0 14.5-9.7 24.2-24.2 24.2-14.8 0-29.3-9.7-29.3-24.2 .1-14.7 14.6-24.4 29.3-24.4zm-136.4 48.6c-14.5 0-29.3-9.7-29.3-24.2 0-14.8 14.8-24.4 29.3-24.4 14.8 0 24.4 9.7 24.4 24.4 0 14.6-9.6 24.2-24.4 24.2zM563 319.4c0-77.9-77.9-141.3-165.4-141.3-92.7 0-165.4 63.4-165.4 141.3S305 460.7 397.6 460.7c19.3 0 38.9-5.1 58.6-9.9l53.4 29.3-14.8-48.6C534 402.1 563 363.2 563 319.4zm-219.1-24.5c-9.7 0-19.3-9.7-19.3-19.6 0-9.7 9.7-19.3 19.3-19.3 14.8 0 24.4 9.7 24.4 19.3 0 10-9.7 19.6-24.4 19.6zm107.1 0c-9.7 0-19.3-9.7-19.3-19.6 0-9.7 9.7-19.3 19.3-19.3 14.5 0 24.4 9.7 24.4 19.3 .1 10-9.9 19.6-24.4 19.6z")),"label"=>__("Weixin (WeChat)","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"whatsapp"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7 .9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z")),"label"=>__("WhatsApp","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"whatsapp-square"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M224 122.8c-72.7 0-131.8 59.1-131.9 131.8 0 24.9 7 49.2 20.2 70.1l3.1 5-13.3 48.6 49.9-13.1 4.8 2.9c20.2 12 43.4 18.4 67.1 18.4h.1c72.6 0 133.3-59.1 133.3-131.8 0-35.2-15.2-68.3-40.1-93.2-25-25-58-38.7-93.2-38.7zm77.5 188.4c-3.3 9.3-19.1 17.7-26.7 18.8-12.6 1.9-22.4 .9-47.5-9.9-39.7-17.2-65.7-57.2-67.7-59.8-2-2.6-16.2-21.5-16.2-41s10.2-29.1 13.9-33.1c3.6-4 7.9-5 10.6-5 2.6 0 5.3 0 7.6 .1 2.4 .1 5.7-.9 8.9 6.8 3.3 7.9 11.2 27.4 12.2 29.4s1.7 4.3 .3 6.9c-7.6 15.2-15.7 14.6-11.6 21.6 15.3 26.3 30.6 35.4 53.9 47.1 4 2 6.3 1.7 8.6-1 2.3-2.6 9.9-11.6 12.5-15.5 2.6-4 5.3-3.3 8.9-2 3.6 1.3 23.1 10.9 27.1 12.9s6.6 3 7.6 4.6c.9 1.9 .9 9.9-2.4 19.1zM400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM223.9 413.2c-26.6 0-52.7-6.7-75.8-19.3L64 416l22.5-82.2c-13.9-24-21.2-51.3-21.2-79.3C65.4 167.1 136.5 96 223.9 96c42.4 0 82.2 16.5 112.2 46.5 29.9 30 47.9 69.8 47.9 112.2 0 87.4-72.7 158.5-160.1 158.5z")),"label"=>__("WhatsApp Square","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"wheat-awn"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M416.1 128.1C407.6 138.3 392.4 138.3 383 128.1C373.7 119.6 373.7 104.4 383 95.03L471 7.029C480.4-2.343 495.6-2.343 504.1 7.029C514.3 16.4 514.3 31.6 504.1 40.97L416.1 128.1zM327.2 230.1L295.3 261.1C323.8 264.7 351.5 277 373.4 298.8L395.1 321.5L373.4 344.1C335.9 381.6 275.1 381.6 237.6 344.1L225.4 331.9L193.5 363.8C221.1 366.5 249.7 378.8 271.5 400.7L294.2 423.3L271.5 445.9C234 483.4 173.3 483.4 135.8 445.9L123.5 433.7L54.63 502.6C42.13 515.1 21.87 515.1 9.372 502.6C-3.124 490.1-3.124 469.9 9.372 457.4L78.29 388.5L67.88 378C30.39 340.6 30.39 279.8 67.88 242.3L90.51 219.6L113.1 242.3C134.1 263.3 146.3 289.7 149.7 317.1L180.1 286.6L169.7 276.2C132.2 238.7 132.2 177.9 169.7 140.5L192.3 117.8L214.1 140.5C235.1 161.4 248.1 187.9 251.5 215.3L281.9 184.8L271.5 174.4C234 136.9 234 76.12 271.5 38.63L294.2 16L316.8 38.63C321.3 43.15 325.4 47.94 329.1 52.93L375 7.03C384.4-2.343 399.6-2.343 408.1 7.03C418.3 16.4 418.3 31.6 408.1 40.97L350.7 99.2C355.9 120.7 355.4 143.2 349.3 164.5C369.6 158.7 391.1 157.1 411.7 162.4L471 103C480.4 93.66 495.6 93.66 504.1 103C514.3 112.4 514.3 127.6 504.1 136.1L458.8 183.2C464.5 187.2 470 191.9 475.2 197L497.8 219.6L475.2 242.3C437.7 279.8 376.9 279.8 339.4 242.3L327.2 230.1z")),"label"=>__("Wheat Awn","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"wheat-awn-circle-exclamation"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M416.1 128.1C407.6 138.3 392.4 138.3 383 128.1C373.7 119.6 373.7 104.4 383 95.03L471 7.03C480.4-2.343 495.6-2.343 504.1 7.03C514.3 16.4 514.3 31.6 504.1 40.97L416.1 128.1zM327.2 230.1L295.3 261.1C312.5 263.6 329.5 268.8 345 277.4C329.1 303.9 320 334.9 320 368C320 369 320 370.1 320 371.1C290.9 375.6 260 366.6 237.6 344.1L225.4 331.9L193.5 363.8C221.1 366.5 249.7 378.8 271.5 400.7L294.2 423.3L271.5 445.9C234 483.4 173.3 483.4 135.8 445.9L123.5 433.7L54.63 502.6C42.13 515.1 21.87 515.1 9.372 502.6C-3.124 490.1-3.124 469.9 9.372 457.4L78.29 388.5L67.88 378C30.39 340.6 30.39 279.8 67.88 242.3L90.51 219.6L113.1 242.3C134.1 263.3 146.3 289.7 149.7 317.1L180.1 286.6L169.7 276.2C132.2 238.7 132.2 177.9 169.7 140.5L192.3 117.8L214.1 140.5C235.1 161.4 248.1 187.9 251.5 215.3L281.9 184.8L271.5 174.4C234 136.9 234 76.12 271.5 38.63L294.2 15.1L316.8 38.63C321.3 43.15 325.4 47.94 329.1 52.93L375 7.029C384.4-2.343 399.6-2.343 408.1 7.029C418.3 16.4 418.3 31.6 408.1 40.97L350.7 99.2C355.9 120.7 355.4 143.2 349.3 164.5C369.6 158.7 391.1 157.1 411.7 162.4L471 103C480.4 93.66 495.6 93.66 504.1 103C514.3 112.4 514.3 127.6 504.1 136.1L458.8 183.1C463.3 186.3 467.6 189.8 471.7 193.7C426.4 199.9 386.5 223.5 359.1 257.4C352 253.3 345.4 248.3 339.4 242.3L327.2 230.1zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 464C509.3 464 520 453.3 520 440C520 426.7 509.3 416 496 416C482.7 416 472 426.7 472 440C472 453.3 482.7 464 496 464zM479.1 288V368C479.1 376.8 487.2 384 495.1 384C504.8 384 511.1 376.8 511.1 368V288C511.1 279.2 504.8 272 495.1 272C487.2 272 479.1 279.2 479.1 288z")),"label"=>__("Wheat Awn Circle Exclamation","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment","lifestyle-and-hobbies")),"wheelchair"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M510.3 421.9c-5.594-16.75-23.53-25.84-40.47-20.22l-19.38 6.438l-41.7-99.97C403.9 295.1 392.2 288 379.1 288h-97.78l-10.4-48h65.11c17.69 0 32-14.31 32-32s-14.31-32-32-32h-78.98L255.6 169.2C251.8 142.1 227.2 124.8 201.2 128.5C174.1 132.2 156.7 156.5 160.5 182.8l23.68 140.4C185.8 339.6 199.6 352 216 352h141.4l44.86 107.9C407.3 472.3 419.3 480 432 480c3.344 0 6.781-.5313 10.12-1.656l48-16C506.9 456.8 515.9 438.7 510.3 421.9zM160 464c-61.76 0-112-50.24-112-112c0-54.25 38.78-99.55 90.06-109.8L130.1 195C56.06 209 0 273.9 0 352c0 88.37 71.63 160 160 160c77.4 0 141.9-54.97 156.8-128h-49.1C252.9 430.1 210.6 464 160 464zM192 96c26.51 0 48-21.49 48-48S218.5 0 192 0S144 21.49 144 48S165.5 96 192 96z")),"label"=>__("Wheelchair","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design","science-and-technology","travel")),"wheelchair-move"=>array("svg"=>array("solid"=>array("width"=>448,"height"=>512,"path"=>"M416 48C416 74.51 394.5 96 368 96C341.5 96 320 74.51 320 48C320 21.49 341.5 0 368 0C394.5 0 416 21.49 416 48zM172.8 54.4C182.3 47.29 194.9 46 205.6 51.05L322.1 105.9C351.3 119.6 358.9 157.5 337.4 181.4L299.1 224H416C425.6 224 434.7 228.3 440.7 235.7C446.8 243.1 449.3 252.9 447.4 262.3L415.4 422.3C411.9 439.6 395.1 450.8 377.7 447.4C360.4 443.9 349.2 427.1 352.6 409.7L376.1 288H306.7C315.3 307.6 320 329.2 320 352C320 440.4 248.4 512 160 512C71.63 512 0 440.4 0 352C0 263.6 71.63 192 160 192C171.1 192 181.1 193.1 192.4 195.3L246.6 141.1L195.8 117.2L147.2 153.6C133.1 164.2 113 161.3 102.4 147.2C91.8 133.1 94.66 113 108.8 102.4L172.8 54.4zM160 448C213 448 256 405 256 352C256 298.1 213 256 160 256C106.1 256 64 298.1 64 352C64 405 106.1 448 160 448z")),"label"=>__("Wheelchair Move","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design","science-and-technology","travel")),"whiskey-glass"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M479.1 32H32.04C12.55 32-2.324 49.25 .3008 68.51L56.29 425.1C60.79 456.6 87.78 480 119.8 480h272.9c31.74 0 58.86-23.38 63.36-54.89l55.61-356.6C514.3 49.25 499.5 32 479.1 32zM422.7 224H89.49L69.39 96h373.2L422.7 224z")),"label"=>__("Whiskey Glass","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"whmcs"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M448 161v-21.3l-28.5-8.8-2.2-10.4 20.1-20.7L427 80.4l-29 7.5-7.2-7.5 7.5-28.2-19.1-11.6-21.3 21-10.7-3.2-7-26.4h-22.6l-6.2 26.4-12.1 3.2-19.7-21-19.4 11 8.1 27.7-8.1 8.4-28.5-7.5-11 19.1 20.7 21-2.9 10.4-28.5 7.8-.3 21.7 28.8 7.5 2.4 12.1-20.1 19.9 10.4 18.5 29.6-7.5 7.2 8.6-8.1 26.9 19.9 11.6 19.4-20.4 11.6 2.9 6.7 28.5 22.6 .3 6.7-28.8 11.6-3.5 20.7 21.6 20.4-12.1-8.8-28 7.8-8.1 28.8 8.8 10.3-20.1-20.9-18.8 2.2-12.1 29.1-7zm-119.2 45.2c-31.3 0-56.8-25.4-56.8-56.8s25.4-56.8 56.8-56.8 56.8 25.4 56.8 56.8c0 31.5-25.4 56.8-56.8 56.8zm72.3 16.4l46.9 14.5V277l-55.1 13.4-4.1 22.7 38.9 35.3-19.2 37.9-54-16.7-14.6 15.2 16.7 52.5-38.3 22.7-38.9-40.5-21.7 6.6-12.6 54-42.4-.5-12.6-53.6-21.7-5.6-36.4 38.4-37.4-21.7 15.2-50.5-13.7-16.1-55.5 14.1-19.7-34.8 37.9-37.4-4.8-22.8-54-14.1 .5-40.9L54 219.9l5.7-19.7-38.9-39.4L41.5 125l53.6 14.1 15.2-15.7-15.2-52 36.4-20.7 36.8 39.4L191 84l11.6-52H245l11.6 45.9L234 72l-6.3-1.7-3.3 5.7-11 19.1-3.3 5.6 4.6 4.6 17.2 17.4-.3 1-23.8 6.5-6.2 1.7-.1 6.4-.2 12.9C153.8 161.6 118 204 118 254.7c0 58.3 47.3 105.7 105.7 105.7 50.5 0 92.7-35.4 103.2-82.8l13.2 .2 6.9 .1 1.6-6.7 5.6-24 1.9-.6 17.1 17.8 4.7 4.9 5.8-3.4 20.4-12.1 5.8-3.5-2-6.5-6.8-21.2z")),"label"=>__("WHMCS","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"wifi"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M319.1 351.1c-35.35 0-64 28.66-64 64.01s28.66 64.01 64 64.01c35.34 0 64-28.66 64-64.01S355.3 351.1 319.1 351.1zM320 191.1c-70.25 0-137.9 25.6-190.5 72.03C116.3 275.7 115 295.9 126.7 309.2C138.5 322.4 158.7 323.7 171.9 312C212.8 275.9 265.4 256 320 256s107.3 19.88 148.1 56C474.2 317.4 481.8 320 489.3 320c8.844 0 17.66-3.656 24-10.81C525 295.9 523.8 275.7 510.5 264C457.9 217.6 390.3 191.1 320 191.1zM630.2 156.7C546.3 76.28 436.2 32 320 32S93.69 76.28 9.844 156.7c-12.75 12.25-13.16 32.5-.9375 45.25c12.22 12.78 32.47 13.12 45.25 .9375C125.1 133.1 220.4 96 320 96s193.1 37.97 265.8 106.9C592.1 208.8 600 211.8 608 211.8c8.406 0 16.81-3.281 23.09-9.844C643.3 189.2 642.9 168.1 630.2 156.7z")),"label"=>__("Wifi","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology","travel")),"wikipedia-w"=>array("svg"=>array("brands"=>array("width"=>640,"height"=>512,"path"=>"M640 51.2l-.3 12.2c-28.1 .8-45 15.8-55.8 40.3-25 57.8-103.3 240-155.3 358.6H415l-81.9-193.1c-32.5 63.6-68.3 130-99.2 193.1-.3 .3-15 0-15-.3C172 352.3 122.8 243.4 75.8 133.4 64.4 106.7 26.4 63.4 .2 63.7c0-3.1-.3-10-.3-14.2h161.9v13.9c-19.2 1.1-52.8 13.3-43.3 34.2 21.9 49.7 103.6 240.3 125.6 288.6 15-29.7 57.8-109.2 75.3-142.8-13.9-28.3-58.6-133.9-72.8-160-9.7-17.8-36.1-19.4-55.8-19.7V49.8l142.5 .3v13.1c-19.4 .6-38.1 7.8-29.4 26.1 18.9 40 30.6 68.1 48.1 104.7 5.6-10.8 34.7-69.4 48.1-100.8 8.9-20.6-3.9-28.6-38.6-29.4 .3-3.6 0-10.3 .3-13.6 44.4-.3 111.1-.3 123.1-.6v13.6c-22.5 .8-45.8 12.8-58.1 31.7l-59.2 122.8c6.4 16.1 63.3 142.8 69.2 156.7L559.2 91.8c-8.6-23.1-36.4-28.1-47.2-28.3V49.6l127.8 1.1 .2 .5z")),"label"=>__("Wikipedia W","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"wind"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M32 192h320c52.94 0 96-43.06 96-96s-43.06-96-96-96h-32c-17.69 0-32 14.31-32 32s14.31 32 32 32h32c17.66 0 32 14.34 32 32s-14.34 32-32 32H32C14.31 128 0 142.3 0 160S14.31 192 32 192zM160 320H32c-17.69 0-32 14.31-32 32s14.31 32 32 32h128c17.66 0 32 14.34 32 32s-14.34 32-32 32H128c-17.69 0-32 14.31-32 32s14.31 32 32 32h32c52.94 0 96-43.06 96-96S212.9 320 160 320zM416 224H32C14.31 224 0 238.3 0 256s14.31 32 32 32h384c17.66 0 32 14.34 32 32s-14.34 32-32 32h-32c-17.69 0-32 14.31-32 32s14.31 32 32 32h32c52.94 0 96-43.06 96-96S468.9 224 416 224z")),"label"=>__("Wind","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment","science-and-technology")),"window-maximize"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M448 32C483.3 32 512 60.65 512 96V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H448zM96 96C78.33 96 64 110.3 64 128C64 145.7 78.33 160 96 160H416C433.7 160 448 145.7 448 128C448 110.3 433.7 96 416 96H96z"),"regular"=>array("width"=>512,"height"=>512,"path"=>"M7.724 65.49C13.36 55.11 21.79 46.47 32 40.56C39.63 36.15 48.25 33.26 57.46 32.33C59.61 32.11 61.79 32 64 32H448C483.3 32 512 60.65 512 96V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V96C0 93.79 .112 91.61 .3306 89.46C1.204 80.85 3.784 72.75 7.724 65.49V65.49zM48 416C48 424.8 55.16 432 64 432H448C456.8 432 464 424.8 464 416V224H48V416z")),"label"=>__("Window Maximize","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"window-minimize"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M0 448C0 430.3 14.33 416 32 416H480C497.7 416 512 430.3 512 448C512 465.7 497.7 480 480 480H32C14.33 480 0 465.7 0 448z"),"regular"=>array("width"=>512,"height"=>512,"path"=>"M0 456C0 442.7 10.75 432 24 432H488C501.3 432 512 442.7 512 456C512 469.3 501.3 480 488 480H24C10.75 480 0 469.3 0 456z")),"label"=>__("Window Minimize","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"window-restore"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M432 64H208C199.2 64 192 71.16 192 80V96H128V80C128 35.82 163.8 0 208 0H432C476.2 0 512 35.82 512 80V304C512 348.2 476.2 384 432 384H416V320H432C440.8 320 448 312.8 448 304V80C448 71.16 440.8 64 432 64zM0 192C0 156.7 28.65 128 64 128H320C355.3 128 384 156.7 384 192V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V192zM96 256H288C305.7 256 320 241.7 320 224C320 206.3 305.7 192 288 192H96C78.33 192 64 206.3 64 224C64 241.7 78.33 256 96 256z"),"regular"=>array("width"=>512,"height"=>512,"path"=>"M432 48H208C190.3 48 176 62.33 176 80V96H128V80C128 35.82 163.8 0 208 0H432C476.2 0 512 35.82 512 80V304C512 348.2 476.2 384 432 384H416V336H432C449.7 336 464 321.7 464 304V80C464 62.33 449.7 48 432 48zM320 128C355.3 128 384 156.7 384 192V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V192C0 156.7 28.65 128 64 128H320zM64 464H320C328.8 464 336 456.8 336 448V256H48V448C48 456.8 55.16 464 64 464z")),"label"=>__("Window Restore","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"windows"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M0 93.7l183.6-25.3v177.4H0V93.7zm0 324.6l183.6 25.3V268.4H0v149.9zm203.8 28L448 480V268.4H203.8v177.9zm0-380.6v180.1H448V32L203.8 65.7z")),"label"=>__("Windows","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"wine-bottle"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M507.3 72.57l-67.88-67.88c-6.252-6.25-16.38-6.25-22.63 0l-22.63 22.62c-6.25 6.254-6.251 16.38-.0006 22.63l-76.63 76.63c-46.63-19.75-102.4-10.75-140.4 27.25l-158.4 158.4c-25 25-25 65.51 0 90.51l90.51 90.52c25 25 65.51 25 90.51 0l158.4-158.4c38-38 47-93.76 27.25-140.4l76.63-76.63c6.25 6.25 16.5 6.25 22.75 0l22.63-22.63C513.5 88.95 513.5 78.82 507.3 72.57zM179.3 423.2l-90.51-90.51l122-122l90.51 90.52L179.3 423.2z")),"label"=>__("Wine Bottle","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies")),"wine-glass"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M232 464h-40.01v-117.3c68.51-15.88 118-79.86 111.4-154.1L287.5 14.5C286.8 6.25 279.9 0 271.8 0H48.23C40.1 0 33.22 6.25 32.47 14.5L16.6 192.6c-6.626 74.25 42.88 138.2 111.4 154.2V464H87.98c-22.13 0-40.01 17.88-40.01 40c0 4.375 3.626 8 8.002 8h208c4.376 0 8.002-3.625 8.002-8C272 481.9 254.1 464 232 464zM77.72 48h164.6L249.4 128H70.58L77.72 48z")),"label"=>__("Wine Glass","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","travel")),"wine-glass-empty"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M232 464h-40.01v-117.3c68.52-15.88 118-79.86 111.4-154.1L287.5 14.5C286.8 6.25 279.9 0 271.8 0H48.23C40.1 0 33.22 6.25 32.47 14.5L16.6 192.6c-6.625 74.25 42.88 138.2 111.4 154.2V464H87.98c-22.13 0-40.01 17.88-40.01 40c0 4.375 3.625 8 8.002 8h208c4.377 0 8.002-3.625 8.002-8C272 481.9 254.1 464 232 464zM180.4 300.2c-13.64 3.16-27.84 3.148-41.48-.0371C91.88 289.2 60.09 245.2 64.38 197.1L77.7 48h164.6L255.6 197.2c4.279 48.01-27.5 91.93-74.46 102.8L180.4 300.2z")),"label"=>__("Wine Glass Empty","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","travel")),"wirsindhandwerk"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M50.77 479.8h83.36V367.8l-83.36 47.01zm329 0h82.35V414.9l-82.35-47.01zm.0057-448V251.6L256.2 179.2 134.5 251.6V31.81H50.77V392.6L256.2 270.3 462.2 392.6V31.81z")),"label"=>__("wirsindhandwerk","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"wix"=>array("svg"=>array("brands"=>array("width"=>640,"height"=>512,"path"=>"M393.4 131.7c0 13.03 2.08 32.69-28.68 43.83-9.52 3.45-15.95 9.66-15.95 9.66 0-31 4.72-42.22 17.4-48.86 9.75-5.11 27.23-4.63 27.23-4.63zm-115.8 35.54l-34.24 132.7-28.48-108.6c-7.69-31.99-20.81-48.53-48.43-48.53-27.37 0-40.66 16.18-48.43 48.53L89.52 299.9 55.28 167.2C49.73 140.5 23.86 128.1 0 131.1l65.57 247.9s21.63 1.56 32.46-3.96c14.22-7.25 20.98-12.84 29.59-46.57 7.67-30.07 29.11-118.4 31.12-124.7 4.76-14.94 11.09-13.81 15.4 0 1.97 6.3 23.45 94.63 31.12 124.7 8.6 33.73 15.37 39.32 29.59 46.57 10.82 5.52 32.46 3.96 32.46 3.96l65.57-247.9c-24.42-3.07-49.82 8.93-55.3 35.27zm115.8 5.21s-4.1 6.34-13.46 11.57c-6.01 3.36-11.78 5.64-17.97 8.61-15.14 7.26-13.18 13.95-13.18 35.2v152.1s16.55 2.09 27.37-3.43c13.93-7.1 17.13-13.95 17.26-44.78V181.4l-.02 .01v-8.98zm163.4 84.08L640 132.8s-35.11-5.98-52.5 9.85c-13.3 12.1-24.41 29.55-54.18 72.47-.47 .73-6.25 10.54-13.07 0-29.29-42.23-40.8-60.29-54.18-72.47-17.39-15.83-52.5-9.85-52.5-9.85l83.2 123.7-82.97 123.4s36.57 4.62 53.95-11.21c11.49-10.46 17.58-20.37 52.51-70.72 6.81-10.52 12.57-.77 13.07 0 29.4 42.38 39.23 58.06 53.14 70.72 17.39 15.83 53.32 11.21 53.32 11.21L556.8 256.5z")),"label"=>__("Wix","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"wizards-of-the-coast"=>array("svg"=>array("brands"=>array("width"=>640,"height"=>512,"path"=>"M219.2 345.7c-1.9 1.38-11.07 8.44-.26 23.57 4.64 6.42 14.11 12.79 21.73 6.55 6.5-4.88 7.35-12.92 .26-23.04-5.47-7.76-14.28-12.88-21.73-7.08zm336.8 75.94c-.34 1.7-.55 1.67 .79 0 2.09-4.19 4.19-10.21 4.98-19.9 3.14-38.49-40.33-71.49-101.3-78.03-54.73-6.02-124.4 9.17-188.8 60.49l-.26 1.57c2.62 4.98 4.98 10.74 3.4 21.21l.79 .26c63.89-58.4 131.2-77.25 184.4-73.85 58.4 3.67 100 34.04 100 68.08-.01 9.96-2.63 15.72-3.94 20.17zM392.3 240.4c.79 7.07 4.19 10.21 9.17 10.47 5.5 .26 9.43-2.62 10.47-6.55 .79-3.4 2.09-29.85 2.09-29.85s-11.26 6.55-14.93 10.47c-3.66 3.68-7.33 8.39-6.8 15.46zm-50.02-151.1C137.8 89.32 13.1 226.8 .79 241.2c-1.05 .52-1.31 .79 .79 1.31 60.49 16.5 155.8 81.18 196.1 202.2l1.05 .26c55.25-69.92 140.9-128.1 236.1-128.1 80.92 0 130.1 42.16 130.1 80.39 0 18.33-6.55 33.52-22.26 46.35 0 .96-.2 .79 .79 .79 14.66-10.74 27.5-28.8 27.5-48.18 0-22.78-12.05-38.23-12.05-38.23 7.07 7.07 10.74 16.24 10.74 16.24 5.76-40.85 26.97-62.32 26.97-62.32-2.36-9.69-6.81-17.81-6.81-17.81 7.59 8.12 14.4 27.5 14.4 41.37 0 10.47-3.4 22.78-12.57 31.95l.26 .52c8.12-4.98 16.5-16.76 16.5-37.97 0-15.71-4.71-25.92-4.71-25.92 5.76-5.24 11.26-9.17 15.97-11.78 .79 3.4 2.09 9.69 2.36 14.93 0 1.05 .79 1.83 1.05 0 .79-5.76-.26-16.24-.26-16.5 6.02-3.14 9.69-4.45 9.69-4.45C617.7 176 489.4 89.32 342.3 89.32zm-99.24 289.6c-11.06 8.99-24.2 4.08-30.64-4.19-7.45-9.58-6.76-24.09 4.19-32.47 14.85-11.35 27.08-.49 31.16 5.5 .28 .39 12.13 16.57-4.71 31.16zm2.09-136.4l9.43-17.81 11.78 70.96-12.57 6.02-24.62-28.8 14.14-26.71 3.67 4.45-1.83-8.11zm18.59 117.6l-.26-.26c2.05-4.1-2.5-6.61-17.54-31.69-1.31-2.36-3.14-2.88-4.45-2.62l-.26-.52c7.86-5.76 15.45-10.21 25.4-15.71l.52 .26c1.31 1.83 2.09 2.88 3.4 4.71l-.26 .52c-1.05-.26-2.36-.79-5.24 .26-2.09 .79-7.86 3.67-12.31 7.59v1.31c1.57 2.36 3.93 6.55 5.76 9.69h.26c10.05-6.28 7.56-4.55 11.52-7.86h.26c.52 1.83 .52 1.83 1.83 5.5l-.26 .26c-3.06 .61-4.65 .34-11.52 5.5v.26c9.46 17.02 11.01 16.75 12.57 15.97l.26 .26c-2.34 1.59-6.27 4.21-9.68 6.57zm55.26-32.47c-3.14 1.57-6.02 2.88-9.95 4.98l-.26-.26c1.29-2.59 1.16-2.71-11.78-32.47l-.26-.26c-.15 0-8.9 3.65-9.95 7.33h-.52l-1.05-5.76 .26-.52c7.29-4.56 25.53-11.64 27.76-12.57l.52 .26 3.14 4.98-.26 .52c-3.53-1.76-7.35 .76-12.31 2.62v.26c12.31 32.01 12.67 30.64 14.66 30.64v.25zm44.77-16.5c-4.19 1.05-5.24 1.31-9.69 2.88l-.26-.26 .52-4.45c-1.05-3.4-3.14-11.52-3.67-13.62l-.26-.26c-3.4 .79-8.9 2.62-12.83 3.93l-.26 .26c.79 2.62 3.14 9.95 4.19 13.88 .79 2.36 1.83 2.88 2.88 3.14v.52c-3.67 1.05-7.07 2.62-10.21 3.93l-.26-.26c1.05-1.31 1.05-2.88 .26-4.98-1.05-3.14-8.12-23.83-9.17-27.23-.52-1.83-1.57-3.14-2.62-3.14v-.52c3.14-1.05 6.02-2.09 10.74-3.4l.26 .26-.26 4.71c1.31 3.93 2.36 7.59 3.14 9.69h.26c3.93-1.31 9.43-2.88 12.83-3.93l.26-.26-2.62-9.43c-.52-1.83-1.05-3.4-2.62-3.93v-.26c4.45-1.05 7.33-1.83 10.74-2.36l.26 .26c-1.05 1.31-1.05 2.88-.52 4.45 1.57 6.28 4.71 20.43 6.28 26.45 .54 2.62 1.85 3.41 2.63 3.93zm32.21-6.81l-.26 .26c-4.71 .52-14.14 2.36-22.52 4.19l-.26-.26 .79-4.19c-1.57-7.86-3.4-18.59-4.98-26.19-.26-1.83-.79-2.88-2.62-3.67l.79-.52c9.17-1.57 20.16-2.36 24.88-2.62l.26 .26c.52 2.36 .79 3.14 1.57 5.5l-.26 .26c-1.14-1.14-3.34-3.2-16.24-.79l-.26 .26c.26 1.57 1.05 6.55 1.57 9.95l.26 .26c9.52-1.68 4.76-.06 10.74-2.36h.26c0 1.57-.26 1.83-.26 5.24h-.26c-4.81-1.03-2.15-.9-10.21 0l-.26 .26c.26 2.09 1.57 9.43 2.09 12.57l.26 .26c1.15 .38 14.21-.65 16.24-4.71h.26c-.53 2.38-1.05 4.21-1.58 6.04zm10.74-44.51c-4.45 2.36-8.12 2.88-11 2.88-.25 .02-11.41 1.09-17.54-9.95-6.74-10.79-.98-25.2 5.5-31.69 8.8-8.12 23.35-10.1 28.54-17.02 8.03-10.33-13.04-22.31-29.59-5.76l-2.62-2.88 5.24-16.24c25.59-1.57 45.2-3.04 50.02 16.24 .79 3.14 0 9.43-.26 12.05 0 2.62-1.83 18.85-2.09 23.04-.52 4.19-.79 18.33-.79 20.69 .26 2.36 .52 4.19 1.57 5.5 1.57 1.83 5.76 1.83 5.76 1.83l-.79 4.71c-11.82-1.07-10.28-.59-20.43-1.05-3.22-5.15-2.23-3.28-4.19-7.86 0 .01-4.19 3.94-7.33 5.51zm37.18 21.21c-6.35-10.58-19.82-7.16-21.73 5.5-2.63 17.08 14.3 19.79 20.69 10.21l.26 .26c-.52 1.83-1.83 6.02-1.83 6.28l-.52 .52c-10.3 6.87-28.5-2.5-25.66-18.59 1.94-10.87 14.44-18.93 28.8-9.95l.26 .52c0 1.06-.27 3.41-.27 5.25zm5.77-87.73v-6.55c.69 0 19.65 3.28 27.76 7.33l-1.57 17.54s10.21-9.43 15.45-10.74c5.24-1.57 14.93 7.33 14.93 7.33l-11.26 11.26c-12.07-6.35-19.59-.08-20.69 .79-5.29 38.72-8.6 42.17 4.45 46.09l-.52 4.71c-17.55-4.29-18.53-4.5-36.92-7.33l.79-4.71c7.25 0 7.48-5.32 7.59-6.81 0 0 4.98-53.16 4.98-55.25-.02-2.87-4.99-3.66-4.99-3.66zm10.99 114.4c-8.12-2.09-14.14-11-10.74-20.69 3.14-9.43 12.31-12.31 18.85-10.21 9.17 2.62 12.83 11.78 10.74 19.38-2.61 8.9-9.42 13.87-18.85 11.52zm42.16 9.69c-2.36-.52-7.07-2.36-8.64-2.88v-.26l1.57-1.83c.59-8.24 .59-7.27 .26-7.59-4.82-1.81-6.66-2.36-7.07-2.36-1.31 1.83-2.88 4.45-3.67 5.5l-.79 3.4v.26c-1.31-.26-3.93-1.31-6.02-1.57v-.26l2.62-1.83c3.4-4.71 9.95-14.14 13.88-20.16v-2.09l.52-.26c2.09 .79 5.5 2.09 7.59 2.88 .48 .48 .18-1.87-1.05 25.14-.24 1.81 .02 2.6 .8 3.91zm-4.71-89.82c11.25-18.27 30.76-16.19 34.04-3.4L539.7 198c2.34-6.25-2.82-9.9-4.45-11.26l1.83-3.67c12.22 10.37 16.38 13.97 22.52 20.43-25.91 73.07-30.76 80.81-24.62 84.32l-1.83 4.45c-6.37-3.35-8.9-4.42-17.81-8.64l2.09-6.81c-.26-.26-3.93 3.93-9.69 3.67-19.06-1.3-22.89-31.75-9.67-52.9zm29.33 79.34c0-5.71-6.34-7.89-7.86-5.24-1.31 2.09 1.05 4.98 2.88 8.38 1.57 2.62 2.62 6.28 1.05 9.43-2.64 6.34-12.4 5.31-15.45-.79 0-.7-.27 .09 1.83-4.71l.79-.26c-.57 5.66 6.06 9.61 8.38 4.98 1.05-2.09-.52-5.5-2.09-8.38-1.57-2.62-3.67-6.28-1.83-9.69 2.72-5.06 11.25-4.47 14.66 2.36v.52l-2.36 3.4zm21.21 13.36c-1.96-3.27-.91-2.14-4.45-4.71h-.26c-2.36 4.19-5.76 10.47-8.64 16.24-1.31 2.36-1.05 3.4-.79 3.93l-.26 .26-5.76-4.45 .26-.26 2.09-1.31c3.14-5.76 6.55-12.05 9.17-17.02v-.26c-2.64-1.98-1.22-1.51-6.02-1.83v-.26l3.14-3.4h.26c3.67 2.36 9.95 6.81 12.31 8.9l.26 .26-1.31 3.91zm27.23-44.26l-2.88-2.88c.79-2.36 1.83-4.98 2.09-7.59 .75-9.74-11.52-11.84-11.52-4.98 0 4.98 7.86 19.38 7.86 27.76 0 10.21-5.76 15.71-13.88 16.5-8.38 .79-20.16-10.47-20.16-10.47l4.98-14.4 2.88 2.09c-2.97 17.8 17.68 20.37 13.35 5.24-1.06-4.02-18.75-34.2 2.09-38.23 13.62-2.36 23.04 16.5 23.04 16.5l-7.85 10.46zm35.62-10.21c-11-30.38-60.49-127.5-191.9-129.6-53.42-1.05-94.27 15.45-132.8 37.97l85.63-9.17-91.39 20.69 25.14 19.64-3.93-16.5c7.5-1.71 39.15-8.45 66.77-8.9l-22.26 80.39c13.61-.7 18.97-8.98 19.64-22.78l4.98-1.05 .26 26.71c-22.46 3.21-37.3 6.69-49.49 9.95l13.09-43.21-61.54-36.66 2.36 8.12 10.21 4.98c6.28 18.59 19.38 56.56 20.43 58.66 1.95 4.28 3.16 5.78 12.05 4.45l1.05 4.98c-16.08 4.86-23.66 7.61-39.02 14.4l-2.36-4.71c4.4-2.94 8.73-3.94 5.5-12.83-23.7-62.5-21.48-58.14-22.78-59.44l2.36-4.45 33.52 67.3c-3.84-11.87 1.68 1.69-32.99-78.82l-41.9 88.51 4.71-13.88-35.88-42.16 27.76 93.48-11.78 8.38C95 228.6 101.1 231.9 93.23 231.5c-5.5-.26-13.62 5.5-13.62 5.5L74.63 231c30.56-23.53 31.62-24.33 58.4-42.68l4.19 7.07s-5.76 4.19-7.86 7.07c-5.9 9.28 1.67 13.28 61.8 75.68l-18.85-58.92 39.8-10.21 25.66 30.64 4.45-12.31-4.98-24.62 13.09-3.4 .52 3.14 3.67-10.47-94.27 29.33 11.26-4.98-13.62-42.42 17.28-9.17 30.11 36.14 28.54-13.09c-1.41-7.47-2.47-14.5-4.71-19.64l17.28 13.88 4.71-2.09-59.18-42.68 23.08 11.5c18.98-6.07 25.23-7.47 32.21-9.69l2.62 11c-12.55 12.55 1.43 16.82 6.55 19.38l-13.62-61.01 12.05 28.28c4.19-1.31 7.33-2.09 7.33-2.09l2.62 8.64s-3.14 1.05-6.28 2.09l8.9 20.95 33.78-65.73-20.69 61.01c42.42-24.09 81.44-36.66 131.1-35.88 67.04 1.05 167.3 40.85 199.8 139.8 .78 2.1-.01 2.63-.79 .27zM203.5 152.4s1.83-.52 4.19-1.31l9.43 7.59c-.4 0-3.44-.25-11.26 2.36l-2.36-8.64zm143.8 38.5c-1.57-.6-26.46-4.81-33.26 20.69l21.73 17.02 11.53-37.71zM318.4 67.07c-58.4 0-106.1 12.05-114.1 14.4v.79c8.38 2.09 14.4 4.19 21.21 11.78l1.57 .26c6.55-1.83 48.97-13.88 110.2-13.88 180.2 0 301.7 116.8 301.7 223.4v9.95c0 1.31 .79 2.62 1.05 .52 .52-2.09 .79-8.64 .79-19.64 .26-83.79-96.63-227.6-321.6-227.6zm211.1 169.7c1.31-5.76 0-12.31-7.33-13.09-9.62-1.13-16.14 23.79-17.02 33.52-.79 5.5-1.31 14.93 6.02 14.93 4.68-.01 9.72-.91 18.33-35.36zm-61.53 42.95c-2.62-.79-9.43-.79-12.57 10.47-1.83 6.81 .52 13.35 6.02 14.66 3.67 1.05 8.9 .52 11.78-10.74 2.62-9.94-1.83-13.61-5.23-14.39zM491 300.6c1.83 .52 3.14 1.05 5.76 1.83 0-1.83 .52-8.38 .79-12.05-1.05 1.31-5.5 8.12-6.55 9.95v.27z")),"label"=>__("Wizards of the Coast","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","brands","brands","social")),"wodu"=>array("svg"=>array("brands"=>array("width"=>640,"height"=>512,"path"=>"M178.4 339.7H141.1L112.2 223.5h-.478L83.23 339.7H45.2L0 168.9H37.55L64.57 285.2h.478L94.71 168.9h35.16l29.18 117.7h.479L187.5 168.9h36.83zM271.4 212.7c38.98 0 64.1 25.83 64.1 65.29 0 39.22-25.11 65.05-64.1 65.05-38.74 0-63.85-25.83-63.85-65.05C207.5 238.5 232.7 212.7 271.4 212.7zm0 104.8c23.2 0 30.13-19.85 30.13-39.46 0-19.85-6.934-39.7-30.13-39.7-27.7 0-29.89 19.85-29.89 39.7C241.5 297.6 248.4 317.5 271.4 317.5zM435.1 323.9h-.478c-7.893 13.39-21.76 19.13-37.55 19.13-37.31 0-55.49-32.04-55.49-66.25 0-33.24 18.42-64.1 54.77-64.1 14.59 0 28.94 6.218 36.83 18.42h.24V168.9h33.96v170.8H435.1zM405.4 238.3c-22.24 0-29.89 19.13-29.89 39.46 0 19.37 8.848 39.7 29.89 39.7 22.48 0 29.18-19.61 29.18-39.94C434.6 257.4 427.4 238.3 405.4 238.3zM592.1 339.7H560.7V322.5h-.718c-8.609 13.87-23.44 20.57-37.79 20.57-36.11 0-45.2-20.33-45.2-50.94V216.1h33.96V285.9c0 20.33 5.979 30.37 21.76 30.37 18.42 0 26.31-10.28 26.31-35.39V216.1H592.1zM602.5 302.9H640v36.83H602.5z")),"label"=>__("Wodu","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"wolf-pack-battalion"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M267.7 471.5l10.56 15.84 5.28-12.32 5.28 7V512c21.06-7.92 21.11-66.86 25.51-97.21 4.62-31.89-.88-92.81 81.37-149.1-8.88-23.61-12-49.43-2.64-80.05C421 189 447 196.2 456.4 239.7l-30.35 8.36c11.15 23 17 46.76 13.2 72.14L412 313.2l-6.16 33.43-18.47-7-8.8 33.39-19.35-7 26.39 21.11 8.8-28.15L419 364.2l7-35.63 26.39 14.52c.25-20 7-58.06-8.8-84.45l26.39 5.28c4-22.07-2.38-39.21-7.92-56.74l22.43 9.68c-.44-25.07-29.94-56.79-61.58-58.5-20.22-1.09-56.74-25.17-54.1-51.9 2-19.87 17.45-42.62 43.11-49.7-44 36.51-9.68 67.3 5.28 73.46 4.4-11.44 17.54-69.08 0-130.2-40.39 22.87-89.65 65.1-93.2 147.8l-58 38.71-3.52 93.25L369.8 220l7 7-17.59 3.52-44 38.71-15.84-5.28-28.1 49.25-3.52 119.6 21.11 15.84-32.55 15.84-32.55-15.84 21.11-15.84-3.52-119.6-28.15-49.26-15.84 5.28-44-38.71-17.58-3.51 7-7 107.3 59.82-3.52-93.25-58.06-38.71C185 65.1 135.8 22.87 95.3 0c-17.54 61.12-4.4 118.8 0 130.2 15-6.16 49.26-36.95 5.28-73.46 25.66 7.08 41.15 29.83 43.11 49.7 2.63 26.74-33.88 50.81-54.1 51.9-31.65 1.72-61.15 33.44-61.59 58.51l22.43-9.68c-5.54 17.53-11.91 34.67-7.92 56.74l26.39-5.28c-15.76 26.39-9.05 64.43-8.8 84.45l26.39-14.52 7 35.63 24.63-5.28 8.8 28.15L153.4 366 134 373l-8.8-33.43-18.47 7-6.16-33.43-27.27 7c-3.82-25.38 2-49.1 13.2-72.14l-30.35-8.36c9.4-43.52 35.47-50.77 63.34-54.1 9.36 30.62 6.24 56.45-2.64 80.05 82.25 56.3 76.75 117.2 81.37 149.1 4.4 30.35 4.45 89.29 25.51 97.21v-29.83l5.28-7 5.28 12.32 10.56-15.84 11.44 21.11 11.43-21.1zm79.17-95L331.1 366c7.47-4.36 13.76-8.42 19.35-12.32-.6 7.22-.27 13.84-3.51 22.84zm28.15-49.26c-.4 10.94-.9 21.66-1.76 31.67-7.85-1.86-15.57-3.8-21.11-7 8.24-7.94 15.55-16.32 22.87-24.68zm24.63 5.28c0-13.43-2.05-24.21-5.28-33.43a235 235 0 0 1 -18.47 27.27zm3.52-80.94c19.44 12.81 27.8 33.66 29.91 56.3-12.32-4.53-24.63-9.31-36.95-10.56 5.06-12 6.65-28.14 7-45.74zm-1.76-45.74c.81 14.3 1.84 28.82 1.76 42.23 19.22-8.11 29.78-9.72 44-14.08-10.61-18.96-27.2-25.53-45.76-28.16zM165.7 376.5L181.5 366c-7.47-4.36-13.76-8.42-19.35-12.32 .6 7.26 .27 13.88 3.51 22.88zm-28.15-49.26c.4 10.94 .9 21.66 1.76 31.67 7.85-1.86 15.57-3.8 21.11-7-8.24-7.93-15.55-16.31-22.87-24.67zm-24.64 5.28c0-13.43 2-24.21 5.28-33.43a235 235 0 0 0 18.47 27.27zm-3.52-80.94c-19.44 12.81-27.8 33.66-29.91 56.3 12.32-4.53 24.63-9.31 37-10.56-5-12-6.65-28.14-7-45.74zm1.76-45.74c-.81 14.3-1.84 28.82-1.76 42.23-19.22-8.11-29.78-9.72-44-14.08 10.63-18.95 27.23-25.52 45.76-28.15z")),"label"=>__("Wolf Pack Battalion","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"won-sign"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M119.1 224H183L224.1 56.24C228.5 41.99 241.3 32 256 32C270.7 32 283.5 41.99 287 56.24L328.1 224H392.9L449.6 53.88C455.2 37.12 473.4 28.05 490.1 33.64C506.9 39.23 515.9 57.35 510.4 74.12L460.4 224H480C497.7 224 512 238.3 512 256C512 273.7 497.7 288 480 288H439.1L382.4 458.1C377.9 471.6 364.1 480.5 350.8 479.1C336.6 479.4 324.4 469.6 320.1 455.8L279 288H232.1L191 455.8C187.6 469.6 175.4 479.4 161.2 479.1C147 480.5 134.1 471.6 129.6 458.1L72.94 288H32C14.33 288 .001 273.7 .001 256C.001 238.3 14.33 224 32 224H51.6L1.643 74.12C-3.946 57.35 5.115 39.23 21.88 33.64C38.65 28.05 56.77 37.12 62.36 53.88L119.1 224zM140.4 288L155.6 333.6L167 288H140.4zM248.1 224H263L256 195.9L248.1 224zM344.1 288L356.4 333.6L371.6 288H344.1z")),"label"=>__("Won Sign","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"wordpress"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M61.7 169.4l101.5 278C92.2 413 43.3 340.2 43.3 256c0-30.9 6.6-60.1 18.4-86.6zm337.9 75.9c0-26.3-9.4-44.5-17.5-58.7-10.8-17.5-20.9-32.4-20.9-49.9 0-19.6 14.8-37.8 35.7-37.8 .9 0 1.8 .1 2.8 .2-37.9-34.7-88.3-55.9-143.7-55.9-74.3 0-139.7 38.1-177.8 95.9 5 .2 9.7 .3 13.7 .3 22.2 0 56.7-2.7 56.7-2.7 11.5-.7 12.8 16.2 1.4 17.5 0 0-11.5 1.3-24.3 2l77.5 230.4L249.8 247l-33.1-90.8c-11.5-.7-22.3-2-22.3-2-11.5-.7-10.1-18.2 1.3-17.5 0 0 35.1 2.7 56 2.7 22.2 0 56.7-2.7 56.7-2.7 11.5-.7 12.8 16.2 1.4 17.5 0 0-11.5 1.3-24.3 2l76.9 228.7 21.2-70.9c9-29.4 16-50.5 16-68.7zm-139.9 29.3l-63.8 185.5c19.1 5.6 39.2 8.7 60.1 8.7 24.8 0 48.5-4.3 70.6-12.1-.6-.9-1.1-1.9-1.5-2.9l-65.4-179.2zm183-120.7c.9 6.8 1.4 14 1.4 21.9 0 21.6-4 45.8-16.2 76.2l-65 187.9C426.2 403 468.7 334.5 468.7 256c0-37-9.4-71.8-26-102.1zM504 256c0 136.8-111.3 248-248 248C119.2 504 8 392.7 8 256 8 119.2 119.2 8 256 8c136.7 0 248 111.2 248 248zm-11.4 0c0-130.5-106.2-236.6-236.6-236.6C125.5 19.4 19.4 125.5 19.4 256S125.6 492.6 256 492.6c130.5 0 236.6-106.1 236.6-236.6z")),"label"=>__("WordPress Logo","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"wordpress-simple"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M256 8C119.3 8 8 119.2 8 256c0 136.7 111.3 248 248 248s248-111.3 248-248C504 119.2 392.7 8 256 8zM33 256c0-32.3 6.9-63 19.3-90.7l106.4 291.4C84.3 420.5 33 344.2 33 256zm223 223c-21.9 0-43-3.2-63-9.1l66.9-194.4 68.5 187.8c.5 1.1 1 2.1 1.6 3.1-23.1 8.1-48 12.6-74 12.6zm30.7-327.5c13.4-.7 25.5-2.1 25.5-2.1 12-1.4 10.6-19.1-1.4-18.4 0 0-36.1 2.8-59.4 2.8-21.9 0-58.7-2.8-58.7-2.8-12-.7-13.4 17.7-1.4 18.4 0 0 11.4 1.4 23.4 2.1l34.7 95.2L200.6 393l-81.2-241.5c13.4-.7 25.5-2.1 25.5-2.1 12-1.4 10.6-19.1-1.4-18.4 0 0-36.1 2.8-59.4 2.8-4.2 0-9.1-.1-14.4-.3C109.6 73 178.1 33 256 33c58 0 110.9 22.2 150.6 58.5-1-.1-1.9-.2-2.9-.2-21.9 0-37.4 19.1-37.4 39.6 0 18.4 10.6 33.9 21.9 52.3 8.5 14.8 18.4 33.9 18.4 61.5 0 19.1-7.3 41.2-17 72.1l-22.2 74.3-80.7-239.6zm81.4 297.2l68.1-196.9c12.7-31.8 17-57.2 17-79.9 0-8.2-.5-15.8-1.5-22.9 17.4 31.8 27.3 68.2 27.3 107 0 82.3-44.6 154.1-110.9 192.7z")),"label"=>__("Wordpress Simple","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"worm"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M256 96C256 42.98 298.1 0 352 0H390.4C439.9 0 480 40.12 480 89.6V376C480 451.1 419.1 512 344 512C268.9 512 208 451.1 208 376V296C208 273.9 190.1 256 168 256C145.9 256 128 273.9 128 296V464C128 490.5 106.5 512 80 512C53.49 512 32 490.5 32 464V296C32 220.9 92.89 160 168 160C243.1 160 304 220.9 304 296V376C304 398.1 321.9 416 344 416C366.1 416 384 398.1 384 376V192H352C298.1 192 256 149 256 96zM376 64C362.7 64 352 74.75 352 88C352 101.3 362.7 112 376 112C389.3 112 400 101.3 400 88C400 74.75 389.3 64 376 64z")),"label"=>__("Worm","ultimate-addons-for-gutenberg"),"custom_categories"=>array("environment")),"wpbeginner"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M462.8 322.4C519 386.7 466.1 480 370.9 480c-39.6 0-78.82-17.69-100.1-50.04-6.887 .356-22.7 .356-29.59 0C219.8 462.4 180.6 480 141.1 480c-95.49 0-148.3-92.1-91.86-157.6C-29.92 190.5 80.48 32 256 32c175.6 0 285.9 158.6 206.8 290.4zm-339.6-82.97h41.53v-58.08h-41.53v58.08zm217.2 86.07v-23.84c-60.51 20.92-132.4 9.198-187.6-33.97l.246 24.9c51.1 46.37 131.7 57.88 187.3 32.91zm-150.8-86.07h166.1v-58.08H189.6v58.08z")),"label"=>__("WPBeginner","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"wpexplorer"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M512 256c0 141.2-114.7 256-256 256C114.8 512 0 397.3 0 256S114.7 0 256 0s256 114.7 256 256zm-32 0c0-123.2-100.3-224-224-224C132.5 32 32 132.5 32 256s100.5 224 224 224 224-100.5 224-224zM160.9 124.6l86.9 37.1-37.1 86.9-86.9-37.1 37.1-86.9zm110 169.1l46.6 94h-14.6l-50-100-48.9 100h-14l51.1-106.9-22.3-9.4 6-14 68.6 29.1-6 14.3-16.5-7.1zm-11.8-116.3l68.6 29.4-29.4 68.3L230 246l29.1-68.6zm80.3 42.9l54.6 23.1-23.4 54.3-54.3-23.1 23.1-54.3z")),"label"=>__("WPExplorer","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"wpforms"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M448 75.2v361.7c0 24.3-19 43.2-43.2 43.2H43.2C19.3 480 0 461.4 0 436.8V75.2C0 51.1 18.8 32 43.2 32h361.7c24 0 43.1 18.8 43.1 43.2zm-37.3 361.6V75.2c0-3-2.6-5.8-5.8-5.8h-9.3L285.3 144 224 94.1 162.8 144 52.5 69.3h-9.3c-3.2 0-5.8 2.8-5.8 5.8v361.7c0 3 2.6 5.8 5.8 5.8h361.7c3.2 .1 5.8-2.7 5.8-5.8zM150.2 186v37H76.7v-37h73.5zm0 74.4v37.3H76.7v-37.3h73.5zm11.1-147.3l54-43.7H96.8l64.5 43.7zm210 72.9v37h-196v-37h196zm0 74.4v37.3h-196v-37.3h196zm-84.6-147.3l64.5-43.7H232.8l53.9 43.7zM371.3 335v37.3h-99.4V335h99.4z")),"label"=>__("WPForms","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"wpressr"=>array("svg"=>array("brands"=>array("width"=>496,"height"=>512,"path"=>"M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S384.1 8 248 8zm171.3 158.6c-15.18 34.51-30.37 69.02-45.63 103.5-2.44 5.51-6.89 8.24-12.97 8.24-23.02-.01-46.03 .06-69.05-.05-5.12-.03-8.25 1.89-10.34 6.72-10.19 23.56-20.63 47-30.95 70.5-1.54 3.51-4.06 5.29-7.92 5.29-45.94-.01-91.87-.02-137.8 0-3.13 0-5.63-1.15-7.72-3.45-11.21-12.33-22.46-24.63-33.68-36.94-2.69-2.95-2.79-6.18-1.21-9.73 8.66-19.54 17.27-39.1 25.89-58.66 12.93-29.35 25.89-58.69 38.75-88.08 1.7-3.88 4.28-5.68 8.54-5.65 14.24 .1 28.48 .02 42.72 .05 6.24 .01 9.2 4.84 6.66 10.59-13.6 30.77-27.17 61.55-40.74 92.33-5.72 12.99-11.42 25.99-17.09 39-3.91 8.95 7.08 11.97 10.95 5.6 .23-.37-1.42 4.18 30.01-67.69 1.36-3.1 3.41-4.4 6.77-4.39 15.21 .08 30.43 .02 45.64 .04 5.56 .01 7.91 3.64 5.66 8.75-8.33 18.96-16.71 37.9-24.98 56.89-4.98 11.43 8.08 12.49 11.28 5.33 .04-.08 27.89-63.33 32.19-73.16 2.02-4.61 5.44-6.51 10.35-6.5 26.43 .05 52.86 0 79.29 .05 12.44 .02 13.93-13.65 3.9-13.64-25.26 .03-50.52 .02-75.78 .02-6.27 0-7.84-2.47-5.27-8.27 5.78-13.06 11.59-26.11 17.3-39.21 1.73-3.96 4.52-5.79 8.84-5.78 23.09 .06 25.98 .02 130.8 .03 6.08-.01 8.03 2.79 5.62 8.27z")),"label"=>__("wpressr","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"wrench"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M507.6 122.8c-2.904-12.09-18.25-16.13-27.04-7.338l-76.55 76.56l-83.1-.0002l0-83.1l76.55-76.56c8.791-8.789 4.75-24.14-7.336-27.04c-23.69-5.693-49.34-6.111-75.92 .2484c-61.45 14.7-109.4 66.9-119.2 129.3C189.8 160.8 192.3 186.7 200.1 210.1l-178.1 178.1c-28.12 28.12-28.12 73.69 0 101.8C35.16 504.1 53.56 512 71.1 512s36.84-7.031 50.91-21.09l178.1-178.1c23.46 7.736 49.31 10.24 76.17 6.004c62.41-9.84 114.6-57.8 129.3-119.2C513.7 172.1 513.3 146.5 507.6 122.8zM80 456c-13.25 0-24-10.75-24-24c0-13.26 10.75-24 24-24s24 10.74 24 24C104 445.3 93.25 456 80 456z")),"label"=>__("Wrench","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","travel")),"x"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M376.6 427.5c11.31 13.58 9.484 33.75-4.094 45.06c-5.984 4.984-13.25 7.422-20.47 7.422c-9.172 0-18.27-3.922-24.59-11.52L192 305.1l-135.4 162.5c-6.328 7.594-15.42 11.52-24.59 11.52c-7.219 0-14.48-2.438-20.47-7.422c-13.58-11.31-15.41-31.48-4.094-45.06l142.9-171.5L7.422 84.5C-3.891 70.92-2.063 50.75 11.52 39.44c13.56-11.34 33.73-9.516 45.06 4.094L192 206l135.4-162.5c11.3-13.58 31.48-15.42 45.06-4.094c13.58 11.31 15.41 31.48 4.094 45.06l-142.9 171.5L376.6 427.5z")),"label"=>__("X","ultimate-addons-for-gutenberg"),"custom_categories"=>array("education")),"x-ray"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M208 352C199.2 352 192 359.2 192 368C192 376.8 199.2 384 208 384S224 376.8 224 368C224 359.2 216.8 352 208 352zM304 384c8.836 0 16-7.164 16-16c0-8.838-7.164-16-16-16S288 359.2 288 368C288 376.8 295.2 384 304 384zM496 96C504.8 96 512 88.84 512 80v-32C512 39.16 504.8 32 496 32h-480C7.164 32 0 39.16 0 48v32C0 88.84 7.164 96 16 96H32v320H16C7.164 416 0 423.2 0 432v32C0 472.8 7.164 480 16 480h480c8.836 0 16-7.164 16-16v-32c0-8.836-7.164-16-16-16H480V96H496zM416 216C416 220.4 412.4 224 408 224H272v32h104C380.4 256 384 259.6 384 264v16C384 284.4 380.4 288 376 288H272v32h69.33c25.56 0 40.8 28.48 26.62 49.75l-21.33 32C340.7 410.7 330.7 416 319.1 416H192c-10.7 0-20.69-5.347-26.62-14.25l-21.33-32C129.9 348.5 145.1 320 170.7 320H240V288H136C131.6 288 128 284.4 128 280v-16C128 259.6 131.6 256 136 256H240V224H104C99.6 224 96 220.4 96 216v-16C96 195.6 99.6 192 104 192H240V160H136C131.6 160 128 156.4 128 152v-16C128 131.6 131.6 128 136 128H240V104C240 99.6 243.6 96 248 96h16c4.4 0 8 3.6 8 8V128h104C380.4 128 384 131.6 384 136v16C384 156.4 380.4 160 376 160H272v32h136C412.4 192 416 195.6 416 200V216z")),"label"=>__("X Ray","ultimate-addons-for-gutenberg"),"custom_categories"=>array("science-and-technology")),"xbox"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M369.9 318.2c44.3 54.3 64.7 98.8 54.4 118.7-7.9 15.1-56.7 44.6-92.6 55.9-29.6 9.3-68.4 13.3-100.4 10.2-38.2-3.7-76.9-17.4-110.1-39C93.3 445.8 87 438.3 87 423.4c0-29.9 32.9-82.3 89.2-142.1 32-33.9 76.5-73.7 81.4-72.6 9.4 2.1 84.3 75.1 112.3 109.5zM188.6 143.8c-29.7-26.9-58.1-53.9-86.4-63.4-15.2-5.1-16.3-4.8-28.7 8.1-29.2 30.4-53.5 79.7-60.3 122.4-5.4 34.2-6.1 43.8-4.2 60.5 5.6 50.5 17.3 85.4 40.5 120.9 9.5 14.6 12.1 17.3 9.3 9.9-4.2-11-.3-37.5 9.5-64 14.3-39 53.9-112.9 120.3-194.4zm311.6 63.5C483.3 127.3 432.7 77 425.6 77c-7.3 0-24.2 6.5-36 13.9-23.3 14.5-41 31.4-64.3 52.8C367.7 197 427.5 283.1 448.2 346c6.8 20.7 9.7 41.1 7.4 52.3-1.7 8.5-1.7 8.5 1.4 4.6 6.1-7.7 19.9-31.3 25.4-43.5 7.4-16.2 15-40.2 18.6-58.7 4.3-22.5 3.9-70.8-.8-93.4zM141.3 43C189 40.5 251 77.5 255.6 78.4c.7 .1 10.4-4.2 21.6-9.7 63.9-31.1 94-25.8 107.4-25.2-63.9-39.3-152.7-50-233.9-11.7-23.4 11.1-24 11.9-9.4 11.2z")),"label"=>__("Xbox","ultimate-addons-for-gutenberg"),"custom_categories"=>array("lifestyle-and-hobbies","brands","brands","social")),"xing"=>array("svg"=>array("brands"=>array("width"=>384,"height"=>512,"path"=>"M162.7 210c-1.8 3.3-25.2 44.4-70.1 123.5-4.9 8.3-10.8 12.5-17.7 12.5H9.8c-7.7 0-12.1-7.5-8.5-14.4l69-121.3c.2 0 .2-.1 0-.3l-43.9-75.6c-4.3-7.8 .3-14.1 8.5-14.1H100c7.3 0 13.3 4.1 18 12.2l44.7 77.5zM382.6 46.1l-144 253v.3L330.2 466c3.9 7.1 .2 14.1-8.5 14.1h-65.2c-7.6 0-13.6-4-18-12.2l-92.4-168.5c3.3-5.8 51.5-90.8 144.8-255.2 4.6-8.1 10.4-12.2 17.5-12.2h65.7c8 0 12.3 6.7 8.5 14.1z")),"label"=>__("Xing","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"xing-square"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM140.4 320.2H93.8c-5.5 0-8.7-5.3-6-10.3l49.3-86.7c.1 0 .1-.1 0-.2l-31.4-54c-3-5.6 .2-10.1 6-10.1h46.6c5.2 0 9.5 2.9 12.9 8.7l31.9 55.3c-1.3 2.3-18 31.7-50.1 88.2-3.5 6.2-7.7 9.1-12.6 9.1zm219.7-214.1L257.3 286.8v.2l65.5 119c2.8 5.1 .1 10.1-6 10.1h-46.6c-5.5 0-9.7-2.9-12.9-8.7l-66-120.3c2.3-4.1 36.8-64.9 103.4-182.3 3.3-5.8 7.4-8.7 12.5-8.7h46.9c5.7-.1 8.8 4.7 6 10z")),"label"=>__("Xing Square","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"xmark"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M310.6 361.4c12.5 12.5 12.5 32.75 0 45.25C304.4 412.9 296.2 416 288 416s-16.38-3.125-22.62-9.375L160 301.3L54.63 406.6C48.38 412.9 40.19 416 32 416S15.63 412.9 9.375 406.6c-12.5-12.5-12.5-32.75 0-45.25l105.4-105.4L9.375 150.6c-12.5-12.5-12.5-32.75 0-45.25s32.75-12.5 45.25 0L160 210.8l105.4-105.4c12.5-12.5 32.75-12.5 45.25 0s12.5 32.75 0 45.25l-105.4 105.4L310.6 361.4z")),"label"=>__("Xmark","ultimate-addons-for-gutenberg"),"custom_categories"=>array("design","education")),"xmarks-lines"=>array("svg"=>array("solid"=>array("width"=>640,"height"=>512,"path"=>"M608 32C625.7 32 640 46.33 640 64C640 81.67 625.7 96 608 96H32C14.33 96 0 81.67 0 64C0 46.33 14.33 32 32 32H608zM608 416C625.7 416 640 430.3 640 448C640 465.7 625.7 480 608 480H32C14.33 480 0 465.7 0 448C0 430.3 14.33 416 32 416H608zM7.029 167C16.4 157.7 31.6 157.7 40.97 167L96 222.1L151 167C160.4 157.7 175.6 157.7 184.1 167C194.3 176.4 194.3 191.6 184.1 200.1L129.9 256L184.1 311C194.3 320.4 194.3 335.6 184.1 344.1C175.6 354.3 160.4 354.3 151 344.1L96 289.9L40.97 344.1C31.6 354.3 16.4 354.3 7.029 344.1C-2.343 335.6-2.343 320.4 7.029 311L62.06 256L7.029 200.1C-2.343 191.6-2.343 176.4 7.029 167V167zM320 222.1L375 167C384.4 157.7 399.6 157.7 408.1 167C418.3 176.4 418.3 191.6 408.1 200.1L353.9 256L408.1 311C418.3 320.4 418.3 335.6 408.1 344.1C399.6 354.3 384.4 354.3 375 344.1L320 289.9L264.1 344.1C255.6 354.3 240.4 354.3 231 344.1C221.7 335.6 221.7 320.4 231 311L286.1 256L231 200.1C221.7 191.6 221.7 176.4 231 167C240.4 157.7 255.6 157.7 264.1 167L320 222.1zM455 167C464.4 157.7 479.6 157.7 488.1 167L544 222.1L599 167C608.4 157.7 623.6 157.7 632.1 167C642.3 176.4 642.3 191.6 632.1 200.1L577.9 256L632.1 311C642.3 320.4 642.3 335.6 632.1 344.1C623.6 354.3 608.4 354.3 599 344.1L544 289.9L488.1 344.1C479.6 354.3 464.4 354.3 455 344.1C445.7 335.6 445.7 320.4 455 311L510.1 256L455 200.1C445.7 191.6 445.7 176.4 455 167V167z")),"label"=>__("Xmarks Lines","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business","environment")),"y"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M378 82.61L224 298.3v149.8c0 17.67-14.31 31.1-32 31.1S160 465.7 160 448V298.3L5.969 82.61C-4.313 68.23-.9688 48.25 13.41 37.97c14.34-10.27 34.38-6.922 44.63 7.453L192 232.1l133.1-187.5c10.28-14.37 30.28-17.7 44.63-7.453C384.1 48.25 388.3 68.23 378 82.61z")),"label"=>__("Y","ultimate-addons-for-gutenberg"),"custom_categories"=>array("education")),"y-combinator"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M448 32v448H0V32h448zM236 287.5L313.5 142h-32.7L235 233c-4.7 9.3-9 18.3-12.8 26.8L210 233l-45.2-91h-35l76.7 143.8v94.5H236v-92.8z")),"label"=>__("Y Combinator","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"yahoo"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M223.7 141.1 167 284.2 111 141.1H14.93L120.8 390.2 82.19 480h94.17L317.3 141.1zm105.4 135.8a58.22 58.22 0 1 0 58.22 58.22A58.22 58.22 0 0 0 329.1 276.9zM394.6 32l-93 223.5H406.4L499.1 32z")),"label"=>__("Yahoo Logo","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"yammer"=>array("svg"=>array("brands"=>array("width"=>512,"height"=>512,"path"=>"M500.7 159.5a12.78 12.78 0 0 0 -6.4-8.282 13.95 13.95 0 0 0 -10.08-1.125L457.8 156.7l-.043-.2-22.3 5.785-1.243 .333-.608-2.17A369 369 0 0 0 347.5 4.289a14.1 14.1 0 0 0 -19.78-.463l-102.9 102.7H24.95A24.9 24.9 0 0 0 0 131.4V380.4a24.96 24.96 0 0 0 24.92 24.9H224.1L328.1 508a13.67 13.67 0 0 0 19.33 0c.126-.126 .249-.255 .37-.385a368 368 0 0 0 69.58-107.4 403.5 403.5 0 0 0 17.3-50.8v-.028l20.41 5.336 .029-.073L483.3 362a20.25 20.25 0 0 0 2.619 .5 13.36 13.36 0 0 0 4.139-.072 13.5 13.5 0 0 0 10.52-9.924 415.9 415.9 0 0 0 .058-193zM337.1 24.65l.013 .014h-.013zm-110.2 165.2L174.3 281.1a11.34 11.34 0 0 0 -1.489 5.655v46.19a22.04 22.04 0 0 1 -22.04 22h-3.4A22.07 22.07 0 0 1 125.3 332.1V287.3a11.53 11.53 0 0 0 -1.388-5.51l-51.6-92.2a21.99 21.99 0 0 1 19.26-32.73h3.268a22.06 22.06 0 0 1 19.61 11.92l36.36 70.28 37.51-70.51a22.07 22.07 0 0 1 38.56-.695 21.7 21.7 0 0 1 0 21.97zM337.1 24.67a348.1 348.1 0 0 1 75.8 141.3l.564 1.952-114.1 29.6V131.4a25.01 25.01 0 0 0 -24.95-24.9H255.1zm60.5 367.3v-.043l-.014 .014a347.2 347.2 0 0 1 -60.18 95.23l-82.2-81.89h19.18a24.98 24.98 0 0 0 24.95-24.9v-66.2l114.6 29.86A385.2 385.2 0 0 1 397.6 391.1zm84-52.45 .015 .014-50.62-13.13L299.4 292.1V219.6l119.7-30.99 4.468-1.157 39.54-10.25 18.51-4.816A393 393 0 0 1 481.6 339.5z")),"label"=>__("Yammer","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"yandex"=>array("svg"=>array("brands"=>array("width"=>256,"height"=>512,"path"=>"M153.1 315.8L65.7 512H2l96-209.8c-45.1-22.9-75.2-64.4-75.2-141.1C22.7 53.7 90.8 0 171.7 0H254v512h-55.1V315.8h-45.8zm45.8-269.3h-29.4c-44.4 0-87.4 29.4-87.4 114.6 0 82.3 39.4 108.8 87.4 108.8h29.4V46.5z")),"label"=>__("Yandex","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"yandex-international"=>array("svg"=>array("brands"=>array("width"=>320,"height"=>512,"path"=>"M129.5 512V345.9L18.5 48h55.8l81.8 229.7L250.2 0h51.3L180.8 347.8V512h-51.3z")),"label"=>__("Yandex International","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"yarn"=>array("svg"=>array("brands"=>array("width"=>496,"height"=>512,"path"=>"M393.9 345.2c-39 9.3-48.4 32.1-104 47.4 0 0-2.7 4-10.4 5.8-13.4 3.3-63.9 6-68.5 6.1-12.4 .1-19.9-3.2-22-8.2-6.4-15.3 9.2-22 9.2-22-8.1-5-9-9.9-9.8-8.1-2.4 5.8-3.6 20.1-10.1 26.5-8.8 8.9-25.5 5.9-35.3 .8-10.8-5.7 .8-19.2 .8-19.2s-5.8 3.4-10.5-3.6c-6-9.3-17.1-37.3 11.5-62-1.3-10.1-4.6-53.7 40.6-85.6 0 0-20.6-22.8-12.9-43.3 5-13.4 7-13.3 8.6-13.9 5.7-2.2 11.3-4.6 15.4-9.1 20.6-22.2 46.8-18 46.8-18s12.4-37.8 23.9-30.4c3.5 2.3 16.3 30.6 16.3 30.6s13.6-7.9 15.1-5c8.2 16 9.2 46.5 5.6 65.1-6.1 30.6-21.4 47.1-27.6 57.5-1.4 2.4 16.5 10 27.8 41.3 10.4 28.6 1.1 52.7 2.8 55.3 .8 1.4 13.7 .8 36.4-13.2 12.8-7.9 28.1-16.9 45.4-17 16.7-.5 17.6 19.2 4.9 22.2zM496 256c0 136.9-111.1 248-248 248S0 392.9 0 256 111.1 8 248 8s248 111.1 248 248zm-79.3 75.2c-1.7-13.6-13.2-23-28-22.8-22 .3-40.5 11.7-52.8 19.2-4.8 3-8.9 5.2-12.4 6.8 3.1-44.5-22.5-73.1-28.7-79.4 7.8-11.3 18.4-27.8 23.4-53.2 4.3-21.7 3-55.5-6.9-74.5-1.6-3.1-7.4-11.2-21-7.4-9.7-20-13-22.1-15.6-23.8-1.1-.7-23.6-16.4-41.4 28-12.2 .9-31.3 5.3-47.5 22.8-2 2.2-5.9 3.8-10.1 5.4h.1c-8.4 3-12.3 9.9-16.9 22.3-6.5 17.4 .2 34.6 6.8 45.7-17.8 15.9-37 39.8-35.7 82.5-34 36-11.8 73-5.6 79.6-1.6 11.1 3.7 19.4 12 23.8 12.6 6.7 30.3 9.6 43.9 2.8 4.9 5.2 13.8 10.1 30 10.1 6.8 0 58-2.9 72.6-6.5 6.8-1.6 11.5-4.5 14.6-7.1 9.8-3.1 36.8-12.3 62.2-28.7 18-11.7 24.2-14.2 37.6-17.4 12.9-3.2 21-15.1 19.4-28.2z")),"label"=>__("Yarn","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"yelp"=>array("svg"=>array("brands"=>array("width"=>384,"height"=>512,"path"=>"M42.9 240.3l99.62 48.61c19.2 9.4 16.2 37.51-4.5 42.71L30.5 358.5a22.79 22.79 0 0 1 -28.21-19.6 197.2 197.2 0 0 1 9-85.32 22.8 22.8 0 0 1 31.61-13.21zm44 239.3a199.4 199.4 0 0 0 79.42 32.11A22.78 22.78 0 0 0 192.9 490l3.9-110.8c.7-21.3-25.5-31.91-39.81-16.1l-74.21 82.4a22.82 22.82 0 0 0 4.09 34.09zm145.3-109.9l58.81 94a22.93 22.93 0 0 0 34 5.5 198.4 198.4 0 0 0 52.71-67.61A23 23 0 0 0 364.2 370l-105.4-34.26c-20.31-6.5-37.81 15.8-26.51 33.91zm148.3-132.2a197.4 197.4 0 0 0 -50.41-69.31 22.85 22.85 0 0 0 -34 4.4l-62 91.92c-11.9 17.7 4.7 40.61 25.2 34.71L366 268.6a23 23 0 0 0 14.61-31.21zM62.11 30.18a22.86 22.86 0 0 0 -9.9 32l104.1 180.4c11.7 20.2 42.61 11.9 42.61-11.4V22.88a22.67 22.67 0 0 0 -24.5-22.8 320.4 320.4 0 0 0 -112.3 30.1z")),"label"=>__("Yelp","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"yen-sign"=>array("svg"=>array("solid"=>array("width"=>320,"height"=>512,"path"=>"M159.1 198.3L261.4 46.25C271.2 31.54 291 27.57 305.8 37.37C320.5 47.18 324.4 67.04 314.6 81.75L219.8 223.1H272C289.7 223.1 304 238.3 304 255.1C304 273.7 289.7 287.1 272 287.1H192V319.1H272C289.7 319.1 304 334.3 304 352C304 369.7 289.7 384 272 384H192V448C192 465.7 177.7 480 159.1 480C142.3 480 127.1 465.7 127.1 448V384H47.1C30.33 384 15.1 369.7 15.1 352C15.1 334.3 30.33 319.1 47.1 319.1H127.1V287.1H47.1C30.33 287.1 15.1 273.7 15.1 255.1C15.1 238.3 30.33 223.1 47.1 223.1H100.2L5.374 81.75C-4.429 67.04-.456 47.18 14.25 37.37C28.95 27.57 48.82 31.54 58.62 46.25L159.1 198.3z")),"label"=>__("Yen Sign","ultimate-addons-for-gutenberg"),"custom_categories"=>array("business")),"yin-yang"=>array("svg"=>array("solid"=>array("width"=>512,"height"=>512,"path"=>"M256 128C238.3 128 224 142.4 224 160S238.3 192 256 192s31.97-14.38 31.97-32S273.7 128 256 128zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 384c-17.68 0-31.97-14.38-31.97-32S238.3 320 256 320s31.97 14.38 31.97 32S273.7 384 256 384zM256 256c-53.04 0-96.03 43-96.03 96S202.1 448 256 448c-106.1 0-192.1-86-192.1-192S149.9 64 256 64c53.04 0 96.03 43 96.03 96S309 256 256 256z")),"label"=>__("Yin Yang","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"yoast"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M91.3 76h186l-7 18.9h-179c-39.7 0-71.9 31.6-71.9 70.3v205.4c0 35.4 24.9 70.3 84 70.3V460H91.3C41.2 460 0 419.8 0 370.5V165.2C0 115.9 40.7 76 91.3 76zm229.1-56h66.5C243.1 398.1 241.2 418.9 202.2 459.3c-20.8 21.6-49.3 31.7-78.3 32.7v-51.1c49.2-7.7 64.6-49.9 64.6-75.3 0-20.1 .6-12.6-82.1-223.2h61.4L218.2 299 320.4 20zM448 161.5V460H234c6.6-9.6 10.7-16.3 12.1-19.4h182.5V161.5c0-32.5-17.1-51.9-48.2-62.9l6.7-17.6c41.7 13.6 60.9 43.1 60.9 80.5z")),"label"=>__("Yoast","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"youtube"=>array("svg"=>array("brands"=>array("width"=>576,"height"=>512,"path"=>"M549.7 124.1c-6.281-23.65-24.79-42.28-48.28-48.6C458.8 64 288 64 288 64S117.2 64 74.63 75.49c-23.5 6.322-42 24.95-48.28 48.6-11.41 42.87-11.41 132.3-11.41 132.3s0 89.44 11.41 132.3c6.281 23.65 24.79 41.5 48.28 47.82C117.2 448 288 448 288 448s170.8 0 213.4-11.49c23.5-6.321 42-24.17 48.28-47.82 11.41-42.87 11.41-132.3 11.41-132.3s0-89.44-11.41-132.3zm-317.5 213.5V175.2l142.7 81.21-142.7 81.2z")),"label"=>__("YouTube","ultimate-addons-for-gutenberg"),"custom_categories"=>array("communication","brands","brands","brands","social","social")),"youtube-square"=>array("svg"=>array("brands"=>array("width"=>448,"height"=>512,"path"=>"M186.8 202.1l95.2 54.1-95.2 54.1V202.1zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-42 176.3s0-59.6-7.6-88.2c-4.2-15.8-16.5-28.2-32.2-32.4C337.9 128 224 128 224 128s-113.9 0-142.2 7.7c-15.7 4.2-28 16.6-32.2 32.4-7.6 28.5-7.6 88.2-7.6 88.2s0 59.6 7.6 88.2c4.2 15.8 16.5 27.7 32.2 31.9C110.1 384 224 384 224 384s113.9 0 142.2-7.7c15.7-4.2 28-16.1 32.2-31.9 7.6-28.5 7.6-88.1 7.6-88.1z")),"label"=>__("YouTube Square","ultimate-addons-for-gutenberg"),"custom_categories"=>array()),"z"=>array("svg"=>array("solid"=>array("width"=>384,"height"=>512,"path"=>"M384 448c0 17.67-14.31 32-32 32H32c-12.41 0-23.72-7.188-28.97-18.42c-5.281-11.25-3.562-24.53 4.375-34.06l276.3-331.5H32c-17.69 0-32-14.33-32-32s14.31-32 32-32h320c12.41 0 23.72 7.188 28.97 18.42c5.281 11.25 3.562 24.53-4.375 34.06L100.3 416H352C369.7 416 384 430.3 384 448z")),"label"=>__("Z","ultimate-addons-for-gutenberg"),"custom_categories"=>array("education")),"zhihu"=>array("svg"=>array("brands"=>array("width"=>640,"height"=>512,"path"=>"M170.5 148.1v217.5l23.43 .01 7.71 26.37 42.01-26.37h49.53V148.1H170.5zm97.75 193.9h-27.94l-27.9 17.51-5.08-17.47-11.9-.04V171.8h72.82v170.3zm-118.5-94.39H97.5c1.74-27.1 2.2-51.59 2.2-73.46h51.16s1.97-22.56-8.58-22.31h-88.5c3.49-13.12 7.87-26.66 13.12-40.67 0 0-24.07 0-32.27 21.57-3.39 8.9-13.21 43.14-30.7 78.12 5.89-.64 25.37-1.18 36.84-22.21 2.11-5.89 2.51-6.66 5.14-14.53h28.87c0 10.5-1.2 66.88-1.68 73.44H20.83c-11.74 0-15.56 23.62-15.56 23.62h65.58C66.45 321.1 42.83 363.1 0 396.3c20.49 5.85 40.91-.93 51-9.9 0 0 22.98-20.9 35.59-69.25l53.96 64.94s7.91-26.89-1.24-39.99c-7.58-8.92-28.06-33.06-36.79-41.81L87.9 311.1c4.36-13.98 6.99-27.55 7.87-40.67h61.65s-.09-23.62-7.59-23.62v.01zm412-1.6c20.83-25.64 44.98-58.57 44.98-58.57s-18.65-14.8-27.38-4.06c-6 8.15-36.83 48.2-36.83 48.2l19.23 14.43zm-150.1-59.09c-9.01-8.25-25.91 2.13-25.91 2.13s39.52 55.04 41.12 57.45l19.46-13.73s-25.67-37.61-34.66-45.86h-.01zM640 258.4c-19.78 0-130.9 .93-131.1 .93v-101c4.81 0 12.42-.4 22.85-1.2 40.88-2.41 70.13-4 87.77-4.81 0 0 12.22-27.19-.59-33.44-3.07-1.18-23.17 4.58-23.17 4.58s-165.2 16.49-232.4 18.05c1.6 8.82 7.62 17.08 15.78 19.55 13.31 3.48 22.69 1.7 49.15 .89 24.83-1.6 43.68-2.43 56.51-2.43v99.81H351.4s2.82 22.31 25.51 22.85h107.9v70.92c0 13.97-11.19 21.99-24.48 21.12-14.08 .11-26.08-1.15-41.69-1.81 1.99 3.97 6.33 14.39 19.31 21.84 9.88 4.81 16.17 6.57 26.02 6.57 29.56 0 45.67-17.28 44.89-45.31v-73.32h122.4c9.68 0 8.7-23.78 8.7-23.78l.03-.01z")),"label"=>__("Zhihu","ultimate-addons-for-gutenberg"),"custom_categories"=>array("brands","brands","social")),"uagb_category_list"=>array(array("slug"=>"brands","title"=>__("Brands","ultimate-addons-for-gutenberg")),array("slug"=>"business","title"=>__("Business","ultimate-addons-for-gutenberg")),array("slug"=>"communication","title"=>__("Communication","ultimate-addons-for-gutenberg")),array("slug"=>"design","title"=>__("Design","ultimate-addons-for-gutenberg")),array("slug"=>"education","title"=>__("Education","ultimate-addons-for-gutenberg")),array("slug"=>"environment","title"=>__("Environment","ultimate-addons-for-gutenberg")),array("slug"=>"lifestyle-and-hobbies","title"=>__("Lifestyle","ultimate-addons-for-gutenberg")),array("slug"=>"science-and-technology","title"=>__("Science","ultimate-addons-for-gutenberg")),array("slug"=>"social","title"=>__("Social","ultimate-addons-for-gutenberg")),array("slug"=>"travel","title"=>__("Travel","ultimate-addons-for-gutenberg"))));
